package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.global.StaticVarExtend;

/**
 * 定时触发记录表
 * @author liangjw
 * @version 1.0
 * @since v7.0
 * 
 */
/**
 * 
create table tw_hz_node_task_trigger(
	id varchar(32) not null,
	trigger_type varchar(20),
	execnum number,
	workid varchar(32),
	trackid varchar(32),
	nodeid varchar(20),
	interface_class(200),
	version number,
	status varchar(2)
);
create table tw_hz_node_task_trigger_log(
	id varchar(32) not null,
	trigger_type varchar(20),
	trigger_time varchar(20),
	execnum number,
	workid varchar(32),
	trackid varchar(32),
	nodeid varchar(20)
	interface_class(200),
	version number,
	status varchar(2)
);

 */
public class DBNodeTaskTrigger extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String triggerType; //node-activation
	private int execnum = 0;//执行次数
	private String workid;
	private String trackid;
	private String nodeid;
	private String interfaceClass;
	private int version;		//实例版本号
	private String status;		//消息状态  0:不可执行  1：可执行   2：执行完成
	private String triggerTime;//触发时间

	private String tablename = StaticVarExtend.Table_Node_Task_Trigger;
	private String tablenameLog = StaticVarExtend.Table_Node_Task_Trigger_log;

//	protected void exeJSON(JSONObject json) {
//		JSONArray jsonArr = json.getJSONArray("DBNodeTaskTrigger");
//		if(jsonArr == null){
//			jsonArr = new JSONArray();
//			json.put("DBNodeTaskTrigger", jsonArr);
//		}
//		Object thisObj = JSON.toJSON(this);
//		jsonArr.add(thisObj);
//	}
	protected void getSQL(Map<String, List<Object>> saveMap) {
		String sql ="INSERT INTO "+tablename+("(id,trigger_type,execnum,workid,trackid,nodeid,interface_class," +
				"version,status) values('").toUpperCase()+getId()+"',?,?,?,?,?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(triggerType);
		dlst.add(execnum);
		dlst.add(workid);
		dlst.add(trackid);
		dlst.add(nodeid);
		dlst.add(interfaceClass);
		dlst.add(version);
		dlst.add(status);
		saveMap.put("DELETE FROM " + tablename + " WHERE ID='"+getId()+"'", null);
		saveMap.put(sql,dlst);
	}
	
	public Map<String, List<Object>> getDelSQL() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		String sql ="INSERT INTO "+tablenameLog+("(id,trigger_type,execnum,workid," +
				"trackid,nodeid,interface_class,version,status,trigger_time) values('").toUpperCase()+getId()+"',?,?,?,?,?,?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(triggerType);
		dlst.add(execnum);
		dlst.add(workid);
		dlst.add(trackid);
		dlst.add(nodeid);
		dlst.add(interfaceClass);
		dlst.add(version);
		dlst.add(status);
		dlst.add(triggerTime);
		saveMap.put("DELETE FROM " + tablenameLog + " WHERE ID='"+getId()+"'", null);
		saveMap.put(sql,dlst);
		return saveMap;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getTriggerTime() {
		return triggerTime;
	}

	public void setTriggerTime(String triggerTime) {
		this.triggerTime = triggerTime;
	}

	public String getWorkid() {
		return workid;
	}
	public void setWorkid(String workid) {
		this.workid = workid;
	}
	public int getExecnum() {
		return execnum;
	}

	public void setExecnum(int execnum) {
		this.execnum = execnum;
	}

	public String getTriggerType() {
		return triggerType;
	}

	public void setTriggerType(String triggerType) {
		this.triggerType = triggerType;
	}

	public String getTrackid() {
		return trackid;
	}
	public void setTrackid(String trackid) {
		this.trackid = trackid;
	}
	public String getNodeid() {
		return nodeid;
	}
	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}
	public String getInterfaceClass() {
		return interfaceClass;
	}
	public void setInterfaceClass(String interfaceClass) {
		this.interfaceClass = interfaceClass;
	}
	
}
