package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.global.StaticVarExtend;

/**
 * 信号触发记录表
 * @author liangjw
 * @version 1.0
 * @since v7.0
 * 
 */
/**
 * 
create table tw_hz_node_signal_trigger(
	id varchar(32) not null,
	signal_type varchar(20),
	signal_content clob,
	signal_id varchar(100),
	signal_name varchar(200),
	signal_from varchar(200),
	signal_to varchar(200),
	signal_para varchar(500),
	workid varchar(32),
	trackid varchar(32),
	nodeid varchar(20),
	flowid varchar(32),
	version number,
	status varchar(2)
);
create table tw_hz_node_signal_trigger_log(
	id varchar(32) not null,
	signal_type varchar(20),
	signal_content clob,
	signal_id varchar(100),
	signal_name varchar(200),
	signal_from varchar(200),
	signal_to varchar(200),
	signal_para varchar(500),
	signal_class varchar(200),
	workid varchar(32),
	trackid varchar(32),
	nodeid varchar(20),
	trigger_time varchar(20),
	issuccess varchar(2),
	version number,
	status varchar(2)
);

 */
public class DBNodeSignalTrigger extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String signalType; //node-activation
	private String workid;
	private String trackid;
	private String nodeid;
	private String signalId;
	private String signalName;
	private String signalFrom;
	private String signalTo;
	private String signalContent; // 消息内容，将参数对象序列化后存入的内容
	private String signalPara;
	private String signalClass;
	private String flowid;
	private int version;		//实例版本号
	private String status;		//消息状态  0:不可执行  1：可执行   2：执行完成
	private String issuccess;
	private String triggerTime;

	private String tablename = StaticVarExtend.Table_Node_Signal_Trigger;
	private String tablenameLog = StaticVarExtend.Table_Node_Signal_Trigger_Log;

//	protected void exeJSON(JSONObject json){
//		JSONArray jsonArr = json.getJSONArray("DBNodeSignalTrigger");
//		if(jsonArr == null){
//			jsonArr = new JSONArray();
//			json.put("DBNodeSignalTrigger", jsonArr);
//		}
//		Object thisObj = JSON.toJSON(this);
//		jsonArr.add(thisObj);
//	}
	
	protected void getSQL(Map<String, List<Object>> saveMap) {
		String sql ="INSERT INTO "+tablename+("(id,signal_type,signal_content,workid,trackid,nodeid," +
				"signal_id,signal_name,signal_from,signal_to,signal_para,flowid,signal_class,version,status) values('").toUpperCase()+getId()+"',?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(signalType);
		dlst.add(signalContent);
		dlst.add(workid);
		dlst.add(trackid);
		dlst.add(nodeid);
		dlst.add(signalId);
		dlst.add(signalName);
		dlst.add(signalFrom);
		dlst.add(signalTo);
		dlst.add(signalPara);
		dlst.add(flowid);
		dlst.add(signalClass);
		dlst.add(version);
		dlst.add(status);
		
		saveMap.put("DELETE FROM " + tablename + " WHERE ID='"+getId()+"'", null);
		saveMap.put(sql,dlst);
	}
	public Map<String, List<Object>> getLogSQL() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		String sql ="INSERT INTO "+tablenameLog+("(id,signal_type,signal_content,workid,trackid,nodeid," +
				"signal_id,signal_name,signal_from,signal_to,signal_para,trigger_time,issuccess,flowid,signal_class,version,status) " +
				"values('").toUpperCase()+getId()+"',?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(signalType);
		dlst.add(signalContent);
		dlst.add(workid);
		dlst.add(trackid);
		dlst.add(nodeid);
		dlst.add(signalId);
		dlst.add(signalName);
		dlst.add(signalFrom);
		dlst.add(signalTo);
		dlst.add(signalPara);
		dlst.add(triggerTime);
		dlst.add(issuccess);
		dlst.add(flowid);
		dlst.add(signalClass);
		dlst.add(version);
		dlst.add(status);
		
		saveMap.put("DELETE FROM " + tablenameLog + " WHERE ID='"+getId()+"'", null);
		saveMap.put(sql,dlst);
		return saveMap;
	}

	
	
	public int getVersion() {
		return version;
	}



	public void setVersion(int version) {
		this.version = version;
	}



	public String getStatus() {
		return status;
	}



	public void setStatus(String status) {
		this.status = status;
	}



	public String getIssuccess() {
		return issuccess;
	}



	public void setIssuccess(String issuccess) {
		this.issuccess = issuccess;
	}



	public String getTriggerTime() {
		return triggerTime;
	}



	public void setTriggerTime(String triggerTime) {
		this.triggerTime = triggerTime;
	}



	public String getSignalType() {
		return signalType;
	}
	public void setSignalType(String signalType) {
		this.signalType = signalType;
	}
	public String getWorkid() {
		return workid;
	}
	public void setWorkid(String workid) {
		this.workid = workid;
	}
	public String getTrackid() {
		return trackid;
	}
	public void setTrackid(String trackid) {
		this.trackid = trackid;
	}
	public String getNodeid() {
		return nodeid;
	}
	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}
	public String getSignalId() {
		return signalId;
	}
	public void setSignalId(String signalId) {
		this.signalId = signalId;
	}
	public String getSignalName() {
		return signalName;
	}
	public void setSignalName(String signalName) {
		this.signalName = signalName;
	}
	public String getSignalFrom() {
		return signalFrom;
	}
	public void setSignalFrom(String signalFrom) {
		this.signalFrom = signalFrom;
	}
	public String getSignalTo() {
		return signalTo;
	}
	public void setSignalTo(String signalTo) {
		this.signalTo = signalTo;
	}
	public String getSignalContent() {
		return signalContent;
	}
	public void setSignalContent(String signalContent) {
		this.signalContent = signalContent;
	}
	public String getSignalPara() {
		return signalPara;
	}
	public void setSignalPara(String signalPara) {
		this.signalPara = signalPara;
	}
	public String getSignalClass() {
		return signalClass;
	}
	public void setSignalClass(String signalClass) {
		this.signalClass = signalClass;
	}
	public String getFlowid() {
		return flowid;
	}
	public void setFlowid(String flowid) {
		this.flowid = flowid;
	}

}
