package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.global.StaticVarExtend;

/**
 * 消息事件记录表
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 * 
 */
/**
 * 
create table tw_hz_node_message_trigger(
	id varchar(32) not null,
	message_type varchar(20),
	message_content clob,
	message_id varchar(100),
	message_name varchar(200),
	message_from varchar(200),
	message_to varchar(200),
	message_para varchar(500),
	message_class varchar(200),
	workid varchar(32),
	trackid varchar(32),
	nodeid varchar(20),
	version number,
	status varchar(2)
);
create table tw_hz_node_message_trigger_log(
	id varchar(32) not null,
	message_type varchar(20),
	message_content clob,
	message_id varchar(100),
	message_name varchar(200),
	message_from varchar(200),
	message_to varchar(200),
	message_para varchar(500),
	message_class varchar(200),
	workid varchar(32),
	trackid varchar(32),
	nodeid varchar(20),
	trigger_time varchar(20),
	issuccess varchar(2),
	version number,
	status varchar(2)
);

 */
public class DBNodeMessageTrigger extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String messageType; //node-activation
	private String workid;
	private String trackid;
	private String nodeid;
	private String messageId;
	private String messageName;
	private String messageFrom;
	private String messageTo;
	private String messageContent; // 消息内容，将参数对象序列化后存入的内容
	private String messagePara;
	private String messageClass;
	private String flowid;
	private int version;		//实例版本号
	private String status;		//消息状态  0:不可执行  1：可执行   2：执行完成
	private String triggerTime;
	private String issuccess;

	
	private String tablename = StaticVarExtend.Table_Node_Message_Trigger;
	private String tablenameLog = StaticVarExtend.Table_Node_Message_Trigger_Log;

//	protected void exeJSON(JSONObject json){
//		JSONArray jsonArr = json.getJSONArray("DBNodeMessageTrigger");
//		if(jsonArr == null){
//			jsonArr = new JSONArray();
//			json.put("DBNodeMessageTrigger", jsonArr);
//		}
//		
//		Object thisObj = JSON.toJSON(this);
//		jsonArr.add(thisObj);
//	}
	
	protected void getSQL(Map<String, List<Object>> saveMap) {
//		LinkedHashMap<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		String sql ="INSERT INTO "+tablename+("(id,message_type,message_content,workid,trackid,nodeid," +
				"message_id,message_name,message_from,message_to,message_para,flowid,message_class,version,status) values('").toUpperCase()+getId()+"',?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(messageType);
		dlst.add(messageContent);
		dlst.add(workid);
		dlst.add(trackid);
		dlst.add(nodeid);
		dlst.add(messageId);
		dlst.add(messageName);
		dlst.add(messageFrom);
		dlst.add(messageTo);
		dlst.add(messagePara);
		dlst.add(flowid);
		dlst.add(messageClass);
		dlst.add(version);
		dlst.add(status);
//		saveMap.put("DELETE FROM " + tablename + " WHERE ID='"+getId()+"'", null);
		saveMap.put(sql,dlst);
//		return saveMap;
	}

	public Map<String, List<Object>> getLogSQL() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		String sql ="INSERT INTO "+tablenameLog+("(id,message_type,message_content,workid,trackid,nodeid," +
				"message_id,message_name,message_from,message_to,message_para,trigger_time,issuccess,flowid,message_class,version,status) values('").toUpperCase()
					+getId()+"',?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(messageType);
		dlst.add(messageContent);
		dlst.add(workid);
		dlst.add(trackid);
		dlst.add(nodeid);
		dlst.add(messageId);
		dlst.add(messageName);
		dlst.add(messageFrom);
		dlst.add(messageTo);
		dlst.add(messagePara);
		dlst.add(triggerTime);
		dlst.add(issuccess);
		dlst.add(flowid);
		dlst.add(messageClass);
		dlst.add(version);
		dlst.add(status);
		
		saveMap.put("DELETE FROM " + tablenameLog + " WHERE ID='"+getId()+"'", null);
		saveMap.put(sql,dlst);
		return saveMap;
	}

	
	public int getVersion() {
		return version;
	}
	public void setVersion(int version) {
		this.version = version;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public String getTriggerTime() {
		return triggerTime;
	}
	public void setTriggerTime(String triggerTime) {
		this.triggerTime = triggerTime;
	}
	public String getIssuccess() {
		return issuccess;
	}
	public void setIssuccess(String issuccess) {
		this.issuccess = issuccess;
	}
	public String getMessageType() {
		return messageType;
	}

	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}

	public String getWorkid() {
		return workid;
	}

	public void setWorkid(String workid) {
		this.workid = workid;
	}

	public String getTrackid() {
		return trackid;
	}

	public void setTrackid(String trackid) {
		this.trackid = trackid;
	}

	public String getNodeid() {
		return nodeid;
	}

	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public String getMessageName() {
		return messageName;
	}

	public void setMessageName(String messageName) {
		this.messageName = messageName;
	}

	public String getMessageFrom() {
		return messageFrom;
	}

	public void setMessageFrom(String messageFrom) {
		this.messageFrom = messageFrom;
	}

	public String getMessageTo() {
		return messageTo;
	}

	public void setMessageTo(String messageTo) {
		this.messageTo = messageTo;
	}

	public String getMessageContent() {
		return messageContent;
	}

	public void setMessageContent(String messageContent) {
		this.messageContent = messageContent;
	}
	public String getMessagePara() {
		return messagePara;
	}
	public void setMessagePara(String messagePara) {
		this.messagePara = messagePara;
	}
	public String getFlowid() {
		return flowid;
	}
	public void setFlowid(String flowid) {
		this.flowid = flowid;
	}
	public String getMessageClass() {
		return messageClass;
	}
	public void setMessageClass(String messageClass) {
		this.messageClass = messageClass;
	}

}
