package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.global.StaticVarExtend;

/**
 * 工作移交
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */

/**
 * 
create table TW_HZ_HANDOVERWORK
(
  id                  VARCHAR2(32) not null,
  workid              VARCHAR2(32),
  olduser             VARCHAR2(34),
   OLDSUBJECTION       VARCHAR2(32),
  OLDSUBJECTIONTYPE   VARCHAR2(2),
  newuser             VARCHAR2(34),
  preservepermissions VARCHAR2(2),
  status              VARCHAR2(2),
  oldname             VARCHAR2(50),
  newname             VARCHAR2(50),
  trackid             VARCHAR2(32)
);
create table tw_hz_handoverwork_success
(
  id                  VARCHAR2(32) not null,
  workid              VARCHAR2(32),
  olduser             VARCHAR2(34),
   OLDSUBJECTION       VARCHAR2(32),
  OLDSUBJECTIONTYPE   VARCHAR2(2),
  newuser             VARCHAR2(34),
  preservepermissions VARCHAR2(2),
  status              VARCHAR2(2),
  dotime              VARCHAR2(20),
  oldname             VARCHAR2(50),
  newname             VARCHAR2(50),
  trackid             VARCHAR2(32)
);

 */
public class DBHandover extends BaseEntity {
	private static final long serialVersionUID = 1L;
	private String workid;
	private String olduser;
	private String oldsubjection;
	private String oldsubjectiontype;
	private String newuser;
	private String newuserid;
	
	private String oldname;
	private String newname;
	private String preservepermissions; // 0=替换,1=增加,2=代办
	private String status;
	private String trackid;

	private static String sql = "INSERT INTO "
			+ StaticVarExtend.Table_Handover
			+ "(id,workid,olduser,oldsubjection,oldsubjectiontype,newuser,newuserid,oldname,newname,preservepermissions,status,trackid) values (?,?,?,?,?,?,?,?,?,?,?,?)".toUpperCase();
	private static String sql_Success = "INSERT INTO "
			+ StaticVarExtend.Table_Handover_Log
			+ "(id,workid,olduser,oldsubjection,oldsubjectiontype,newuser,newuserid,oldname,newname,preservepermissions,status,dotime,trackid) values (?,?,?,?,?,?,?,?,?,?,?,?,?)".toUpperCase();
	
	private static String del_sql="DELETE FROM "+ StaticVarExtend.Table_Handover + " WHERE TRACKID=? AND OLDUSER=?";
	
	public void getSQL(Map<String, List<Object>> saveMap) {
		List<String> dpara = new ArrayList<String>();
		dpara.add(trackid);
		dpara.add(olduser);
		List<Object> delall = saveMap.get(del_sql);
		if(delall == null){
			delall = new ArrayList<Object>();
			saveMap.put(del_sql,delall);
		}
		delall.add(dpara);
		
		List<String> para = new ArrayList<String>();
		para.add(getId());
		para.add(workid);
		para.add(olduser);
		para.add(oldsubjection);
		para.add(oldsubjectiontype);
		
		para.add(newuser);
		para.add(newuserid);
		para.add(oldname);
		para.add(newname);
		para.add(preservepermissions);
		para.add(status);
		para.add(trackid);
		List<Object> all = saveMap.get(sql);
		if (all == null) {
			all = new ArrayList<Object>();
			saveMap.put(sql, all);
		}
		all.add(para);
		
		
	}

	public void getDelSQL(Map<String, List<Object>> saveMap) {
		saveMap.put("DELETE FROM " + StaticVarExtend.Table_Handover + " WHERE ID='"
				+ getId() + "'", null);
		List<Object> para = new ArrayList<Object>();
		para.add(getId());
		para.add(workid);
		para.add(olduser);
		para.add(oldsubjection);
        para.add(oldsubjectiontype);
		para.add(newuser);
		para.add(newuserid);
		para.add(oldname);
		para.add(newname);
		para.add(preservepermissions);
		para.add("1");
		para.add(DateUtilExtend.getNow());
		para.add(trackid);
		saveMap.put(sql_Success, para);
	}

	public static void  deleteNotReceiveWorkForSubmit(Map<String, List<Object>> saveMap,RunningData runningdata){
		DBTrack curTrack = runningdata.getCurTrack();
    	String userid = runningdata.getCurUser().getUseridWithMark();
//    	JSONArray jsonArr = runningdata.getResultJson().getJSONArray("DBHandover");
    	
    	//参数为了适应多个实例同时执行时,sql参数可以一起执行
        if (curTrack._isEnd()) {
        	List<Object> lst = new ArrayList<Object>();
        	List<Object> para = new ArrayList<Object>(1);
            para.add(curTrack.getId());
            lst.add(para);
            // 当前路径结束删除所有当前trackid下的中间数据
            saveMap.put("DELETE FROM " + StaticVarExtend.Table_Handover + " WHERE TRACKID=? ", lst);
        } 
        else {
            // 删除当前路径下的当前人的中间数据
        	List<Object> lst = new ArrayList<Object>();
        	List<Object> para = new ArrayList<Object>(2);
            para.add(curTrack.getId());
            para.add(userid);
            lst.add(para);
            saveMap.put("DELETE FROM " + StaticVarExtend.Table_Handover + " WHERE TRACKID=? AND OLDUSER=?", lst);
        }
	}

	public String getWorkid() {
		return workid;
	}

	public void setWorkid(String workid) {
		this.workid = workid;
	}

	public String getOlduser() {
		return olduser;
	}

	public void setOlduser(String olduser) {
		this.olduser = olduser;
	}
	
	public String getOldsubjection() {
        return oldsubjection;
    }

    public void setOldsubjection(String oldsubjection) {
        this.oldsubjection = oldsubjection;
    }

    public String getOldsubjectiontype() {
        return oldsubjectiontype;
    }

    public void setOldsubjectiontype(String oldsubjectiontype) {
        this.oldsubjectiontype = oldsubjectiontype;
    }

    public String getNewuserid() {
        return newuserid;
    }

    public void setNewuserid(String newuserid) {
        this.newuserid = newuserid;
    }

    public String getNewuser() {
		return newuser;
	}

	public void setNewuser(String newuser) {
		this.newuser = newuser;
	}
	
	public String getOldname() {
		return oldname;
	}

	public void setOldname(String oldname) {
		this.oldname = oldname;
	}

	public String getNewname() {
		return newname;
	}

	public void setNewname(String newname) {
		this.newname = newname;
	}

	public String getPreservepermissions() {
		return preservepermissions;
	}

	public void setPreservepermissions(String preservepermissions) {
		this.preservepermissions = preservepermissions;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getTrackid() {
		return trackid;
	}

	public void setTrackid(String trackid) {
		this.trackid = trackid;
	}
	
}
