package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.AccessUtil;

/**
 * 用于记录当前办理人在当前节点上的已办权限设置信息
 * @author liys
 *
 */
public class DBDone extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String workid;		//实例id
	private String userid;		//办理人id
	private String nodeid;		//节点id
	private String formid;		//表单id
	private String formbutton;	//表单按钮id
	private String fieldauthid;	//字段权限定义数据id
	private int version;
	
	private final static String TABLENAME = StaticVarExtend.Table_Done;
	private final static String INSERT_SQL = "INSERT INTO " 
									+ TABLENAME + "(ID,WORKID,USERID,NODEID,FORMID,FORMBUTTON,FIELDAUTHID,VERSION)VALUES(?,?,?,?,?,?,?,?)";
	private final static String DELETE_SQL = "DELETE FROM " 
									+ TABLENAME + " WHERE WORKID=? AND USERID=? AND NODEID=?";
	private final static String GET_SQL = "SELECT ID,WORKID,USERID,NODEID,FORMID,FORMBUTTON,FIELDAUTHID,VERSION FROM " 
									+ TABLENAME + " WHERE WORKID=? AND USERID=?";
	
//	protected void exeJSON(JSONObject json){
//		JSONArray jsonArr = json.getJSONArray("DBDone");
//		if(jsonArr == null){
//			jsonArr = new JSONArray();
//			json.put("DBDone", jsonArr);
//		}
//		Object thisObj = JSON.toJSON(this);
//		jsonArr.add(thisObj);
//	}
	
	protected void getSQL(Map<String, List<Object>> saveMap) {
		List<Object> dPara = new ArrayList<Object>();
		List<Object> deletePara = new ArrayList<Object>();
		deletePara.add(workid);
		deletePara.add(userid);
		deletePara.add(nodeid);
		dPara.add(deletePara);
		List<Object> tmpDeletePara = saveMap.get(DELETE_SQL);
		if(tmpDeletePara == null){
			saveMap.put(DELETE_SQL, dPara);
		}
		else{
			//20190515 liys 判断删除条件中是否已经存在相同的参数
			if(checkList(tmpDeletePara)){
				tmpDeletePara.add(deletePara);
			}
		}
		
		List<Object> iPara = new ArrayList<Object>();
		List<Object> insertPara = new ArrayList<Object>();
		insertPara.add(getId());
		insertPara.add(workid);
		insertPara.add(userid);
		insertPara.add(nodeid);
		insertPara.add(formid);
		insertPara.add(formbutton);
		insertPara.add(fieldauthid);
		insertPara.add(new Integer(version));
		iPara.add(insertPara);
		
		List<Object> tmpInsertPara = saveMap.get(INSERT_SQL);
		if(tmpInsertPara == null){
			saveMap.put(INSERT_SQL,iPara);
		}
		else{
			tmpInsertPara.add(insertPara);
		}
	}
	private boolean checkList(List<Object> lst){
		for(Object tmp :lst){
			List<Object> tmpLst = (List<Object>)tmp;
			if(workid.equals(tmpLst.get(0))
					&& userid.equals(tmpLst.get(1))
					&& nodeid.equals(tmpLst.get(2))
			){
				return false;
			}
		}
		return true;
	}
	public static List<DBDone> getListDone(JSONObject json,String workid,String userid,String nodeid,String identifier){
		List<DBDone> list = new ArrayList<DBDone>();
//		if(json!= null){
//			JSONArray jsonArr = json.getJSONArray("DBDone");
//			if(jsonArr != null){
//				for(int i=0,n=jsonArr.size();i<n;i++){
//					JSONObject tmpObj = jsonArr.getJSONObject(i);
//					if(userid.equals(tmpObj.getString("userid"))){
//						DBDone done = JSON.toJavaObject(tmpObj, DBDone.class);
//						list.add(done);
//					}
//				}
//				return list;
//			}
//		}
		List<Object> para = new ArrayList<Object>(3);
		para.add(workid);
		para.add(userid);
		
		list =	 AccessUtil.getInstance()
								.getMultiObject(GET_SQL, para, DBDone.class, identifier);
		return list;
	}
	
	public String getWorkid() {
		return workid;
	}
	public void setWorkid(String workid) {
		this.workid = workid;
	}
	public String getUserid() {
		return userid;
	}
	public void setUserid(String userid) {
		this.userid = userid;
	}
	public String getNodeid() {
		return nodeid;
	}
	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}
	public String getFormid() {
		return formid;
	}
	public void setFormid(String formid) {
		this.formid = formid;
	}
	public String getFormbutton() {
		return formbutton;
	}
	public void setFormbutton(String formbutton) {
		this.formbutton = formbutton;
	}
	public String getFieldauthid() {
		return fieldauthid;
	}
	public void setFieldauthid(String fieldauthid) {
		this.fieldauthid = fieldauthid;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}
	
	
}
