package com.horizon.wf.designer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.core.HorizonCore;
import com.horizon.db.Access;
import com.horizon.third.Authority;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.mem.PubDBUtil;
import com.horizon.wf.definition.FlowDBJsonUtil;
import com.horizon.wf.definition.FlowDefinitionUtil;
import com.horizon.wf.definition.json.JSONFlowInfo;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.info.IFlowVar;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.definition.tools.UUIDFun;
import com.horizon.wf.definition.tools.XMLParseUtil;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.expand.impl.common.AdapterFactory;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.form.FormInfo;
import com.horizon.wf.rule.form.IFormInfo;
import com.horizon.wf.tools.*;
import com.horizon.workflow.designer.wf.XMLFlowUtil;

import java.util.*;


/**
 * 前台流程定义跟后台交互数据的中间处理类
 * Created by LIYS on 2019/4/26.
 */
public class DesignerUtil {

    /**
     * 为新的前端HTML5的画图提供后端数据
     * @param showType	显示类型1=定义,2=流程跟踪图,3=监控
     * @param dataId	showtype=1,3时为flowid或者是flowid;version,showtype=2时为workid
     * @param tenantId  租户id
     * @param identifier 数据源id
     * @return
     */
    public static String chartData(String dataId,int showType,String tenantId,String identifier){
        //前台显示类型:0获取orgName,1流程定义,2流程跟踪图,3流程监控,4自动测试,5实例修改,6位置选择
        JSONObject json =null;
        try {
            json = FlowDBJsonUtil.getFlowChartData(showType, dataId, tenantId, identifier);
            if(json == null){
                System.out.println("检查参数设置是否正确");
                return "";
            }

            if (showType == 2) {
                //如果已经从内存中获取了，则不需要再次获取
                JSONArray historys = json.getJSONArray("historys");
                if(historys == null || historys.isEmpty()){
                    historys = getHistory(dataId, identifier);
                    if (historys != null) {
                        json.put("historys", historys);
                    }
                }
            }
            else if(showType == 3){
                JSONObject instanceNums = getDataForMonitor(dataId, identifier);
                if(instanceNums != null){
                    json.put("instanceNums",instanceNums);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return json.toJSONString();
    }

    /**
     * 为新的前端HTML5的画图提供后端数据
     * @param showType	显示类型1=定义,2=流程跟踪图,3=监控
     * @param dataId	showtype=1,3时为flowid或者是flowid;version,showtype=2时为workid
     * @param tenantId  租户id
     * @param identifier 数据源id
     * @param localeVal 当前语言
     *
     * @return
     */
    public static String chartData(String dataId,int showType,String tenantId,String identifier,String localeVal){
        //前台显示类型:0获取orgName,1流程定义,2流程跟踪图,3流程监控,4自动测试,5实例修改,6位置选择
        JSONObject json =null;
        try {
            json = FlowDBJsonUtil.getFlowChartData(showType, dataId, tenantId, identifier);
            if(json == null){
                System.out.println("检查参数设置是否正确");
                return "";
            }

            if (showType == 2) {
                //如果已经从内存中获取了，则不需要再次获取
                JSONArray historys = json.getJSONArray("historys");
                if(historys == null || historys.isEmpty()){
                    historys = getHistory(dataId, identifier);
                    if (historys != null) {
                        json.put("historys", historys);
                    }
                }
            }
            else if(showType == 3){
                JSONObject instanceNums = getDataForMonitor(dataId, identifier);
                if(instanceNums != null){
                    json.put("instanceNums",instanceNums);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if(StringUtil.hasValue(localeVal)){
            json.put("localeVal",localeVal);
        }
        return json.toJSONString();
    }

    public static JSONObject getDataForMonitor(String flowid,String identifier){
        //1.获取当前流程的实例数
        JSONObject json = getInstanceNum(flowid,identifier);
        //2.获取子流程节点
        getSubflowNum(json,flowid,identifier);

        return json;
    }
    private static String GetInstanceNumSQL = ("SELECT NODEID,NODENAME,COUNT(NODEID) AS SUMNUM " +
            "FROM TW_HZ_TRACK A,TW_HZ_INSTANCE B " +
            "WHERE A.WORKID=B.ID AND B.FLOWID=? GROUP BY NODEID,NODENAME");

    private static String GetEndInstanceNumSQL = ("SELECT NODEID,NODENAME,COUNT(NODEID) AS SUMNUM " +
            "FROM TW_HZ_TRACK_END A,TW_HZ_INSTANCE_END B " +
            "WHERE A.WORKID=B.ID AND B.FLOWID=? GROUP BY NODEID,NODENAME");

    private static String GetWarningNumSQL = "SELECT NODEID,NODENAME,COUNT(NODEID) AS WARNNUM " +
            "FROM TW_HZ_TASK " +
            "WHERE FLOWID=?  AND (NODELIMITTIME < ? OR FLOWLIMITTIME < ?) GROUP BY NODEID,NODENAME" ;
    /**
     * 获取某个流程的实例数
     * @param flowid
     * @param identifier
     * @return
     */
    private static JSONObject getInstanceNum(String flowid,String identifier) {
        List<Object> para = new ArrayList(1);
        para.add(flowid);
        JSONObject json = new JSONObject(new LinkedHashMap());
        int total = doInstanceNum(json,GetInstanceNumSQL,para,identifier);

        //如果结束分表，可以在这个地方添加获取已经结束的实例数
        if(HZResourceBundle.getInstance().isMoveEndInstanceDataToOtherTable()){
            total += doInstanceNum(json,GetEndInstanceNumSQL,para,identifier);
        }

        //当前实例的总数
        json.put("sumnum",total);
        //获取超期数
        String now = DateUtil.getNow();
        para.add(now);
        para.add(now);
        List<DBInstance> result = AccessUtil.getInstance()
                .getMultiObject(GetWarningNumSQL, para, DBInstance.class,identifier);
        total = 0;
        if(!result.isEmpty()){
            for(int i=0,n=result.size();i<n;i++){
                DBInstance instance = result.get(i);
                String nodeid = instance.getNodeid();
                int sum = instance.getWarnnum();
                JSONObject node = json.getJSONObject(nodeid);
                node.put("warnnum",sum);
                total += sum;
            }
        }
        json.put("warnnum",total);
        //如果需要修改显示演示的话
        json.put("sumnumcolor","#1fb5eb"); //设置颜色(蓝色)
        json.put("warnnumcolor","#ee0804");    //超期颜色(红色)
        return json;
    }

    private static int doInstanceNum(JSONObject json,String sql,List<Object> para,String identifier){
        List<DBInstance> result = AccessUtil.getInstance()
                .getMultiObject(sql, para, DBInstance.class,identifier);
        int total = 0;
        if(!result.isEmpty()){
            for(int i=0,n=result.size();i<n;i++){
                DBInstance instance = result.get(i);
                String nodeid = instance.getNodeid();
                //自由提交时可能nodeid相同,但是nodename不同,该怎么处理呢
                JSONObject tmpNodeJson = json.getJSONObject(nodeid);
                if(tmpNodeJson == null){
                    json.put(nodeid,JSON.toJSON(instance));
                }
                else{
                    int sumnum = tmpNodeJson.getIntValue("sumnum");
                    tmpNodeJson.put("sumnum",sumnum + instance.getSumnum());
                    tmpNodeJson.put("nodename",tmpNodeJson.getString("nodename") + "/" + instance.getNodename());
                }
                int sum = instance.getSumnum();
                total += sum;
            }
        }
        return total;
    }

    /**
     * 递归查询子流程节点下的实例数
     */
    private static void getSubflowNum(JSONObject json,String flowid,String identifier){
        String sql = "select distinct pre_nodeid,pre_nodename,pre_subflowid from tw_hz_flow_nodes where flowid=? and islastver=1 and pre_nodetype="+NodeTypeEnum.Node_Sub;
        List<Object> para = new ArrayList<Object>();
        para.add(flowid);
        List<Map<String,Object>> result = AccessUtil.getInstance().getMultiMap(sql,para,identifier);
        if(!result.isEmpty()){
            for(int i=0,n=result.size();i<n;i++){
                Map<String , Object> next = result.get(i);
                String nodeid = (String)next.get("pre_nodeid");
                String nextSubflowid = (String) next.get("pre_subflowid");
                if(CStrUtil.isNotNull(nextSubflowid)) {
                    String[] subflows = nextSubflowid.split(";");
                    JSONObject nodeJson = json.getJSONObject(nodeid);
                    if(nodeJson == null){
                        //当子流程节点没有停留的实例时,这个对象会为null
                        nodeJson = new JSONObject(new LinkedHashMap());
                        nodeJson.put("nodeid",nodeid);
                        nodeJson.put("nodename",(String)next.get("pre_nodename"));
                        nodeJson.put("sumnum",0);
                        nodeJson.put("warnnum",0);
                        json.put(nodeid,nodeJson);
                    }
                    nodeJson.put("subflows", subflows);

                    int total = 0,warn = 0;

                    for(String subflowid : subflows){
                        JSONObject subJson = getInstanceNum(subflowid,identifier);
                        //继续获取子流程是否有子流程节点
                        getSubflowNum(subJson,subflowid,identifier);

                        total += subJson.getIntValue("sumnum");
                        warn += subJson.getIntValue("warnnum");
                        nodeJson.put(subflowid,subJson);
                    }

                    nodeJson.put("sumnum", total + nodeJson.getIntValue("sumnum"));
                    nodeJson.put("warnnum", warn + nodeJson.getIntValue("warnnum"));
                    json.put("sumnum",json.getIntValue("sumnum") + total);
                    json.put("warnnum",json.getIntValue("warnnum") + warn);
                }
            }
        }
    }

    private static String GetWorkSQL = "SELECT B.TITLE,A.WORKID,A.ID AS TRACKID FROM TW_HZ_TRACK A,TW_HZ_INSTANCE B " +
            "WHERE B.FLOWID=? AND A.NODEID=? AND A.WORKID=B.ID ORDER BY A.VERSION";
    private static String GetEndWorkSQL = "SELECT B.TITLE,A.WORKID,A.ID AS TRACKID " +
            "FROM TW_HZ_TRACK_END A,TW_HZ_INSTANCE_END B " +
            "WHERE B.FLOWID=? AND A.NODEID=? AND A.WORKID=B.ID ORDER BY A.VERSION";

    private static String GetWarningSQL = "SELECT TITLE,WORKID,TRACKID FROM TW_HZ_TASK WHERE FLOWID=? AND NODEID=? " +
            "AND (NODELIMITTIME < ? OR FLOWLIMITTIME < ?) ORDER BY RECEIVETIME";
    public static String getWorksByNodeid(String flowid,String nodeid,boolean isWarn,String identifier){
        List<Object> para = new ArrayList(1);
        para.add(flowid);
        para.add(nodeid);
        if(isWarn){
            String now = DateUtil.getNow();
            para.add(now);
            para.add(now);
        }
        List<Map<String,Object>> result = AccessUtil.getInstance()
                .getMultiMap(isWarn?GetWarningSQL:GetWorkSQL, para, identifier);
        JSONObject json = new JSONObject(new LinkedHashMap());
        if(!result.isEmpty()){
            return JSON.toJSONString(result);
        }
        if(!isWarn){
            result = AccessUtil.getInstance()
                    .getMultiMap(GetEndWorkSQL, para, identifier);
            return JSON.toJSONString(result);
        }
        return "[]";
    }


    /**
     * 获取实例的日志记录
     * @param workId
     * @param identifier
     * @return
     */
    public static JSONArray getHistory(String workId,String identifier){
        IWorkflowOperator ica = WorkflowFactory.getWorkflowOperator();
        List<DBLog> logs = ica.getHistory(workId, identifier);
        if (logs != null && !logs.isEmpty()) {
            JSONArray result = (JSONArray) JSON.toJSON(logs);
            return result;
        }
        return null;
    }

    /**
     * 判断给定的flowid是否已经存在
     * @param flowid
     * @param identifier
     * @return
     */
    public static boolean checkFlowExist(String flowid,String identifier){
        return FlowDBJsonUtil.checkFlowExist(flowid,identifier);
    }

    /**
     * 获取指定id表单的相关信息(字段列表,按钮,字段权限)
     * @param formIds
     * @param identifier
     * @return
     */
    public static String getFormInfo(String formIds,String identifier){
        IFormInfo formInfo  = PluginsUtil.getSingleInstance().getFormInfo();
        List<String> formLst = new ArrayList<String>();
        String[] formArr = formIds.split(";");
        StringBuilder sb = new StringBuilder();

        for(int i=0,n=formArr.length;i<n;i++){
            if(CStrUtil.isNotNull(formArr[i])) {
                formLst.add(formArr[i]);
                sb.append(",").append("?");
            }
        }
        int size = formLst.size();
        if(size ==0){
            return backJson("formInfo",new JSONObject(new LinkedHashMap()));
        }
        String result = "";
        try {
           result = formInfo.getFiledAndActionByFormId(formLst, identifier);
       }
       catch (Exception e){
           e.printStackTrace();
           return backJson("formInfo",new JSONObject(new LinkedHashMap()));
       }
        JSONObject json = new JSONObject(new LinkedHashMap());
        String[] cat = result.split("\\^");//按钮和字段拆分

        splitResult(json,"buttons",cat[0]);
        splitResult(json,"fields",cat[1]);

        //获取字段权限
        sb.deleteCharAt(0);//删除第一个逗号

        if(formLst.size() ==1){
            sb.insert(0, "SELECT * FROM " + Table_FieldAuth+ " WHERE FORMID=");
        }
        else{
           sb.insert(0,"SELECT * FROM " + Table_FieldAuth+ " WHERE FORMID IN(");
           sb.append(")");
        }
        sb.append(" ORDER BY AUTH_NAME");

        List<Map<String,Object>> rList = AccessUtil.getInstance().getMultiMap(sb.toString(),formLst, identifier);

        for(int i=0,n= rList.size();i<n;i++){
            Map<String,Object> map = rList.get(i);
            String formid =(String)map.get("formid");
            String dataid = (String)map.get("id");
            JSONObject control = getJSONObjectAdd(getJSONObjectAdd(json,formid),"fieldControl");
            JSONObject auth = getJSONObjectAdd(control,dataid);
            auth.put("data",dataid);
            auth.put("label",(String)map.get("auth_name"));
            auth.put("edit",(String)map.get("editfield"));
            auth.put("must",(String)map.get("checkfield"));
            auth.put("read",(String)map.get("readfield"));
            auth.put("hide",(String)map.get("hiddenfield"));
        }
        return backJson("formInfo",json);
    }
    private static void splitResult(JSONObject json,String key,String cat){
        if(CStrUtil.isNull(cat)){
            return;
        }
        //formid1~actionid1=name1;actionid2=name2,formid2~actionid1=name1;actionid2=name2
        String[] formPro = cat.split(",");//表单拆分
        for(int i=0,n=formPro.length;i<n;i++){
            if(CStrUtil.isNull(formPro[i])){
                continue;
            }
            String[] form = formPro[i].split("~");
            JSONObject formJson = getJSONObjectAdd(json,form[0]);
            JSONObject keyJson = getJSONObjectAdd(formJson,key);

            String[] actions = form[1].split(";");
            for(int j=0,m=actions.length;j<m;j++){
                if(CStrUtil.isNull(actions[j])){
                    continue;
                }
                String [] idName = actions[j].split("=");
                keyJson.put(idName[0],idName[1]);
            }
        }
    }
    private static JSONObject getJSONObjectAdd(JSONObject json,String key){
        JSONObject tmp = json.getJSONObject(key);
        if(tmp == null){
            tmp = new JSONObject(new LinkedHashMap());
            json.put(key,tmp);
        }
        return tmp;
    }


    /**
     * 获取所有的表单列表,用于选择
     * @param identifier
     * @return
     */
    public static String getForms(String identifier){
        IFormInfo formInfo  = PluginsUtil.getSingleInstance().getFormInfo();
        List<FormInfo> list = null;
        try {
            list = formInfo.loadFormList(identifier);
        }
        catch (Exception e){
            e.printStackTrace();
            return backJson("forms",new JSONObject(new LinkedHashMap()));
        }
        JSONObject json = new JSONObject(new LinkedHashMap());
        for(int i=0,n= list.size();i<n;i++){
            FormInfo info = list.get(i);
            JSONObject tmp = new JSONObject(new LinkedHashMap());
            tmp.put("data",info.getFormId());
            tmp.put("label",info.getFormName());
            tmp.put("table",info.getTableId());
            tmp.put("type",info.getFormType());
            tmp.put("version",info.getVersion());

            json.put(info.getFormId(),tmp);
        }
        return backJson("forms",json);
    }

    /**
     * 获取orgs指定id的中文名称,orgs是任意格式的组织id,需要判断区分
     * @param orgs
     * @param identifier
     * @return
     */
    public static String getOrgName(String orgs,String tenantCode,String identifier){
        JSONObject json = JSON.parseObject(orgs);
        IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantCode);

        JSONArray person = json.getJSONArray("person");
        JSONObject orgJson = new JSONObject(new LinkedHashMap());
        if(!(person  == null || person.isEmpty())){
            String[] pp = new String[person.size()];
            person.toArray(pp);
            List<Map<String,String>> persons = org.getUserByIDs(pp,identifier);//User对象列表
            for(int i=0,n=persons.size();i<n;i++){
                Map<String,String> map = persons.get(i);
                String id = map.get("id");
                if(CStrUtil.isNotNull(id)){
                    orgJson.put(id,map.get("name"));
                }
            }

        }

        JSONArray dept = json.getJSONArray("dept");
        if(!(dept == null || dept.isEmpty())){
            String[] pp = new String[dept.size()];
            dept.toArray(pp);
            List<Map<String,String>> depts = org.getDeptsByIDs(pp,identifier);
            for(int i=0,n=depts.size();i<n;i++){
                Map<String,String> map = depts.get(i);
                String id = map.get("id");
                if(CStrUtil.isNotNull(id)){
                    orgJson.put(id,map.get("dept_name"));
                }
            }

        }

        JSONArray group = json.getJSONArray("group");
        if(!(group == null || group.isEmpty())){
            String[] pp = new String[group.size()];
            group.toArray(pp);
            List<Map<String,String>> groups = org.getGroupByIDs(pp,identifier);
            for(int i=0,n=groups.size();i<n;i++){
                Map<String,String> map = groups.get(i);
                String id = map.get("id");
                if(CStrUtil.isNotNull(id)){
                    orgJson.put(id,map.get("group_name"));
                }
            }

        }

        JSONArray position = json.getJSONArray("position");
        if(!(position == null || position.isEmpty())){
            String[] pp = new String[position.size()];
            position.toArray(pp);
            List<Map<String,String>> positions = org.getPositionByIDs(pp,identifier);
            for(int i=0,n=positions.size();i<n;i++){
                Map<String,String> map = positions.get(i);
                String id = map.get("id");
                if(CStrUtil.isNotNull(id)){
                    orgJson.put(id,map.get("position_name"));
                }
            }
        }

        return backJson("orgs",orgJson);//data:label id:cn
    }
    private static final String Table_FieldAuth = "TW_HZ_FORM_FIELDAUTH";
    private static final String Table_Rule = StaticVarExtend.Table_Rule;
    private static final String INSERTRULESQL = "INSERT INTO "
            + Table_Rule
            + "(ID,FLOWID,WORKID,FLOWVER,HTMLCODE) "
            + "values(?,?,?,?,?)";
    private static final String INSERTFORMFIELDSQL = "INSERT INTO "
            + Table_FieldAuth
            + "(ID,FORMID,TABLEID,AUTH_NAME,AUTH_CODE,EDITFIELD,CHECKFIELD,HIDDENFIELD,READFIELD,AUTHFLAG) "
            + "values(?,?,?,?,?,?,?,?,?,?)";
    private static String GETRULESQL = "SELECT HTMLCODE FROM "+Table_Rule +" WHERE ID=?";
    private static String DELRULESQL = "DELETE FROM " + Table_Rule + " WHERE ID=?";
    private static String DELFORMFIELDSQL = "DELETE FROM " + Table_FieldAuth + " WHERE ID=?";
    private static String COPYRULESQL = "SELECT ID,HTMLCODE FROM "+Table_Rule +" WHERE ID ";

    /**
     *
     * @return
     */
    public static String getRuleById(String id,String identifier){
        List<Object> para = new ArrayList<Object>();
        para.add(id);
        Map<String,Object> result = AccessUtil.getInstance()
                .getSingleMap(GETRULESQL,para,identifier);
        if(result == null || result.isEmpty()) {
            return backJson("rule", new JSONObject(new LinkedHashMap()));
        }
        else{
            JSONObject json = new JSONObject(new LinkedHashMap());
            json.put("html",result.get("htmlcode"));
            return backJson("rule",json);
        }
    }
    /*
    public static String saveRule(String jsonStr,String html, String tenantid, String identifier){
        JSONObject json = JSON.parseObject(jsonStr);
        json.put("html",html);
        Map<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        String id = json.getString("id");
        String workid = json.getString("workid");
        //如果workid不为空则说明是对实例进行修改
        if(StringUtil.isNull(workid) && StringUtil.isNotNull(id)) {
            //不是对实例进行修时,先删除原有数据

            List<Object> delpara = new ArrayList<Object>(1);
            delpara.add(id);
            map.put(DELRULESQL, delpara);
        }
        else{//id在js中一定会被赋值的,所以此分支时不会出现的(在js中赋值,可以及时对id进行绑定)
            //修改实例中的规则时,重新生成id
            id = UUIDFun.getUnid();
        }
        //2.保存
        // 插入新数据
        List<Object> dlst = new ArrayList<Object>();
        dlst.add(id);
        dlst.add(json.getString("flowid"));
        dlst.add(workid);
        dlst.add(json.getString("html"));
        map.put(INSERTRULESQL, dlst);

        if (AccessUtil.getInstance().executeMultiUpdate(map, identifier)) {
            return backJson("ok", id);
        }
        else{
            return backJson("err","保存失败");
        }
    }
    //*/
    //获取最新版本的流程
    private final static String SQL8 = "select a.flowid,a.flowname,a.version,a.typename from "+ StaticVar.Table_Flow
            +" a where a.version=(select max(version) from "+StaticVar.Table_Flow+" where flowid=a.flowid) ";
    /**
     * 获取所有的流程,用于子流程选择
     * @param identifier
     * @return
     */
    public static String getFlowList(String userId,String tenantCode,String identifier){
        Authority authority = ThirdAdapterFactory.getAuthorityInstance(tenantCode);
        List<String> rList = authority.getFlowDesignList(userId, identifier);
        if(rList==null||rList.isEmpty()) {
            return backJson("flows", new JSONObject(new LinkedHashMap()));
        }
        StringBuffer mysql=new StringBuffer();
        for(int i=0,n=rList.size();i<n;i++){
            if(i==0){
                mysql.append("?");
            }else{
                mysql.append(",?");
            }
        }
        String sql = SQL8 +" and a.FlowID in ( "+mysql.toString()+" ) order by typename";	;
        List<Map<String,Object>> flowlst = AccessUtil.getInstance().getMultiMap(sql,rList,identifier);
        JSONArray json = new JSONArray();
        for(int i=0,n=flowlst.size();i<n;i++){
            Map<String,Object> map = flowlst.get(i);
            String id =(String) map.get("flowid");
            String name = (String) map.get("flowname");
            String type = (String)map.get("typename");
            JSONObject tmp = new JSONObject(new LinkedHashMap());
            tmp.put("id",id);
            tmp.put("name",name);
            tmp.put("type",type);

            json.add(tmp);
        }

        return backJson("flows",json);
    }

    /**
     * 获取流程变量列表,子流程页面
     * @param identifier
     * @return
     */
    public static String getFlowVar(String flowid,String identifier){
        DBFlow flow = FlowDBJsonUtil.getMaxVerFlow(flowid,identifier);

        FlowDefinitionUtil flowUtil = new FlowDefinitionUtil(true,"","");
        IFlowInfo flowInfo = flowUtil.getFlowInfo(flowid,"",identifier);
        List<IFlowVar> lst = flowInfo.getAllVar();
        JSONArray json = new JSONArray();
        for(int i=0,n=lst.size();i<n;i++){
            IFlowVar var = lst.get(i);
            JSONObject tmp = new JSONObject(new LinkedHashMap());
            tmp.put("data",var.getVarId());
            tmp.put("label",var.getVarName());

            json.add(tmp);
        }
        return backJson("vars",json);
    }

    /**
     * 获取流程分类列表
     * @return
     */
    public static String getFlowType(String identifier){
        String sql = "select distinct typename from " +StaticVar.Table_Flow +" order by typename";
        List<Map<String,Object>> flowlst = AccessUtil.getInstance().getMultiMap(sql.toUpperCase(),null,identifier);
        JSONArray json = new JSONArray();
        for(int i=0,n=flowlst.size();i<n;i++){
            Map<String,Object> map = flowlst.get(i);
            String type = (String)map.get("typename");
            if(CStrUtil.isNotNull(type)){
                json.add(type);
            }
        }

        return backJson("flowtypes",json);
    }

    /**
     * 获取节点模版分类
     * @param identifier
     * @return
     */
    public static String getNodeModuleType(String identifier){
        String sql = "select distinct moduletype from tw_hz_flow_node_module order by moduletype";
        List<Map<String,Object>> flowlst = AccessUtil.getInstance().getMultiMap(sql,null,identifier);
        JSONArray json = new JSONArray();
        for(int i=0,n=flowlst.size();i<n;i++){
            Map<String,Object> map = flowlst.get(i);
            String type = (String)map.get("moduletype");
            if(CStrUtil.isNotNull(type)){
                json.add(type);
            }
        }

        return backJson("moduletype",json);
    }

    public static String getNodeModuleList(String nodefix, String identifier) {
        List<Map<String, Object>> list = FlowDBJsonUtil.getNodeModuleList(nodefix, identifier);
        JSONObject json = new JSONObject(new LinkedHashMap());
        for(int i=0,n=list.size();i<n;i++){
            Map<String,Object> map = list.get(i);
            String id   = (String) map.get("id");
            String name = (String) map.get("name");
            String type = (String) map.get("moduletype");
            String data = (String) map.get("nodexml");
            JSONObject tmp = new JSONObject(new LinkedHashMap());
            tmp.put("id",id);
            tmp.put("name",name);
            tmp.put("type",type);
            tmp.put("data",data);
            json.put(id,tmp);
        }

        return backJson("nodes", json);
    }

    public static String delNodeModule(String mId,String rId,String identifier){
        String delModuleSql = "DELETE FROM TW_HZ_FLOW_NODE_MODULE WHERE ID ";
        String delRuleSql = "DELETE FROM " + Table_Rule + " WHERE ID ";
        Map<String,List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        checkPara(saveMap,delModuleSql,mId);
        checkPara(saveMap,delRuleSql,rId);

        boolean result = AccessUtil.getInstance().executeMultiUpdate(saveMap,identifier);
        if(result) {
            return backJson("ok", "ok");
        }
        else{
            return backJson("删除失败!");
        }
    }

    private static void checkPara(Map<String,List<Object>> saveMap,String sql,String para){
        List<Object> mPara = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        String[] paras = para.split(",");
        for(int i=0,n=paras.length;i<n;i++){
            if(!"".equals(paras[i])) {
                mPara.add(paras[i]);
                sb.append(",?");
            }
        }
        if(mPara.size() == 0){
            return;
        }
        sb.deleteCharAt(0);
        if(mPara.size() ==1){
            sb.insert(0,"=");
        }
        else{
            sb.insert(0," IN (").append(")");
        }
        sb.insert(0,sql);
        saveMap.put(sb.toString(),mPara);
    }


    /**
     * 保存节点模版
     */
    public static String saveNodeModule(String name,String fix,String type,String data,String rule,String identifier){
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        String backstr = saveRuleAction(saveMap,rule,true,false,null,identifier);
        if(CStrUtil.isNotNull(backstr)){
            return backstr;
        }

        String result = FlowDBJsonUtil.saveNodeModule(saveMap,name, fix,type, data, identifier);
        //"保存成功!":"保存失败!";
        return backJson(result);
    }
    private static String saveRuleAction(Map<String, List<Object>> saveMap,String ruleStr,boolean module,
                                         boolean isVerChg,JSONFlowInfo jsonFlow,String identifier){
        if(CStrUtil.isNotNull(ruleStr)){
            JSONArray ruleArr = JSON.parseArray(ruleStr);
            List<Object> cpPara = new ArrayList<Object>();
            Map<String,JSONObject> cpMap = new HashMap<String, JSONObject>();
            StringBuilder sb = new StringBuilder();
            String jsonStr = "";
            int flowver = 0;
            if(jsonFlow != null){
                flowver = jsonFlow.getVersion();
                if(isVerChg){
                    //版本发生变化时，规则需要保留
                    jsonStr = jsonFlow.getDataString();
                }
            }
            String tmpJsonStr = jsonStr;
            boolean isChg = false;
            for(int i=0,n=ruleArr.size();i<n;i++){
                JSONObject rule = ruleArr.getJSONObject(i);
                String id = rule.getString("id");
                String html = rule.getString("html");
                String oldId = rule.getString("oldId");
                //html =="" 时分两种情况:
                //id == oldId || oldId=='' 时,删除id
                //id != oldId 时拷贝oldId到id
                if(CStrUtil.isNull(html)){
                    if((CStrUtil.isNull(oldId) || (id.equals(oldId)))){
                       if(!isVerChg) {
                           //当前版本不发生变化时才需要删除语句，为了插入时没有数据冲突（新建和更新时）
                           List<Object> para = BaseEntity.getParaList(saveMap, DELRULESQL);
                           para.add(id);
                       }
                    }
                    else{
                        //拷贝id(复制规则)
                        sb.append(",?");    //查找参数
                        cpPara.add(oldId);   //查找记录id条件
                        cpMap.put(oldId,rule); //记录对应关系,
                    }
                }
                else{
                    //有html时,新建或者更新或者拷贝
                    if(isVerChg){
                        //如果版本发生了变化，则修改id为新的数据
                        oldId = id;
                        id = getUnid();
                        tmpJsonStr = tmpJsonStr.replace(oldId,id);
                        isChg = true;
                    }
                    else if(id.equals(oldId)) {
                        //20200424 LIYS 版本增加，或者保存为原版本
                        List<Object> para = BaseEntity.getParaList(saveMap, DELRULESQL);
                        para.add(id);
                    }
                    //插入
                    List<Object> insertLst = BaseEntity.getParaList(saveMap,INSERTRULESQL);
                    insertLst.add(id);
                    if(module) {
                        insertLst.add("");
                        insertLst.add("");
                    }
                    else{
                        insertLst.add(rule.getString("flowid"));
                        insertLst.add(rule.getString("workid"));
                    }

                    insertLst.add(new Integer(flowver));
                    insertLst.add(html);
                }
            }

            if(isChg){
                JSONObject json = JSON.parseObject(tmpJsonStr);
                jsonFlow.chgJson(json);
            }
            //判断是否有需要拷贝的规则
            int size = cpPara.size();
            if(size > 0){
                sb.deleteCharAt(0);
                if(size ==1){
                    sb.insert(0,"=");
                    sb.insert(0,COPYRULESQL);
                }
                else{
                    sb.insert(0," IN(");
                    sb.insert(0,COPYRULESQL);
                    sb.append(")");
                }

                List<Map<String,Object>> rules = AccessUtil.getInstance().getMultiMap(sb.toString(),cpPara,identifier);
                if(size != rules.size()){
                    return backJson("复制流程或者复制节点时,源规则数据未能正确获取."+rules.size()+","+size);
                }
                for(int i=0;i<size;i++){
                    Map<String,Object> tmp = rules.get(i);
                    List<Object> insertLst = BaseEntity.getParaList(saveMap,INSERTRULESQL);
                    JSONObject rule = cpMap.get(tmp.get("id"));
                    insertLst.add(rule.getString("id"));
                    if(module){
                        insertLst.add("");
                        insertLst.add("");
                    }
                    else {
                        insertLst.add(rule.getString("flowid"));
                        insertLst.add(rule.getString("workid"));
                    }
                    insertLst.add(new Integer(flowver));
                    insertLst.add(tmp.get("htmlcode"));

                }
            }
        }
        return null;
    }
    /**
     * 保存前端数据(定义数据和实例数据)
     * @param jsonStr   数据json字符串
     * @param userid    操作人
     * @param showtype  数据类型
     * @param dataid    根据数据类型不同对应不同的值,showtype=1为saveFlag,showtype=5为workid
     * @param tenantid  租户标示
     * @param identifier 数据源标示
     * @return
     */
    public static String saveData(String jsonStr,String ruleStr,String userid,int showtype,
                                  String dataid,String tenantid,String identifier){
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();

        JSONObject json = JSON.parseObject(jsonStr);
        JSONFlowInfo jsonFlow = new JSONFlowInfo(json);
        jsonFlow.setModifier(userid);
        jsonFlow.setUpdate(DateUtil.getNow());
        String flowid = jsonFlow.getFlowid();
        //如果flowid没有定义，不保存
        if(!CStrUtil.hasValue(flowid)){
            return backJson("flowid 为空!");
        }
        if(showtype ==1){
            //需要考虑保存方式，来确定规则是否要拷贝
            //当showtype =1 && dataid =3时
            String saveFlag = dataid;
            return saveFlow(saveMap,jsonFlow,ruleStr,saveFlag,"",tenantid,identifier);
        }
        else if(showtype == 5){
            String backstr = saveRuleAction(saveMap,ruleStr,false,false,null,identifier);
            if(CStrUtil.isNotNull(backstr)){
                return backstr;
            }

            String workid = dataid;
            if("".equals(workid)){
                return backJson("参数异常:workid="+workid);
            }
            return saveWork(saveMap,jsonFlow,workid,tenantid,identifier);
        }

        return backJson("参数异常:showtype="+showtype);

    }

    /**
     * 保存流程定义数据,前置处理
     * @param saveMap 需要保存的其他数据SQL和对应的参数,如果没有请传入null
     * @param jsonFlow    要保存的流程对象
     * @param saveFlag    保存标示: 1=系统自动按照规则判断 , 2=强制保存为新版本
     * @param vendorid    权限id
     * @param tenantid    租户id
     * @param identifier  数据源id
     * @return
     */
    private static String saveFlow(Map<String, List<Object>> saveMap,JSONFlowInfo jsonFlow,String ruleStr,
                     String saveFlag,String vendorid,String tenantid, String identifier){
        //saveMap存放准备写入库的数据，批量提交
        if(saveMap == null){
            saveMap= new LinkedHashMap<String, List<Object>>();
        }
        //需要考虑的问题,1.存为版本时,版本的计算,2.新流程存为本地文件,再次打开的问题,3.判断 id是否为空,FlowID是否为空
        String unid = jsonFlow.getId();
        String flowid = jsonFlow.getFlowid();
        int active = jsonFlow.getActive();
        int nowver = jsonFlow.getVersion();

        //根据flowid查找流程
        DBFlow dbFlow = FlowDBJsonUtil.getMaxVerFlow(flowid,identifier);
        //判断是否为新流程
        boolean isNew = false;
        //版本相对数据库中的最大版本是否发生变化
        boolean isVerChg = false;
        if(dbFlow == null) {
            dbFlow = new DBFlow();
            dbFlow.setId(unid);
            dbFlow.setVersion(0);
            dbFlow.setFlowid(flowid);
            dbFlow.setCreated(jsonFlow.getUpdate());
            dbFlow.setCreator(jsonFlow.getModifier());

            jsonFlow.setCreated(jsonFlow.getUpdate());
            jsonFlow.setCreator(jsonFlow.getModifier());
            vendorid = jsonFlow.getModifier();
            isNew = true;
        }

        if(!CStrUtil.hasValue(unid)){
            //32位id是否为空（一般不会走到此处）
            unid = getUnid();
            nowver = dbFlow.getVersion();
            //新流程版本为1，已存在流程,流程版本+1
            if(nowver==0)
                nowver=1;
            else
                nowver++;
        }
        else{
            int lastver = dbFlow.getVersion();
            if("3".equals(saveFlag)){
                //此为保存版本不变
                unid=dbFlow.getId();
                nowver=dbFlow.getVersion();

            }
            else if("2".equals(saveFlag)){
                //强制保存新版本时
                unid =getUnid();
                nowver = lastver+1;
            }
            else if(lastver >= nowver){
                //版本相同但是id不相同时,可能删除或者其他原因不匹配时,纠正
                if(!dbFlow.getId().equals(unid)){
                    unid = getUnid();
                    nowver = lastver+1;
                }
                else if(dbFlow.getActive() ==1){
                    unid = getUnid();
                    nowver = lastver+1;
                }
            }
            else{
                unid = getUnid();
                nowver = lastver + 1;
            }
        }

        if(nowver != jsonFlow.getVersion()){
            isVerChg = true;
        }

        dbFlow.setId(unid);
        dbFlow.setVersion(nowver);
        //更新json值
        jsonFlow.setId(dbFlow.getId());
        jsonFlow.setVersion(nowver);

        String backstr = saveRuleAction(saveMap,ruleStr,false,isVerChg,jsonFlow,identifier);
        if(CStrUtil.isNotNull(backstr)){
            return backstr;
        }

        if(!CStrUtil.hasValue(dbFlow.getCreator())){
            dbFlow.setCreated(jsonFlow.getCreated());
            dbFlow.setCreator(jsonFlow.getCreator());
        }

        dbFlow.setModified(jsonFlow.getUpdate());
        dbFlow.setModificator(jsonFlow.getModifier());

        //更新需要保存的对象值
//        dbFlow.setId(unid);
//        dbFlow.setVersion(nowver);
        dbFlow.setActive(active);
        dbFlow.setFlowname(jsonFlow.getFlowname());
        dbFlow.setType(jsonFlow.getFlowType());
        dbFlow.setTypename(jsonFlow.getFlowTypeName());
        if(CStrUtil.isNull(dbFlow.getType())){
            dbFlow.setType(dbFlow.getTypename());
        }
        dbFlow.setXml("");

        if(isNew && CStrUtil.hasValue(vendorid)){
            Authority authority = ThirdAdapterFactory.getAuthorityInstance(tenantid);
            //初始化权限数据
            authority.authInit(vendorid, flowid, "FLOWOPER", saveMap, identifier);
        }

        if(!"3".equals(saveFlag)) {
            //设置启动方式,saveFlag =3时不需要处理启动方式
            startType(jsonFlow, saveMap, flowid, tenantid, identifier);
        }

        //20160616 liys 增加XML对象放入DBFlow对象中
        dbFlow.setXml(jsonFlow.getDataString());
        dbFlow.setFlowInfo(jsonFlow);
        //保存流程定义文件
        String result = FlowDBJsonUtil.saveFlow(dbFlow,tenantid, identifier);
        //保存流程其他相关数据
        if(result.equals(dbFlow.getFlowid())){
            boolean flag = AccessUtil.getInstance().executeMultiUpdate(saveMap,identifier);
            if(flag){
                JSONObject back = new JSONObject(new LinkedHashMap());
                back.put("result","ok");
                back.put("id",dbFlow.getId());
                back.put("version",dbFlow.getVersion());
                return back.toJSONString();
            }
        }
        else if("0".equals(result)){
            //License验证失败，没有保存流程定义文件
            return backJson("流程数量超过license限制!");
        }
        return backJson("保存失败!");
    }
    /**
     * 保存流程时，对开始节点启动方式进行的处理
     * @param saveMap：要返回的集合
     * @param flowid：流程id
     * @param identifier：系统数据库标识
     */
    private static void startType(JSONFlowInfo flow, Map<String,List<Object>> saveMap,
                                  String flowid,String tenantCode,String identifier){
        ITaskInterface taskImpl = AdapterFactory.getTaskInterface();
        //删除定时启动
        taskImpl.deleteFlowStartTask(flowid);
        //删除消息
        saveMap.put("delete from "+ StaticVarExtend.Table_Node_Message_Trigger+" where FLOWID='"+flowid+"' and MESSAGE_TYPE='flowStart'", null);
        //删除信号
        saveMap.put("delete from "+StaticVarExtend.Table_Node_Signal_Trigger+" where FLOWID='"+flowid+"' and SIGNAL_TYPE='flowStart'", null);

        String msgSql = "";
        List<Object> sqlpara = new ArrayList<Object>();

        //启动方式
        IFlowNode startNode = flow.getStartNode();
        String startType = startNode.getStartModeType();
        startType = startType.equals("")?"0":startType;
        //流程状态
        int activeFlag = flow.getActive();
        //流程启用且已经发布状态
        if(activeFlag == 1){
            int startTypeInt = Integer.parseInt(startType);
            if(startTypeInt == NodeTypeEnum.Node_Timer_Start){
                //定时启动
                String dataTime = startNode.getStartModeTimeDate();//开始时间
                String cycle = startNode.getStartModeTimeCycle();
                if(cycle ==null || "".equals(cycle)){
                    cycle="0";
                }
                Map<String,Object> map = new HashMap<String,Object>();
                map.put("startTime", dataTime);//开始执行时间
                map.put("repeatInterval", cycle);//执行频率，默认毫秒,0表示仅执行一次
                map.put("flowid", flowid);
                map.put("identifier", identifier);
                map.put("tenantid", tenantCode);
                //加入定时任务队列
                taskImpl.addFlowStartTask(map);
            }else if(startTypeInt == NodeTypeEnum.Node_Msg_Start){
                //消息启动
                String msgid = startNode.getStartModeTriggerMessageID();
                String msgname =startNode.getStartModeTriggerMessageName();
                String msgfrom = startNode.getStartModeTriggerMessageFrom();
                String msgto = startNode.getStartModeTriggerMessageTo();
                String para = startNode.getStartModeSignalPara();

                msgSql = "insert into "+StaticVarExtend.Table_Node_Message_Trigger+"(ID,MESSAGE_TYPE,MESSAGE_ID,MESSAGE_NAME,MESSAGE_FROM,MESSAGE_TO,MESSAGE_PARA,FLOWID,status)" +
                        " VALUES(?,?,?,?,?,?,?,?,?)";
                sqlpara.add(getUnid());
                sqlpara.add("flowStart");
                sqlpara.add(msgid);
                sqlpara.add(msgname);
                sqlpara.add(msgfrom);
                sqlpara.add(msgto);
                sqlpara.add(para);
                sqlpara.add(flowid);
                sqlpara.add("1");
            }else if(startTypeInt == NodeTypeEnum.Node_Signal_Start){
                //信号启动
                String para = startNode.getStartModeSignalPara();
                msgSql = "insert into "+StaticVarExtend.Table_Node_Signal_Trigger+"(ID,FLOWID,signal_type,signal_para,status)" +
                        " VALUES(?,?,?,?,?)";
                sqlpara.add(getUnid());
                sqlpara.add(flowid);
                sqlpara.add("flowStart");
                sqlpara.add(para);
                sqlpara.add("1");
            }
        }

        if(CStrUtil.hasValue(msgSql)){
            saveMap.put(msgSql, sqlpara);
        }
    }


    private static String saveWork(Map<String, List<Object>> saveMap,JSONFlowInfo flow,String workid,
                                   String tenantid,String identifier){
        //需要考虑的问题,1.存为版本时,版本的计算,2.新流程存为本地文件,再次打开的问题,3.判断 id 是否为空,FlowID是否为空
        String flowid = flow.getFlowid();
        int nowver = flow.getVersion();
        String flowname = flow.getFlowname();
        DBWork xWork = new DBWork();
        xWork.setId(workid);
        xWork.setFlowname(flowname);
        xWork.setFlowver((nowver));
        //准备写入库的数据
//        Map saveMap = new LinkedHashMap();

        xWork.setWorkxml(flow.toJSONString());
        //保存实例
        if(FlowDBJsonUtil.saveInstance(xWork, saveMap, tenantid, identifier)){
            JSONObject back = new JSONObject(new LinkedHashMap());
            back.put("result","ok");
            back.put("flowid",flowid);
            back.put("version",nowver);
            return back.toJSONString();
        }

        return backJson("保存失败!");
    }

    public static String makeUNID(){
        JSONObject result = new JSONObject(new LinkedHashMap());
        JSONArray unids = new JSONArray();
        for(int i=0;i<50;i++){
            unids.add(UUIDFun.getUnid());
        }
        result.put("Unids",unids);
        return result.toJSONString();
    }
    /**
     * 保存表单字段权限
     * @return
     */
    public static String saveFormField(String jsonStr, String tenantid, String identifier){
        JSONObject json = JSON.parseObject(jsonStr);
        Map<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        //1.判断Name是否合法
        String id = json.getString("data");
        if(!"".equals(id)) {
            String sql = "SELECT ID FROM " + Table_FieldAuth
                    + " WHERE FORMID=? AND AUTH_NAME=? AND ID!=?";
            List<Object> lstConditions = new ArrayList<Object>();
            lstConditions.add(json.getString("formid"));
            lstConditions.add(json.getString("label"));
            lstConditions.add(id);
            if(AccessUtil.getInstance().getRsCount(sql, lstConditions, identifier) > 0){
                return backJson("err",
                        "在当前表单下已经存在:"+json.getString("label"));
            }
            //如果可以保存,则需要先删除当前数据
            // 先删除原有数据
            String delSQL = "DELETE FROM " + Table_FieldAuth + " WHERE ID=?";
            List<Object> delpara = new ArrayList<Object>(1);
            delpara.add(id);
            map.put(delSQL, delpara);
        }
        else{
            id=UUIDFun.getUnid(); //新创建时生成一个新的32位id
        }
        //2.保存
        // 插入新数据
        String insertSQL = "INSERT INTO "
                + Table_FieldAuth
                + "(ID,FORMID,AUTH_NAME,AUTH_CODE,TABLEID,EDITFIELD,CHECKFIELD,READFIELD,HIDDENFIELD,AUTHFLAG) "
                + "values(?,?,?,?,?,?,?,?,?,?)";

        List<Object> dlst = new ArrayList<Object>();
        dlst.add(id);
        dlst.add(json.getString("formid"));
        dlst.add(json.getString("label"));
        dlst.add("");
        dlst.add("");
        dlst.add(json.getString("edit"));
        dlst.add(json.getString("must"));
        dlst.add(json.getString("read"));
        dlst.add(json.getString("hide"));
        dlst.add("");
        map.put(insertSQL, dlst);

        if (AccessUtil.getInstance().executeMultiUpdate(map, identifier)) {
            return backJson("ok", id);
        }
        else{
            return backJson("err","保存失败");
        }
    }

    /**
     * 导出流程定义
     */
    public static String exportFlow(String flowid, String identifier) {

        String rSql = "SELECT * FROM " + Table_Rule + " WHERE  FLOWID=?";
        String fSql = "SELECT * FROM " + StaticVarExtend.Table_Flow + " WHERE FLOWID =? AND VERSION=?";
        List<Object> rPara = new ArrayList<Object>();
        List<Object> fPara = new ArrayList<Object>();
        String[] d = flowid.split("-");
        fPara.add(d[0]);
        fPara.add(new Integer(d[1]));
        //规则
        rPara.add(d[0]);
        DBFlow dbFlow = PubDBUtil.getDBFlow(fSql,fPara,identifier);
        List<Map<String,Object>> rlist = AccessUtil.getInstance().getMultiMap(rSql,rPara,identifier);
        List<Map<String,Object>> formFieldAuth=getAllFormFieldAuthByFlowJson(dbFlow.getXml(),identifier);
        dbFlow.setXml(PubDBUtil.encodeXml(dbFlow.getXml()));
        JSONObject data = new JSONObject(new LinkedHashMap());
        data.put("Flow",dbFlow);
        data.put("Rule",rlist);
        data.put("FormField",formFieldAuth);

        return data.toJSONString();
    }

    public static String importFlow(String data,String tenantid,String identifier){
        Map<String,List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        //20201109 LIYS 增加对xml定义的导入支持
        //数据类型判断
        int pos = data.indexOf("Flow");
        //1.如果是xml则调用 XMLFlowUtil.saveFlow(workXML, saveFlag, vendorid,tenantCode, dbIdentifier)方法执行
        if(pos > 3){
            HZElement workXML = XMLParseUtil.convertStringToXML(data);
            String rs = XMLFlowUtil.saveFlow(workXML, "2", "1",tenantid, identifier);
            if(rs == null || "".equals(rs)) {
                return backJson("导入失败!");
            }
            else if("0".equals(rs)){
                return backJson("license超过限制,导入失败!");
            }
            else{
                return backJson("ok","导入成功!");
            }
        }
        //2.json需要修为调用保存数据用于license数目的验证
        JSONObject json = JSON.parseObject(data);
        JSONObject flowJson =json.getJSONObject("Flow");
        List<DBFlow> newFlows = new ArrayList<DBFlow>();
        DBFlow flow = JSON.toJavaObject(flowJson,DBFlow.class);
        newFlows.add(flow);
        boolean result = FlowDBJsonUtil.importFlow(saveMap,newFlows,tenantid,identifier);
        if(!result){
            return backJson("license超过限制,导入失败!");
        }
        if(FlowDBJsonUtil.checkFlow(flow,identifier)){
            Authority authority = ThirdAdapterFactory.getAuthorityInstance(tenantid);
            //初始化权限数据
            authority.authInit(HorizonCore.USER_ID.value(), flow.getFlowid(), "FLOWOPER", saveMap, identifier);
        }
        JSONArray rlist = json.getJSONArray("Rule");
        for(int i=0;i<rlist.size();i++){
            JSONObject rule = rlist.getJSONObject(i);

            List<Object> dPara = BaseEntity.getParaList(saveMap,DELRULESQL);
            List<Object> iPara = BaseEntity.getParaList(saveMap,INSERTRULESQL);
            dPara.add(rule.getString("id"));

            iPara.add(rule.getString("id"));
            iPara.add(rule.getString("flowid"));
            iPara.add("");//workid
            iPara.add(rule.getString("flowver"));
            iPara.add(rule.getString("htmlcode"));
        }

        JSONArray formlist = json.getJSONArray("FormField");
        if(null!=formlist && formlist.isEmpty()){
            for(int i=0;i<formlist.size();i++){
                JSONObject formField = formlist.getJSONObject(i);

                List<Object> dFormFieldPara = BaseEntity.getParaList(saveMap,DELFORMFIELDSQL);
                List<Object> iFormFieldPara = BaseEntity.getParaList(saveMap,INSERTFORMFIELDSQL);
                dFormFieldPara.add(formField.getString("id"));

                iFormFieldPara.add(formField.getString("id"));
                iFormFieldPara.add(formField.getString("formid"));
                iFormFieldPara.add(formField.getString("tableid"));
                iFormFieldPara.add(formField.getString("auth_name"));
                iFormFieldPara.add(formField.getString("auth_code"));
                iFormFieldPara.add(formField.getString("editfield"));
                iFormFieldPara.add(formField.getString("checkfield"));
                iFormFieldPara.add(formField.getString("hiddenfield"));
                iFormFieldPara.add(formField.getString("readfield"));
                iFormFieldPara.add(formField.getString("authflag"));
            }
        }
        result = AccessUtil.getInstance().executeMultiUpdate(saveMap,identifier);

        if(result){
            return backJson("ok","导入成功!");
        }
        return backJson("导入失败!");
    }

    /**
     * 获取 节点事件/自定义办理人 实现配置信息
     * @param type
     * @param identifier
     * @return
     */
    public static List<DBCustomCls> findFlowRuleImpl(String type,String identifier){

        String sql="SELECT * FROM TW_HZ_CUSTOMCLS WHERE TYPE=?";
        List<String> con= Lists.newArrayList();
        con.add(type);
        return Access.getMultiObject (sql,con,DBCustomCls.class,identifier);
    }

    /**
     * 新增 节点事件/自定义办理人 实现配置信息
     * @param customCls
     * @param identifier
     * @return
     */
    public static DBCustomCls addFlowRuleImpl(DBCustomCls customCls, String identifier){

        customCls.setId(Access.getUUID());
        customCls.setCreated(DateUtil.getNow());
        Map<String,DBCustomCls> map= Maps.newHashMap();
        map.put("TW_HZ_CUSTOMCLS",customCls);
        boolean saveStatus=Access.saveObjectData(map,identifier);
        if(!saveStatus)return null;
        return customCls;
    }

    /**
     * 删除 节点事件/自定义办理人 实现配置信息
     * @param id
     * @param identifier
     * @return
     */
    public static boolean delFlowRuleImpl(String id,String identifier){

        String sql="DELETE FROM TW_HZ_CUSTOMCLS WHERE ID=?";
        List<String> con= Lists.newArrayList();
        con.add(id);
        return Access.executeUpdate(sql,con,identifier);
    }

    /**
     * 校验表单字段权限名称是否重复
     * @param id
     * @param identifier
     * @param formId
     * @return
     */
    public static boolean checkFormAuthName(String id,String formId,String name,String identifier){

        String sql="SELECT FF.AUTH_NAME FROM TW_HZ_FORM_FIELDAUTH FF WHERE FF.AUTH_NAME=? AND FF.FORMID=?";
        List<String> con= Lists.newArrayList();
        if(StringUtil.hasValue(id)){
            con.add(id);
            sql="SELECT FF.AUTH_NAME FROM TW_HZ_FORM_FIELDAUTH FF WHERE FF.ID!=? AND FF.AUTH_NAME=? AND FF.FORMID=?";
        }
        con.add(name);
        con.add(formId);
        int result=Access.getRsCount(sql,con,identifier);
        return result<=0;
    }

    public static String backJson(String result,String msg){
        JSONObject back = new JSONObject(new LinkedHashMap());
        back.put("result",result);
        back.put("msg",msg);
        return back.toJSONString();
    }
    public static String backJson(String msg){
        return backJson("err",msg);
    }

    public static String backJson(String key,JSONObject json){
        JSONObject result = new JSONObject(new LinkedHashMap());
        result.put(key,json);
        return result.toJSONString();
    }
    private static String backJson(String key,JSONArray json){
        JSONObject result = new JSONObject(new LinkedHashMap());
        result.put(key,json);
        return result.toJSONString();
    }
    private static String getUnid(){
        return UUIDFun.getUnid();
    }

    /**
     * 通过流程定义信息获取流程上配置的表单字段权限信息
     * @param xml
     * @return
     */
    private static List<Map<String,Object>> getAllFormFieldAuthByFlowJson(String xml,String identifier){
        if(!StringUtil.hasValue(xml))return null;
        List<String> formAuthList=Lists.newArrayList();
        JSONObject json = JSON.parseObject(xml);
        JSONFlowInfo  jsonFlowInfo=new JSONFlowInfo(json);
        List<IFlowNode> flowNodes= jsonFlowInfo.getAllNodes();
        List<String> auth=Lists.newArrayList();
        auth.add("Done");
        auth.add("SecondAuthor");
        auth.add("Author");
        auth.add("Reader");
        auth.add("Creator");
        auth.add("Manager");
        for (IFlowNode flowNode:flowNodes){
            for (String authStr:auth){
                INodeControl nodeControl= flowNode.getParticipantsControl(authStr);
                if(null==nodeControl)continue;
                List<INodeForm> nodeForms= nodeControl.getAllNodeForms();
                if(null==nodeForms)continue;
                for (INodeForm iNodeForm:nodeForms ){
                    if(iNodeForm.getRealFormid().length()==32){
                        formAuthList.add(iNodeForm.getRealFormid());
                    }
                }
            }
        }
        if(null==formAuthList || formAuthList.isEmpty())return new ArrayList<Map<String, Object>>();
        String fieldAuthSql="SELECT ID,FORMID,TABLEID,AUTH_NAME,AUTH_CODE,EDITFIELD,CHECKFIELD,HIDDENFIELD,READFIELD,AUTHFLAG FROM "+Table_FieldAuth+" WHERE ID IN (";
        for(String au:formAuthList){
            fieldAuthSql+="?,";
        }
        fieldAuthSql=fieldAuthSql.substring(0,fieldAuthSql.length()-1)+" )";
        return AccessUtil.getInstance().getMultiMap(fieldAuthSql,formAuthList,identifier);
    }
}
