package com.horizon.wf.config;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
/**
 * pub包中的操作使用到的语言文件获取
 * @author Administrator
 *
 */
public class PubInfo {
	private LangInfo langInfo;
	private ResourceBundle bundle;
	
	public static Map<String,PubInfo> map = new HashMap<String,PubInfo>();
	public static PubInfo getPubInfo(String tenantid){
		PubInfo pubInfo = map.get(tenantid);
		if(pubInfo == null){
			pubInfo = new PubInfo(LangInfo.getInstance(tenantid));
			map.put(tenantid, pubInfo);
		}
		return pubInfo;
	}
	public static PubInfo getPubInfo(LangInfo langInfo){
		return new PubInfo(langInfo);
	}
	
	private PubInfo(LangInfo langInfo){
		this.langInfo = langInfo;
		bundle = langInfo.getPubResourceBundle();
	}
	
	public String getInfo(String key,String defaultValue){
		return langInfo.getString(bundle, key, defaultValue);
	}
}
