package com.horizon.wf.bean;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.action.base.HmiResultBean;
import com.horizon.wf.core.instance.CreateInstance;
import com.horizon.wf.core.instance.OpenInstance;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.track.json.bean.TrackFormJsonImpl;
import com.horizon.wf.core.track.json.impl.ITrackJson;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.definition.xml.IXmlButton;
import com.horizon.wf.entity.db.DBRelation;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * 存放流程操作过程中的返回值
 * 
 * @author liangjw
 * @version 1.0
 *  2013-05-24
 */
public class WorkResultBean extends HmiResultBean implements IWorkResult {
	private List<ITrackJson> activeTrackInfos;				//如果打开后有多条可选的路径则获取该值
	private OpenInstance openInstance = null;
	private CreateInstance createInstance = null;
	//当前路径
	
	private boolean isNowUserLock;
	private String lockUser;
//	private Set<IGetBackInfo> getBackInfos = null;			//执行退回操作，提示选择办理人时，从该变量中获取相应值
	
	private List<INodeButton> curButton = new ArrayList<INodeButton>();//当前可用按钮组成的列表
	
	/**
	 * 获取当前节点的主办人
	 * @return 多个以";"割开
	 */
	public String getCurNodeAuthor(){
		StringBuilder authors = new StringBuilder("");
		if(null != runningdata){
			List<DBWorkAuth> auths = new ArrayList<DBWorkAuth>();
			auths.addAll(runningdata.getXAuthListForCurNode(StaticVarExtend.AUTH_AUTHOR
					+StaticVarExtend.StrSplitChar+StaticVarExtend.AUTH_HUIQIAN_AUTHOR));//办理人//会签人

//			auths.addAll(runningdata.getXAuthListForCurNode(StaticVarExtend.AUTH_HUIQIAN_AUTHOR));
			
			if(CollectionUtil.isListNotEmpty(auths)){
				for(int i=0,n=auths.size();i<n;i++){
					DBWorkAuth auth = auths.get(i);
					authors.append(auth._getFullNameWithAgent());
					authors.append(StaticVarExtend.UserSplitChar);
				}
			}else{
				authors.append(StaticVarExtend.UserFix).append(StaticVarExtend.Mark_Fix).append(getCurUser().getUserid());
			}
		}
		return authors.toString();
	}
	
	/**
	 * 	public static final int FlowStatus_Start 	= 100;
		public static final int FlowStatus_Normal 	= 110;
		public static final int FlowStatus_Reject 	= 130;
		public static final int FlowStatus_Pause 	= 140;
		public static final int FlowStatus_End 		= 170;
		public static final int FlowStatus_ErrorEnd	= 180;
	 * @param flowStatus
	 * @return
	 */
	public String getFlowStatusName(int flowStatus){
		String statusName = "";
		switch(flowStatus){
		case StaticVarExtend.FlowStatus_Start:statusName = "起草";break;    //100
		case StaticVarExtend.FlowStatus_Normal:statusName = "正常";break;   //110
		case StaticVarExtend.FlowStatus_Huiqian:statusName = "会签";break;  //120
		case StaticVarExtend.FlowStatus_Reject:statusName = "退回";break;   //130
		case StaticVarExtend.FlowStatus_Pause:statusName = "暂停";break;    //140
		case StaticVarExtend.FlowStatus_Cancel:statusName = "撤办";break;   //150
		case StaticVarExtend.FlowStatus_SubFlow:statusName = "子流程";break;//160
		case StaticVarExtend.FlowStatus_End:statusName = "结束";break;      //170
		case StaticVarExtend.FlowStatus_ErrorEnd:statusName = "终止";break; //180
		case StaticVarExtend.FlowStatus_GetBack:statusName="拿回";break;    //190
		default:statusName = "";break;
		}
		return statusName;
	}
	
	/**
	 * 根据nodeid获取节点选择人员的方式
	 * @param nodeid
	 * @return 1:单选(默认)   2:多选
	 */
	public int getNextSelectTypeByNodeid(String nodeid){
		int selectType = 1;
		String funname = runningdata.getFunname();
		if(StringUtilExtend.isNotNull(funname)){
			//加签,会签,添加读者,减签为多选
			if(StaticVarExtend.OPERATOR_FUNNAME_JIAQIAN.equals(funname) ||
					StaticVarExtend.OPERATOR_FUNNAME_HUIQIAN.equals(funname) ||
					StaticVarExtend.OPERATOR_FUNNAME_ADD_READER.equals(funname) ||
					StaticVarExtend.OPERATOR_FUNNAME_REDUCE_AUTHOR.equals(funname)){
				selectType = 2;
			}else if(StaticVarExtend.OPERATOR_FUNNAME_SUBMIT.equals(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_STARTFLOW.equals(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_GOTO.equals(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_REISSUE_ROUTER.equals(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_REPLACE_AUTHOR.equals(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_JUMP_REJECT.equals(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_REJECT.equals(funname)
					){//提交需要根据下一节点类型来判断人员选择方式
				if(CollectionUtil.isListNotEmpty(getNextNodes())){
					for(int i=0,n=getNextNodes().size();i<n;i++){
						INextNode node = getNextNodes().get(i);
						if(null != nodeid && nodeid.equals(node.getNodeid())){
							int nodetype = node.getFlowNode().getNodetype();
							//下一节点为多人单一签核，多人顺序，多人处理时为多选
							if(NodeTypeEnum.Node_Multi_Single == nodetype || 
									NodeTypeEnum.Node_Multi == nodetype ||
											NodeTypeEnum.Node_Order == nodetype){
								selectType = 2;
							}
						}
					}
				}
			}
			
		}
		return selectType;
	}
	/**
	 * 根据nodeid从下一节点列表中获取对应的trackid
	 * @param nodeid
	 * @return
	 */
	public String getNxtTrackidByNodeid(String nodeid){
		List<DBTrack> nextTrackInfos = getNextTrackInfos();
		if(nextTrackInfos == null || nextTrackInfos.isEmpty()){
			return "";
		}
		for(int i=0,n=nextTrackInfos.size();i<n;i++){
			DBTrack track = nextTrackInfos.get(i);
			if(track.getNodeid().equals(nodeid)){
				return track.getId();
			}
		}
		return "";
	}
	/**
	 * 根据formid获取dataid
	 * 先查找前台是否传入dataid，如果传入则直接返回
	 * @param formid
	 * @return
	 */
	public String getDataidByFormid(String formid){
		if(formid.equals("FlowTrack")){
			return "";
		}
		TrackFormJsonImpl trackForm = runningdata.getTrackFormInfo();
		String dataid = trackForm.getDataidByFormid(formid);
		if(StringUtilExtend.isNotNull(dataid)){
		    runningdata.putValueToHashMap(formid+"_ID", dataid);
		    return dataid;
		}
		
		String sql = "SELECT DATAID FROM "+StaticVarExtend.Table_WorkApp +" WHERE WORKID = ? AND FORMID = ?";
		List<String> conditionList = new ArrayList<String>();
		conditionList.add(getWorkid());
		conditionList.add(formid);
		List<Object> resultList =  AccessUtil.getInstance().getSingleList(sql, conditionList, getIdentifier());
		dataid = StaticFunExtend.getUnid();
		//标识此dataid为新创建
		runningdata.putValueToHashMap(dataid+"_IsNewDoc","1");
		if(CollectionUtil.isListEmpty(resultList)){
			String temp = runningdata.getValueFromHashMap(formid+"_ID");
			//如果map中没有dataid则放入map
			if(StringUtilExtend.isNotNull(temp)){
				dataid = temp;
			}
		}else{
			dataid = String.valueOf(resultList.get(0));
			runningdata.putValueToHashMap(dataid+"_IsNewDoc","0");
		}
		runningdata.putValueToHashMap(formid+"_ID", dataid);
		
		return dataid;
	}
	
	/**
     * 判断指定的dataid是否为新创建的数据
     * @param dataid
     * @return
     */
	public boolean checkDataidIsNewCreate(String dataid){
	    String value = runningdata.getValueFromHashMap(dataid+"_IsNewDoc");
	    if(StringUtilExtend.isNotNull(value)){
	        if("1".equals(value)){
	            return true;
	        }
	    }
	    return false;
	}
	/**
	 * 根据workid获取关联关系数据
	 * @param workid
	 * @return List<DBRelation>
	 */
	public List<DBRelation> getRelationsByWorkid(String workid){
		if(StringUtilExtend.isNull(workid)){
			return null;
		}
		String sql = "SELECT  ID,WORKID,TABLEID,DATAID,FORMID,AUTH FROM "+StaticVarExtend.Table_WorkApp +" WHERE WORKID = ?";
		List<String> conditionList = new ArrayList<String>();
		conditionList.add(workid);
		return  AccessUtil.getInstance().getMultiObject(sql, conditionList, DBRelation.class, getIdentifier());
	}
	
	private String getIdentifier(){
		if(null != runningdata){
			return runningdata.getInitData().getFlowIdentifier();
		}
//		if(null != createInstance){
//			return createInstance.getRunningdata().getInitData().getFlowIdentifier();
//		}
//		if(null != openInstance){
//			return openInstance.getRunningdata().getInitData().getFlowIdentifier();
//		}
		return "";
	}
	
	public String getWorkid() {
		if(getWork() ==null){
			return getWorkParaBean().getWorkId();
		}
		return getWork().getId();
	}


	public List<ITrackJson> getActiveTrackInfos() {
		return activeTrackInfos;
	}

	public boolean isNowUserLock() {
		return isNowUserLock;
	}

	public String getLockUser() {
		return lockUser;
	}
	public void setTmpAuthorMap(String key,String value) {
		getTmpAuthorMap().put(key, value);
	}

	public void setLockUser(String lockUser) {
		this.lockUser = lockUser;
	}

	public void setNowUserLock(boolean isNowUserLock) {
		this.isNowUserLock = isNowUserLock;
	}
	
	public void setActiveTrackInfos(List<ITrackJson> activeTrackInfos) {
		this.activeTrackInfos = activeTrackInfos;
	}

	public void setOpenInstance(OpenInstance openInstance) {
		this.openInstance = openInstance;
	}

	public void setCreateInstance(CreateInstance createInstance) {
		this.createInstance = createInstance;
	}

	public OpenInstance getOpenInstance() {
		return openInstance;
	}

	public CreateInstance getCreateInstance() {
		return createInstance;
	}
	/**
	 * 通过当前人所有权限获取当前可用的按钮
	 * @return 当前可用按钮组成的列表
	 */
	public List<INodeButton> getCurNodeButton(){
		return curButton;
	}
	public List<IXmlButton> getCurButton(){
		List<IXmlButton> button = new ArrayList<IXmlButton>();
		for(INodeButton btn:curButton){
			button.add(btn);
		}
		return button;
	}
	public void setCurButton(List<INodeButton> curButton) {
		this.curButton = curButton;
	}

	public String forServiceString() {
		StringBuilder sb = new StringBuilder(10000);
		sb.append("<WorkResultBean>");
		CStrUtil.appendTo(sb,"workid",getWorkid());
		CStrUtil.appendTo(sb,"curNodeAuthor",getCurNodeAuthor());
		
		forServiceString(sb);
		
		if(!(activeTrackInfos == null || activeTrackInfos.isEmpty())){
			sb.append("<activeTrackInfoList>");
			for(int i=0,n=activeTrackInfos.size();i<n;i++){
				ITrackJson track = activeTrackInfos.get(i);
				sb.append("<xml>");
					sb.append(track.toJSONString());
				sb.append("</xml>");
			}
			sb.append("</activeTrackInfoList>");
		}
		if(!(curButton == null || curButton.isEmpty())){
			sb.append("<curButtonXmlList>");
			for(int i=0,n=curButton.size();i<n;i++){
				INodeButton button = curButton.get(i);
				sb.append("<xml>");
					sb.append(button.getDataString());
				sb.append("</xml>");
			}
			sb.append("</curButtonXmlList>");
		}
		sb.append("</WorkResultBean>");
		
		return sb.toString();//.replace("&", "&amp;");
	}

}
