package com.horizon.wf.bean;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import com.horizon.wf.global.StringUtilExtend;
/**
 * 传入参数对象基类
 * @author liys
 *
 */
public class WorkParaBeanBase {
	private String flowId;					//流程id
	private String outerConfig;				//外部设置办理人，办理人类型
	
	private String workId;					//实例id
	private String trackId;					//路径id
	private String nodeId;					//当前节点id
	private String tenantCode;				//租户标识
	private String dataIdentifier;			//业务数据的数据源
	private String flowIdentifier;			//流程数据的数据源,如果有租户则在赋值前自行根据租户id转换
	
	private String userId;					//当前操作人id,所属集合可以直接在userId后面,也可以使用subjection设置
	private String subjection;				//当前人所属集合,如果使用subjection设置,则覆盖userId中的subjection
	private String allUserids;				//用户的所有权限Id集合信息(一般用于权限判断)
	private String userName;				//当前操作人名称
	private String deptName;				//部门名称
//	private String dataid;		            //业务数据id
	private String parentWorkid;			//设置当前实例是否需要继承其他实例数据,一般用于子流程启动时
	
	private String actionClass;				//操作的实现类（全路径）
	/**
     * 设置流程实例下一个流转节点Id 
     * @param nextNodeId 节点Id 
     * 格式:提交操作格式：路由Id~节点Id，多值用“&”分隔
     *     除了提交操作外，其他格式都是节点Id,多值用"&"分隔 
     *       例如提交:  
     *          Line1~Node1  单值
     *          Line1~Node1&Line2~Node2 多值
     *       例如退回:  
     *          Node1  单值
     *          Node1&Node2 多值
     */
	private String nextNodeId;				//下一节点id
	private String nextNodeName;			//动态增加节点时,输入的节点名称
	private String nextNodeModuleName;		//动态增加节点时,指定拷贝的节点模版名称
	private int nextNodeX = 0;				//动态增加节点时,节点位置坐标X
	private int nextNodeY = 0;				//动态增加节点时,节点位置坐标Y
	private int nextNodePosX = 0;			//动态节点相对当前节点的X位移
	private int nextNodePosY = 0;			//动态节点相对当前节点的Y位移
	private String selectSubFlowid;			//选择的子流程id
	/**
	 * 前台确定的参与者
	 * 前台选择人员设置格式:
	 * 	key=节点id_参与者类型(Author,reader)
	 *  value=userid(多个使用分号";"分割)
	 * 	例如：
	 * 			LinkedHashMap<String,String> selectedUsers = new LinkedHashMap<String,String>();
	 * 			selectedUsers.put("Node1_Author","xxxx;yyyyy"); 
			    selectUsers.put("Node1_Reader","xxxx;yyyyy");	
	 */
	private Map<String, String> selectAuthorMap = new LinkedHashMap<String, String>();			//指定的下一节点的办理人	
	/**
	 * key跟selectAuthorMap的key一致,此map存放对应的中文名称,用于日志记录
	 */
	private Map<String, String> selectAuthorNameMap = new LinkedHashMap<String, String>();			//指定的下一节点的办理人
	//仅为创建流程实例时使用，不对外
	private Map<String,String> onlyForCreateMap = new LinkedHashMap<String, String>();	
	//仅为创建流程实例时使用,默认为false
	private boolean doNotToFirstNode = false;
	//退回操作时,是否需要前台选择办理人
	private boolean isSelAuthorForReject = false;
	
	/**
     * 设置消息发送方式 
     * @param key 消息发送角色标识(参与者类型)
     *           例如:  
     *                Author  含义主办者
                      SecondAuthor 含义协办者
                      Reader   含义读者
                      Done     含义已办理者
                      Manager  含义管理者
                      Creator  含义创建者
     * @param value 具体发送方式（多种方式时中间用"|"分隔）
     *             例如：
                         Todo  含义待办
                         Read  含义待阅
                         Mail  含义邮件
                         Msg   含义系统消息
                         SMS   含义短信
                         IM    含义即时消息
                         Todo|Read|Mail 多值
     */
	private Map<String, String> msgSendFlagMap = new LinkedHashMap<String, String>();			//消息发送方式
	private Map<String, String> flowVarMap = new HashMap<String, String>();//流程变量
	private Map<String, int[]> nodeLimitSetMap = new LinkedHashMap<String, int[]>(); //节点办理实现重置
	
	private String bussinessClass;			//业务数据处理实现类路径(必须实现接口IBaseRule)
	private String comment="";					//流程意见
	private String sxComment="";				//手写意见
	private String funname = "";					//操作id
	private String submitflag = "0";				//是否确认提交 0：确认提交  1：前后台交互
	private boolean clearMemAfterAction = true;		//操作完成后是否清空内存 默认清空
	private String actionname;				//操作中文名称,用于日志记录,如果该值不为空则记录到日志,如果为空则查找按钮名称
	private boolean isMultiInstanceTransaction = false;//本次操作是否保存sql语句到数据库
	private String rejectOtherBranch; //是否需要连带退回标识,1是,0否
	private String memo;		//记录操作内容，如果在调用操作时设置内容了，则在操作内部不再赋值，否则操作执行中进行默认赋值。
	
	private String title;					//待办标题
	/**
	 * 	key=节点id_参与者类型(Author,reader)
	 *  value=要显示的值
	 */
	private Map<String, String> messageMoulds = new LinkedHashMap<String, String>();//消息模板组成的map	
	
	private String bussinessClassForOpenByService;//service中打开实例时,获取业务数据的实现类
	
	private Map<String, Object> 
		otherPara = new LinkedHashMap<String, Object>();	
	
	private String urlApp;					//待办打开的连接
	
	public String getTenantCode() {
		return tenantCode;
	}

	public void setTenantCode(String tenantCode) {
		this.tenantCode = tenantCode;
	}

//	public String getDataid() {
//		return dataid;
//	}
//
//	public void setDataid(String dataid) {
//		this.dataid = dataid;
//	}

	public boolean isMultiInstanceTransaction() {
		return isMultiInstanceTransaction;
	}

	public void setMultiInstanceTransaction(boolean isMultiInstanceTransaction) {
		this.isMultiInstanceTransaction = isMultiInstanceTransaction;
	}

	public Map<String, String> getMessageMoulds() {
		return messageMoulds;
	}

	public void setMessageMoulds(Map<String, String> messageMoulds) {
		this.messageMoulds = messageMoulds;
	}

	public String getActionname() {
		return actionname;
	}

	public void setActionname(String actionname) {
		this.actionname = actionname;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public boolean isClearMemAfterAction() {
		return clearMemAfterAction;
	}

	public void setClearMemAfterAction(boolean clearMemAfterAction) {
		this.clearMemAfterAction = clearMemAfterAction;
	}

	public String getSubmitflag() {
		return submitflag;
	}

	public void setSubmitflag(String submitflag) {
		this.submitflag = submitflag;
	}

	public String getBussinessClass() {
		return bussinessClass;
	}

	public String getFunname() {
		return funname;
	}

	public void setFunname(String funname) {
		this.funname = funname;
	}

	public void setBussinessClass(String bussinessClass) {
		this.bussinessClass = bussinessClass;
	}
	

	public String getOuterConfig() {
		return outerConfig;
	}

	public void setOuterConfig(String outerConfig) {
		this.outerConfig = outerConfig;
	}

	public String getParentWorkid() {
		return parentWorkid;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getSxComment() {
		return sxComment;
	}

	public void setSxComment(String sxComment) {
		this.sxComment = sxComment;
	}

	public void setParentWorkid(String parentWorkid) {
		this.parentWorkid = parentWorkid;
	}

	public String getSubjection() {
		return subjection;
	}

	public void setSubjection(String subjection) {
		this.subjection = subjection;
	}
	
	public String getAllUserids() {
		return allUserids;
	}

	public void setAllUserids(String allUserids) {
		this.allUserids = allUserids;
	}

	public String getFlowId() {
		return flowId;
	}

	public void setFlowId(String flowId) {
		this.flowId = flowId;
	}

	public String getWorkId() {
		return workId;
	}

	public void setWorkId(String workId) {
		this.workId = workId;
	}

	public String getTrackId() {
		return trackId;
	}

	public void setTrackId(String trackId) {
		this.trackId = trackId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getNodeId() {
		return nodeId;
	}

	public void setNodeId(String nodeId) {
		this.nodeId = nodeId;
	}
	
	public Map<String, String> getMsgSendFlagMap() {
		return msgSendFlagMap;
	}
	public void setMsgSendFlagMap(Map<String, String> sendFlagMap){
	    this.msgSendFlagMap = sendFlagMap;
	}
	public void putAllMsgSendFlagMap(Map<String, String> sendFlagMap) {
		if(null != sendFlagMap){
			msgSendFlagMap.putAll(sendFlagMap);
		}
	}
	
	public void putMsgSendFlagMap(String key, String value){
		if(null != key && !"".equals(key)){
			msgSendFlagMap.put(key, value);
		}
	}

	public Map<String, String> getFlowVarMap() {
		return flowVarMap;
	}
	
	public void setFlowVarMap(Map<String, String> flowVarMap) {
		this.flowVarMap = flowVarMap;
	}
	public void putFlowVarMap(Map<String, String> flowVarMap){
	    if(flowVarMap != null){
	        this.flowVarMap.putAll(flowVarMap);
	    }
	}
	public void putFlowVar(String key, String value) {
		flowVarMap.put(key, value);
	}

	/**
	 * 办理时限类型(0=工作日,1=自然天,2=小时,3=分)<P>
     * 办理时长<P>
     * 警告时长<P>
     * 允许催办次数<P>
	 * @param nodeid
	 * @return
	 */
	public int[] getNodeLimitByActionSet(String nodeid) {
	    int[] ns = nodeLimitSetMap.get(nodeid);
        if(ns != null){
            return ns;
        }
        return null;
    }
	/**
	 * @deprecated
	 * 使用putNodeLimitSetMap代替
	 * 数组顺序:
	 * 0:办理时限类型(0=工作日,1=自然天,2=小时,3=分)<P>
     * 1:办理时长<P>
     * 2:警告时长<P>
     * 3:允许催办次数<P>
	 * 数组长度不必为4,允许设置部分
	 */
	public void setNodeLimitForAction(String nodeid,int[] ns) {
		putNodeLimitSetMap(nodeid,ns);
	}
	/**
	 * 数组顺序:
	 * 0:办理时限类型(0=工作日,1=自然天,2=小时,3=分)<P>
     * 1:办理时长<P>
     * 2:警告时长<P>
     * 3:允许催办次数<P>
	 * 数组长度不必为4,允许设置部分
	 */
	public void putNodeLimitSetMap(String nodeid,int[] ns) {
	    if(ns != null){
	        nodeLimitSetMap.put(nodeid, ns);
	    }
	}
	/**
	 * @deprecated
	 * 使用putNodeLimitSetMap代替
	 * 顺序:
     * 0:办理时限类型(0=工作日,1=自然天,2=小时,3=分)<P>
     * 1:办理时长<P>
     * 2:警告时长<P>
     * 3:允许催办次数<P>
	 * @param nodeid
	 * @param ns 使用分号;连接
	 */
    public void setNodeLimitForAction(String nodeid,String ns) {
    	putNodeLimitSetMap(nodeid,ns);
    }
    /**
	 * 顺序:
     * 0:办理时限类型(0=工作日,1=自然天,2=小时,3=分)<P>
     * 1:办理时长<P>
     * 2:警告时长<P>
     * 3:允许催办次数<P>
	 * @param nodeid
	 * @param ns 使用分号;连接
	 */
    public void putNodeLimitSetMap(String nodeid,String ns){
    	if(StringUtilExtend.isNotNull(ns)){
            String[]  tmpNs = ns.split(";");
            int len = tmpNs.length;
            int[] limit = new int[tmpNs.length];
            for(int i=0;i<len;i++){
                limit[i] = Integer.parseInt(tmpNs[i]);
            }
            nodeLimitSetMap.put(nodeid, limit);
        }
    }
    
    public void setNodeLimitSetMap(Map<String, int[]> nodeLimitSetMap){
        this.nodeLimitSetMap = nodeLimitSetMap;
    }
    public Map<String, int[]> getNodeLimitSetMap(){
        return nodeLimitSetMap;
    }
    public String getNextNodeId() {
		return nextNodeId;
	}

	public void setNextNodeId(String nextNodeId) {
		this.nextNodeId = nextNodeId;
	}
	
	public String getNextNodeName() {
		return nextNodeName;
	}

	public void setNextNodeName(String nextNodeName) {
		this.nextNodeName = nextNodeName;
	}
	
	public String getNextNodeModuleName() {
		return nextNodeModuleName;
	}

	public void setNextNodeModuleName(String nextNodeModuleName) {
		this.nextNodeModuleName = nextNodeModuleName;
	}

	public int getNextNodeX() {
		return nextNodeX;
	}

	public void setNextNodeX(int nextNodeX) {
		this.nextNodeX = nextNodeX;
	}

	public int getNextNodeY() {
		return nextNodeY;
	}

	public void setNextNodeY(int nextNodeY) {
		this.nextNodeY = nextNodeY;
	}

	public int getNextNodePosX() {
		return nextNodePosX;
	}

	public void setNextNodePosX(int nextNodePosX) {
		this.nextNodePosX = nextNodePosX;
	}

	public int getNextNodePosY() {
		return nextNodePosY;
	}

	public void setNextNodePosY(int nextNodePosY) {
		this.nextNodePosY = nextNodePosY;
	}

	public Map<String, Object> getOtherPara() {
		return otherPara;
	}

	public void setOtherPara(Map<String, Object> otherPara) {
		if(otherPara !=null){
			this.otherPara.putAll(otherPara);
		}
	}

	public void putOtherPara(String key, Object value) {
		otherPara.put(key, value);
	}

	public Map<String, String> getSelectAuthorMap() {
		return selectAuthorMap;
	}
	public Map<String, String> getOnlyForCreateMap() {
		return onlyForCreateMap;
	}
	public void setSelectAuthorMap(Map<String, String> selectAuthorMap) {
		if(selectAuthorMap!=null){
			this.selectAuthorMap = selectAuthorMap;
		}
	}
	
	public void putSelectAuthorMap(Map<String, String> selectAuthorMap) {
		this.selectAuthorMap.putAll(selectAuthorMap);
	}
	
	
	public void putSelectAuthor(String key, String value) {
		selectAuthorMap.put(key, value);
	}

	public Map<String, String> getSelectAuthorNameMap() {
		return selectAuthorNameMap;
	}
	public void setSelectAuthorNameMap(Map<String, String> selectAuthorNameMap) {
		if(selectAuthorNameMap!=null){
			this.selectAuthorNameMap = selectAuthorNameMap;
		}
	}
	
	public void putSelectAuthorNameMap(Map<String, String> selectAuthorNameMap) {
		this.selectAuthorNameMap.putAll(selectAuthorNameMap);
	}
	
	
	public void putSelectAuthorName(String key, String value) {
		selectAuthorNameMap.put(key, value);
	}
	
	
	public String getSelectSubFlowid() {
		return selectSubFlowid;
	}

	public void setSelectSubFlowid(String selectSubFlowid) {
		this.selectSubFlowid = selectSubFlowid;
	}

	public String getUrlApp() {
		return urlApp;
	}

	public void setUrlApp(String urlApp) {
		this.urlApp = urlApp;
	}

	public String getDataIdentifier() {
		return dataIdentifier;
	}

	public void setDataIdentifier(String dataIdentifier) {
		this.dataIdentifier = dataIdentifier;
	}

	public String getFlowIdentifier() {
		return flowIdentifier;
	}

	public void setFlowIdentifier(String flowIdentifier) {
		this.flowIdentifier = flowIdentifier;
	}

	public String getActionClass() {
		return actionClass;
	}

	public void setActionClass(String actionClass) {
		this.actionClass = actionClass;
	}

	public String getRejectOtherBranch() {
		return rejectOtherBranch;
	}

	public void setRejectOtherBranch(String rejectOtherBranch) {
		this.rejectOtherBranch = rejectOtherBranch;
	}

	public String getMemo() {
		return memo;
	}
	/**
	 * 记录操作内容
	 * 如果在调用操作API时进行赋值了，
	 * 则在操作执行时不再赋值，
	 * 否则操作执行中会根据操作内容进行默认赋值。
	 * @param memo
	 */
	public void setMemo(String memo) {
		this.memo = memo;
	}

    public String getBussinessClassForOpenByService() {
        return bussinessClassForOpenByService;
    }
    /**
     * 设置在service中打开实例时,获取业务数据的实现类
     * @param bussinessClassForOpenByService
     */
    public void setBussinessClassForOpenByService(String bussinessClassForOpenByService) {
        this.bussinessClassForOpenByService = bussinessClassForOpenByService;
    }

	public boolean isDoNotToFirstNode() {
		return doNotToFirstNode;
	}

	public void setDoNotToFirstNode(boolean doNotToFirstNode) {
		this.doNotToFirstNode = doNotToFirstNode;
	}

	public boolean isSelAuthorForReject() {
		return isSelAuthorForReject;
	}

	public void setSelAuthorForReject(boolean isSelAuthorForReject) {
		this.isSelAuthorForReject = isSelAuthorForReject;
	}
	
}
