package com.horizon.wf.autotest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.autotest.vo.BackVo;
import com.horizon.wf.autotest.vo.NodeVo;
import com.horizon.wf.autotest.vo.UserVo;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.XMLParseUtil;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

public class AutoTestMain {
	private volatile static AutoTestMain Instance;
	//用来临时存储测试时使用的参数对象
	private Map<String,WorkParaBean> mapParaBean = new HashMap<String,WorkParaBean>(); 
	private int num=1;
	private IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator();
	private AutoTestMain(){	}
	public static AutoTestMain getInstance(){
		if(Instance==null){
			 synchronized (AutoTestMain.class) {
				 if(Instance==null){
					 Instance = new AutoTestMain();
				 }
			 }
		}
		return Instance;
	}
	public void clearFromMap(String workid){
		mapParaBean.remove(workid);
	}
	public BackVo startInstance(String flowid,String userid,boolean saveToDB,String tenantid,String identifier){
		WorkParaBean paraBean = new WorkParaBean();
		paraBean.setUserId(userid);
		IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantid);
		AuthUserImpl auth = AuthUserImpl.getAuthUserByStr(userid);
		Map<String,String> userObj = org.getUserById(auth.getAuthId(), identifier);
		paraBean.setUserName(userObj.get("name"));
		paraBean.setFlowId(flowid);
		paraBean.setTenantCode(tenantid);
		paraBean.setFlowIdentifier(identifier);
		paraBean.setDataIdentifier(identifier);
		paraBean.setMultiInstanceTransaction(!saveToDB);
		
		paraBean.setTitle(num+++":["+flowid+"]"+DateUtil.getNow()+"自动测试流程...");
		
		return startInstance(paraBean,tenantid,identifier);
	}

	//创建流程实例,并返回workid
	public BackVo startInstance(String flowid,String userid,String tenantid,String identifier){
		WorkParaBean paraBean = new WorkParaBean();
		paraBean.setUserId(userid);
		IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantid);
		AuthUserImpl auth = AuthUserImpl.getAuthUserByStr(userid);
		Map<String,String> userObj = org.getUserById(auth.getAuthId(), identifier);
		paraBean.setUserName(userObj.get("name"));
		paraBean.setFlowId(flowid);
		paraBean.setTenantCode(tenantid);
		paraBean.setFlowIdentifier(identifier);
		paraBean.setDataIdentifier(identifier);
		paraBean.setTitle(num+++":["+flowid+"]"+DateUtil.getNow()+"自动测试流程...");
		
		return startInstance(paraBean,tenantid,identifier);
	}
	private BackVo startInstance(WorkParaBean paraBean,String tenantid,String identifier){
		IWorkResult resultBean = operator.create(paraBean);
		if(resultBean.getResult() == StaticVarExtend.Init_Success){
			String workid = resultBean.getWorkid();
			mapParaBean.put(workid, resultBean.getWorkParaBean());
			Map<String,String> mapStatus = XmlDBUtil.getNodeStatus(workid,tenantid,identifier);
			BackVo vo = new BackVo(mapStatus);
			
			vo.setWorkid(workid);
			vo.setResult("Success");
			vo.setError("创建实例成功!");
			return vo;
		}
		BackVo vo = new BackVo();
		vo.setResult("Error");
		vo.setError(resultBean.getBackMsg());

		return vo;
	}
	
	//提交指定节点
	private String SQL_GetTodoLst = "select * from tw_hz_worklist where workid=? and nodeid=? and status=? and isactive='1'";
	public BackVo submit(String workid,String nodeid){
		WorkParaBean oldParaBean = mapParaBean.get(workid);
		if(oldParaBean == null){
		    return null;
		}
		
		String identifier = oldParaBean.getFlowIdentifier();
		String tenantid = oldParaBean.getTenantCode();
		//从待办中查找
		List<String> para = new ArrayList<String>();
		para.add(workid);
		para.add(nodeid);
		para.add(StaticVarExtend.AUTH_AUTHOR);
		List<DBTodo> todoLst =  AccessUtil.getInstance().getMultiObject(SQL_GetTodoLst, para, DBTodo.class, identifier);
		
		for(int i=0,n=todoLst.size();i<n;i++){
			DBTodo todo = todoLst.get(i);
			WorkParaBean paraBean = new WorkParaBean();
			paraBean.setUserId(todo.getAuthId());
			BackVo vo = new BackVo();
			if(todo.getAuthId().equals(StaticVarExtend.NullStr)){
				//记录节点信息
				oldParaBean.setNodeId(nodeid);
				oldParaBean.setTrackId(todo.getTrackid());
				
				vo.setResult("Claim");
				vo.setError("节点["+nodeid+"]待办需要认领,自动测试停止.");
				vo.setSubjectionId(todo.getSubjectionId());
				String tt = todo.getSubjectionType();
				vo.setSubjectionType(tt);
				if(tt == null || tt.equals("") || tt.equals(StaticVarExtend.NullStr)){
					oldParaBean.setSubjection(todo.getSubjectionId());
				}
				else{
					oldParaBean.setSubjection(tt+"_"+todo.getSubjectionId());
				}
				
				vo.setNodeid(nodeid);
				return vo;
			}
			
			IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantid);
			Map<String,String> userObj = org.getUserById(todo.getAuthId(), identifier);
			paraBean.setUserName(userObj.get("name"));
			paraBean.setSubjection(todo.getSubjectionId());
			paraBean.setWorkId(workid);
			paraBean.setTrackId(todo.getTrackid());
			paraBean.setNodeId(todo.getNodeid());
			
			paraBean.setActionClass("com.horizon.wf.action.ActionSubmit");
			paraBean.setSubmitflag("0");
			
			paraBean.setFlowIdentifier(oldParaBean.getFlowIdentifier());
			paraBean.setDataIdentifier(oldParaBean.getDataIdentifier());
			paraBean.setTenantCode(oldParaBean.getTenantCode());
			
			int r = submit_operator(paraBean,vo,nodeid);
			if(r==0){
				break;
			}
			else if(r==1){
				continue;
			}
			else if(r==2){
				mapParaBean.put(workid,paraBean);
				return vo;
			}
		}
		
		//获取当前实例的当前状态
		BackVo vo = new BackVo(XmlDBUtil.getNodeStatus(workid,tenantid,identifier));
		vo.setResult("Success");
		vo.setError("提交成功!");
		return vo;
	}
	//0=break;1=continue;2=vo
	private int submit_operator(WorkParaBean paraBean ,BackVo vo,String nodeid){
		String identifier = paraBean.getFlowIdentifier();
		String tenantid = paraBean.getTenantCode();
		IWorkResult resultBean = operator.operator(paraBean);
		int result =resultBean.getResult();
		if(result == StaticVarExtend.F_STATUS_Success){
			List<INextNode> nextNodes = resultBean.getNextNodes();
			boolean isBreak = false;
			for(int i=0,n=nextNodes.size();i<n;i++){
				INextNode nextNode = nextNodes.get(i);
				if(!nextNode.getNodeid().equals(nodeid)){
					//已经提交到下一节点,则说明当前节点的其他办理人不需要办理
					isBreak = true;
					break;
				}
			}
			if(isBreak){
//					break;
				return 0;
			}
			else{
//					continue;
				return 1;
			}
		}
		else if(result == StaticVarExtend.F_STATUS_SelectNode){
			vo.setResult("SelectNode");
			vo.setError("");//为空时，可以选择，不为空时，直接提示
			selectNodeid(resultBean,vo,tenantid,identifier);
		}
		else if(result == StaticVarExtend.F_STATUS_SelectAuthor){
			vo.setResult("SelectAuthor");
			vo.setError("");//为空时，可以选择，不为空时，直接提示
			selectNodeid(resultBean,vo,tenantid,identifier);
		}
		else{
			vo.setResult("Error");
			vo.setError(resultBean.getBackMsg());
		}
		vo.setNodeid(nodeid);
		return 2;
	}
	private void selectNodeid(IWorkResult resultBean,BackVo vo,String tenantid,String identifier){
		List<INextNode> tpNextNodes = resultBean.getNextNodes();	//可选的路由信息
		NodeVo[] nextNodes = new NodeVo[tpNextNodes.size()];
		
		int i= 0;
		//已经确定的参与者Map
		Map<String,String> selectAuthorMap = resultBean.getWorkParaBean().getSelectAuthorMap();
		//待选择的参与者Map
		Map<String,String> initAuthorMap = resultBean.getInitAuthorMap();
		IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantid);
		for(int k=0,n=tpNextNodes.size();k<n;k++) {
			INextNode nxtNode = tpNextNodes.get(k);
			String keyid = nxtNode.getKeyid();
			NodeVo nVo = new NodeVo();
			nextNodes[i++] = nVo;
			nVo.setKeyId(keyid);
			nVo.setNodeId(nxtNode.getNodeid());
			nVo.setNodeName(nxtNode.getNodename());
			nVo.setSelectname(nxtNode.getShowName());
			
			nVo.setSelectid(nxtNode.getSelectedIdStr());
			nVo.setSelected( nxtNode.isSelected());	
			nVo.setDoneNode(nxtNode.isDoneNode());
			nVo.setGroupName( nxtNode.getGroupName());
			
			nVo.setResult(nxtNode.getInitResult());
			if(nVo.isSelected()){
				IFlowNode node = nxtNode.getFlowNode();
				//增加循环
				List<INodeAuthUser> userList = node.getParticipantsUserList();
//				List<UserVo> userVos = new ArrayList<UserVo>(userList.size());
				UserVo[] userVos = new UserVo[userList.size()];
				nVo.setUsers(userVos);
				int j=0;
				for(int p=0,u=userList.size();p<u;p++){
					INodeAuthUser tempUser = userList.get(p);
					String tempParticipantId = tempUser.getAuthName();
					String tempParticipantName = tempUser.getAuthCnName();
					UserVo uVo = new UserVo();
					userVos[j++] = uVo;
//					userVos.add(uVo);
					String tempId = "";
					uVo.setAuthType(tempParticipantId);
					uVo.setAuthName(tempParticipantName);
					
					if(selectAuthorMap!=null){
						tempId = (String)selectAuthorMap.get(keyid+"-"+tempParticipantId);
						tempId = tempId==null?"":tempId;
						if(tempId.endsWith(";")){
							tempId = tempId.substring(0,tempId.length()-1);
						}
					}
					if(CStrUtil.hasValue(tempId)){
						uVo.setSelectAuthorValue(tempId);
						String tempName = org.getNameByIds(tempId, identifier);
						uVo.setSelectAuthorName(tempName);
						continue;
					}
					
					boolean freeSelect = true;//是否允许在设置为空时自由选择人
					if(tempUser.getControlAttribute().indexOf("FreeSelect")<0){
						freeSelect = false;
					}
					uVo.setFreeSelect(freeSelect);
					int onlySelectUser = 0;//是否仅允许选择人员
					if(tempUser.getControlAttribute().indexOf("OnlySelectUser")>-1){
						onlySelectUser = 1;
					}
					uVo.setOnlySelectUser(onlySelectUser);
					int selectType = resultBean.getNextSelectTypeByNodeid(nxtNode.getNodeid());//根据节点办理类型确定是单选1还是多选2
					if("Reader".equals(tempParticipantId)){
						selectType = 2;
					}
					uVo.setSelectType(selectType);
					
					String initAuthorValue = "";
					if(initAuthorMap!=null ){
						initAuthorValue = (String)initAuthorMap.get(keyid+"-"+tempParticipantId);
						initAuthorValue = initAuthorValue==null?"":initAuthorValue;
						if(initAuthorValue.endsWith(";")){
							initAuthorValue = initAuthorValue.substring(0,initAuthorValue.length()-1);
						}
					}
					uVo.setInitAuthorValue(initAuthorValue);
					
					//办理人时，额外判断是否没有办理人
					if("Author".equals(tempParticipantId) && !freeSelect && "".equals(initAuthorValue)){
						vo.setError("节点["+nxtNode.getNodename()+"]未设置办理人或者因为跳过当前人而无其他办理人,且不能自由选择");
						vo.setResult("Error");
						return;
					}
				}
			}
		}
		vo.setNextNodes(nextNodes);	
	}
	
	//认领处理
	public BackVo claim(String workid,String userid){
		WorkParaBean oldParaBean = mapParaBean.get(workid);
		WorkParaBean paraBean = new WorkParaBean();
		
		paraBean.setUserId(userid);
		
		IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(oldParaBean.getTenantCode());
		AuthUserImpl auth = AuthUserImpl.getAuthUserByStr(userid);
		Map<String,String> userObj = org.getUserById(auth.getAuthId(), oldParaBean.getFlowIdentifier());
		paraBean.setUserName(userObj.get("name"));
		
		paraBean.setWorkId(oldParaBean.getWorkId());
		paraBean.setTrackId(oldParaBean.getTrackId());
		paraBean.setNodeId(oldParaBean.getNodeId());
		paraBean.setSubmitflag("0");
		paraBean.setActionClass("com.horizon.wf.action.ActionClaim");
		
		paraBean.setFlowIdentifier(oldParaBean.getFlowIdentifier());
		paraBean.setDataIdentifier(oldParaBean.getDataIdentifier());
		paraBean.setTenantCode(oldParaBean.getTenantCode());
		
		IWorkResult resultBean = operator.operator(paraBean);
		int result =resultBean.getResult();
		if(result == StaticVarExtend.F_STATUS_Success){
			return submit(workid,oldParaBean.getNodeId());
		}
		else{
			BackVo vo = new BackVo();
			vo.setResult("Error");
			vo.setError(resultBean.getBackMsg());
			return vo;
		}
		
	}
	/**
	 * 交互后提交
	 * @param workid
	 * @return
	 */
	public BackVo submitContinue(String workid,String selectNodeids,String selectUserids){
		WorkParaBean oldParaBean = mapParaBean.get(workid);
//		20180531 liys 清空memo数据,避免交互后操作时无法重新计算memo值
//		com.horizon.wf.action.base.BaseAction.doMemoFromSelected(INextNode)
		oldParaBean.setMemo("");
		BackVo vo = new BackVo();
		oldParaBean.setNextNodeId(selectNodeids);
		if(selectUserids.length()>0){
			Map<String,String> selectAuthorMap = oldParaBean.getSelectAuthorMap();
			HZElement xml = XMLParseUtil.convertStringToXML("<xml>"+selectUserids+"</xml>");
			List<HZElement> lst = XMLParseUtil.getElements(xml, "entry");
			for(int i=0,n=lst.size();i<n;i++){
				HZElement e = lst.get(i);
				String key = XMLParseUtil.getTextTrim(e, "key");
				String value = XMLParseUtil.getTextTrim(e, "value");
				selectAuthorMap.put(key, value);
			}
		}
		
		int r = submit_operator(oldParaBean,vo,oldParaBean.getNodeId());
		if(r==2){
			return vo;
		}
		//获取当前实例的当前状态
		vo = new BackVo(XmlDBUtil.getNodeStatus(workid,oldParaBean.getTenantCode(),oldParaBean.getFlowIdentifier()));
		vo.setResult("Success");
		vo.setError("提交成功!");
		return vo;
	}
	
	//------------------------------------------
	public String startInstanceJson(String flowid,String userid,String tenantid,String identifier){
		return JSON.toJSONString(startInstance(flowid, userid, tenantid, identifier));
	}
	public String submitJson(String workid,String nodeid){
		return JSON.toJSONString(submit(workid, nodeid));
	}
	public String submitContinueJson(String workid,String selectNodeids,String selectUserids){
		WorkParaBean oldParaBean = mapParaBean.get(workid);
		oldParaBean.setMemo("");
		BackVo vo = new BackVo();
		oldParaBean.setNextNodeId(selectNodeids);
		if(CStrUtil.isNotNull(selectUserids)){
			Map<String,String> selectAuthorMap = oldParaBean.getSelectAuthorMap();
			JSONObject userJson = JSON.parseObject(selectUserids);
			Iterator<Map.Entry<String, Object>> iter = userJson.entrySet().iterator();
			while (iter.hasNext()) {
				Map.Entry<String, Object> entry = (Map.Entry<String,Object>) iter.next();
				String key = entry.getKey();
				String value = (String)entry.getValue();
				selectAuthorMap.put(key, value);
			}
		}

		int r = submit_operator(oldParaBean,vo,oldParaBean.getNodeId());
		if(r==2){
			return JSON.toJSONString(vo);
		}
		//获取当前实例的当前状态
		vo = new BackVo(XmlDBUtil.getNodeStatus(workid,oldParaBean.getTenantCode(),oldParaBean.getFlowIdentifier()));
		vo.setResult("Success");
		vo.setError("提交成功!");

		return JSON.toJSONString(vo);
	}

	public String claimJson(String workid,String userid){
		return JSON.toJSONString(claim(workid, userid));
	}
	
}
