package com.horizon.wf.api.mutual;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * 引擎交互数据处理的演示类
 * 使用说明:
 * 1.获取所有需要发送的数据Map
 * 	Map<String,Map<String,List<String>>> allmap = getMutualData();
 * 2.遍历allmap
 * 	针对每个租户的数据进行数据的传输
 * 	for(String identifier:allmap.keySet()){
 * 		获取到某个租户的所有数据map
 * 		Map<String,List<String>> map = allmap.get(identifier);
 * 		遍历map
 * 		for(String workid:map.keySet()){
 * 			List<String> lst = map.get(workid);
 * 			数据传输执行
 * 			........
 *
 * 			记录传输结果
 *
 *
 * 		}
 *  }
 * @author liys
 *
 */
public class MutualExample {
	/**
	 * 演示代码
	 * 发送数据到指定的地址
	 */
	public static void sendDataExample() {
		// 定义一个执行结果的返回map
		Map<String, Map<String, Boolean>> actionMap = new HashMap<String, Map<String, Boolean>>();
		// 1.获取所有需要发送的数据Map
		Map<String, Map<String, List<String>>> allmap = HZInstance.getInstance().getMutualData();
		// 2.遍历allmap
		// 针对每个租户的数据进行数据的传输
		for (String identifier : allmap.keySet()) {
			Map<String, Boolean> actionMapOne = new HashMap<String, Boolean>();
			// 获取到某个租户的所有数据map
			Map<String, List<String>> map = allmap.get(identifier);
			// 遍历map
			for (String workid : map.keySet()) {
				List<String> lst = map.get(workid);
				// 数据传输执行
				// ...........
				lst.get(0);// 业务数据
				lst.get(1);// 引擎数据
				// ...........

				// 记录传输结果,根据数据传输返回记录
				// 也可以只记录传输成功,失败的不记录
				actionMapOne.put(workid, true);
			}
			actionMap.put(identifier, actionMapOne);
		}
		// 3.根据执行结果对临时数据进行删除操作.删除发送成功的数据.
		Map<String, Boolean> result = HZInstance.getInstance().deleteTmpMutualData(actionMap);
		// 4.针对结果进行后续处理.如果删除失败,自行进行标记下次不再执行数据发送
		result.get("");
	}

	/**
	 * 演示代码
	 * 接收服务器方,对接收到的数据处理演示
	 * 
	 * @return
	 */
	public static boolean receiveDataExample() {
		//data为接收到的数据,比如已经存入到数据库中,
		String data = "";//testGetFromTemp();
		// 写入数据
		// 解包接收到的流程引擎数据, 保存数据到指定的数据源中 
		// 执行引擎交互节点的自动提交,提交失败时创建自动提交的定时任务
//		boolean result = HZInstance.getInstance().unpackageInstanceData("",data, "tenant02", "identifier02");
		return true;
	}

	/**
	 * 测试代码
	 * 从临时表中获取接收到的交互数据
	 * 
	 * @param workid
	 * @param identifier
	 * @return
	 */
//	private static String testGetFromTemp() {
//		String identifier = "identifier02";
//		String workid = "TestWorkid";
//		String sql = "select * from " + StaticVarExtend.Table_Flowvar_Record
//				+ " where workid=?";
//		List<String> lst = new ArrayList<String>(1);
//		lst.add(workid);
//		DBFlowVarRecord record = ResponsibleImplFactory.getDBAccess()
//				.getRsToObj(sql, lst, DBFlowVarRecord.class, identifier);
//
//		return record.getFlowvar();
//	}

	/**
	 * 测试,写入临时表(此示例把数据放入流程变量库表)
	 * 
	 * @param workid
	 * @param data
	 * @param identifier
	 * @return
	 */
//	public static boolean testSaveToTemp(String workid, String data,
//			String identifier) {
//		DBFlowVarRecord record = new DBFlowVarRecord();
//		record.setId(StaticFunExtend.getUnid());
//		record.setWorkid(workid);
//		record.setFlowvar(data);
//
//		return ResponsibleImplFactory.getDBAccess().saveObjectToDatabase(
//				record, StaticVarExtend.Table_Flowvar_Record, identifier);
//
//	}
}
