package com.horizon.wf.api.mutual;

import java.io.*;
import java.net.URL;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.tools.CStrUtil;

/**
 * 多服务器间数据传输实现类
 * @author liys
 *
 */
public class HZTranslation extends BaseRuleImpl implements IBaseRule {

	public boolean executeRule() {
		String targetServer = (String)getParameter("Server");
		List<String> parameter = (List<String>) getParameter("SendData");
		List<String> dataLst = parameter;
		
		//业务数据
		String appdata = dataLst.get(0);
		//实例相关数据
		String engdata = dataLst.get(1);

		JSONObject para = new JSONObject();
		para.put("appdata",appdata);
		para.put("engdata",engdata);

//		http://192.168.2.60:9000/hz7sp2/horizon/workflow/rest/cluster/receive.wf
		String result = PostRequest(targetServer,para.toJSONString());
        if(CStrUtil.isNull(result)){
            return false;
        }
		JSONObject json = JSON.parseObject(result);
        return json.getBooleanValue("success");
	}

	public static String PostRequest(String URL,String obj) {
		String jsonString="";
		try {
			//创建连接
			URL url = new URL(URL);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST"); //设置请求方法
			connection.setRequestProperty("Charsert", "UTF-8"); //设置请求编码
			connection.setUseCaches(false);
			connection.setInstanceFollowRedirects(true);
			connection.setRequestProperty("Content-Type","application/json");

			connection.connect();

			//POST请求
//			DataOutputStream out = new DataOutputStream(
//					connection.getOutputStream()); //关键的一步
//			out.writeBytes(obj);

			PrintWriter out = new PrintWriter(
					new OutputStreamWriter(
							connection.getOutputStream(),"utf-8"));
			out.println(obj);


			out.flush();
			out.close();

			// 读取响应
			if (connection.getResponseCode()==200) {
				BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
				String lines;
				StringBuffer sb = new StringBuffer("");
				while ((lines = reader.readLine()) != null) {
					lines = new String(lines.getBytes(), "utf-8");
					sb.append(lines);
				}
				jsonString=sb.toString();
				reader.close();
			}//返回值为200输出正确的响应信息

			if (connection.getResponseCode()==400) {
				BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
				String lines;
				StringBuffer sb = new StringBuffer("");
				while ((lines = reader.readLine()) != null) {
					lines = new String(lines.getBytes(), "utf-8");
					sb.append(lines);
				}
				jsonString=sb.toString();
				reader.close();
			}//返回值错误，输出错误的返回信息
			// 断开连接
			connection.disconnect();
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return jsonString;
	}
}
