package com.horizon.wf.api.mutual;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBMutualTask;
import com.horizon.wf.tools.CStrUtil;
/**
 * 交互处理的接口实现演示类
 * @author liys
 *
 */
public class HZInteractiveSample extends BaseRuleImpl implements IBaseRule {

	@Override
	public boolean executeRule() {
		
		System.out.println("交互处理类,比如从其他系统中获取数据,如果成功返回true流程继续往下流转,如果不成功则返回false,系统撤销本次操作");
		
		//如果是需要根据不同业务跟不同的服务器之间进行交互的时候,也可以在此接口中实现
		//*
		RunningData runningdata = getRunningdata();
		String workid = (String)getParameter("workid");
		String nxtTrackid = (String)getParameter("nxtTrackid");
		//下面这两个参数需要根据业务逻辑去计算并赋值
		String clusterUrl = "";
		String clusterClassName = "";
		if(CStrUtil.isNotNull(clusterUrl)){
			DBMutualTask sTask = HZInstance.getInstance().makeDBMutualTask(workid, nxtTrackid, clusterUrl, clusterClassName);
			
			Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
	        sTask.getSQL(saveMap,runningdata.getResultJson());
			
	        runningdata.putSQLToDataMap(saveMap);
	        
	        //增加返回标识,标识当前为引擎交互处理,同时传回临时数据对象
	        //在com.horizon.wf.action.common.ActionExtraData.nextNode_Mutual(IXmlNode, IActionForStartSubFlow)
	        //方法中会获取并判断
	        setResult("IsCluster", "1");
	        setResult("DBMutualTask",sTask);
	        
		}
		//*/
		//处理成功返回true,如果返回false,则流程不允许往下流转
		return true;
	}

}
