package com.horizon.wf.api.mutual;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.action.robot.ExcuteAutoSubmit;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.entity.db.DBMutualTask;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.mutual.InstanceDataUtil;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

/**
 * 慧正引擎实例数据在多服务器交互时的数据处理
 * @author liys
 *
 */
public class HZInstance {
	private static HZInstance INSTANCE = new HZInstance();
	public static HZInstance getInstance(){
		return INSTANCE;
	}
	private HZInstance(){}
	private  final String getMutalTaskSql = "SELECT * FROM "+StaticVarExtend.Table_Mutual;
	private  final String deleteTaskSql = "DELETE FROM "+StaticVarExtend.Table_Mutual +" WHERE ID=?";

	/**
	 * 入口方法,在提交操作执行完毕时进行调用
	 * 针对当前实例提交到引擎交互节点完成时的处理
	 * 在操作执行完毕后发送数据到目标服务器
	 * @param tasklist 交互信息对象列表
	 * @param identifier 引擎数据的数据源标识符
	 * @return
	 */
	public  boolean sendDataAfterAction(List<DBMutualTask> tasklist,String identifier){
		List<Object> para = new ArrayList<Object>();
		//1.处理指定的引擎交互数据,一般应该只有一条
		for(int j=0,m=tasklist.size();j<m;j++){
			DBMutualTask task = tasklist.get(j);
			Map<String,List<String>> dataMap = new HashMap<String,List<String>>();
			if(getSendData(dataMap,task,identifier)){
				//记录发送成功的数据id
				para.add(task.getId());
			}
			else{
				//需要修改库表和xml解析来增加配置信息
				task.setTransClassname("com.horizon.wf.api.mutual.HZTranslation"); //暂时写死实现类
				IBaseRule transObj = InterfaceFactory.getNewInterface(task.getTransClassname());
				if(transObj == null){
					continue;
				}
				transObj.setParameter("Server", task.getServername());
				transObj.setParameter("SendData",dataMap.get(task.getWorkid()));
				if(transObj.executeRule()){
					//发送成功时,删除
					para.add(task.getId());
				}
			}
		}
		//对于返回成功的,进行临时数据清理
		if(!para.isEmpty()){
			Map<String,List<Object>> lm = new HashMap<String,List<Object>>();
			lm.put(deleteTaskSql, para);
			AccessUtil.getInstance().executeMultiUpdate(lm, identifier);
		}
		return true;
	}
	/**
	 * 获取一条引擎交互数据的处理,
	 * 返回true在当前租户流转成功
	 * 返回false,数据写入dataMap中,如果没有写入表示在当前租户流转下一节点失败
	 * @param task
	 * @param identifier
	 */
	private  boolean getSendData(Map<String,List<String>> dataMap,DBMutualTask task,String identifier){
		List<String> data = new ArrayList<String>(2);
		String server  = task.getServername();
		
		if(server == null || "".equals(server)){
			//接收服务器为空时,让流程实例继续在当前服务器上运转
			if(autoSubmitOK(task.getWorkid(),task.getTrackid(),"",identifier)){
				return true;
			}
			return false;
		}
		//4.处理业务数据
		String className = task.getClassname();
		IBaseRule br = InterfaceFactory.getNewInterface(className);
		if(br != null){
			br.setParameter("workid", task.getWorkid());
			br.setParameter("identifier", identifier);
			
			if(br.executeRule()){
				String bisData = (String)br.getResult();
				//记录需要发送到目标服务器业务数据
				//返回的数据中应该要包含解包处理的实现方式
				//{"unpackageclass":"","data":""}
				data.add(bisData);
			}
		}
		//如果业务数据为空时,
		if(data.isEmpty()){
			data.add("");
		}
		
		//5.处理实例数据
		String instanceData = packageInstanceData(task.getWorkid(),task.getTrackid(),identifier);
		//6.记录需要发送到目标服务器的引擎数据
		data.add(instanceData);
		
		dataMap.put(task.getWorkid(), data);
		return false;
	}
	
	/**
	 * 获取指定实例id的实例数据
	 * @param workid
	 * @param identifier
	 * @return
	 */

	private  String packageInstanceData(String workid,String trackid,String identifier){
		return InstanceDataUtil.packageInstanceData(workid, trackid, identifier);
	}

	/**
	 * 入口方法
	 * 解包接收到的流程数据,
	 * 保存数据到指定的数据源中
	 * 执行引擎交互节点的自动提交,提交失败时创建自动提交的定时任务
	 * @param identifier
	 * @return 空表示成功,不为空则表示失败
	 */
	public  String unpackageInstanceData(String appdata,String engdata,String tenantid,String identifier){
		Map<String,List<Object>> saveMap = new LinkedHashMap<String,List<Object>>();
		Map<String,List<Object>> delMap = new LinkedHashMap<String,List<Object>>();
        List<Object> objects = InstanceDataUtil.unpackageInstanceData(saveMap,engdata,identifier);
        DBWork work = (DBWork) objects.get(0);
        DBTrack track = (DBTrack) objects.get(1);
        boolean isExist = (Boolean)objects.get(2);
		//对业务数据进行接收处理
		String  backApp = unpackageAppData(saveMap,delMap,appdata,isExist,tenantid,identifier);
		if(CStrUtil.isNotNull(backApp)){
			return backApp;
		}


		boolean result = AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
		if(result){
			//直接执行自动提交,失败后需要删除之前的数据
			if(!autoSubmitOK(work.getId(),track.getId(),track.getNodeid(),identifier)){
				//提交失败
				ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
				if(!ti.addTaskForMutualReceive(work, track, tenantid, identifier)){
					deleteFromTemp(delMap,work.getId(),identifier,isExist);
					return "实例自动提交执行失败!";
				}
			}
		}
		return "";
	}
	/**
	 * 业务数据解包处理(对数据保存进行处理,同时也需要对失败后的数据进行处理)
	 * @param saveMap		返回需要保存数据的sql和参数(业务数据保存)
	 * @param delMap		需要删除数据时的sql和参数	(失败后需要删除的业务数据)
	 * @param data			需要处理的业务数据
	 * @param isExist		对应的实例是否已经在此服务器上存在
	 * @param tenantid		租户标识
	 * @param identifier	数据源标识符
	 * @return
	 */
	private String unpackageAppData(Map<String,List<Object>> saveMap,Map<String,List<Object>> delMap,
									 String data,boolean isExist,String tenantid,String identifier){
		if(data == null || "".equals(data)){
			//没有业务数据需要处理时
			return "";
		}
		//强制要求打包数据时,返回格式为JSON格式,并指定接收处理的类
		//{"unpackageclass":"","data":""}
		JSONObject json = JSON.parseObject(data);
		if(json == null){
			return "业务数据格式错误,无法转换为JSON对象!";
		}
		String unpackageclass = json.getString("unpackageclass");
		String appdata = json.getString("data");

		IBaseRule appObj = InterfaceFactory.getNewInterface(unpackageclass);
		if(appObj == null){
			return "未指定业务数据接收处理类或者类不符合IBaseRule接口规范!";
		}
		appObj.setParameter("data",appdata);
		appObj.setParameter("saveMap",saveMap);
		appObj.setParameter("delMap",delMap);
		appObj.setParameter("isExist",isExist);
		appObj.setParameter("tenantid",tenantid);
		appObj.setParameter("identifier",identifier);

		if(appObj.executeRule()){
			return "";
		}
		return "业务数据接收类执行失败!";
	}
	//自动提交失败,添加任务也失败时,删除数据
	private  void deleteFromTemp(Map<String,List<Object>> saveMap,String workid,String identifier,boolean isExist){
		if(!isExist){
			List<Object> para = new ArrayList<Object>(1);
			para.add(workid);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Work+" WHERE ID = ?", para);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Work_Ver+" WHERE WORKID = ?", para);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Track+" WHERE WORKID = ?", para);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Track_Ver+" WHERE WORKID = ?", para);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Track_XML+" WHERE WORKID = ?", para);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Track_XML_Ver+" WHERE WORKID = ?", para);
			saveMap.put("DELETE FROM "+StaticVarExtend.Table_Work_XML+" WHERE WORKID = ?", para);
			if(HZResourceBundle.getInstance().isVerUseJson()) {
				saveMap.put("DELETE FROM " + StaticVarExtend.Table_Json + " WHERE WORKID = ?", para);
				saveMap.put("DELETE FROM " + StaticVarExtend.Table_Json_Ver + " WHERE WORKID = ?", para);
			}
		}

		if(saveMap.isEmpty()){
			return;
		}

		AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
	}

	private  boolean autoSubmitOK(String workid,String trackid,String nodeid,String identifier){
		ExcuteAutoSubmit autoSubmit = new ExcuteAutoSubmit();
		return autoSubmit.excuteSubmit(workid,trackid,nodeid,identifier) == StaticVarExtend.F_STATUS_Success;
	}

//-------------------------------------

	/**
	 * 数据交互时,创建交互临时对象
	 * @param workid
	 * @param trackid
	 * @param clusterUrl
	 * @param clusterClassName
	 * @return
	 */
	public  DBMutualTask makeDBMutualTask(String workid,String trackid,String clusterUrl,String clusterClassName){
		// 插入一条交互中间数据,用于后面定时任务执行时获取
		DBMutualTask sTask = new DBMutualTask();
		sTask.setId(StaticFunExtend.getUnid());
		sTask.setSortnum(1);
		sTask.setServername(clusterUrl);
		sTask.setClassname(clusterClassName);
		sTask.setWorkid(workid);
		sTask.setStatus("0"); // 0=还没有写入到目标服务器
		sTask.setTrackid(trackid);
		return sTask;
	}

	/**
	 * * 获取引擎交互数据,用于定时任务执行时获取所有的临时交互数据
	 * @return Map格式如下
	 * key  = identifier
	 * value= Map 格式如下
	 * 		 key = workid
	 * 		 value = List<String> 0=业务数据  1=引擎数据
	 */

	public  Map<String,Map<String,List<String>>> getMutualData(){
		//记录所有交互数据,用于返回值
		Map<String,Map<String,List<String>>> allMap = new HashMap<String,Map<String,List<String>>>();
		//1.获取所有的租户空间
		List<String> allIdentifier = ThirdAdapterFactory.getAllIdentifierList();
		for(int i=0,n=allIdentifier.size();i<n;i++){
			String identifier = allIdentifier.get(i);
			//2.循环获取指定租户空间所有的引擎交互临时数据
			List<DBMutualTask> mTasks = AccessUtil.getInstance()
					.getMultiObject(getMutalTaskSql, null, DBMutualTask.class, identifier);
			if(!(mTasks == null || mTasks.isEmpty())){
				Map<String,List<String>> dataMap = new HashMap<String,List<String>>();

				List<Object> para = new ArrayList<Object>();
				//3.处理指定的引擎交互数据
				for(int j=0,m=mTasks.size();j<m;j++){
					DBMutualTask task = mTasks.get(j);
					if(getSendData(dataMap,task,identifier)){
						//记录发送成功的数据id
						para.add(task.getId());
					}
				}
				//对于返回成功的,进行临时数据清理
				if(!para.isEmpty()){
					Map<String,List<Object>> lm = new HashMap<String,List<Object>>();
					lm.put(deleteTaskSql, para);
					AccessUtil.getInstance().executeMultiUpdate(lm, identifier);
				}
				if(!dataMap.isEmpty()){
					allMap.put(identifier, dataMap);
				}
			}
		}
		return allMap;
	}
	/**
	 * 删除发送成功的引擎交互数据
	 * @param resultMap
	 * key = identifier
	 * 		key = workid
	 * 		value =
	 */
	public  Map<String,Boolean>  deleteTmpMutualData(Map<String,Map<String,Boolean>> resultMap){
		Map<String,Boolean> actionMap = new HashMap<String,Boolean>();
		String deleteTaskSql = "DELETE FROM "+StaticVarExtend.Table_Mutual +" WHERE WORKID=?";
		for(String identifier:resultMap.keySet()){
			boolean result = true;
			Map<String,Boolean> map = resultMap.get(identifier);
			if(!(map == null || map.isEmpty())){
				List<Object> para = new ArrayList<Object>();
				for(String workid:map.keySet()){
					boolean isSuccess = map.get(workid);
					if(isSuccess){
						para.add(workid);
					}
				}

				if(!para.isEmpty()){
					Map<String,List<Object>> lm = new HashMap<String,List<Object>>();
					lm.put(deleteTaskSql, para);
					result = AccessUtil.getInstance().executeMultiUpdate(lm, identifier);
				}
			}
			actionMap.put(identifier, result);
		}
		return actionMap;
	}
}
