package com.horizon.wf.api.flowmgr.mgr;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;

/**
 * 在第一个节点的进入事件中配置
 * 功能为:把当前实例id赋值给指定的流程变量
 * @author LIYS
 * 2019-01-28
 */
public class InNodeEvent extends BaseRuleImpl implements IBaseRule {

    public boolean executeRule() {
        //在第一个节点进入时,对流程变量进行赋值
        RunningData runningData = getRunningdata();
        String workid = runningData.getWork().getId();

        //激活节点标识为当前实例ID
        runningData.getFlowVar().setValue("ActiveFlag",workid);

        System.out.println("实例的流程变量赋值ActiveFlag="+workid);
        return true;
    }
}
