package com.horizon.wf.api.flowmgr.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.api.mutual.HZTranslation;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.tools.CStrUtil;

/**
 * 业务流程启动事件
 * 功能:发送通知到管理流程
 * 示例代码
 * @author LIYS
 * 2019-01-29
 */
public class StartAppEvent extends BaseRuleImpl implements IBaseRule {

    public boolean executeRule() {
        System.out.println("业务流程实例开始:"+getRunningdata().getWork().getId());
        String url = "http://192.168.2.63:9000/hz7sp2/horizon/workflow/rest/cmd/receive.wf";
        JSONObject jsonPara = new JSONObject();
        jsonPara.put("status","1"); //启动实例时,必须传入1

        //TODO unid 固定值,需要跟管理流程系统中做匹配处理
        jsonPara.put("unid",getRunningdata().getWork().getFlowid());  //unid为固定值,FlowMgrB_Node1为测试模拟数据
        /*
            dataid用于跟管理流程关联的标识,管理流程对应的各个业务流程应该使用同一个dataid来标识
            title 也是用来标识各个业务流程属于同一个管理流程的标识
            这两个参数,应该可以根据一些条件来获取
         */
        jsonPara.put("dataid","HZ2882bf689c688701689c7262e300e2");//暂时使用第一个节点对应的业务流程workid
        jsonPara.put("title","业务流程启动");

        String result = HZTranslation.PostRequest(url,jsonPara.toJSONString());

        if(CStrUtil.isNull(result)){
            return false;
        }
        JSONObject json = JSON.parseObject(result);
        return json.getBooleanValue("success");
    }
}
