package com.horizon.wf.api.flowmgr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.horizon.common.base.Charsets;
import com.horizon.common.io.Resources;
import com.horizon.exception.HorizonException;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.expand.signal.Signal;
import com.horizon.wf.expand.signal.SignalListenerUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 外部系统调用时用到的指令处理
 * rest接口调用此类
 * @author LIYS
 * 2019-01-28
 */
public class ReceiveCmd {
    private String tenantid = "system";
    private String identifier = "system";
    //根据dataid获取对应的workid
    private String SQL_getWorkidByDataid = "SELECT WORKID FROM " + StaticVarExtend.Table_WorkApp
            +" WHERE DATAID=?";
    //插入关联数据(因为管理系统的流程不包含业务数据,没有表单,系统不能自动关联,所以需要在启动后手动增加)
    private String SQL_InsertTo_Instance= "INSERT INTO "+StaticVarExtend.Table_WorkApp
            +"(ID,WORKID,DATAID) VALUES(?,?,?)";
    /**
     * 接收到指令信息时的处理
     * @return
     */
    public String doCmd(Map<String, Object> data){
        JSONObject json = new JSONObject();
        String unid = (String)data.get("unid");
        int status = Integer.parseInt((String) data.get("status"));
        String dataid = (String)data.get("dataid");
        String title = (String)data.get("title");

        return doCmd(unid,status,dataid,title);
    }

    public String doCmd(JSONObject json) {
/*json 需要的数据格式
{
    unid:可以唯一标记对应流程的标识(在管理系统中进行管理对应关系),
    status:状态,0=结束(离开),1=开始(到达) 标记对应的流程节点是到达还是离开,
    dataid:业务唯一标识,用来跟管理流程的实例关联,
    title:业务标题
    tenantid:管理系统中的租户(一般为固定值)
    identifier:管理系统中的数据源标识(一般为固定值)
}
*/
        String unid = json.getString("unid");//根据此标识来获取管理流程的流程id和节点id
        int status = json.getIntValue("status");//用来确定流程是开始一个节点还是结束一个节点
        String dataid = json.getString("dataid");//根据此标识来获取管理流程的实例id
        String title = json.getString("title");
        tenantid = json.getString("tenantid");
        identifier = json.getString("identifier");
        return doCmd(unid,status,dataid,title);
    }
     private String doCmd(String unid,int status,String dataid,String title){
        if(CStrUtil.isNull(tenantid)){
            tenantid = "system";
        }

        if(CStrUtil.isNull(identifier)){
            identifier = "system";
        }
        //1.根据dataid去获取workid
        String workid = getWorkidByDataid(dataid);
        //2.获取流程id和节点id,userid
        JSONObject paraCore = getParaByUnid(unid);
        //3.准备数据
        WorkParaBean paraBean = new WorkParaBean();
        paraBean.setWorkId(workid);
        if(CStrUtil.isNotNull(title)) {
            paraBean.setTitle(title);
        }
        paraBean.setFlowId(paraCore.getString("Flowid"));
        paraBean.setNodeId(paraCore.getString("Nodeid"));
        paraBean.setUserId(paraCore.getString("Userid"));         //办理人该怎么处理???
        paraBean.setFlowIdentifier(identifier);
        paraBean.setTenantCode(tenantid);


        if(workid == null){
            return createInstance(paraBean,status,dataid);
        }
        else{
            if(status == 0){
                //离开当前节点
                return submitInstance(paraBean);
            }
            else{
                return activeNode(workid);
            }
        }
    }
    //激活节点(修改)
    private String activeNode(String workid){
        //进入节点,是否需要校验呢
        //执行打开实例操作,校验当前节点是否跟传入的标识一致

        //执行激活
        Signal message=new Signal();
        message.setIdentifier(identifier);
        message.setSignalPara(workid);		//定义的参数的值

        SignalListenerUtil.sendSignal(message);
        return "";
    }

    //离开节点时,执行提交操作
    private String submitInstance(WorkParaBean paraBean){
        //因为没有trackid,所以先行执行一下打开
        IWorkResult openResult = WorkflowFactory.getWorkflowOperator().open(paraBean);
        if(openResult.getResult() != StaticVarExtend.Init_Success){
            return (openResult.getBackMsg());
        }
        //判断操作
        String className = "com.horizon.wf.action.ActionSubmit";
        List<INodeButton> buttons = openResult.getCurNodeButton();
        boolean isContinue = false;
        for(int i=0,n=buttons.size();i<n;i++){
            INodeButton button = buttons.get(i);
            String buttonClass = button.getImplClass();
            if(className.equals(buttonClass)){
                isContinue = true;
                break;
            }
        }
        if(!isContinue){
            return "无操作权限";
        }
        paraBean.setTrackId(openResult.getCurTrackInfo().getId());
        paraBean.setSubmitflag("0");    //执行提交
        paraBean.setActionClass(className);
        IWorkResult workResult = WorkflowFactory.getWorkflowOperator().operator(paraBean);
        if(workResult.getResult() == StaticVarExtend.F_STATUS_Success){
            return "";
        }
        else{
            return (workResult.getBackMsg());
        }
    }

    //实例不存在时,创建
    private String createInstance(WorkParaBean paraBean,int status,String dataid){
        //说明不存在实例,此时应该创建一个新的实例
        if(status == 0){
            //如果实例不存在,说明节点不应该是离开状态
            return ("传入参数错误.status=0");
        }

        //创建实例(变量赋值在第一个节点的进入事件中处理)
        IWorkResult workResult = WorkflowFactory.getWorkflowOperator().create(paraBean);
        if(workResult.getResult() == StaticVarExtend.Init_Success){
            //插入关联数据
            List<Object> para = new ArrayList<Object>();
            para.add(StaticFunExtend.getUnid());
            para.add(workResult.getWorkid());
            para.add(dataid);

            boolean result = AccessUtil.getInstance().executeUpdate(SQL_InsertTo_Instance,para,identifier);
            if(result){
                return "";
            }
            else{

                WorkflowFactory.getWorkflowManager().deleteWork(workResult.getWorkid(),tenantid,identifier);
                return  ("关联数据保存失败!");
            }
        }
        else{
            return (workResult.getBackMsg());
        }
    }


    private String getWorkidByDataid(String dataid){
        List<Object> para =new ArrayList<Object>();
        para.add(dataid);
        List<Object> result = AccessUtil.getInstance().getSingleList(SQL_getWorkidByDataid,para,identifier);

        if(result == null || result.isEmpty()){
            return null;
        }

        return (String) result.get(0);
    }

    //获取管理流程的流程id和节点id,节点办理人id
    private JSONObject getParaByUnid(String unid){
        //TODO 测试代码
        JSONObject json = makeTestData();

        JSONObject result = json.getJSONObject(unid);

        return result;
    }

    private void println(String msg){
        System.out.println(msg);
    }

    private JSONObject makeTestData(){
        // 测试数据,unid和管理系统中的流程对应关系表
        String data = getFileLines("com/horizon/wf/api/flowmgr/FlowList.json");

        return JSON.parseObject(data);
    }

    private String getFileLines(String fileName) {

        StringBuilder builder = new StringBuilder();
        URL url= Resources.getResource(fileName);
        try {
            List<String> lines = Resources.readLines(url, Charsets.UTF_8);
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    builder.append(line.trim());
                }
            }
        } catch (IOException e) {
            throw new HorizonException("读取FlowList.json失败 ");
        }

        return builder.toString();
    }
}
