package com.horizon.wf.api.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * 本类提供对字符串和对象之间的相互转换
 * @author liangjw
 * @version 1.0
 * @since hzwf v7.0
 *
 */
public class SerializableUtil {
	private SerializableUtil(){}
	public static void main(String[] args){
//		Object s = "6688";
//		String temp = objectToString(s);
//		System.out.println(temp);
//		Object o = stringToObject(temp);
//		System.out.println(o);
	}
	
	/**
	 * 将给定的字符串转换成对象
	 * @param objBody
	 * @return
	 */
	public static Object stringToObject (String objBody) {
		if(null == objBody || "".equals(objBody)){
			return null;
		}
        ObjectInputStream ois = null;
        Object obj = null;
        try {
    		String temp = URLDecoder.decode(objBody,"UTF-8"); 
            byte[] bytes = temp.getBytes("ISO-8859-1");
            
            ois = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(bytes)));
            obj = ois.readObject();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (ois != null)
                    ois.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }
	
	/**
	 * 将给定的object转换成String
	 * @param obj
	 * @return
	 */
    public static String objectToString(Object obj) {
		if(null == obj){
			return "";
		}
        String objBody = null;
        ByteArrayOutputStream baops = null;
        ObjectOutputStream oos = null;
        try {
            baops = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baops);
            oos.writeObject(obj);
            byte[] serStr = baops.toByteArray(); 
            String temp = new String(serStr,"ISO-8859-1");
            objBody = URLEncoder.encode(temp,"UTF-8");        
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (oos != null)
                    oos.close();
                if (baops != null)
                    baops.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return objBody;
    }

}
