package com.horizon.wf.api.bean;

import java.util.ArrayList;
import java.util.List;


/**
 * 节点对象,用于从xml中转换节点中的部分信息到数据库
 * @author liys
 * 
 */
public class XNode{
	private String id;			//数据id
	private String flowid;		//流程id
	private int    flowver = 1;         //流程版本
	private int    islastver = 1;      //是否为最后版本
	private String preNodeid;		//上一节点id
	private String preNodename;		//上一节点名称
	private int    preNodetype;		//上一节点类型
	private String preSubflowid; //下一节点如果为子流程,则记录子流程id

	private String routerid;		//路由id
	private String routername;		//路由名称
	
	private String nextNodeid;		//下一节点id
	private String nextNodename;	//下一节点名称
	private int nextNodetype;	//下一节点类型

	
	public static final String SQL = ("insert into tw_hz_flow_nodes (id,flowid,flowver,islastver,pre_nodeid,pre_nodename,pre_nodetype,"
			+ "routerid,routername,next_nodeid,next_nodename,next_nodetype,pre_subflowid) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?)").toUpperCase();
	public List<Object> getParaList(){
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(id);
		dlst.add(flowid);
		dlst.add(new Integer(flowver));
		dlst.add(new Integer(1));
		dlst.add(preNodeid);

		dlst.add(preNodename);
		dlst.add(new Integer(preNodetype));
		dlst.add(routerid);
		dlst.add(routername);
		dlst.add(nextNodeid);

		dlst.add(nextNodename);
		dlst.add(new Integer(nextNodetype));
		dlst.add(preSubflowid);
		return dlst;
	}
	
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getFlowid() {
		return flowid;
	}
	public void setFlowid(String flowid) {
		this.flowid = flowid;
	}
	public int getFlowver() {
        return flowver;
    }
    public void setFlowver(int flowver) {
        this.flowver = flowver;
    }
    public int getIslastver() {
        return islastver;
    }
    public void setIslastver(int islastver) {
        this.islastver = islastver;
    }
    public String getPreNodeid() {
		return preNodeid;
	}
	public void setPreNodeid(String preNodeid) {
		this.preNodeid = preNodeid;
	}
	public String getPreNodename() {
		return preNodename;
	}
	public void setPreNodename(String preNodename) {
		this.preNodename = preNodename;
	}
	public int getPreNodetype() {
		return preNodetype;
	}
	public void setPreNodetype(int preNodetype) {
		this.preNodetype = preNodetype;
	}
	public String getRouterid() {
		return routerid;
	}
	public void setRouterid(String routerid) {
		this.routerid = routerid;
	}
	public String getRoutername() {
		return routername;
	}
	public void setRoutername(String routername) {
		this.routername = routername;
	}
	public String getNextNodeid() {
		return nextNodeid;
	}
	public void setNextNodeid(String nextNodeid) {
		this.nextNodeid = nextNodeid;
	}
	public String getNextNodename() {
		return nextNodename;
	}
	public void setNextNodename(String nextNodename) {
		this.nextNodename = nextNodename;
	}
	public int getNextNodetype() {
		return nextNodetype;
	}
	public void setNextNodetype(int nextNodetype) {
		this.nextNodetype = nextNodetype;
	}

	public String getPreSubflowid() {
		return preSubflowid;
	}

	public void setPreSubflowid(String preSubflowid) {
		this.preSubflowid = preSubflowid;
	}
}
