package com.horizon.wf.api.bean;

import java.util.List;

import com.horizon.third.ThirdAdapterFactory;

public class TodoPara {
	private String flowid;
	private String userid;
	private String alluserid;
	private String where;
	private String oderby;
	private List<String> para;
	private String tenantid;
	private String identifier;
	private int pageNum  =0;
	private int pageSize =15;
	public String getFlowid() {
		return flowid;
	}
	/**
	 * 流程id
	 * @param flowid
	 */
	public void setFlowid(String flowid) {
		this.flowid = flowid;
	}
	public String getUserid() {
		return userid;
	}
	/**
	 * 人员id必须参数
	 * @param userid
	 */
	public void setUserid(String userid) {
		this.userid = userid;
	}
	public String getAlluserid() {
		return alluserid;
	}
	/**
	 * 人员所有权限id,
	 * @param alluserid
	 */
	public void setAlluserid(String alluserid) {
		this.alluserid = alluserid;
	}
	public String getWhere() {
		return where;
	}
	/**
	 * 额外的查询条件
	 * @param where
	 */
	public void setWhere(String where) {
		this.where = where;
	}
	public List<String> getPara() {
		return para;
	}
	
	/**
	 * 排序条件
	 * @return
	 */
	public String getOderby(String defOrderBy) {
	    if(oderby == null || "".equals(oderby)){
	        return " "+defOrderBy;
	    }
        return " "+oderby;
    }
    public void setOderby(String oderby) {
        this.oderby = oderby;
    }
    
    public String getOderby(){
        return oderby;
    }
    /**
	 * 额外查询条件对应的参数
	 * @param para
	 */
	public void setPara(List<String> para) {
		this.para = para;
	}
	public String getTenantid() {
		return tenantid;
	}
	/**
	 * 租户标识id
	 * identifier 和 tenantid 二者必须传入其中一个
	 * @param tenantid
	 */
	public void setTenantid(String tenantid) {
		this.tenantid = tenantid;
	}
	public String getIdentifier() {
		if(identifier == null || "".equals(identifier)){
			identifier = ThirdAdapterFactory.getIdentifierFromTenantid(tenantid);
		}
		return identifier;
	}
	/**
	 * 数据源标识符id
	 * identifier 和 tenantid 二者必须传入其中一个
	 * @param identifier
	 */
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}
	public int getPageNum() {
		return pageNum;
	}
	/**
	 * 分页时,获取第多少页
	 * @param pageNum
	 */
	public void setPageNum(int pageNum) {
		this.pageNum = pageNum;
	}
	public int getPageSize() {
		return pageSize;
	}
	/**
	 * 分页时,每页数目
	 * @param pageSize
	 */
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
	
	
	
	
}
