package com.horizon.wf.api.bean;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBRelation;
import com.horizon.wf.entity.db.DBSubflowRecord;

import java.util.List;
import java.util.Map;

/**
 * 用来在pub包中扩展,获取当前节点的子流程是否全部结束
 * 按钮获取放入core包之后,因为子流程结束的判断在WorkflowOperator中处理的,
 * 所以使用一个中间类来记录已经计算过的结果,避免重复从数据库获取
 */
public class SubEndBean extends BaseRuleImpl implements IBaseRule {

    @Override
    public boolean executeRule() {
        String trackid = (String) getParameter("trackid");
        String nodeid = (String) getParameter("nodeid");;
        String identifier = getRunningdata().getInitData().getFlowIdentifier();

        List<DBSubflowRecord>  srList = DBSubflowRecord.getListByParentTrackidAndNodeid(trackid, nodeid, identifier);
        boolean checkSubflowIsAllEnd = checkSubflowIsAllEnd(srList);

        setResult("DBSubflowRecord",srList);
        setResult("checkSubflowIsAllEnd",checkSubflowIsAllEnd);
        return checkSubflowIsAllEnd;
    }

    private boolean checkSubflowIsAllEnd(List<DBSubflowRecord>  srList ){
        for (int i = 0, n = srList.size(); i < n; i++) {
            DBSubflowRecord sr = srList.get(i);
            if("0".equals(sr.getSubflowend())){
                return false;
            }
        }
        return true;
    }

}
