package com.horizon.wf.api;

import com.horizon.wf.api.bean.XNode;
import com.horizon.wf.definition.INodeForXmlToDB;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.tools.AccessUtil;

import java.util.*;

/**
 * 把xml信息转换为数据库信息
 * @author liys
 *
 */
public class XNodeUtil implements INodeForXmlToDB{
	public boolean saveNodeToDB(IFlowInfo flowInfo, String identifier) {
		String flowid = flowInfo.getFlowid();
		List<IFlowNode> list = flowInfo.getAllNodesAndVirtual();
		List<Object> para = new ArrayList<Object>();
		int flowver = flowInfo.getVersion();//Integer.parseInt(XMLParseUtil.getTextTrim(xml, "TypeDeclarations/Version"));
		Map<String,IFlowNode> nodeMap = chgToMap(list);
		for(int i=0,n=list.size();i<n;i++){
			IFlowNode node = list.get(i);
			List<INodeRouter> routers =  node.getAllToRouters();
			if(routers == null || routers.isEmpty()){
				continue;
			}
			StringBuilder sb = new StringBuilder();
			if(node.getNodetype() == NodeTypeEnum.Node_Sub){
				List<INodeSubflow> subflows = node.getSubFlowList();
				for(int k=0,p=subflows.size();k<p;k++){
					sb.append(";").append(subflows.get(k).getSubFlowId());
				}
				if(sb.length()>0){
					sb.deleteCharAt(0);
				}
			}

			for(int j=0,m=routers.size();j<m;j++){
				INodeRouter router = routers.get(j);
				XNode xNode = new XNode();
				xNode.setId(StaticFunExtend.getUnid());
				xNode.setFlowid(flowid);
				xNode.setFlowver(flowver);
				xNode.setPreNodeid(node.getNodeid());
				xNode.setPreNodename(node.getNodename());
				xNode.setPreNodetype(node.getNodetype());

				xNode.setRouterid(router.getRouterid());
				xNode.setRoutername(router.getRoutername());

				xNode.setNextNodeid(router.getNodeid());
				xNode.setNextNodename(router.getNodename());
				xNode.setNextNodetype(router.getNodetype());
				xNode.setPreSubflowid(sb.toString());
				para.add(xNode.getParaList());
			}
		}

		Map<String,List<Object>> saveMap = new LinkedHashMap<String,List<Object>>();
		List<Object> paradel = new ArrayList<Object>(1);
		paradel.add(flowid);
		paradel.add(new Integer(flowver));
		saveMap.put("UPDATE TW_HZ_FLOW_NODES SET ISLASTVER=0 WHERE FLOWID=? AND FLOWVER < ?", paradel);
		saveMap.put("DELETE FROM TW_HZ_FLOW_NODES WHERE FLOWID=? AND FLOWVER=?", paradel);

		saveMap.put(XNode.SQL, para);

		boolean result = false;
		try{
			result = AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
		}catch(Exception e){
			System.out.println("保存节点信息到数据库失败,可能表不存在");
			e.printStackTrace();
		}
		return result;
	}

	private Map<String,IFlowNode> chgToMap(List<IFlowNode> list){
		Map<String,IFlowNode> map = new HashMap<String, IFlowNode>();
		for(int i=0,n=list.size();i<n;i++){
			IFlowNode node = list.get(i);
			map.put(node.getNodeid(),node);
		}
		return map;
	}

	/**
	 * 删除数据库中记录的节点信息
	 * @param flowid
	 * @param identifier
	 * @return
	 */
	public boolean delNodeFromDB(String flowid,String identifier){
		Map<String,List<Object>> saveMap = new HashMap<String,List<Object>>();
		List<Object> paradel = new ArrayList<Object>(1);
		paradel.add(flowid);
		saveMap.put("delete from tw_hz_flow_nodes where flowid=?", paradel);
		
		boolean result = false;
		try{
			result = AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
		}catch(Exception e){
			System.out.println("保存节点信息到数据库失败,可能表不存在");
			e.printStackTrace();
		}
		return result;
	}
}
