package com.horizon.wf.api;

import com.alibaba.fastjson.JSONObject;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.action.ActionReaded;
import com.horizon.wf.action.common.MemoryOperator;
import com.horizon.wf.api.common.SerializableUtil;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.bean.WorkResultBean;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.instance.CreateInstance;
import com.horizon.wf.core.instance.OpenInstance;
import com.horizon.wf.core.mem.MemCacheUtil;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.ITaskWork;
import com.horizon.wf.core.work.TaskWork;
import com.horizon.wf.core.work.data.InitData;
import com.horizon.wf.definition.FlowDefinitionUtil;
import com.horizon.wf.definition.InstanceDefinitionUtil;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.expand.impl.IHZTransaction;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.event.EventUtil;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

/**
 * 封装流程操作
 * 
 * @author liangjw
 * @version 1.0
 * @since hzwf v7.0
 *
 */
public class WorkflowOperator implements IWorkflowOperator {

	/**
	 * 关闭实例
	 * 
	 * @param workid
	 * @param trackid
	 * @param userid
	 */
	public void close(String workid, String trackid, String userid) {
		// 2016-11-17 liys
		// 增加判断实例不为子流程时版本是否为1,如果是,则删除
		String identifier = MemCacheUtil.closeForOpen(workid, trackid, userid);
		if (identifier != null) {
			WorkflowFactory.getWorkflowManager().deleteWork(workid, "",
					identifier);
		}
	}
	public void close(String workid, String trackid, String userid,String tenantid) {
		// 2016-11-17 liys
		// 增加判断实例不为子流程时版本是否为1,如果是,则删除
		String identifier = MemCacheUtil.closeForOpen(workid, trackid, userid,tenantid);
		if (identifier != null) {
			WorkflowFactory.getWorkflowManager().deleteWork(workid, "",
					identifier);
		}
	}
	
	private boolean checkTenantidForWorkParaBean(WorkParaBean workParaBean,
			WorkResultBean wb) {
		if (null == workParaBean) {
			String backMsg = "参数WorkParaBean对象为空";
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}

		String tenantCode = workParaBean.getTenantCode();
		String identifier = workParaBean.getFlowIdentifier();
		if (null == tenantCode || "".equals(tenantCode)) {
			if (null == identifier || "".equals(identifier)) {
				wb.setBackMsg("数据源标识符和租户id同时为空!");
				wb.setResult(StaticVarExtend.Init_Failed);
				return false;
			} else {
				tenantCode = ThirdAdapterFactory
						.getTenantidByIdentifier(identifier);
				workParaBean.setTenantCode(tenantCode);
			}
		} else {
			if (null == identifier || "".equals(identifier)) {
				identifier = ThirdAdapterFactory
						.getIdentifierFromTenantid(tenantCode);
				workParaBean.setFlowIdentifier(identifier);
			}
		}
		return true;
	}

	private void testPrintln(String str,long start){
		//System.out.println("----------["+str+"]执行时间:------------"+(System.currentTimeMillis()-start));
	}

	/**
	 * 创建流程实例
	 * 
	 * @param workParaBean
	 *            :其中flowid和userid为必须的参数
	 * @return 创建后的返回值已经实例信息
	 */
	public IWorkResult create(WorkParaBean workParaBean) {
		long start = System.currentTimeMillis();
		WorkResultBean wrb = new WorkResultBean();// 操作返回对象
		// 校验创建流程实例的参数是否合法
		if (checkCreatePara(workParaBean, wrb)) {
			CreateInstance ci = new CreateInstance();
			// 设置创建实例的参数
			setCreatePara(workParaBean, ci);

			// 执行创建实例
			int result = ci.doAction();
			testPrintln("创建实例API",start);
			if (StaticVarExtend.Init_Success == result) {
				setCreateReturnPara(wrb, ci, workParaBean);
			} else if (StaticVar.F_STATUS_SelectAuthor == result) {
				setCreateReturnPara(wrb, ci, workParaBean);
			}
			wrb.setResult(result);
			wrb.setBackMsg(ci.getBackMsg());
		}
		testPrintln("创建实例",start);
		return wrb;
	}

	/**
	 * 批量创建实例
	 * 
	 * @param workParaBeans
	 *            操作实例所需参数对象集合
	 */
	public boolean createTransactionalConsistency(
			List<WorkParaBean> workParaBeans) {
		if (CollectionUtil.isListNotEmpty(workParaBeans)) {
			boolean isSuccess = false;// 标识执行是否成功
			StringBuilder workids = new StringBuilder(3200);// 需要解锁的workid
			IHZTransaction ht = PluginsUtil.getSingleInstance().getHZTransaction();// 手动控制事务接口
			long startTime = Calendar.getInstance().getTimeInMillis();
			try {
				ht.begin();
				Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
				List<RunningData> worklist = new ArrayList<RunningData>();
				for (int i = 0, n = workParaBeans.size(); i < n; i++) {
					WorkParaBean wpb = workParaBeans.get(i);
					wpb.setMultiInstanceTransaction(true);// 是否多个操作保证事务的一致性
					WorkResultBean wrb = new WorkResultBean();// 操作返回对象
					if (checkCreatePara(wpb, wrb)) {
						CreateInstance ci = new CreateInstance();
						// 设置创建实例的参数
						setCreatePara(wpb, ci);

						// 执行创建实例
						int result = ci.doAction();
						if (StaticVarExtend.Init_Success == result) {
							workids.append(ci.getWorkid()).append(
									StaticVarExtend.StrSplitChar);
							RunningData rd = ci.getRunningdata();
							Map<String, List<Object>> map = rd.getFlowMap();
							Iterator<Map.Entry<String, List<Object>>> iter = map
									.entrySet().iterator();
							while (iter.hasNext()) {
								Map.Entry<String, List<Object>> entry = (Map.Entry<String, List<Object>>) iter
										.next();
								excuteMap(entry,saveMap);
							}
							isSuccess = true;
							worklist.add(rd);
						} else {
							ht.rollback();
							String workid = ci.getWorkid();
							if (!"".equals(workid)) {
								close(workid, ci.getTrackid(), wpb.getUserId());
							}
							isSuccess = false;
							break;
						}
					} else {
						ht.rollback();
						isSuccess = false;
						break;
					}
				}
				long nowTime = Calendar.getInstance().getTimeInMillis();
				testPrintln("创建实例[" + workParaBeans.size()
						+ "]_引擎逻辑处理用时" ,startTime);
				if (isSuccess) {
					String identifier = workParaBeans.get(0)
							.getFlowIdentifier();
					isSuccess = AccessUtil.getInstance()
							.executeMultiUpdate(saveMap, identifier);
					startTime = Calendar.getInstance().getTimeInMillis();
					testPrintln("创建实例[" + workParaBeans.size()
							+ "]_数据写库处理用时" ,nowTime);

					saveMap.clear();
				}
				if (isSuccess) {
					ht.commit();
					boolean isOk = ht.isSuccess();// 确定是否所有sql都执行完成
					if (isOk) {
						excuteAfterSaveToDB_MultiInstanceTransaction(worklist);
						return true;
					}
				}
				MemCacheUtil.unLockForBatch(workids.toString());
				ht.rollback();
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				try {
					ht.rollback();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			} finally {
				try {
					ht.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return false;
	}
	private void excuteMap(Map.Entry<String, List<Object>> entry,Map<String, List<Object>> saveMap){
		String key = entry.getKey();
		List<Object> value = entry.getValue();
		List<Object> oldValue = saveMap.get(key);
		if (oldValue == null) {
			saveMap.put(key, value);
		} else {
			oldValue.addAll(value);
		}
	}
	private void excuteAfterSaveToDB_MultiInstanceTransaction(List<RunningData> worklist){
		for (int i = 0, n = worklist.size(); i < n; i++) {
			RunningData rd = worklist.get(i);
			rd.excuteAfterSaveToDB_MultiInstanceTransaction();
		}
	}

	/**
	 * 打开流程实例(执行打开事件)
	 * 
	 * @param workParaBean
	 *            :打开实例所需的参数
	 * @return IWorkResult 打开后的信息
	 */
	public IWorkResult open(WorkParaBean workParaBean) {
		IWorkResult result = openWithLock(workParaBean, false);
		return result;
	}

	/**
	 * 打开流程实例
	 * 
	 * @param workParaBean
	 *            :打开实例所需的参数
	 * @param isLock
	 *            批量操作时 是否锁定实例
	 * @return IWorkResult 打开后的信息
	 */
	private IWorkResult openWithLock(WorkParaBean workParaBean, boolean isLock) {
		long start = System.currentTimeMillis();
		WorkResultBean wb = new WorkResultBean();// 操作返回对象
		// 校验创建流程实例的参数是否合法
		if (checkOpenPara(workParaBean, wb)) {
			OpenInstance newInstance = new OpenInstance();
			// 设置打开实例的参数
			setOpenPara(workParaBean, newInstance);
			if (isLock) {
				newInstance.lockInstanceForBatch();
			}
			int result = newInstance.doAction();
			testPrintln("打开实例API",start);
			// 打开成功后执行打开事件
			if (StaticVarExtend.Init_Success == result) {
				boolean isSuccess = excuteOpenEvent(
						newInstance.getRunningdata(),
						StaticVarExtend.EVENT_OPEN);
				if (isSuccess) {
					setOpenReturnPara(wb, newInstance, workParaBean, result);
				} else {
					// 20150630 liys 打开事件执行失败时,如果是系统执行,则返回打开失败信息
					if (workParaBean.getUserId().equals(
							StaticVarExtend.System_Id)) {
						wb.setResult(StaticVarExtend.Init_Failed);
						wb.setBackMsg(PubInfo.getPubInfo(
								workParaBean.getTenantCode()).getInfo(
								"Operator_Msg0002",
								"节点进入事件执行失败或者异常.如果异常已处理请重新打开."));
						return wb;
					}
					// 人工打开时,忽略事件再次执行打开
					IWorkResult reOpenResult = openNotExeOpenEvent(workParaBean);
					return reOpenResult;
				}
			} else if (StaticVarExtend.Init_Locked == result) {
				setOpenReturnPara(wb, newInstance, workParaBean, result);
			}

			wb.setWorkParaBean(workParaBean);
			wb.setBackMsg(newInstance.getBackMsg());
			wb.setResult(result);
		}
		testPrintln("打开实例",start);
		return wb;
	}

	/**
	 * 打开流程实例(不执行打开事件) 用于异常执行时打开实例
	 * 
	 * @param workParaBean
	 *            :打开实例所需的参数
	 * @return IWorkResult 打开后的信息
	 */
	public IWorkResult openNotExeOpenEvent(WorkParaBean workParaBean) {
		WorkResultBean wb = new WorkResultBean();// 操作返回对象
		// 校验创建流程实例的参数是否合法
		if (checkOpenPara(workParaBean, wb)) {
			OpenInstance newInstance = new OpenInstance();
			// 设置打开实例的参数
			setOpenPara(workParaBean, newInstance);
			int result = newInstance.doAction();
			setOpenReturnPara(wb, newInstance, workParaBean, result);
			wb.setBackMsg(newInstance.getBackMsg());
			wb.setResult(result);
		}
		return wb;
	}

	/**
	 * 调用流程实例的操作
	 * 
	 * @return IWorkResult 操作后的实例相关信息
	 */
	public IWorkResult operator(WorkParaBean workParaBean) {
		long start = System.currentTimeMillis();
		WorkResultBean wb = new WorkResultBean();// 操作返回对象
		if (checkOperatorPara(workParaBean, wb)) {
			ITaskWork work = TaskWork.getTaskWork();
			setOperatorPara(workParaBean, work);
			work.executeWork();
			Object obj = work.getWorkResultBean();
			if (obj != null) {
				wb = (WorkResultBean) obj;
			}

			wb.setBackMsg(work.getRunningdata().getBackMsg());
			wb.setResult(work.getRunningdata().getResultCode());
		}
		testPrintln("操作实例",start);
		return wb;
	}

	/**
	 * 批量操作（同一事物）
	 * 
	 * @param workParaBeans
	 *            操作实例所需参数对象集合
	 * @return 操作是否成功
	 */
	public boolean operatorsTransactionalConsistency(
			List<WorkParaBean> workParaBeans) {
		if (CollectionUtil.isListNotEmpty(workParaBeans)) {
			boolean isSuccess = false;// 标识执行是否成功
			StringBuilder workids = new StringBuilder(3200);// 需要解锁的workid
			IHZTransaction ht = PluginsUtil.getSingleInstance().getHZTransaction();// 手动控制事务接口
			long startTime = Calendar.getInstance().getTimeInMillis();
			try {
				ht.begin();
				Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
				List<RunningData> worklist = new ArrayList<RunningData>();
				for (int i = 0, n = workParaBeans.size(); i < n; i++) {
					WorkParaBean wpb = workParaBeans.get(i);

					wpb.setMultiInstanceTransaction(true);// 是否多个操作保证事务的一致性
					IWorkResult r = openWithLock(wpb, true);
					if (r.getResult() == StaticVarExtend.Init_Success) {
						workids.append(r.getWorkid()).append(
								StaticVarExtend.StrSplitChar);
						ITaskWork work = TaskWork.getTaskWork();
						setOperatorPara(wpb, work);
						work.executeWork();

						RunningData rd = work.getRunningdata();

						if (rd.getResultCode() != StaticVarExtend.F_STATUS_Success) {
							ht.rollback();
							close(wpb.getWorkId(), wpb.getTrackId(),
									wpb.getUserId());
							isSuccess = false;
							break;
						} else {

							Map<String, List<Object>> map = rd.getFlowMap();
							Iterator<Map.Entry<String, List<Object>>> iter = map
									.entrySet().iterator();
							while (iter.hasNext()) {
								Map.Entry<String, List<Object>> entry = (Map.Entry<String, List<Object>>) iter
										.next();
								String key = entry.getKey();
								List<Object> value = entry.getValue();
								List<Object> oldValue = saveMap.get(key);
								if (oldValue == null) {
									saveMap.put(key, value);
								} else {
									oldValue.addAll(value);
								}
							}
							isSuccess = true;
							worklist.add(rd);
						}
					} else {
						ht.rollback();
						isSuccess = false;
						close(wpb.getWorkId(), wpb.getTrackId(),
								wpb.getUserId());
						break;
					}
				}
				long nowTime = Calendar.getInstance().getTimeInMillis();
				testPrintln("实例提交[" + workParaBeans.size()
						+ "]引擎逻辑处理用时",startTime);
				if (isSuccess) {
					String identifier = workParaBeans.get(0)
							.getFlowIdentifier();
					isSuccess = AccessUtil.getInstance()
							.executeMultiUpdate(saveMap, identifier);
					testPrintln("实例提交[" + workParaBeans.size()
							+ "]_数据写库处理用时",nowTime);

					saveMap.clear();
				}
				if (isSuccess) {
					ht.commit();
					boolean isOk = ht.isSuccess();// 确定是否所有sql都执行完成
					if (isOk) {
						for (int i = 0, n = worklist.size(); i < n; i++) {
							RunningData rd = worklist.get(i);
							rd.excuteAfterSaveToDB_MultiInstanceTransaction();
						}
						return true;
					}
				}
				MemCacheUtil.unLockForBatch(workids.toString());
				ht.rollback();
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				try {
					ht.rollback();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			} finally {
				try {
					ht.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return false;
	}

	/**
	 * 批量操作（不在同一事物）
	 * 
	 * @param workParaBeans
	 *            操作实例所需参数对象集合
	 * @return 操作是否成功
	 */
	public List<IWorkResult> operators(List<WorkParaBean> workParaBeans) {
		if (CollectionUtil.isListNotEmpty(workParaBeans)) {
			List<IWorkResult> results = new ArrayList<IWorkResult>();
			for (int i = 0, n = workParaBeans.size(); i < n; i++) {
				WorkParaBean wpb = workParaBeans.get(i);
				IWorkResult r = open(wpb);
				if (r.getResult() == StaticVarExtend.Init_Success) {
					r = operator(wpb);
					if (r.getResult() != StaticVarExtend.F_STATUS_Success) {
						close(wpb.getWorkId(), wpb.getTrackId(),
								wpb.getUserId());
					}
				}
				results.add(r);
			}
			return results;
		}
		return null;
	}

	/**
	 * 打开实例成功后，执行节点中的打开(创建)事件
	 * 
	 */
	private boolean excuteOpenEvent(RunningData rd, String eventType) {
		IFlowNode curNode = rd.getCurFlowNode();
		return EventUtil.getInstance().excuteEventsForOpen(curNode, eventType,
				rd);
	}

	/**
	 * 设置操作时的参数
	 * 
	 * @param workParaBean
	 * @param work
	 */
	@SuppressWarnings("unchecked")
	private void setOperatorPara(WorkParaBean workParaBean, ITaskWork work) {
		work.setClassNameForAction(workParaBean.getActionClass());
		if (workParaBean instanceof WorkParaBean) {
			WorkParaBean paraBean = (WorkParaBean) workParaBean;
			work.setBusinessImpl(paraBean.getBussinessImpl());
		}
		work.setClassNameForBusiness(workParaBean.getBussinessClass());
		work.setDataIdentifier(workParaBean.getDataIdentifier());
		work.setFlowIdentifier(workParaBean.getFlowIdentifier());
		work.setTrackid(workParaBean.getTrackId());
		// 保证userid为userid
		AuthUserImpl user = AuthUserImpl.getAuthUserByStr(workParaBean
				.getUserId());
		work.setUserid(user.getAuthId());

		String workid = workParaBean.getWorkId();
		work.setTenantid(workParaBean.getTenantCode());
		work.setWorkid(workid);
		// 从内存获取打开之后存放的值
		Map<String, String> flowVarMap = new LinkedHashMap<String, String>();
		Map<String, String> map = (HashMap<String, String>) MemoryOperator
				.getValueFromMap(workid);

		if (CollectionUtil.isMapNotEmpty(map)) {
			flowVarMap.putAll(map);
		}
		// 重新从前台设置获取并覆盖,用于本次执行
		flowVarMap.putAll(workParaBean.getFlowVarMap());

		// 操作执行时,内部从表单上获取数据,并更新
		work.setFlowVarValueMap(flowVarMap);

		work.setOtherPara(workParaBean.getOtherPara());
		work.setWorkParaBean(workParaBean);
	}

	/**
	 * 设置返回值的参数到WorkResultBean
	 * 
	 * @param wb
	 * @param ci
	 */
	private void setCreateReturnPara(WorkResultBean wb, CreateInstance ci,
			WorkParaBean workParaBean) {
		wb.setWorkParaBean(workParaBean);
		RunningData rd = ci.getRunningdata();
		wb.setRunningdata(rd);
		DBTrack track = rd.getCurTrack();
		wb.setCurTrackInfo(track);
		wb.setWork(ci.getWork());
		String workid = ci.getWorkid();
		InitData id = rd.getInitData();
		if (null != id) {
			wb.setHashMap(id.getHashMap());
		}
		InstanceDefinitionUtil idu = rd.getInstanceDefinition();
		if (null != idu) {
			IFlowInfo flowInfo = idu.getFlowinfo();
			wb.setFlowInfo(flowInfo);
			// 流程创建 初始化流程变量
			Map<String, String> flowVarMap = rd.getFlowVar().getAllFlowVarMap();
			// ac.getFlowVarDefaultValueFromFlowInfo(flowInfo.getAllVar());
			if (null == flowVarMap) {
				flowVarMap = new LinkedHashMap<String, String>();
			}
			// 使用前台传入的变量值替换默认值
			flowVarMap.putAll(workParaBean.getFlowVarMap());
			// 流程变量放入内存
			if (CollectionUtil.isMapNotEmpty(flowVarMap)) {
				MemoryOperator.putValueToMap(workid, flowVarMap);
			}

			wb.setFlowVarMap(flowVarMap);
		}
		IRunUser curUser = ci.getCurUser();
		IFlowNode curNode = ci.getCurNode();

		wb.setCurButton(ci.getCurButton());
		wb.setCurUser(curUser);
		wb.setCurNode(curNode);
		wb.setCreateInstance(ci);
	}

	/**
	 * 设置创建流程实例的参数
	 * 
	 * @param workParaBean
	 *            创建流程实例时的参数bean
	 * @param ci
	 *            创建流程实例时的bean，将workParaBean中的值设置到该类中
	 */
	private void setCreatePara(WorkParaBean workParaBean, CreateInstance ci) {
		String allUserids = workParaBean.getAllUserids();
		String userid = workParaBean.getUserId();
		AuthUserImpl user = AuthUserImpl.getAuthUserByStr(userid);
		String flowIdentifier = workParaBean.getFlowIdentifier();
		if (!(StringUtilExtend.isNotNull(allUserids) || userid
				.equals(StaticVarExtend.System_Id))
				|| userid.equals(StaticVarExtend.Manager_Log_Userid)) {
			ci.getRunningdata().putMsgToConsole("[Msg]getAllUserid...start");
			allUserids = PluginsUtil.getMultiInstance().getOrganization(
					workParaBean.getTenantCode()).getAllUserids(
					user.getAuthId(), flowIdentifier);
			ci.getRunningdata().putMsgToConsole("[Msg]getAllUserid...end");
		}
		ci.setAllUserid(allUserids);
		ci.setDataIdentifier(workParaBean.getDataIdentifier());

		ci.setFlowid(workParaBean.getFlowId());
		ci.setFlowIdentifier(flowIdentifier);
		ci.setOuterConfig(workParaBean.getOuterConfig());
		ci.setParentWorkid(workParaBean.getParentWorkid());
		ci.setUserid(user.getAuthId());
		ci.setSubjectionid(user.getSubjectionId());
		ci.setSubjectionType(user.getSubjectionType());
		// 以直接设置的归属id为准,如果未设置则以userid中拆分的为准
		ci.setSubjection(workParaBean.getSubjection());
		ci.setTenantid(workParaBean.getTenantCode());// 租户标识
		ci.setTitle(workParaBean.getTitle());//设置标题
		if (userid.equals(StaticVarExtend.System_Id)) {
			workParaBean.setUserName(PubInfo.getPubInfo(
					ci.getRunningdata().getLangInfo()).getInfo("System_Name",
					"工作流系统"));
			workParaBean.setDeptName(workParaBean.getUserName());
		} else if (userid.equals(StaticVarExtend.Manager_Log_Userid)) {
			workParaBean.setUserName(PubInfo.getPubInfo(
					ci.getRunningdata().getLangInfo()).getInfo(
					"Manager_Log_Username", "系统管理员"));
			workParaBean.setDeptName(workParaBean.getUserName());
		} else {
			// 设置自动提交时的参数
			workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_AUTHOR, "Todo");
			workParaBean.setFunname("autofirst");
			workParaBean
					.setActionClass("com.horizon.wf.action.ActionSubmitFirst");
			workParaBean.setSubmitflag("0");// 不保存

			Map<String, String> selectAuthorMap = workParaBean
					.getOnlyForCreateMap();
			String key = StaticVarExtend.AUTH_AUTHOR;
			selectAuthorMap.put(key, ci.getCurUser().getFullName());
		}
		if (workParaBean.isDoNotToFirstNode()) {
			// 20161213 liys 不自动提交到第一个节点
			ci.doNotToFirstNode();
		}

		ci.setUsername(workParaBean.getUserName());
		ci.setDeptname(workParaBean.getDeptName());

		ci.setFlowVarValueMap(workParaBean.getFlowVarMap());

		if (workParaBean instanceof WorkParaBean) {
			WorkParaBean paraBean = (WorkParaBean) workParaBean;
			ci.setBusinessImpl(paraBean.getBussinessImpl());
		}
		ci.setClassNameForBusiness(workParaBean.getBussinessClass());
		ci.setOtherPara(workParaBean.getOtherPara());

		ci.setWorkParaBean(workParaBean);
	}

	/**
	 * 设置打开的参数到OpenInstance对象
	 * 
	 * @param workParaBean
	 * @param newInstance
	 */
	private void setOpenPara(WorkParaBean workParaBean, OpenInstance newInstance) {
		String allUserids = workParaBean.getAllUserids();
		String userid = workParaBean.getUserId();
		AuthUserImpl user = AuthUserImpl.getAuthUserByStr(userid);
		String flowIdentifier = workParaBean.getFlowIdentifier();
		if (!(StringUtilExtend.isNotNull(allUserids)
				|| userid.equals(StaticVarExtend.System_Id) || userid
					.equals(StaticVarExtend.Manager_Log_Userid))) {
			newInstance.getRunningdata().putMsgToConsole("[Msg]getAllUserid...start");
			allUserids = PluginsUtil.getMultiInstance().getOrganization(
					workParaBean.getTenantCode()).getAllUserids(
					user.getAuthId(), flowIdentifier);
			newInstance.getRunningdata().putMsgToConsole("[Msg]getAllUserid...end");
		}
		newInstance.setAllUserid(allUserids);
		newInstance.setCurTrack(workParaBean.getTrackId());
		newInstance.setDataIdentifier(workParaBean.getDataIdentifier());
		newInstance.setFlowIdentifier(flowIdentifier);
		newInstance.setUserid(user.getAuthId());
		newInstance.setSubjectionid(user.getSubjectionId());
		newInstance.setSubjectionType(user.getSubjectionType());
		// 以直接设置的归属id为准,如果未设置则以userid中拆分的为准
		newInstance.setSubjection(workParaBean.getSubjection());
		newInstance.setWorkid(workParaBean.getWorkId());
		newInstance.setTenantid(workParaBean.getTenantCode());

		if (userid.equals(StaticVarExtend.System_Id)) {
			workParaBean.setUserName(PubInfo.getPubInfo(
					newInstance.getRunningdata().getLangInfo()).getInfo(
					"System_Name", "工作流系统"));
			workParaBean.setDeptName(workParaBean.getUserName());
		} else if (userid.equals(StaticVarExtend.Manager_Log_Userid)) {
			workParaBean.setUserName(PubInfo.getPubInfo(
					newInstance.getRunningdata().getLangInfo()).getInfo(
					"Manager_Log_Username", "系统管理员"));
			workParaBean.setDeptName(workParaBean.getUserName());
		}
		newInstance.setUsername(workParaBean.getUserName());
		newInstance.setDeptname(workParaBean.getDeptName());
		newInstance.setWorkParaBean(workParaBean);
	}

	/**
	 * 设置打开后的返回值到WorkResultBean对象
	 * 
	 * @param wb
	 * @param newInstance
	 */
	private void setOpenReturnPara(WorkResultBean wb, OpenInstance newInstance,
			WorkParaBean workParaBean, int result) {
		wb.setWorkParaBean(workParaBean);
		RunningData rd = newInstance.getRunningdata();
		wb.setRunningdata(rd);
		wb.setCurTrackInfo(rd.getCurTrack());
		InitData id = rd.getInitData();
		if (null != id) {
			wb.setHashMap(id.getHashMap());
		}
		InstanceDefinitionUtil idu = rd.getInstanceDefinition();
		if (null != idu) {
			wb.setFlowInfo(idu.getFlowinfo());
		}
		IRunUser curUser = newInstance.getCurUser();
		IFlowNode curNode = newInstance.getCurNode();
		//20180815 liys 把对子流程的处理放到获取操作之前,
		//子流程的处理会修改流程状态,所以放到前面来
		Map<String, String> flowVarMap = new LinkedHashMap<String, String>();
		Map<String, String> tempMap = rd.getFlowVar().getAllFlowVarMap();
		if (!(null == tempMap || tempMap.isEmpty())) {
			flowVarMap.putAll(tempMap);
		}

		// 使用前台设置的变量替换已存在的值,用于本次操作
		if (null != workParaBean.getFlowVarMap()) {
			flowVarMap.putAll(workParaBean.getFlowVarMap());
		}
		if (curNode != null) {
			//处理子流程
			doWithSubflowRecord(rd,flowVarMap,curNode.getNodeid(),newInstance.getSubEndBean());
		}
		wb.setFlowVarMap(flowVarMap);

		if (StaticVarExtend.Init_Locked == result) {
			wb.setCurButton(null);
			wb.setLockUser(newInstance.getLockUser());
		}
		else{
			wb.setCurButton(newInstance.getCurButton());
			if(newInstance.isAutoReaded()){
				autoReaded(rd, curUser);
			}

		}

		// 20180126 liys 独占打开时,增加判断是否有操作,如果没有则把内存中的锁定人删除
		List<INodeButton> btns = wb.getCurNodeButton();
		if (StaticVarExtend.Init_Locked != result
				&& (btns == null || btns.size() == 0)) {
			newInstance.removeLockFromMem();
		}
		wb.setCurUser(curUser);
		wb.setCurNode(curNode);
		wb.setWork(newInstance.getWork());
		String workId = newInstance.getWorkid();
		wb.setActiveTrackInfos(newInstance.getActiveTrackInfo());
		wb.setOpenInstance(newInstance);

		// 20180319 liys 增加判断已办表单权限
		String authName = wb.getCurUser().getAuthName();
		if (HZResourceBundle.getInstance().isDoneAuthFormAuthorNode()
				&& StaticVarExtend.AUTH_DONE.equals(authName)) {
			// //从数据库中获取已办表单信息
			List<DBDone> listDone = DBDone.getListDone(rd.getResultJson(),workId, curUser.getUserid(),
					curNode.getNodeid(), rd.getInitData()
							.getFlowIdentifier());
			if(!listDone.isEmpty()){
				wb.setCurNode(chgCurXmlNode(wb.getCurFlowNode().getDataString(), listDone));
			}
		}
		if (CollectionUtil.isMapNotEmpty(flowVarMap)) {
			MemoryOperator.putValueToMap(workId, flowVarMap);
		}
	}


	/**
	 * 重新对已办表单权限进行设置
	 * @param xml
	 * @param listDone
	 * @return
	 */
	private IFlowNode chgCurXmlNode(String xml, List<DBDone> listDone) {
		IFlowNode curXmlNode = FlowDefinitionUtil.getNodeByStr(xml);

		INodeControl control = curXmlNode
				.getParticipantsControl(StaticVarExtend.AUTH_DONE);
		if (control == null) {
			return null;
		}
		// 删除当前节点定义的已办表单信息
		List<INodeForm> listOldForms = control.getAllNodeForms();
		for (int i = 0, n = listOldForms.size(); i < n; i++) {
			INodeForm tmpForm = listOldForms.get(i);
			control.delNodeForm(tmpForm.getFormid());
		}
		// 从数据库中获取已办表单信息
		boolean isHaveTrack = false;
		for (int i = 0, n = listDone.size(); i < n; i++) {
			DBDone done = listDone.get(i);
			if ("FlowTrack".equals(done.getFormid())) {
				isHaveTrack = true;
				continue;
			}
			INodeForm newForm = control.getNodeForm(done.getFormid());
			newForm.setFormButton(done.getFormbutton());
			newForm.setRealFormid(done.getFieldauthid());
		}
		// 避免多个节点都有流程跟踪时出现重复
		if (isHaveTrack) {
			INodeForm newForm = control.getNodeForm("FlowTrack");
			newForm.setFormButton("");
			newForm.setRealFormid("");
		}
		return curXmlNode;
	}

	/**
	 * 处理子流程数据，查看当前流程是否有子流程启动，如果有，将数据写回主流程
	 * 子流程数据回写到主流程后，主流程需要执行操作方可将数据保存到主流程的xml文件中
	 */
	@SuppressWarnings("unchecked")
	private void doWithSubflowRecord(RunningData runningData, Map<String, String> flowVarMap, String nodeid, IBaseRule subEndBean) {
		//1.如果打开时,subEndBean为null则说明不满足执行条件
		if(subEndBean == null){
			return;
		}

		//1.判断当前路径的状态是否为StaticVarExtend.FlowStatus_SubFlow
		DBTrack curTrack = runningData.getCurTrack();
//		if(curTrack.getFlowstatus() != StaticVarExtend.FlowStatus_SubFlow){
//			if(curTrack.getNodeid().indexOf("SubFlow") ==-1){
//				return;
//			}
//		}
		//如果当前路径状态为FlowStatus_SubFlow,则表示主流程等待子流程返回
		//2.判断当前路径下的子流程是否都已经结束

		List<DBSubflowRecord> srList = (List<DBSubflowRecord>)subEndBean.getResult("DBSubflowRecord");
//				DBSubflowRecord.getListByParentTrackidAndNodeid(curTrack.getId(), nodeid, identifier);
		if (CollectionUtil.isListNotEmpty(srList)) {
			//判断subflowend是否都为1
			boolean isAllEnd = (Boolean)subEndBean.getResult("checkSubflowIsAllEnd");
			if(!isAllEnd){
				return;
			}
			//恢复主流程状态,避免提交操作不显示
			curTrack.setFlowstatus(StaticVarExtend.FlowStatus_Normal);
			//处理流程变量返回
			for (int i = 0, n = srList.size(); i < n; i++) {
				DBSubflowRecord sr = srList.get(i);
				// 子流程要传入主流程的变量名称组成的list
				String subtoparentdata = sr.getSubtoparentdata();
				if (StringUtilExtend.isNotNull(subtoparentdata)) {
					// 子流程中流程变量的数据组成的map
					String subflowData = sr.getSubflowvardata();
					if (null != subflowData && !"".equals(subflowData)) {
						// 解码
						subtoparentdata = CStrUtil.decode(subtoparentdata);
						subflowData = CStrUtil.decode(subflowData);
						// 反序列化
						List<List<String>> paras = (List<List<String>>) SerializableUtil
								.stringToObject(subtoparentdata);
						Map<String, String> subflowVar = (HashMap<String, String>) SerializableUtil
								.stringToObject(subflowData);
						if (CollectionUtil.isListNotEmpty(paras)) {
							for (int j = 0, m = paras.size(); j < m; j++) {
								List<String> list = paras.get(j);
								// list.get(0) 主流程变量id list.get(1)子流程变量id
								flowVarMap.put(list.get(0),
										subflowVar.get(list.get(1)));
							}
						}
					}
				}
			}
		}
	}

	private boolean checkSubflowIsAllEnd(List<DBSubflowRecord> srList){
		for (int i = 0, n = srList.size(); i < n; i++) {
			DBSubflowRecord sr = srList.get(i);
			if("0".equals(sr.getSubflowend())){
				return false;
			}
		}
		return true;
	}

	/**
	 * 校验创建流程实例的参数是否合法
	 * 
	 * @param workParaBean
	 *            传入参数bean类
	 * @param wb
	 *            是否合法以及返回信息存放的bean
	 * @return
	 */
	private boolean checkCreatePara(WorkParaBean workParaBean, WorkResultBean wb) {
		if (!checkTenantidForWorkParaBean(workParaBean, wb)) {
			return false;
		}

		String userid = workParaBean.getUserId();
		if (StringUtilExtend.isNull(userid)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0003", "用户id为空,无法创建实例!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.Init_Failed);
			return false;
		}

		String flowid = workParaBean.getFlowId();
		if (StringUtilExtend.isNull(flowid)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0004", "流程id为空,无法创建实例!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.Init_Failed);
			return false;
		}

		return true;
	}

	/**
	 * 校验打开流程的参数是否合法
	 * 
	 * @param workParaBean
	 *            传入参数bean类
	 * @param wb
	 *            是否合法以及返回信息存放的bean
	 * @return
	 */
	private boolean checkOpenPara(WorkParaBean workParaBean, WorkResultBean wb) {
		if (!checkTenantidForWorkParaBean(workParaBean, wb)) {
			return false;
		}
		String userid = workParaBean.getUserId();
		if (StringUtilExtend.isNull(userid)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0005", "用户id为空,无法打开实例!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		String workid = workParaBean.getWorkId();
		if (StringUtilExtend.isNull(workid)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0006", "实例id为空,无法打开实例!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}

		return true;
	}

	private boolean checkOperatorPara(WorkParaBean workParaBean,
			WorkResultBean wb) {
		if (!checkTenantidForWorkParaBean(workParaBean, wb)) {
			return false;
		}

		String userid = workParaBean.getUserId();
		if (StringUtilExtend.isNull(userid)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0007", "用户id为空,无法对实例进行操作!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		String workid = workParaBean.getWorkId();
		if (StringUtilExtend.isNull(workid)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0008", "实例id为空,无法对实例进行操作!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		String actionClass = workParaBean.getActionClass();
		if (StringUtilExtend.isNull(actionClass)) {
			String backMsg = PubInfo.getPubInfo(workParaBean.getTenantCode())
					.getInfo("Operator_Msg0009", "操作类为空,无法对实例进行操作!");
			wb.setBackMsg(backMsg);
			wb.setResult(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}

		return true;
	}

	/**
	 * 自动已阅处理
	 */
	private void autoReaded(RunningData rd, IRunUser curUser) {
		List<DBWorkAuth> singleAuths = new ArrayList<DBWorkAuth>();
		List<DBTodo> todoLst = new ArrayList<DBTodo>();
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		ActionReaded.doReaded(rd, curUser, true, singleAuths, todoLst);

		//因为在子流程结束时发送的待阅,是直接在数据库种插入的一条数据,
		// 所以在执行自动已阅时不能传入json,因为json中是不包含这条数据的
		JSONObject json = null ;
		if (CollectionUtil.isListNotEmpty(singleAuths)) {
			json = rd.getResultJson();
			for (int i = 0, n = singleAuths.size(); i < n; i++) {
				DBWorkAuth auth = singleAuths.get(i);
				auth.getSQL(saveMap,json);
			}
		}

		if (CollectionUtil.isListNotEmpty(todoLst)) {
			for (int i = 0, n = todoLst.size(); i < n; i++) {
				DBTodo todo = todoLst.get(i);
				todo.getSQL(saveMap,json);
			}
		}

		AccessUtil.getInstance().executeMultiUpdate(saveMap,
				rd.getInitData().getFlowIdentifier());

	}

	/**
	 * 根据实例id获取历史记录
	 * 
	 * @return 当前实例所有历史记录组成的list
	 */

	final static String runningSQL = "SELECT "+ DBLog.FIELDS +" FROM " + StaticVarExtend.Table_Log
			+ " WHERE WORKID=? ORDER BY ACTIONTIME";
	public List<DBLog> getHistory(String workid, String identifier) {
		if (StringUtilExtend.isNull(workid)
				|| StringUtilExtend.isNull(identifier)) {
			return null;
		}

		List<String> listConditions = new ArrayList<String>();
		listConditions.add(workid);
		List<DBLog> lst = null;
		if(!MemCacheUtil.checkInstanceIsHaveEndFlagFromMem(workid)) {
			//如果内存中没有标记为已结束,则从运行库中获取
			lst =	AccessUtil.getInstance().getMultiObject(runningSQL, listConditions, DBLog.class,
					identifier);
		}
		if(lst == null || lst.isEmpty()){
			String suffix = MemCacheUtil.getSuffix(workid);
			lst = AccessUtil.getInstance().getMultiObject(runningSQL
					.replaceAll(StaticVarExtend.Table_Log,StaticVarExtend.Table_Log+suffix)
					, listConditions, DBLog.class,
					identifier);
		}
		return lst;
	}

	//修改流程全局时限
	public boolean chgFlowLimit(String workid,int type,int days,String tenantid,String identifier){
		FlowDefinitionUtil flowUtil = new FlowDefinitionUtil(StaticVarExtend.System_Id,StaticVarExtend.System_Id);
		IFlowInfo flowXml = flowUtil.getWork(workid,identifier);
		int[] limit= new int[2];
		limit[0]= type;
		limit[1] = days;
		flowXml.setLimitSet(limit);

		boolean result = flowUtil.saveWork(tenantid);

		return result;
	}
}
