package com.horizon.wf.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.api.bean.TodoPara;
import com.horizon.wf.config.AuthEnum;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;
import com.horizon.wf.tools.JSONUtil;
import com.horizon.wf.tools.StringUtil;

class WfmWorkList {
	/**
	 * 根据租户id获取数据源标识符
	 * 
	 * @param tenantid
	 * @return
	 */
	String getIdentifierByTenantid(String tenantid) {
		return ThirdAdapterFactory.getIdentifierFromTenantid(tenantid);
	}
	//=========================================================================	
	/*
delete from tw_hz_worklist;
delete from tw_hz_worklist_done;
delete from tw_hz_track_xml;
delete from tw_hz_track_xml_ver;
delete from tw_hz_track;
delete from tw_hz_track_ver;
delete from tw_hz_task;
delete from tw_hz_log;
delete from tw_hz_instance;
delete from tw_hz_instance_ver;
delete from tw_hz_instance_xml;
delete from tw_hz_instance_auth;
delete from tw_hz_instance_auth_ver;
delete from tw_hz_json_ver;
delete from tw_hz_json;

delete from tw_hz_worklist_end;
delete from tw_hz_track_xml_end;
delete from tw_hz_track_end;
delete from tw_hz_log_end;
delete from tw_hz_instance_end;
delete from tw_hz_instance_xml_end;
delete from tw_hz_instance_auth_end;
delete from tw_hz_json_end;
	======= worklist 库表字段 =====
		  SENDUSERID         VARCHAR2(32),发送人id
		  SENDUSERNAME       VARCHAR2(20),发送人name
		  SENDSUBJECTIONID   VARCHAR2(32),发送人归属id
		  SENDSUBJECTIONTYPE VARCHAR2(2),发送人归属类型(部门,群组,角色,岗位)
		  SENDSUBJECTIONNAME VARCHAR2(50),发送人归属名称
		  SENDTIME           VARCHAR2(20),发送时间
		  FLOWID             VARCHAR2(32),流程id
		  FLOWNAME           VARCHAR2(50),流程名称
		  WORKID             VARCHAR2(32),实例id
		  TITLE              VARCHAR2(100),标题
		  LIMITTIME          VARCHAR2(20),时限
		  PRIORITY           VARCHAR2(5),优先级
		  NODEID             VARCHAR2(10),节点id
		  TRACKID            VARCHAR2(32),路径id
		  TRACKSTATUS        VARCHAR2(5),路径状态
		  TRACKACTIVE        VARCHAR2(2),路径是否激活状态
		  WORKVER            VARCHAR2(2),版本
		  DOTIME             VARCHAR2(20),办理时间
		  STATUS             VARCHAR2(30),对应权限(Author,Done,Reader....)
		  ISCLAIM            VARCHAR2(2),是否需要认领状态,1需要认领
		  AUTH_ID            VARCHAR2(32),接收人id
		  SUBJECTION_ID      VARCHAR2(32),接收人归属id
		  SUBJECTION_TYPE    VARCHAR2(2),接收人归属类型(部门,群组,角色,岗位)
		  SUBJECTIONNAME     VARCHAR2(50),接收人归属名称
		  AGENT_ID           VARCHAR2(32),代办人id
		  ISAGENT            VARCHAR2(2),是否代办
		  ISACTIVE           VARCHAR2(2)是否激活
		  status_no			VARCHAR2(5) STATUS对应的编号
		  
	#所有权限,记录在worklist库表中status字段中的值
	auths=Author,SecondAuthor,StartSubFlow,HuiQian,StartHuiQian,Done,DoneHuiQian,DoneSecond,Reader,Readed,CReader,Creator
	#待办的最大编号+1
	TodoMax=200
	#待办的最小编号-1
	TodoMin=100
	#已办的最大编号+1
	DoMax=300
	#已办的最小编号-1
	DoMin=200

	#对应的编号,记录在worklist库表中status_no字段中的值
	#放入待办列表中的权限(101-199)
	Author=101
	SecondAuthor=102
	StartSubFlow=103
	HuiQian=104
	StartHuiQian=105
	#放入已办列表中的权限(201-299)
	Done=201
	DoneHuiQian=202
	DoneSecond=203

	#待阅
	Reader=301
	#已阅
	Readed=401
	#可阅
	CReader=501
	#创建者
	Creator=601
	待办查询条件:
	select * from TW_HZ_WorkList where (auth_id=? or agent_id=?) and isactive='1' and status_no < [TodoMax(200)]

	//已办查询条件
	select * from TW_HZ_WorkList where (auth_id=? or agent_id=?) and status_no > [DoMin(200)] and status_no < [DoMax(300)] 

	//需要认领的条件
	 select * from (select * from TW_HZ_WorkList 
				 			where isclaim='1' and isactive='1' and auth_id='-null-' and status_no < [TodoMax(200)]
							 and ((subjection_id in([alluserid]) and subjection_type<>'S') 
							or (subjection_id =? and subjection_type='S'))
						   ) a 

	//待阅查询条件
	 select * from (select t.* from TW_HZ_WorkList t
					  		where status='Reader' and isactive='1' and (auth_id=? 
					  		or (auth_id='-null-' and subjection_id in([alluserid]) and subjection_type<>'S') 
					  		or (auth_id='-null-' and subjection_id =? and subjection_type='S'))
					 		) a  
					where workid not in(select workid from "+StaticVarExtend.Table_Work_List 
					  						where status='Readed' and auth_id=?) 
	====
	select t2.* from tw_hz_worklist t2 where t2.status='Reader' and 
	(t2.auth_id='HZ28821856ef63420156ef6342a3002e' or 
	(t2.auth_id='-null-' 
	and ((subjection_id in('HZ28821856ef63420156ef6342a700e7','HZ28821856ef63420156ef6342a3002c') and subjection_type<>'S') 
	or (subjection_id ='' and subjection_type='S')) 
	and subjection_id not in 
	(select t3.subjection_id from tw_hz_worklist t3 where t3.auth_id='HZ28821856ef63420156ef6342a3002e' and t3.subjection_id != '-null-' 
	and t3.status='Readed')));				  						
	 	
	//已阅查询条件
	select * from TW_HZ_WorkList where auth_id=? and status='Readed'

	//可阅查询条件
	select * from TW_HZ_WorkList where (auth_id=? or (auth_id='-null-' and subjection_id in([alluserid]))) and status='CReader' 

	//发起的流程实例
	select * from TW_HZ_Instance where creator=?
	*/
	// ===========================================================================================
	private static String Todo_SQL = "SELECT * FROM "
			+ StaticVarExtend.Table_Work_List + " WHERE 1=1 ";
	private static String Done_SQL = "SELECT * FROM "
			+ StaticVarExtend.Table_Work_List_Done + " WHERE 1=1 ";
	private static String End_SQL = "SELECT * FROM "
			+ StaticVarExtend.Table_Work_List_End + " WHERE " ;
	// 待办查询条件
	private final static String todoWhere = " AND (AUTH_ID=? OR AGENT_ID=?) AND ISACTIVE='1' AND STATUS_NO < ? ";
	private final static String todoMax = AuthEnum.getStatusNo("TodoMax");
	// 已办查询条件
	private final static String hasTodoWhere = " AND (AUTH_ID=? OR AGENT_ID=?) AND STATUS_NO > ? AND STATUS_NO < ? ";
	private final static String doneMax = AuthEnum.getStatusNo("DoMax");
	private final static String doneMin = AuthEnum.getStatusNo("DoMin");
	// 已结束查询条件
	private final static String endWhere = " AND (AUTH_ID=? OR AGENT_ID=?)";

	// 排序
	private final static String OrderBySendTime = " ORDER BY SENDTIME DESC ";
	private final static String OrderByDoTime = " ORDER BY DOTIME DESC";

	private final static String EndWhere = " (AUTH_ID=? OR AGENT_ID=? OR (AUTH_ID='-null-' AND SUBJECTION_ID IN(@)))";

	// 已阅查询条件
	private final static String readedWhere = " AND AUTH_ID=? AND STATUS='Readed' ";
	// 可阅查询条件
	private final static String CReaderWhere = " AND (AUTH_ID=? OR (AUTH_ID='-null-' AND SUBJECTION_ID IN(@))) AND STATUS='CReader' ";
	// 待阅查询条件,需要用到HZSQL
	// private final static String readerSQL =
	// "select * from (select t.* from "+StaticVarExtend.Table_Work_List
	// + " t where status='Reader' and isactive='1' and (auth_id=? "
	// +
	// " or (auth_id='-null-' and subjection_id in(@) and subjection_type<>'S') "
	// + " or (auth_id='-null-' and subjection_id =? and subjection_type='S'))"
	// +
	// ") a  where workid not in(select workid from "+StaticVarExtend.Table_Work_List
	// + " where status='Readed' and auth_id=?)  ";
	private final static String readerSQL = "SELECT T2.* FROM "
			+ StaticVarExtend.Table_Work_List
			+ " T2 WHERE T2.STATUS='Reader' AND ISACTIVE='1' AND (AUTH_ID=? "
			+ " OR (T2.AUTH_ID='-null-' AND ((SUBJECTION_ID IN(@) AND SUBJECTION_TYPE<>'S') "
			+ " OR (SUBJECTION_ID =? AND SUBJECTION_TYPE='S')) "
			+ " AND SUBJECTION_ID NOT IN "
			+ " (SELECT T3.SUBJECTION_ID FROM donetable T3 WHERE T3.AUTH_ID=? "
			+ " AND T3.SUBJECTION_ID != '-null-' AND T3.STATUS='Readed' AND T3.WORKID=T2.WORKID)"
			+ "))";

	// 认领查询
	private final static String claimWhere = "SELECT A.* FROM (SELECT W.* FROM "
			+ StaticVarExtend.Table_Work_List
			+ " W WHERE W.ISCLAIM='1' AND W.ISACTIVE='1' AND W.AUTH_ID='-null-' AND W.STATUS_NO < ? "
			+ " AND W.TRACKID NOT IN (SELECT WS.TRACKID FROM "
			+StaticVarExtend.Table_Work_List
			+" WS WHERE WS.TRACKID=W.TRACKID AND STATUS='Author' AND AUTH_ID=?)"
			+ " AND ((W.SUBJECTION_ID IN(@) AND W.SUBJECTION_TYPE<>'S') OR (W.SUBJECTION_ID =? AND W.SUBJECTION_TYPE='S'))"
			+ ") A ";
	/**
	 * 发起的流程实例草稿
	 */
//	private final static String myDraftWhere = "SELECT * FROM (SELECT A.* FROM "
//			+ StaticVarExtend.Table_Work
//			+ " A,"
//			+ StaticVarExtend.Table_Track
//			+ " B  WHERE A.CREATOR=? AND A.VERSION='1' AND B.WORKID=A.ID AND B.FUNNAME='autofirst') B WHERE 1=1 ";
	/**
	 * 发起的流程实例
	 */
	private final static String myStartWhere = "SELECT ID,WORKID,TITLE,FLOWID,FLOWNAME,VERSION,CREATED,"
			+ "CREATOR,STARTTIME,PARENTWORKID,FLOWVER FROM "
			+ StaticVarExtend.Table_Work + " WHERE CREATOR=? ";

	private final static String allInstanceWhere = "SELECT ID,WORKID,TITLE,FLOWID,FLOWNAME,VERSION,CREATED,"
			+"CREATOR,STARTTIME,PARENTWORKID,FLOWVER FROM "
			+ StaticVarExtend.Table_Work +" WHERE 1=1 ";

	private final static String allEndInstanceWhere = "SELECT ID,WORKID,TITLE,FLOWID,FLOWNAME,VERSION,CREATED,"
			+"CREATOR,STARTTIME,PARENTWORKID,FLOWVER FROM "
			+ StaticVarExtend.Table_Work_End +" WHERE 1=1 ";
	/**
	 * alluserid的处理
	 * @param userid
	 * @param alluserid
	 * @return
	 */
	private String doAlluserid(String userid, String alluserid) {
		String lastid = alluserid;
		if (alluserid == null || "".equals(alluserid)) {
			lastid = userid;
		}
		return "'" + lastid.replace(",", "','") + "'";// alluserid
	}

	// ============传入bean对象参数==================================================================
	/**
	 * 获取指定人的待办
	 * 
	 * @return
	 */
	public List<DBTodo> getTodoList(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		para.add(todoPara.getUserid());
		para.add(todoMax);

		String where = _getWhere(para, todoWhere, todoPara);
		if (todoPara.getPageNum() > 0) {
			return _getTodoWherePageList(where, para,
					todoPara.getOderby(OrderBySendTime), todoPara.getPageNum(),
					todoPara.getPageSize(), todoPara.getIdentifier());
		} else {
			return _getTodoWhereList(where, para,
					todoPara.getOderby(OrderBySendTime),
					todoPara.getIdentifier());
		}
	}

	public int getTodoCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		para.add(todoPara.getUserid());
		para.add(todoMax);

		String where = _getWhere(para, todoWhere, todoPara);
		return _getTodoWhereCounts(where, para, todoPara.getIdentifier());
	}

	public List<DBTodo> getHasTodoList(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		para.add(todoPara.getUserid());
		para.add(doneMin);
		para.add(doneMax);

		String where = _getWhere(para, hasTodoWhere, todoPara);
		if (todoPara.getPageNum() > 0) {
			return _getDoneWherePageList(where, para,
					todoPara.getOderby(OrderByDoTime), todoPara.getPageNum(),
					todoPara.getPageSize(), todoPara.getIdentifier());
		} else {
			return _getDoneWhereList(where, para,
					todoPara.getOderby(OrderByDoTime), todoPara.getIdentifier());
		}

	}

	public int getHasTodoCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		para.add(todoPara.getUserid());
		para.add(doneMin);
		para.add(doneMax);

		String where = _getWhere(para, hasTodoWhere, todoPara);
		return _getDoneWhereCounts(where, para, todoPara.getIdentifier());
	}

	public List<DBTodo> getHaveReadList(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());

		String where = _getWhere(para, readedWhere, todoPara);
		if (todoPara.getPageNum() > 0) {
			return _getDoneWherePageList(where, para,
					todoPara.getOderby(OrderBySendTime), todoPara.getPageNum(),
					todoPara.getPageSize(), todoPara.getIdentifier());
		} else {
			return _getDoneWhereList(where, para,
					todoPara.getOderby(OrderBySendTime),
					todoPara.getIdentifier());
		}
	}

	public int getHaveReadCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());

		String where = _getWhere(para, readedWhere, todoPara);
		return _getDoneWhereCounts(where, para, todoPara.getIdentifier());
	}

	public List<DBTodo> getCReaderList(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		String where = _getWhere(para, CReaderWhere, todoPara).replaceAll("@",
				doAlluserid(todoPara.getUserid(), todoPara.getAlluserid()));

		if (todoPara.getPageNum() > 0) {
			return _getDoneWherePageList(where, para,
					todoPara.getOderby(OrderBySendTime), todoPara.getPageNum(),
					todoPara.getPageSize(), todoPara.getIdentifier());
		} else {
			return _getDoneWhereList(where, para,
					todoPara.getOderby(OrderBySendTime),
					todoPara.getIdentifier());
		}
	}

	public int getCReaderCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		String where = _getWhere(para, CReaderWhere, todoPara).replaceAll("@",
				doAlluserid(todoPara.getUserid(), todoPara.getAlluserid()));

		return _getDoneWhereCounts(where, para, todoPara.getIdentifier());
	}

	public List<DBTodo> getAllEndList(TodoPara todoPara){
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		para.add(todoPara.getUserid());

		String where = _getWhere(para, EndWhere, todoPara).replaceAll("@",
				doAlluserid(todoPara.getUserid(), todoPara.getAlluserid()));
		if (todoPara.getPageNum() > 0) {
			return _getEndWherePageList(where, para,
					todoPara.getOderby(OrderByDoTime), todoPara.getPageNum(),
					todoPara.getPageSize(), todoPara.getIdentifier());
		} else {
			return _getEndWhereList(where, para,
					todoPara.getOderby(OrderByDoTime), todoPara.getIdentifier());
		}
	}
	public int getAllEndCount(TodoPara todoPara){
		List<String> para = new ArrayList<String>();
		para.add(todoPara.getUserid());
		para.add(todoPara.getUserid());

		String where = _getWhere(para, EndWhere, todoPara).replaceAll("@",
				doAlluserid(todoPara.getUserid(), todoPara.getAlluserid()));
		return _getEndWhereCounts(where, para, todoPara.getIdentifier());
	}

	public List<DBWork> getAllRunningInstanceList(TodoPara todoPara){
		List<DBWork> list = getListForDBWork(allInstanceWhere,todoPara);
		return list;
	}

	public int getAllRunningInstanceCount(TodoPara todoPara){
		List<String> para = new ArrayList<String>();
		String where = getSQLForDBWork(allInstanceWhere,todoPara,para);
		int count = AccessUtil.getInstance().getRsCount(where, para,
				todoPara.getIdentifier());
		return count;
	}

	public List<DBWork> getAllEndInstanceList(TodoPara todoPara){
		List<DBWork> list = getListForDBWork(allEndInstanceWhere,todoPara);
		return list;
	}
	public int getAllEndInstanceCount(TodoPara todoPara){
		List<String> para = new ArrayList<String>();
		String where = getSQLForDBWork(allEndInstanceWhere,todoPara,para);
		int count = AccessUtil.getInstance().getRsCount(where, para,
				todoPara.getIdentifier());
		return count;
	}

	public List<DBWork> getMyStartList(TodoPara todoPara) {
		List<DBWork> list = getListForDBWork(myStartWhere,todoPara);
		return list;
	}
	public int getMyStartCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();
		String where = getSQLForDBWork(myStartWhere,todoPara,para);
		int count = AccessUtil.getInstance().getRsCount(where, para,
				todoPara.getIdentifier());
		return count;
	}

	private List<DBWork> getListForDBWork(String sql,TodoPara todoPara){
		List<String> para = new ArrayList<String>();
		String where = getSQLForDBWork(sql,todoPara,para);

		List<DBWork> list;
		if (todoPara.getPageNum() > 0) {
			list = AccessUtil.getInstance().getPagingObject(
					where + todoPara.getOderby(" ORDER BY CREATED DESC"), para,
					todoPara.getPageNum(), todoPara.getPageSize(),
					DBWork.class, todoPara.getIdentifier());
		} else {
			list = AccessUtil.getInstance().getMultiObject(
					where + todoPara.getOderby(" ORDER BY CREATED DESC"), para,
					DBWork.class, todoPara.getIdentifier());
		}
		return list;
	}

	private String getSQLForDBWork(String sql,TodoPara todoPara,List<String> para){
		if(CStrUtil.isNotNull(todoPara.getUserid())) {
			para.add(todoPara.getUserid());
		}
		String tmpWhere = sql;
		if (!(todoPara.getFlowid() == null || "".equals(todoPara.getFlowid()))) {
			tmpWhere = sql + " AND FLOWID=? ";
			para.add(todoPara.getFlowid());
		}
		String where = _getWhere(para, tmpWhere, todoPara);
		return where;
	}

	public List<DBTodo> getClaimList(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();

		String sql = _getClaimSQL(para, todoPara);

		List<DBTodo> list;
		if (todoPara.getPageNum() > 0) {

			List<Map<String,Object>> result = AccessUtil.getInstance().getPagingMap(sql, para,
					todoPara.getPageNum(), todoPara.getPageSize(),
					todoPara.getIdentifier());
			list=dealResult(result);//处理拓展字段，转换对象
		} else {
			List<Map<String,Object>> result = AccessUtil.getInstance().getMultiMap(sql,
					para == null || para.isEmpty() ? null : para, todoPara.getIdentifier());
			list=dealResult(result);//处理拓展字段，转换对象
		}

		return list;
	}

	public int getClaimCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();

		String sql = _getClaimSQL(para, todoPara);

		int count = AccessUtil.getInstance().getRsCount(sql, para,
				todoPara.getIdentifier());
		return count;
	}

	public List<DBTodo> getToBeReadList(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();

		String sql = _getReaderSQL(para, todoPara);

		List<DBTodo> list=Lists.newArrayList();
		if (todoPara.getPageNum() > 0) {
			List<Map<String,Object>> result = AccessUtil.getInstance().getPagingMap(sql, para,
					todoPara.getPageNum(), todoPara.getPageSize(),
					todoPara.getIdentifier());
			list=dealResult(result);//处理拓展字段，转换对象

		} else {

			List<Map<String,Object>> result = AccessUtil.getInstance().getMultiMap(sql,
					para == null || para.isEmpty() ? null : para, todoPara.getIdentifier());
			list=dealResult(result);//处理拓展字段，转换对象
		}

		return list;
	}

	public int getToBeReadCount(TodoPara todoPara) {
		List<String> para = new ArrayList<String>();

		String sql = _getReaderSQL(para, todoPara);

		int count = AccessUtil.getInstance().getRsCount(sql, para,
				todoPara.getIdentifier());
		return count;
	}

	private String _getReaderSQL(List<String> para, TodoPara todoPara) {
		String deptid = PluginsUtil.getMultiInstance().getOrganization(todoPara.getTenantid())
				.getDeptIdByUserid(todoPara.getUserid(),
						todoPara.getIdentifier());
		para.add(todoPara.getUserid());
		para.add(deptid);
		para.add(todoPara.getUserid());

		String sql = readerSQL;
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = sql.replaceAll("donetable",
					StaticVarExtend.Table_Work_List_Done);
		} else {
			sql = sql.replaceAll("donetable", StaticVarExtend.Table_Work_List);
		}
		if (!(todoPara.getWhere() == null || "".equals(todoPara.getWhere())
				|| todoPara.getPara() == null || todoPara.getPara().isEmpty())) {

			sql = "SELECT * FROM(" + sql + ") T WHERE 1=1 "
					+ todoPara.getWhere();
			para.addAll(todoPara.getPara());
		}
		sql = sql + todoPara.getOderby(OrderBySendTime);
		return sql.replaceAll("@",
				doAlluserid(todoPara.getUserid(), todoPara.getAlluserid()));
	}

	private String _getClaimSQL(List<String> para, TodoPara todoPara) {
		String deptid = PluginsUtil.getMultiInstance().getOrganization(todoPara.getTenantid())
				.getDeptIdByUserid(todoPara.getUserid(),
						todoPara.getIdentifier());
		para.add(todoMax);
		para.add(todoPara.getUserid());
		para.add(deptid);
		String sql = claimWhere;
		if (!(todoPara.getWhere() == null || "".equals(todoPara.getWhere())
				|| todoPara.getPara() == null || todoPara.getPara().isEmpty())) {

			sql = sql + " WHERE 1=1 " + todoPara.getWhere();
			para.addAll(todoPara.getPara());
		}
		sql = sql + todoPara.getOderby(OrderBySendTime);
		return sql.replaceAll("@",
				doAlluserid(todoPara.getUserid(), todoPara.getAlluserid()));
	}

	private String _getWhere(List<String> para, String where, TodoPara todoPara) {
		if (todoPara.getWhere() == null || "".equals(todoPara.getWhere())) {
			return where;
		}
		if (!(todoPara.getPara() == null || todoPara.getPara().isEmpty())) {
			where = where + todoPara.getWhere();
			para.addAll(todoPara.getPara());
		}

		return where;
	}

	private List<DBTodo> _getTodoWhereList(String where,
			List<? extends Object> para, String orderby, String identifier) {
		String sql = Todo_SQL + where + orderby;
		List<Map<String,Object>> list = AccessUtil.getInstance().getMultiMap(sql,
				para == null || para.isEmpty() ? null : para, identifier);
		List<DBTodo> result=dealResult(list);//处理拓展字段，转换对象
		return result;
	}

	private List<DBTodo> _getTodoWherePageList(String where,
			List<? extends Object> para, String orderby, int pageNum,
			int pageSize, String identifier) {
		String sql = Todo_SQL + where + orderby;
		List<Map<String,Object>> list = AccessUtil.getInstance().getPagingMap(sql,
				para == null || para.isEmpty() ? null : para, pageNum,
				pageSize,identifier);
		List<DBTodo> result=dealResult(list);//处理拓展字段，转换对象
		return result;
	}

	private int _getTodoWhereCounts(String where, List<? extends Object> para,
			String identifier) {
		String sql = Todo_SQL + where;
		int count = AccessUtil.getInstance().getRsCount(sql,
				para == null || para.isEmpty() ? null : para, identifier);
		return count;
	}

	private List<DBTodo> _getDoneWhereList(String where,
			List<? extends Object> para, String orderby, String identifier) {
		String sql = "";
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = Done_SQL + where + orderby;
		}
		else{
			sql = Todo_SQL + where + orderby;
		}
		List<Map<String,Object>> list = AccessUtil.getInstance().getMultiMap(sql,
				para == null || para.isEmpty() ? null : para,identifier);
		List<DBTodo> result=dealResult(list);//处理拓展字段，转换对象
		return result;
	}

	private List<DBTodo> _getDoneWherePageList(String where,
			List<? extends Object> para, String orderby, int pageNum,
			int pageSize, String identifier) {
		String sql = "";
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = Done_SQL + where + orderby;
		}
		else{
			sql = Todo_SQL + where + orderby;
		}
		List<Map<String,Object>> list = AccessUtil.getInstance().getPagingMap(sql,
				para == null || para.isEmpty() ? null : para, pageNum,
				pageSize,identifier);
		List<DBTodo> result=dealResult(list);//处理拓展字段，转换对象
		return result;
	}

	private int _getDoneWhereCounts(String where, List<? extends Object> para,
			String identifier) {
		String sql = "";
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = Done_SQL + where ;
		}
		else{
			sql = Todo_SQL + where ;
		}
		int count = AccessUtil.getInstance().getRsCount(sql,
				para == null || para.isEmpty() ? null : para, identifier);
		return count;
	}



	private List<DBTodo> _getEndWhereList(String where,
										   List<? extends Object> para, String orderby, String identifier) {
		String sql = End_SQL + where + orderby;
		List<DBTodo> list = AccessUtil.getInstance().getMultiObject(sql,
				para == null || para.isEmpty() ? null : para, DBTodo.class,
				identifier);
		return list;
	}
	private List<DBTodo> _getEndWherePageList(String where,
											   List<? extends Object> para, String orderby, int pageNum,
											   int pageSize, String identifier) {
		String sql =  End_SQL + where + orderby;
		List<DBTodo> list = AccessUtil.getInstance().getPagingObject(sql,
				para == null || para.isEmpty() ? null : para, pageNum,
				pageSize, DBTodo.class, identifier);
		return list;
	}
	private int _getEndWhereCounts(String where,
								   List<? extends Object> para,  String identifier) {
		String sql = End_SQL + where ;
		int count = AccessUtil.getInstance().getRsCount(sql,
				para == null || para.isEmpty() ? null : para, identifier);
		return count;
	}
//-------------------------------------------------------------	
	/**
	 * 根据指定where条件获取待办列表
	 * 
	 * @param where
	 *            (DBTodo对象中的字段)
	 * @param para
	 * @return
	 */

	public List<DBTodo> getWhereList(String where, List<? extends Object> para,
			String tenantid) {
		String identifier = getIdentifierByTenantid(tenantid);
		return getWhereList(where, para, tenantid, identifier);
	}

	public List<DBTodo> getWhereList(String where, List<? extends Object> para,
			String tenantid, String identifier) {
		List<DBTodo> list = getWhereList(where,
				para == null || para.isEmpty() ? null : para, OrderBySendTime,
				tenantid, identifier);
		return list;
	}

	public List<DBTodo> getWhereList(String where, List<? extends Object> para,
			String orderBy, String tenantid, String identifier) {
		String sql = Todo_SQL + where + orderBy;
		
		List<DBTodo> list = AccessUtil.getInstance().getMultiObject(sql,
				para == null || para.isEmpty() ? null : para, DBTodo.class,
				identifier);
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = Done_SQL + where + orderBy;
			List<DBTodo> donelist = AccessUtil.getInstance().getMultiObject(sql,
					para == null || para.isEmpty() ? null : para, DBTodo.class,
					identifier);
			list.addAll(donelist);
		}
		
		return list;
	}

	/**
	 * 根据指定where条件获取待办列表
	 * 
	 * @param where
	 * @param para
	 * @param pageNum
	 *            页数
	 * @param pageSize
	 *            每页数目
	 * @return
	 */
	public List<DBTodo> getWherePageList(String where,
			List<? extends Object> para, int pageNum, int pageSize,
			String tenantid) {
		String identifier = getIdentifierByTenantid(tenantid);
		return getWherePageList(where, para, pageNum, pageSize, tenantid,
				identifier);
	}

	public List<DBTodo> getWherePageList(String where,
			List<? extends Object> para, int pageNum, int pageSize,
			String tenantid, String identifier) {
		List<DBTodo> list = getWherePageList(where, para, OrderBySendTime,
				pageNum, pageSize, tenantid, identifier);
		return list;
	}

	private List<DBTodo> getWherePageList(String where,
			List<? extends Object> para, String orderBy, int pageNum,
			int pageSize, String tenantid, String identifier) {
		String sql = Todo_SQL + where + orderBy;
		List<DBTodo> list = AccessUtil.getInstance().getPagingObject(sql,
				para == null || para.isEmpty() ? null : para, pageNum,
				pageSize, DBTodo.class, identifier);
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = Done_SQL + where + orderBy;
			List<DBTodo> donelist =AccessUtil.getInstance().getPagingObject(sql,
					para == null || para.isEmpty() ? null : para, pageNum,
							pageSize, DBTodo.class, identifier);
			list.addAll(donelist);
		}
		return list;
	}

	/**
	 * 获取指定条件的待办数量
	 * 
	 * @param where
	 * @param para
	 * @return
	 */
	public int getWhereCounts(String where, List<? extends Object> para,
			String tenantid) {
		String identifier = getIdentifierByTenantid(tenantid);
		return getWhereCounts(where, para, tenantid, identifier);
	}

	public int getWhereCounts(String where, List<? extends Object> para,
			String tenantid, String identifier) {
		String sql = Todo_SQL + where;
		int count = AccessUtil.getInstance().getRsCount(sql,
				para == null || para.isEmpty() ? null : para, identifier);
		if (HZResourceBundle.getInstance().isSplitTodo()) {
			sql = Done_SQL + where;
			int donecount = AccessUtil.getInstance().getRsCount(sql,
					para == null || para.isEmpty() ? null : para, identifier);
			count += donecount;
		}
		
		return count;
	}

	/**
	 * 处理待办列表接口拓展字段
	 * @param todoList
	 * @return
	 */
	private List<DBTodo> dealResult(List<Map<String,Object>> todoList ){

		if(null==todoList || todoList.isEmpty())return null;
		List<DBTodo> result= Lists.newArrayList();
		for (Map<String,Object> todo:todoList) {
			DBTodo dbTodo=JSONUtil.fromJson(JSONUtil.toJson(todo),DBTodo.class);
			LinkedHashMap<String,String> otherField=dbTodo.getOtherField();
			if(null!=otherField && !otherField.isEmpty()){
				for (String key : otherField.keySet()) {
					otherField.put(key,todo.get(key.toLowerCase()).toString());
				}
			}
			result.add(dbTodo);
		}
		return result;
	}
}
