package com.horizon.wf.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.third.Persistence;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.entity.db.DBHandover;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.pool.XMLTodoPub;
import com.horizon.wf.tools.DateUtil;

public class AgentUtil {
	private AgentUtil(){}
	private volatile  static AgentUtil singleClass = null;
	public static AgentUtil getInstance(){
		if(singleClass==null){
			synchronized (AgentUtil.class) {
				if(singleClass==null){
					singleClass = new AgentUtil();
				}
			}
		}
		return singleClass;
	}
	
	private Persistence persistenceImpl = ThirdAdapterFactory.getPersistenceInstance();
	private final String Table_Agent = "TW_HZ_AGENT";
	private final String Table_AgentLog = "TW_HZ_AGENT_LOG";

	/**
	 * 代办设置，取消代办设置
	 * @param hashMap：代办信息
	 * @param tenantid：租户标识
	 * @param identifier：数据库标识
	 * @return
	 */
	public boolean agentUserSet(Map<String, String> hashMap,
			String tenantid, String identifier) {
		String userid = hashMap.get("userid");// 被代理人id
		String username = hashMap.get("username");// 被代理人名称
		String userdeptname = hashMap.get("userdeptname");// 被代理人部门
		String agentName = hashMap.get("agentName");// 代办人名称
		String agentID = hashMap.get("agentID");// 代办人id
		String noticetype = hashMap.get("noticetype");// 发送消息类型
		String[] ids = hashMap.get("ids").split(";");// 设置代办时格式：流程id~流程name|流程id~流程name|流程id~流程name；取消代办时格式：流程id~agent表id|流程id~agent表id
		String actionName = hashMap.get("actionName");// 1：设置代办
		String movetodo = hashMap.get("movetodo");// 1:转移代办
		String begindate = hashMap.get("begindate");// 开始时间
		String enddate = hashMap.get("enddate");// 结束时间

		String sql1 = "UPDATE "+ Table_Agent +" SET STATUS=? WHERE FLOWID=? AND USERID=?";
		String sql2 = "INSERT INTO "+ Table_Agent +"(ID,USERID,USERNAME,AGENTUSERID,AGENTUSERNAME,FLOWID,FLOWNAME,STATUS,BEGINDATE,ENDDATE) VALUES(?,?,?,?,?,?,?,?,?,?)";
		String sql3 = "UPDATE "+ Table_Agent +" SET STATUS='0' WHERE ID=?";

		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		int n = ids.length;
		List<String> idlst = new ArrayList<String>(n);
		Map<String, String> objectIdMap = new LinkedHashMap<String, String>();
		// 设置代办
		if ("1".equals(actionName)) {
			if ( agentID != null && agentID.trim().length() > 0) {
				List<Object> lst1 = new ArrayList<Object>(n);
				List<Object> lst2 = new ArrayList<Object>(n);
				for (int i = 0; i < n; ++i) {
					String[] tmpID = ids[i].split("~");
					List<Object> tmplst1 = new ArrayList<Object>();
					tmplst1.add("0");//失效
					tmplst1.add(tmpID[0]);
					tmplst1.add(userid);
					lst1.add(tmplst1);
					
					String id = StaticFunExtend.getUnid();
					List<Object> tmplst2 = new ArrayList<Object>();
					tmplst2.add(id);
					tmplst2.add(userid);
					tmplst2.add(username);
					tmplst2.add(agentID);
					tmplst2.add(agentName);
					tmplst2.add(tmpID[0]);
					tmplst2.add(tmpID[1]);
					tmplst2.add("1");//有效
					tmplst2.add(begindate);
					tmplst2.add(enddate);
					lst2.add(tmplst2);
					
					idlst.add(tmpID[0]);// 记录flowid列表用于后面转移待办
					objectIdMap.put(tmpID[0], id);//记录代办记录id用于后面转移待办时记录代办日志
				}
				saveMap.put(sql1, lst1);//把之前存在的代办设置状态置为失效
				saveMap.put(sql2, lst2);//新增一条代办设置
				
				// 转移已有待办,添加工作移交记录
				if ("1".equals(movetodo)) {
					PubInfo pubInfo = PubInfo.getPubInfo(tenantid);
					Map<String,String> para = new HashMap<String,String>();
					para.put("identifier", identifier);
					para.put("actionname",pubInfo.getInfo("Agent_Msg0001", "代办移交") );
					para.put("actionUserid", userid);
					para.put("actionUsername", username);
					para.put("agentId", agentID);
					para.put("agentName", agentName);
					para.put("memo", pubInfo.getInfo("Agent_Msg0002","移交给[|name|]")
											.replace("|name|", agentName));
					para.put("tenantid", tenantid);
					
					movetodoForAgent(saveMap, idlst, para, objectIdMap);
				}
			}
		} else {//取消代办
			List<Object> lst = new ArrayList<Object>(n);
			for (int i = 0; i < n; ++i) {
				String[] tmpID = ids[i].split("~");
				if(tmpID!=null && tmpID.length>1){
					List<Object> tmplst = new ArrayList<Object>();
					tmplst.add(tmpID[1]);				
					lst.add(tmplst);
					
					idlst.add(tmpID[0]);// 记录flowid
				}		
			}
			saveMap.put(sql3, lst);//取消代办设置，把之前存在的代办设置状态置为失效
		}

		String backMsg = sendNoticeForAgent(userid, username, userdeptname,
				actionName, noticetype, ids, agentID, tenantid,identifier);
		StaticFunExtend.println(backMsg);
		return persistenceImpl.executeMultiUpdate(saveMap, identifier);
	}

	/**
	 * 设置代理人时,转移已有待办
	 * @param saveMap
	 * @param idlst=流程id
	 *  userid=被代理人id
	 *  agentId=代办人id
	 *  tenantid=租户标识
	 * identifier=数据源标识
	 */
	private void movetodoForAgent(Map<String, List<Object>> saveMap,
			List<String> idlst, Map<String,String> para,
			Map<String,String> objectIdMap) {
		StringBuilder sql = new StringBuilder(1000);
		String userid = para.get("actionUserid");
		String identifier  = para.get("identifier");
		String agentId = para.get("agentId");
		String username = para.get("actionUsername");
		String agentName = para.get("agentName");
		
		int n = idlst.size();
		sql.append("");
		for (int i = 0; i < n; i++) {
			sql.append(",?");
		}
		sql.deleteCharAt(0);
		if (n == 1) {
			sql.insert(0, "=(");
		} else {
			sql.insert(0, " in (");
		}
		sql.append(")");
		sql.insert(0, "SELECT * FROM " + StaticVarExtend.Table_Work_List
				+ " WHERE AUTH_ID='" + userid
				+ "' AND STATUS LIKE '%Author%' AND FLOWID  ");
		List<DBTodo> resultlst = persistenceImpl.getMultiObject(sql.toString(), idlst,
				DBTodo.class, identifier);
		
		if (resultlst != null && !resultlst.isEmpty()) {
		    AuthUserImpl newAuth = AuthUserImpl.getAuthUserByStr(agentId);
		    
			for (DBTodo todo : resultlst) {
				DBHandover xHandover = new DBHandover();
				xHandover.setId(StaticFunExtend.getUnid());
				xHandover.setWorkid(todo.getWorkid());
				xHandover.setTrackid(todo.getTrackid());
				//HZWF-797 如果已经有代理人了,olduser字段会超长,20151224 liys 修改为去掉原来的代理人
				xHandover.setOlduser(todo.getAuthId());
				xHandover.setOldsubjection(todo.getSubjectionId());
				xHandover.setOldsubjectiontype(todo.getSubjectionType());
				
				
				xHandover.setNewuser(newAuth.getAuthId());
				xHandover.setNewuserid(agentId);
				xHandover.setNewname(agentName);
				xHandover.setOldname(username);
				xHandover.setPreservepermissions("2");
				xHandover.setStatus("0");
				xHandover.getSQL(saveMap);
				
				
				para.put("workid", todo.getWorkid());
				para.put("trackid", todo.getTrackid());
				DBLog trackLog = StaticFunExtend.getActionCommon().makeDbLogForMgr(para);
				trackLog.getSQL(saveMap);
				
				//记录代办日志,第二个参数ObjectId统一存储agentId
				insertAgentLog(saveMap, agentId, todo.getWorkid(), todo.getFlowid());
			}
		}
	}
	
	/**
	 * 保存TW_HZ_AGENT_LOG
	 * @param saveMap
	 * @param objectid
	 * @param workid
	 * @param flowid
	 */
	private void insertAgentLog(Map<String, List<Object>> saveMap, String objectid, String workid, String flowid){
		String logSql = "INSERT INTO "+ Table_AgentLog +"(ID,SAVETIME,OBJECTID,WORKID,FLOWID) VALUES(?,?,?,?,?)";
		
		List<String> tmp = new ArrayList<String>(5);
		tmp.add(persistenceImpl.getUUID());
		tmp.add(DateUtilExtend.getNow());
		tmp.add(objectid);
		tmp.add(workid);
		tmp.add(flowid);
		
		if(null==saveMap.get(logSql)){
			List<Object> lstcondition = new ArrayList<Object>();
			lstcondition.add(tmp);
			saveMap.put(logSql, lstcondition);
		}else{
			List<Object> lstcondition = (List<Object>)saveMap.get(logSql);
			lstcondition.add(tmp);
			saveMap.put(logSql, lstcondition);
		}
	}
	
	/**
	 * 发送消息
	 * @param userid
	 * @param username
	 * @param userdeptname
	 * @param actionName
	 * @param noticetype
	 * @param ids=流程id~流程name
	 * @param identifier
	 * @return
	 */
	private String sendNoticeForAgent(String userid, String username,
			String userdeptname, String actionName, String noticetype,
			String[] ids, String agentuserid,String tenantid, String identifier) {
		if (null == ids || ids.length == 0) {
			return "";
		}
		if (null == noticetype || noticetype.length() == 0) {
			return "";
		}
		PubInfo pubInfo = PubInfo.getPubInfo(tenantid);
		Map<String, Object> todoHM = new LinkedHashMap<String, Object>();
		todoHM.put("SENDTIME", DateUtilExtend.getNow());
		todoHM.put("SENDUSERID", userid);
		todoHM.put("SENDUSERNAME", username);
		todoHM.put("SENDUSERDEPTNAME", userdeptname);
		todoHM.put("IMPORTANCE", "");
		todoHM.put("URL", "");
		todoHM.put("TIMELIMIT", "0");
		todoHM.put("LIMITTYPE", StaticVarExtend.Day_Normal);
		todoHM.put("MODELID", "");
		todoHM.put("MODELNAME", pubInfo.getInfo("Agent_Msg0003", "代办设置"));
		todoHM.put("DATAID", "");
		// 增加数据源参数
		todoHM.put("IDENTIFIER", identifier);
		
		String rs = "";
		if (!(ids == null || ids.length == 0)) {
			for (int i = 0; i < ids.length; i++) {
				String flowid = ids[i].split("~")[0];
				String flowname = ids[i].split("~")[1];
				
				todoHM.put("TITLE", username
						+ "("
						+ userdeptname
						+ ")"
						+ ("1".equals(actionName) ? pubInfo.getInfo("Agent_Msg0004","设置以下流程由您代为办理")
								: pubInfo.getInfo("Agent_Msg0005","取消以下流程的代理权")) 
							+ ":" + flowname+"【"+flowid+"】");
				todoHM.put("USERID", agentuserid);

				String[] types = noticetype.split("\\|");
				for (String t : types) {
					XMLTodoPub.sendMsg(t, todoHM,tenantid);
				}
			}
		}
		return rs;
	}
	
	/**
	 * 获取给定userid的代办人
	 * @param userid
	 * @param workid
	 * @param flowid
	 * @param identifier
	 * @return
	 */
	public String getAgentUser(String userid, String workid, String flowid,String identifier) {
		if (userid.length() == 0){
			return "";
		}
		List<String> para = new ArrayList<String>();
		StringBuilder sql = new StringBuilder(1000);
		//20171016 liys 改成带时分秒的日期,可以兼容数据设置中带和不带时分秒的数据,不带时默认为00:00:00
		String nowDate = //DateUtil.getYearMonthDay();
						 DateUtil.getNow();
		List<AuthUserImpl> userLst = AuthUserImpl.getAuthUserList(userid);
		para.add(flowid);
		int usernum =0;
		for(int i=0,n=userLst.size();i<n;i++){
			AuthUserImpl user =userLst.get(i);
			String authid = user.getAuthId();
			//如果已经获取了代理人，则不再获取
			if(authid.equals(StaticVarExtend.NullStr) || !user.getAgentId().equals(StaticVarExtend.NullStr)){
				continue;
			}
			sql.append(",?");
			para.add(authid);
			usernum ++;
		}
		if(sql.length()==0){
			return userid;
		}
		
		sql.deleteCharAt(0);
		if(usernum > 1){
			sql.insert(0, "in(").append(")");
		}
		else{
			sql.insert(0, "=");
		}
		String paraSql = sql.toString();
		sql.delete(0, sql.length());
		sql.append("SELECT UserID,AgentUserID,id FROM "+ Table_Agent +" where Status='1' and begindate <= '").append(nowDate).append("' ")
		   .append("and '").append(nowDate).append("' <= enddate  and flowID=? and  userid ")
		   .append(paraSql);
		
		List<List<Object>> result = persistenceImpl.getMultiList(sql.toString(), para, identifier);
		Map<String, String> resultMap = new LinkedHashMap<String, String>();
		if (!(null == result || result.isEmpty())) {
			for (List<Object> tmpLst : result) {
				resultMap.put(String.valueOf(tmpLst.get(0)),String.valueOf(tmpLst.get(1)));
			}
		}
		//代办设置获取为空,则直接返回userid
		if(resultMap.isEmpty()){
			return userid;
		}
		
		String logSql = "INSERT INTO "+ Table_AgentLog +"(ID,SAVETIME,OBJECTID,WORKID,FLOWID) VALUES(?,?,?,?,?)";
		Map<String, List<List<String>>> saveMap = new LinkedHashMap<String, List<List<String>>>();
		List<List<String>> paraList = new ArrayList<List<String>>();
		
		sql.delete(0, sql.length());
		for(int i=0,n=userLst.size();i<n;i++){
			AuthUserImpl user =userLst.get(i);
			String agentid = resultMap.get(user.getAuthId());
			if(!(agentid ==null || "".equals(agentid))){
				user.setAgentId(agentid);
				
				List<String> tmp = new ArrayList<String>(5);
				tmp.add(persistenceImpl.getUUID());
				tmp.add(DateUtilExtend.getNow());
				tmp.add(agentid);
				tmp.add(workid);
				tmp.add(flowid);
				paraList.add(tmp);
			}
			sql.append(StaticVar.UserSplitChar).append(user._getFullNameWithAgent());
		}
		sql.deleteCharAt(0);
		
		if(!paraList.isEmpty()){
			saveMap.put(logSql, paraList);
			persistenceImpl.executeMultiUpdate(saveMap, identifier);
		}
		
		return sql.toString();
	}
	
}
