package com.horizon.wf.action.manage;

import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ISpecialAction;
import com.horizon.wf.core.work.data.InitData;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;

import java.util.*;
/**
 * 接收移交工作
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionHandoverWork implements ISpecialAction{
	private RunningData runningdata ; 
	private String identifier="";
	private int newVersion;
	private PubInfo pubInfo;
//	private IDBAccess db = ResponsibleImplFactory.getDBAccess();//数据库操作类

	public void setRunningData(RunningData runningdata) {
		this.runningdata = runningdata;
	}
	public boolean doAction() {	
		pubInfo = PubInfo.getPubInfo(runningdata.getLangInfo());
		InitData initData = runningdata.getInitData();
		DBWork xWork =  runningdata.getWork();
		String workid = xWork.getId();
		newVersion = (xWork.getVersion()+1);
		identifier = initData.getFlowIdentifier();
		DBHandover handover = (DBHandover)initData.getVariable("handover");
		List<DBWorkAuth> auths = new ArrayList<DBWorkAuth>();
		int permission = Integer.parseInt(handover.getPreservepermissions());
		if(permission<2){//工作移交 0=不保留权限,1=保留权限
			//获取当前节点的所有办理人
			auths = runningdata.getAllAuthListByWorkid(workid);			
		}else{//代理
			auths = runningdata.getXAuthListForCurNode(StaticVarExtend.AUTH_AUTHOR);
		}
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();		
		//处理参与者
		AuthUserImpl oldUser = new AuthUserImpl();
		oldUser.setAuthId(handover.getOlduser());
		oldUser.setSubjectionId(handover.getOldsubjection());
		oldUser.setSubjectionType(handover.getOldsubjectiontype());
		
		AuthUserImpl newUser = AuthUserImpl.getAuthUserByStr(handover.getNewuserid());
		ITrackNodeJson trackNode = runningdata.getCurTrack()._getTrackNode();
		for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
			if(auth.getStatus().indexOf(StaticVarExtend.AUTH_AUTHOR) ==-1){
				continue;
			}
			if(!auth.getTrackid().equals(handover.getTrackid())){
				continue;
			}
			/**
			 * 如果有代理人的不再处理工作移交则使用isSameAuth方法,否则需要使用isSameAuthForHandover
			 */
			if(auth.isSameAuthWithoutAgentid(oldUser)){
				String newUserid = "";
				//标记内核不更新xml
				auth.setIgnoreXmlUpdate(true);
				//状态改变前克隆一个
				DBWorkAuth newAuth = auth.cloneAuth();
				//修改当前权限为CReader,20150727 liys 必须放在前面(否则在接收代办的时候,权限条件是一样的,会被删除)
				auth.setStatus(StaticVarExtend.AUTH_CREADER);
				newAuths.add(auth);
				
				if(0 == permission){	//替换原有办理人
					addTodo(newAuth, newUser, saveMap);
					
					//拷贝新人员信息到新的权限对象中,放在addTodo下面,避免原来办理人的待办获取不到
					newUser.copyToWorkAuth(newAuth);
					newAuths.add(newAuth);
					
					String newAuth_status = newAuth.getStatus();
					//如果是会签或者启动子流程的办理人时
					if(!newAuth_status.equals(StaticVarExtend.AUTH_AUTHOR)){
						ITrackUserJson tUser = trackNode.getTrackUserImpl(newAuth_status,StaticVarExtend.AUTH_AUTHOR)	;
						newUserid = handover.getNewuserid();
						chgXml_Plan(auth,newUserid,tUser);
						chgXml_Now (auth,newUserid,tUser);
					}
					
					ITrackUserJson tUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR)	;
					newUserid = handover.getNewuserid();
					chgXml_Plan(auth,newUserid,tUser);
					chgXml_Now (auth,newUserid,tUser);
					
				}
				else{//设置代办时转移待办,直接设置代理人
					oldUser.copyToWorkAuth(newAuth);
					newAuth.setAgentId(newUser.getAuthId());
					newAuths.add(newAuth);
					
					chgTodo(newAuth,newUser.getAuthId(),saveMap);
					
					String newAuth_status = newAuth.getStatus();
					//如果是会签或者启动子流程的办理人时
					if(!newAuth_status.equals(StaticVarExtend.AUTH_AUTHOR)){
						ITrackUserJson tUser = trackNode.getTrackUserImpl(newAuth_status,StaticVarExtend.AUTH_AUTHOR)	;
						newUserid =  newAuth._getFullNameWithAgent();
						chgXml_Plan(auth,newUserid,tUser);
						chgXml_Now (auth,newUserid,tUser);
					}

					ITrackUserJson tUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR)	;
					newUserid = newAuth._getFullNameWithAgent();
					chgXml_Plan(auth,newUserid,tUser);
					chgXml_Now (auth,newUserid,tUser);
				}
				
				//参与者权限为主办或者协办时发送待办
				Map<String,String> para = new HashMap<String,String>();
				para.put("workid", auth.getWorkid());
				para.put("trackid", auth.getTrackid());
				para.put("identifier", identifier);
				para.put("actionname",pubInfo.getInfo("Handover_Msg0001", "接收") );
				para.put("actionUserid", handover.getNewuser());
				para.put("actionUsername", handover.getNewname());
				para.put("memo", pubInfo.getInfo("Handover_Msg0002","来自于[|oldname|]").replace("|oldname|", handover.getOldname()));
				
				DBLog log = StaticFunExtend.getActionCommon().makeDbLogForMgr(para);
				log.getSQL(saveMap);
			}
		}
		
		handover.getDelSQL(saveMap);//删除数据
		runningdata.setCurAuthToMap(newAuths);

		for(Map.Entry<String, List<Object>> entry : saveMap.entrySet()){
			runningdata.putSQLToDataMap(entry.getKey(), entry.getValue());
		}
		runningdata.setSaveLog(false);//不调用日志记录规则
		return true;
	}
	
	private void chgXml_Plan(DBWorkAuth oldauth,String newauth,ITrackUserJson tUser){
		String planId = tUser.getPlanId();
		String newUser = getUserForChgXml(oldauth,newauth,planId);
		runningdata.setPlanId_ForTrackUser(tUser, newUser);
	}
	private void chgXml_Now(DBWorkAuth oldauth,String newauth,ITrackUserJson tUser){
		String nowId = tUser.getNowId();
		String newUser = getUserForChgXml(oldauth,newauth,nowId);
		runningdata.setNowId_ForTrackUser(tUser, newUser);
	}
	private String getUserForChgXml(DBWorkAuth oldauth,String newauth,String oldUser){
		List<AuthUserImpl> lstPlan = AuthUserImpl.getAuthUserList(oldUser);
		StringBuilder newPlan = new StringBuilder(1000);
		for(int i=0,n=lstPlan.size();i<n;i++){
			AuthUserImpl p = lstPlan.get(i);
			newPlan.append(StaticVarExtend.UserSplitChar);
			if(p.isSameAuth(oldauth)){
				newPlan.append(newauth); //newauth中的authid是未分拆的
			}
			else{
				newPlan.append(p._getFullNameWithAgent());
			}
		}
		if(newPlan.length()>0){
			newPlan.deleteCharAt(0);
		}
		return newPlan.toString();
	}
	
	
	//处理待办数据
	private void addTodo(DBWorkAuth auth,AuthUserImpl newUser,Map<String, List<Object>> saveMap){
		DBChgTodo dTodo = getOldTodo(auth);
		if(dTodo != null){
			dTodo.setWorkver((newVersion));
			//生成一条新的待办数据
			DBTodo nTodo = dTodo.copy();
			nTodo.setAuthId(newUser.getAuthId());
			nTodo.setSubjectionId(newUser.getSubjectionId());
			nTodo.setSubjectionType(newUser.getSubjectionType());
			//20160413 liys 增加subjection的容错处理，如果newUser不包含subjection，则使用auth中的subjection
//			if(newUser.getSubjectionId().equals(StaticVarExtend.NullStr)){
//				nTodo.setSubjectionId(auth.getSubjectionId());
//				nTodo.setSubjectionType(auth.getSubjectionType());
//			}
			nTodo.setAgentId(newUser.getAgentId());
			
			nTodo.setAuthId(nTodo._getFullNameWithAgent());
			nTodo.setStatus(auth.getStatus());
			nTodo.getSQL(saveMap,runningdata.getResultJson());
			//修改当前
			dTodo._setStatus(StaticVarExtend.AUTH_CREADER);
			dTodo.getSQL(saveMap,runningdata.getResultJson());
		}
	}
	
	private void chgTodo(DBWorkAuth auth,String newUser,Map<String, List<Object>> saveMap){
		DBChgTodo dTodo = getOldTodo(auth);
		if(dTodo != null){
			dTodo.setWorkver((newVersion));
			dTodo._setAgentId(newUser);
			dTodo.getSQL(saveMap,runningdata.getResultJson());
		}
		
	}
	
	private DBChgTodo getOldTodo(DBWorkAuth auth){
		DBChgTodo todo = new DBChgTodo();
		todo.setTrackid(auth.getTrackid());
		todo.setNodeid(auth.getNodeid());
		todo.setAuthId(auth.getAuthId());
		todo.setSubjectionId(auth.getSubjectionId());
		todo.setStatus(auth.getStatus());
		todo._setIdentifier(identifier);
		DBChgTodo dTodo = todo._getFromDBTodo();
		return dTodo;
	}
	
	/**
	 * 操作执行保存数据完毕后调用此方法.比如对消息之类的数据进行更新(如:待办变已办)
	 * 此方法在流程数据保存成功之后调用(如果需要事务统一,请在doSendInfo中实现)
	 */
	public void actionAfterSaveToDB(){
		
	}
	
}
