package com.horizon.wf.action.manage;

import java.util.*;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.ISpecialAction;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.pool.XMLTodoPub;
import com.horizon.wf.tools.AccessUtil;

/**
 * 激活流程
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionActiveTrack implements ISpecialAction{
	private RunningData runningdata ; 
	private String workid;
	private String trackid;
	private String identifier;
	private PubInfo pubInfo;
	public void setRunningData(RunningData runningdata) {
		this.runningdata = runningdata;
	}
	
	public boolean doAction() {
		pubInfo = PubInfo.getPubInfo(runningdata.getLangInfo());
		DBTrack xTrack = runningdata.getCurTrack();
		DBWork work = runningdata.getWork();
		trackid = xTrack.getId();
		workid = work.getId();
		identifier = runningdata.getInitData().getFlowIdentifier();
		
		String interfaceClass = (String)runningdata.getInitData().getVariable("interfaceClass");
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(StringUtilExtend.isNotNull(interfaceClass)){
			WorkParaBean wpb = new WorkParaBean();
			wpb.setWorkId(workid);
			wpb.setFlowId(work.getFlowid());
			wpb.setTrackId(trackid);
			wpb.setNodeId(xTrack.getNodeid());
		
			try{
				IBaseRule br = InterfaceFactory.getNewInterface(interfaceClass);
				br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
				br.setParameter(StaticVarExtend.Parameter_DBWork, work);
				br.setParameter(StaticVarExtend.Parameter_RunUser, runningdata.getCurUser());
				br.setParameter(StaticVarExtend.Parameter_DBTrack, xTrack);
				br.setParameter(StaticVarExtend.Parameter_SaveMap,saveMap);
				br.setRunningData(runningdata);
				if(!br.executeRule()){
					runningdata.setResultCode(StaticVarExtend.F_STATUS_Active_Track_Error);
					runningdata.setBackMsg(pubInfo.getInfo("Active_Msg0001", "节点激活失败"));
					return false;
				}
			}catch(Exception e){
				runningdata.setBackMsg(pubInfo.getInfo("Active_Msg0002", "节点激活接口执行失败"));
				runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
				return false;
			}
//			Map<String, String> varMap = wpb.getFlowVarMap();
//			//保存流程变量
//			if(CollectionUtil.isMapNotEmpty(varMap)){
//				DBFlowVarRecord vr = new DBFlowVarRecord();
//				vr.setFlowvar(SerializableUtil.objectToString(varMap));
//				vr.setWorkid(workid);
//				vr.setId(StaticFunExtend.getUnid());
//				vr.setVersion(work.getVersion()+1);
//				vr.getSQL(saveMap);				
//			}
			
		}
		//获取是否激活参数
		String active = (String)runningdata.getInitData().getVariable("Active");
		xTrack.setActive(Integer.parseInt(active)); //激活路径
		DBChgTodo todo = new DBChgTodo();
		todo._setIsactive(active);
		todo._setTrackactive(active);

		todo._setWhere_and_isactive_equals("0");
		todo._setWhere_and_trackid_equals(trackid);
		
		 //下面的赋值仅仅为了在拆分库表的情况下能找到对应的库表
        todo.setStatus(StaticVarExtend.AUTH_AUTHOR);
        
		todo.getSQL(saveMap,runningdata.getResultJson());
		//其他消息状态修改
		//String sql = "update "+StaticVar.Table_Todo_Temp+" set active='1'  where active='0' and trackid='"+xTrack.getId()+"'"; ;
		//saveMap.put(sql, null);
		
		//记录日志,不用系统默认的日志记录
		Map<String,String> logPara = new HashMap<String,String>();
		logPara.put("workid",workid);
		logPara.put("trackid",  trackid);
		logPara.put("identifier", identifier);
		logPara.put("actionUserid", StaticVarExtend.System_Id);
		logPara.put("actionUsername",pubInfo.getInfo("System_Name", "工作流系统"));
		logPara.put("memo", pubInfo.getInfo("Active_Msg0006","无"));
		
		//Timing定时激活Active_Msg0003,Signal信号激活Active_Msg0004,Message消息激活Active_Msg0005,
		String actionname = (String)runningdata.getInitData().getVariable("Actionname");
		if(actionname.equals("Timing")){
			logPara.put("actionname",pubInfo.getInfo("Active_Msg0003","定时激活") );
		}
		else if(actionname.equals("Signal")){
			logPara.put("actionname",pubInfo.getInfo("Active_Msg0004","信号激活") );
		}
		else if(actionname.equals("Message")){
			logPara.put("actionname",pubInfo.getInfo("Active_Msg0005","消息激活") );
		}
		DBLog trackLog = StaticFunExtend.getActionCommon().makeDbLogForSys(logPara);

		String receivetime = getLastLogTime();
		if(!receivetime.equals("")) {
			String nowtime = DateUtilExtend.getNow();
			trackLog.setDotime(DateUtilExtend.getSubtractDHM(receivetime, nowtime));
			trackLog.setDotimemin(DateUtilExtend.getTimeDifferenceMin(receivetime, nowtime));
		}
		trackLog.getSQL(saveMap);	
		
		
		if(!saveMap.isEmpty()){
			runningdata.putSQLToDataMap(saveMap);
		}
		runningdata.setSaveLog(false);//不记录日志
		
		return true;
	}

	/**
	 * 获取跟当前节点相关的最后一次执行时间
	 * @return
	 */
	private String getLastLogTime(){
		String sql = "SELECT ACTIONTIME FROM " +StaticVarExtend.Table_Log
				+" WHERE WORKID=? AND NEXTNODEIDS LIKE ? ORDER BY ACTIONTIME DESC  ";
		List<Object> para = new ArrayList<Object>();
		para.add(workid);
		para.add("%"+runningdata.getCurTrack().getNodeid()+";%");

		runningdata.putMsgToConsole("[IO]getLastLogTime...Start");
		List<List<Object>> result = AccessUtil.getInstance()
				.getMultiList(sql, para, identifier);
		runningdata.putMsgToConsole("[IO]getLastLogTime...End");
		if(result == null || result.size()==0){
			return "";
		}
		String startTime = (String)result.get(0).get(0);
		return startTime;
	}
	/**
	 * 操作执行保存数据完毕后调用此方法.比如对消息之类的数据进行更新(如:待办变已办)
	 * 此方法在流程数据保存成功之后调用(如果需要事务统一,请在doSendInfo中实现)
	 */
	public void actionAfterSaveToDB(){
		XMLTodoPub.startThreadForNoActiveMsg(workid,trackid,identifier);
	}
	
}
