package com.horizon.wf.action.event;

import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;

import java.util.List;


/**
 * 
 * 自动提交实现类
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ExecuteEventSubmit {
	private WorkParaBean wpb = new WorkParaBean();
	private IWorkflowOperator iwo = WorkflowFactory.getWorkflowOperator();
	private IWorkResult wr = null;
	//构造参数
	public ExecuteEventSubmit(String workid,String trackid,String nodeid,String identifier){
		String tenantid = ThirdAdapterFactory.getTenantidByIdentifier(identifier);
		wpb.setActionClass("com.horizon.wf.action.ActionSubmitEvent");
		wpb.setTenantCode(tenantid);
		wpb.setDataIdentifier(identifier);
		wpb.setFlowIdentifier(identifier);
		wpb.setFunname(StaticVarExtend.OPERATOR_FUNNAME_AUTO_SUBMIT);
		wpb.setUserId(StaticVarExtend.System_Id);
		wpb.setAllUserids(StaticVarExtend.System_Id);
		wpb.setWorkId(workid);
		wpb.setTrackId(trackid);
		wpb.setNodeId(nodeid);
		wpb.setUrlApp(StaticVarExtend.Todo_Default_URL.replace("|workid|", workid));
		wr = iwo.open(wpb);
	}
	//执行提交
	public int excuteSubmit(){
		if(StaticVarExtend.Init_Success == wr.getResult()){
			wpb.putMsgSendFlagMap(StaticVarExtend.AUTH_AUTHOR, StaticVarExtend.Send_Todo);
			wpb.setFlowVarMap(wr.getFlowVarMap());
			wr = iwo.operator(wpb);	
			if(StaticVarExtend.F_STATUS_Success == wr.getResult()){
				return wr.getResult();
			}
		}
		//不成功时，处理异常
		List<INodeException> ex = wr.getCurFlowNode().getExceptions();
		INodeException e = StaticFunExtend.getActionCommon().getExceptionByCode(StaticVarExtend.Exception_Code_NodeEventAutoSubmitError,ex );
		StaticFunExtend.getActionCommon().handleException(e, wr.getCurFlowNode(), wpb,wr.getRunningdata());
		return wr.getResult();
	}

	public IWorkResult getWorkResult() {
		return wr;
	}
	
}
