package com.horizon.wf.action.common;

import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.bean.WorkResultBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.global.StaticVarExtend;

import java.util.List;
/**
 * 操作时,如果没有打开实例时,调用此接口执行打开实例
 * 
 * @author liys
 *
 */
public class OpenForInOperator extends BaseRuleImpl implements IBaseRule {
	/**
	 * 打开实例,并校验当前操作是否在权限范围内
	 */
	public boolean executeRule() {
		IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator();
		WorkParaBean paraBean = (WorkParaBean)getParameter("WorkParaBean");
		
		WorkResultBean resultBean = (WorkResultBean)operator.open(paraBean);
		
		int result = resultBean.getResult();
		if(result == StaticVarExtend.Init_Success){
			setResult(resultBean.getRunningdata());
			//从操作中判断是否有指定的操作权限
			String className = paraBean.getActionClass();
			List<INodeButton> buttons = resultBean.getCurNodeButton();
			for(int i=0,n=buttons.size();i<n;i++){
				INodeButton button = buttons.get(i);
				String buttonClass = button.getImplClass();
				if(className.equals(buttonClass)){
					return true;
				}
			}
			String msg = PubInfo.getPubInfo(resultBean.getRunningdata().getLangInfo())
					.getInfo("Action_Msg0053","无权执行当前操作.");
			setBackMsg(msg);
		}
		else{
			//20170117 liys 增加失败信息返回
			setBackMsg(resultBean.getBackMsg());
		}
		
		return false;
	}



}
