package com.horizon.wf.action.common;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 打开实例时,用于临时存放流程变量值
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class MemoryOperator {
	private static Map<String,Object> map = new LinkedHashMap<String, Object>();
	private MemoryOperator(){}
	/**
	 * 将给定的键值放到map中
	 * @param key 实例id
	 * @param value 要存放的map
	 */
	public static void putValueToMap(String key,Object value){
		map.put(key, value);
	}
	/**
	 * 获取给定key的map值
	 * @param key
	 * @return
	 */
	public static Object getValueFromMap(String key){
		return map.get(key);
	}
	/**
	 * 通过key值移除指定数据
	 * @param key
	 * @return
	 */
	public static Object clearValueByKey(String key){
		return map.remove(key);
	}
	
	/**
	 * 清空map
	 */
	public static void clearAll(){
		map.clear();
	}
}
