package com.horizon.wf.action.common;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.bean.WorkResultBean;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.INodeUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.CStrUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 人员选择判断通用类
 * @deprecated
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class HandleSelectUserUtil {
	private HandleSelectUserUtil(){}
	/**
	 * 判断给定的节点是否选择了办理人
	 * 循环遍历所有下一节点，将每个节点的情况都至于results的list中，如果之中还有false则返回需要传入办理人
	 * @param nextNodes 节点
	 * @param selectedUsers	办理人
	 * @param tmpUsers	初始化的办理人
	 * @return 1:节点办理人准备就绪
	 * 			2:需要传入办理人
	 * 			3:后台设置办理人为空时不允许选择办理人,且未找到办理人
	 */
	public static int isSelectAuthor(List<INextNode> nextNodes,Map<String, String> selectedUsers,
			Map<String, String> tmpUsers, RunningData rd){
		Object obj = rd.getWorkResultBean();
		if(null != obj){
			WorkResultBean wrb = (WorkResultBean)obj;
			WorkParaBean wpb = (WorkParaBean)rd.getWorkParaBean();
			wrb.setWorkParaBean(wpb);
			return isSelectAuthor(nextNodes, selectedUsers, rd.getFunname(), tmpUsers, 
					wpb.getSubmitflag(),null, wrb.getInitAuthorMap(), rd,true);			
		}
		return 999;
	}
		/**
		 * 判断给定的节点是否选择了办理人
		 * 循环遍历所有下一节点，将每个节点的情况都至于results的list中，如果之中还有false则返回需要传入办理人
		 * @param nextNodes 节点
		 * @param selectedUsers	办理人
		 * @param tmpUsers	初始化的办理人
		 * @return 1:节点办理人准备就绪
		 * 			2:需要传入办理人
		 * 			3:后台设置办理人为空时不允许选择办理人,且未找到办理人
		 */
		public static int isSelectAuthor(List<INextNode> nextNodes,Map<String, String> selectedUsers,
				String funname,Map<String, String> tmpUsers, String submitflag,
				Map<String, String> initAuthorMap,RunningData rd){
			return isSelectAuthor(nextNodes,selectedUsers,funname,tmpUsers,submitflag,null,initAuthorMap,rd,false);
		}
		public static int isSelectAuthorForEntryRule(List<INextNode> nextNodes,Map<String, String> selectedUsers,
				String funname,Map<String, String> tmpUsers, String submitflag,Map<String,List<INodeUser>> tmpNodeUser,
				Map<String, String> initAuthorMap,RunningData rd){
			return isSelectAuthor(nextNodes,selectedUsers,funname,tmpUsers,submitflag,tmpNodeUser,initAuthorMap,rd,false);
		}
		
		
		private static int isSelectAuthor(List<INextNode> nextNodes,Map<String, String> selectedUsers,
				String funname,Map<String, String> tmpUsers, String submitflag,Map<String,List<INodeUser>> tmpNodeUser,
				Map<String, String> initAuthorMap,RunningData rd,boolean isUpdateNextNodeResult){
		List<Boolean> results = new ArrayList<Boolean>();
		
		rd.putMsgToConsole("[msg]isSelectAuthor is begining");
		for(int j=0,n=nextNodes.size();j<n;j++){
			INextNode nextNode = nextNodes.get(j);
			IFlowNode node = nextNode.getFlowNode();
			int nodetype = node.getNodetype();
			rd.putMsgToConsole("[msg]next nodetype is "+nodetype);
			if(ActionCommon.getInstance().isGateWayNode(nodetype) 
//					|| ActionCommon.getInstance().isAutoNode(nodetype)	//20150921 liys 自动节点和事件节点一致处理
					|| nodetype == NodeTypeEnum.Node_Mutual
					){
				rd.putMsgToConsole("[msg]isGateWayNode continue");
				continue;
			}
			
			//获取前台传入的办理人
			String users = getAuthorFromSelected(nextNode,selectedUsers,submitflag,funname);
			//下一节点没有传入办理人
			if(StringUtilExtend.isNull(users)){
				rd.putMsgToConsole("[msg]selectedUsers is null.");
				//下一节点的参与者列表
				List<INodeUser> lst = nextNode.getListUserByNodeInit();
				if(tmpNodeUser!=null && CollectionUtil.isListEmpty(lst)){
					//传入的临时节点人员不为空,且当前循环的节点办理人员为空时执行
					String nodeid = node.getNodeid();
					List<INodeUser> tmpLst = tmpNodeUser.get(nodeid);
					//根据当前节点id获取列表,不为空时使用此列表
					if(CollectionUtil.isListNotEmpty(tmpLst)){
						lst = tmpLst;
					}
				}
				//判断是否存在办理人,办理人是否需要前台选择干预
				if(CollectionUtil.isListEmpty(lst)){
//					前台选择人员为空
//					 * 下一节点办理人员也为空时
//					 * 1=继续下一节点,2=需要选择人,3=未找到办理人
					int intResult = doNextUsersIsNull(node,nodetype,submitflag);
					if(intResult == 3){
						return 3;
					}
					else if(intResult == 2){
						//标识需要选择办理人
						rd.putMsgToConsole("[msg]nextNode is not author.");
						results.add(false);
						if(isUpdateNextNodeResult){
							nextNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);//标记节点需要选择人员
						}
					}
				}
				//下一节点列表不为空(进入时获取到了办理人)
				else{
					rd.putMsgToConsole("[msg]get nextNode author start.");
					int i=0;
					for(int k=0,m=lst.size();k<m;k++){
						INodeUser nu = lst.get(k);
						String authType = nu.getAuthType();
						String key = nextNode.getKeyid()+StaticVarExtend.MARK_NODE_USER + authType ;
						
						int doNodetype = doForNextNodeType(node, nu, nodetype, key, submitflag
								,selectedUsers,initAuthorMap, tmpUsers);
						if(doNodetype == 2){
							results.add(false);
							if(isUpdateNextNodeResult){
								nextNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
							}
						}
						else if(doNodetype == 3){
							continue;
						}
						//不进行交互时，只判断主办是否需要选择人员(submitflag等于1：前后台交互)
						//需要选择办理人时results.contains(false)
						//前后台交互时submitflag=1
						//author且不是退回操作时
						if(results.contains(false) 
								|| StaticVarExtend.Submit_Flag.equals(submitflag) 
								|| (!funname.equalsIgnoreCase(StaticVarExtend.OPERATOR_FUNNAME_REJECT) 
									&& StaticVarExtend.AUTH_AUTHOR.equals(authType))){
							if(!StaticVarExtend.AUTH_AUTHOR.equals(authType)){
								i++;//记录非Author类型的参与者个数
							}
							
							String userid = nu.getPlanid();
							int userCounts = CStrUtil.TrimArray(userid.split(StaticVarExtend.UserSplitChar)).length;
							int selectType = getNextSelectTypeByNodeid(nextNode.getFlowNode(), funname, authType);
							//判断下一节点是否允许选择
							INodeAuthUser xmlUser = nextNode.getFlowNode().getParticipantsUser(authType);
							//不允许为空时,且不能自由选择，未找到办理人
							if(xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_FreeSelect) != -1 && userCounts < 1){
								return 3;
							}
							//单选人员数量不等于1并且为主办时 返回前台
							//单选 人员数量等于1 并且需要选择 返回前台
							//多选人员数量大于0，并且需要选择 返回前台
							if((selectType == 1 && userCounts > 1 && indexOfAuthor(authType)) 
							  ||(
									  //20150629 liys 如果只有一个办理人时,不提示选择
								  ((selectType == 1 && userCounts > 1) ||(selectType == 2 && userCounts > 0)) 
								 && xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_ManualSelect) >= 0
								 && StringUtilExtend.isNotNull(initAuthorMap.get(key))
								 )
							   ){

									if(null != tmpUsers){
										tmpUsers.put(key,userid);
									}
									rd.putMsgToConsole("[msg]nextNode is manualSelect.");
									results.add(false);	
									if(isUpdateNextNodeResult){
										nextNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);//标记节点需要选择人员
									}
								
							}else{
								if(StaticVarExtend.AUTH_AUTHOR.equals(authType)){
									if(null != selectedUsers && StringUtilExtend.isNull(selectedUsers.get(key))){
										selectedUsers.put(key,userid);
									}								
								}else{
									isJudgeSelectReaderAndSelectAuthor(nextNode, selectedUsers, tmpUsers, initAuthorMap, nu);
								}
							}
						}else{
							if(null != selectedUsers && !results.contains(false)){
								String tempkey = nextNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR;
								if(StringUtilExtend.isNotNull(selectedUsers.get(tempkey))
										|| funname.equalsIgnoreCase(StaticVarExtend.OPERATOR_FUNNAME_REJECT)){
									selectedUsers.put(key,nu.getPlanid());
								}
								if(!StaticVarExtend.Submit_Flag.equals(submitflag)){
									selectedUsers.put(key,nu.getPlanid());									
								}
							}
							if(null != tmpUsers && "".equals(selectedUsers.get(key))){
								tmpUsers.put(key,nu.getPlanid());
							}
							if(!StaticVarExtend.AUTH_AUTHOR.equals(nu.getAuthType())){
								i++;//不是主办 自增 用于确定列表里是否有主办									
							}
							continue;
						}
						//前后台交互时，初始化参与者只有主办，则判断读者和协办是否需要选择
						if(StaticVarExtend.Submit_Flag.equals(submitflag) && !lst.isEmpty() && StaticVarExtend.AUTH_AUTHOR.equals(nu.getAuthType())){
							if(isJudgeSelectReaderAndSelectAuthor(nextNode, selectedUsers, tmpUsers, initAuthorMap, nu) 
									&& rd.isNewDoc()>1){
								results.add(false);
								if(isUpdateNextNodeResult){
									nextNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);//标记节点需要选择人员
								}
							}
						}
						rd.putMsgToConsole("[msg]nextNode author :"+nu.getPlanid());
					}
					
					rd.putMsgToConsole("[msg]get nextNode author end.");
					if(i == lst.size() && !ActionCommon.getInstance().isEndNode(nodetype)){
						results.add(false);
						if(isUpdateNextNodeResult){
							nextNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);//标记节点需要选择人员
						}
					}
				
				}
			}else{
				doSelectUserIsNotNull(selectedUsers,nextNode,rd);
			}
		}	
		
		rd.putMsgToConsole("[msg]isSelectAuthor is end.");
		boolean resultAuth = results.contains(false);
		if(resultAuth){
			return 2;
		}
		return 1;
	}
	/**
	 * 前台选择人员为空
	 * 下一节点办理人员也为空时
	 * 1=继续下一节点,2=需要选择人,3=未找到办理人
	 */
	private static int doNextUsersIsNull(IFlowNode node,int nodetype, String submitflag){
		INodeAuthUser xmlUser = node.getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		//不允许为空时且不能自由选择时，返回未找到办理人
		if(null != xmlUser && xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_FreeSelect) < 0){
			return 3; 
		}
		if(ActionCommon.getInstance().isEndNode(nodetype) 
			|| ActionCommon.getInstance().isEventNode(nodetype)	
			|| ActionCommon.getInstance().isAutoNode(nodetype) //20150921 liys 自动节点
				){
			xmlUser = node.getParticipantsUser(StaticVarExtend.AUTH_READER);
			//判断结束节点是否允许选择读者,不允许选择读者时,继续下一个节点的判断
			if(null != xmlUser && xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_FreeSelect) < 0){
				return 1;
			}
			if(!StaticVarExtend.Submit_Flag.equals(submitflag)){
				return 1;
			}
		}
		
		return 2;
	}
	/**
	 * 前台选择人员为空
	 * 下一节点办理人员不为空时
	 * 
	 * @return
	 */
	private static int doForNextNodeType(IFlowNode node,INodeUser nu,int nodetype,String key,String submitflag
			,Map<String,String> selectedUsers,Map<String, String> initAuthorMap,Map<String,String> tmpUsers){
		
		String authtype = nu.getAuthType();
		//结束节点/事件节点/自动节点
		if(ActionCommon.getInstance().isEndNode(nodetype) 
				|| ActionCommon.getInstance().isEventNode(nodetype)
				|| ActionCommon.getInstance().isAutoNode(nodetype)		//20150921 liys 自动节点
		){
			if(authtype.equals(StaticVarExtend.AUTH_READER)){
				INodeAuthUser xmlUser = node.getParticipantsUser(authtype);
				boolean isManualSelect = xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_ManualSelect) >= 0;
				boolean isFreeSelect = xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_FreeSelect) >= 0;
				//只有是从xml中获取到的参与者才可以
				if(CollectionUtil.isMapNotEmpty(initAuthorMap) && !isManualSelect){
					//initAuthorMap是否有值,来源于EntryRuleDefault.java Line484的方法是否执行
					if(null != selectedUsers){
						selectedUsers.put(key,nu.getNowid());//重置选择的人员,包含前台选择的和所有流程参与者
					}
				}
				else if(StaticVarExtend.Submit_Flag.equals(submitflag)  //预处理
						&& (isFreeSelect || isManualSelect)			//自由选择,从列表中选则
						&& CollectionUtil.isMapEmpty(selectedUsers) ){	//前台未传入时
					if(null != tmpUsers){
						tmpUsers.put(key,initAuthorMap.get(key));
					}
					return 2;
				}
			}
			return 3;
		}
		return 1;
	}
	
	
	
	
	/**
	 * 前台传入人员不为空的处理
	 */
	private static void doSelectUserIsNotNull(Map<String,String> selectedUsers,INextNode nextNode,RunningData rd){
		Map<String, String> tempMap = new LinkedHashMap<String, String>();
		for(String key:selectedUsers.keySet()){
			String value = selectedUsers.get(key);
//			INodeAuthUser xmluser = nextNode.getFlowNode().getParticipantsUser(subNodeidFromAuthname(key, nextNode.getKeyid()));
//			if(!(null == xmluser || xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) == -1)){
//				//代办人员获取
//				value = AgentUtil.getInstance()
//						.getAgentUser(value, rd.getWork().getId(), rd.getWork().getFlowid(), rd.getInitData().getFlowIdentifier());						
//			}
			
			tempMap.put(key, value);
		}
		//重新覆盖一下,key不变,值可能会变
		selectedUsers.putAll(tempMap);
	}
	
	
	
	private static boolean isJudgeSelectReaderAndSelectAuthor(INextNode nextNode,Map<String, String> selectedUsers,
			Map<String, String> tmpUsers, Map<String, String> initAuthorMap, INodeUser nu){
		IFlowNode node = nextNode.getFlowNode();
		INodeAuthUser xmlUserReader = node.getParticipantsUser(StaticVarExtend.AUTH_READER);
		//是否有初始化人员
		boolean isSelect = false;
		if(null != xmlUserReader){
			//是否允许自由选择读者
			boolean isReaderFreeSelect = xmlUserReader.getControlAttribute().indexOf(StaticVarExtend.Node_Control_FreeSelect) >= 0;
			//是否允许从列表中选择读者
			boolean isReaderManualSelect = xmlUserReader.getControlAttribute().indexOf(StaticVarExtend.Node_Control_ManualSelect) >= 0;
			String tempReaderKey = nextNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_READER;
			boolean isSelectReaderUsersNull = null == initAuthorMap.get(tempReaderKey) || "".equals(initAuthorMap.get(tempReaderKey));
			if(isReaderFreeSelect ){
				if(isSelectReaderUsersNull){
					isSelect = true;
				}else{
					if(isReaderManualSelect){
						selectedUsers.remove(tempReaderKey);
						if(null != tmpUsers){
							tmpUsers.put(tempReaderKey,initAuthorMap.get(tempReaderKey));
						}									
						isSelect = true;
					}else{
						if(null != selectedUsers){
							selectedUsers.put(tempReaderKey, initAuthorMap.get(tempReaderKey));
						}
					}
				}
			}else{
				if(!isSelectReaderUsersNull){
					selectedUsers.put(tempReaderKey, initAuthorMap.get(tempReaderKey));									
				}
			}			
		}
		
		INodeAuthUser xmlUserSecond = node.getParticipantsUser(StaticVarExtend.AUTH_SECOND_AUTHOR);
		if(null != xmlUserSecond){
			boolean isSecondFreeSelect = xmlUserSecond.getControlAttribute().indexOf(StaticVarExtend.Node_Control_FreeSelect) >= 0;
			boolean isSecondManualSelect = xmlUserSecond.getControlAttribute().indexOf(StaticVarExtend.Node_Control_ManualSelect) >= 0;
			String tempSecondKey = nextNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_SECOND_AUTHOR;
			boolean isSecondSelectUsersNull = null == initAuthorMap.get(tempSecondKey) || "".equals(initAuthorMap.get(tempSecondKey));
			if(isSecondFreeSelect ){
				if(isSecondSelectUsersNull){
					isSelect = true;
				}else{
					if(isSecondManualSelect){
						selectedUsers.remove(tempSecondKey);
						if(null != tmpUsers){
							tmpUsers.put( nextNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+nu.getAuthType(),nu.getPlanid());
						}									
						isSelect = true;
					}else{
						if(null != selectedUsers){
							selectedUsers.put(tempSecondKey, initAuthorMap.get(tempSecondKey));
						}
					}
				}
			}else{
				if(!isSecondSelectUsersNull){
					selectedUsers.put(tempSecondKey, initAuthorMap.get(tempSecondKey));									
				}
			}			
		}
		return isSelect;
	}

	/**
	 * 判断给定的权限名称是否是主办
	 * @param authname
	 * @return true:拥有主办权限
	 */
	public static boolean indexOfAuthor(String authname){
		if(StringUtilExtend.isNull(authname)){
			return false;
		}
		return authname.indexOf(StaticVarExtend.AUTH_AUTHOR)>=0;
	}
	
	/**
	 * 判断给定的权限名称是否是当前节点主办
	 * @return true:拥有主办权限
	 */
	public static boolean indexOfAuthor(String name,String nodeid){
		if(StringUtilExtend.isNull(name)){
			return false;
		}
		if(name.startsWith(nodeid)){
			String authname = subNodeidFromAuthname(name, nodeid);
			return StaticVarExtend.AUTH_AUTHOR.equals(authname);
		}
		return indexOfAuthor(name);
	}
	
	/**
	 * 判断给定的authname是否已nodeid开头 如果是则截取掉nodeid
	 * @param authname
	 * @param nodeid
	 * @return 权限名称
	 */
	public static String subNodeidFromAuthname(String authname,String nodeid){
		if(authname.startsWith(nodeid)){
			return authname.split(StaticVarExtend.MARK_NODE_USER)[1];
		}
		return authname;
	}
	/**
	 * 获取前台传入的办理人
	 * @param node 节点
	 * @param selectedUsers
	 * @return
	 */
	private static String getAuthorFromSelected(INextNode node,Map<String, String> selectedUsers,String submitflag,String funname) {
		String type = StaticVarExtend.AUTH_AUTHOR;
		//前后台交互时直接返回空
		if(StaticVarExtend.Submit_Flag.equals(submitflag)){
			return "";
		}
		if(CollectionUtil.isMapEmpty(selectedUsers)){
			return null;
		}
		String user = selectedUsers.get(node.getKeyid()+StaticVarExtend.MARK_NODE_USER+type);
		if(null != user){
			user = user.trim();
		}
		if(StringUtilExtend.isNotNull(user)){
			String[] users = CStrUtil.TrimArray(user.split(StaticVarExtend.UserSplitChar));
			int selectType = getNextSelectTypeByNodeid(node.getFlowNode(), funname, type);
			//如果节点类型为单选,但是传入的办理人为多个则返回空
			if(users.length > 1 && selectType == 1){
				return "";
			}
		}
		return user;
	}

	/**
	 * 将给定的list中的数据转换成String，以“|”分割
	 * @param users
	 * @return
	 */
	public static String listToUserString(List<String> users){
		StringBuilder temp = new StringBuilder(1000);
		if(CollectionUtil.isListNotEmpty(users)){
			for(int i=0,n=users.size();i<n;i++){
				temp.append(users.get(i)+StaticVarExtend.MARK_VERTICAL);
			}
		}
		return temp.toString();
	}

	/**
	 * 获取具有主办权限的列表
	 * @return
	 */
	public static List<DBWorkAuth> getAllAuthor(RunningData runningdata){
		return getAuthorList(runningdata, StaticVarExtend.AUTH_AUTHOR);
	}

	/**
	 * 获取具有指定办理权限的列表
	 * @return
	 */
	public static List<DBWorkAuth> getAuthorList(RunningData runningdata, String authname){
		return runningdata.getXAuthListForCurNode(authname);
/*		List<DBWorkAuth> authnameList = new ArrayList<DBWorkAuth>();//处理后的权限列表
		List<DBWorkAuth> authList = runningdata.getAllAuthListForCurNode();//当前节点所有权限列表
		if(null != authList && authList.size() > 0){
			for(DBWorkAuth auth : authList){
				//如果权限中含有指定的权限字样则添加到处理后的权限列表中
				if(null != authname && authname.length()>0 && auth.getStatus().indexOf(authname) >=0){
					authnameList.add(auth);
				}
			}
		}
		return authnameList;
*/	}

	/**
	 * 根据nodeid获取节点选择人员的方式
	 * @return 1:单选(默认)   2:多选
	 */
	public static int getNextSelectTypeByNodeid(IFlowNode node,String funname, String authType){
		int nodetype = node.getNodetype();
//		return getNextSelectTypeByNodeid(nodetype,funname,authType);
//	}
//	private static int  getNextSelectTypeByNodeid(int nodetype,String funname, String authType){
		int selectType = 1;
		if(StringUtilExtend.isNotNull(funname)){
			//非主办时全部为多选
			if(!StaticVarExtend.AUTH_AUTHOR.equals(authType)){
				selectType = 2;
			}
			//加签,会签,添加读者为多选
			else if(StaticVarExtend.OPERATOR_FUNNAME_JIAQIAN.equals(funname) ||
					StaticVarExtend.OPERATOR_FUNNAME_JIAQIAN_BEFORE.equals(funname) ||
					StaticVarExtend.OPERATOR_FUNNAME_HUIQIAN.equals(funname) ||
					StaticVarExtend.OPERATOR_FUNNAME_ADD_READER.equals(funname)){
				selectType = 2;
			}
			//提交需要根据下一节点类型来判断人员选择方式
			else /*if(StaticVarExtend.OPERATOR_FUNNAME_SUBMIT.equalsIgnoreCase(funname) 
					|| StaticVarExtend.OPERATOR_FUNNAME_AUTOSUBMIT.equalsIgnoreCase(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_GOTO.equalsIgnoreCase(funname)
					|| StaticVarExtend.OPERATOR_FUNNAME_JUMPREJECT.equalsIgnoreCase(funname)
					)//*/
			{
				//下一节点为多人单一签核，多人顺序，多人处理时为多选
				if(NodeTypeEnum.Node_Multi_Single == nodetype || 
						NodeTypeEnum.Node_Multi == nodetype ||
								NodeTypeEnum.Node_Order == nodetype){
					selectType = 2;
				}
			}
		}
		return selectType;
	}

	
}
