package com.horizon.wf.action.common;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.plugins.PluginsUtilCore;

import java.util.Map;
/**
 * 用于引擎内部在操作执行完毕后调用
 * 执行异常处理程序
 * @author liys
 *
 */
public class HandleExceptionDelay extends BaseRuleImpl implements IBaseRule{

	
	public boolean executeRule() {
		Map<String,Object> handleDelayPara = getRunningdata().getHandleDelayPara();
		INodeException e = (INodeException)handleDelayPara.get("IXmlException");
		IFlowNode node = (IFlowNode)handleDelayPara.get("IXmlNode");
		
		ActionCommon.getInstance().handleException(e, getRunningdata(), node);
		
		IBaseRule eLog = PluginsUtilCore.getMultiInstance().getExceptionLog();
		if (eLog != null) {
			eLog.setRunningData(getRunningdata());
			eLog.setParameter("ErrType", "3");
			//根据需要传入异常的相关信息,
			//从IXmlException和IXmlNode中获取对应的节点和执行的异常类型
			eLog.setParameter("Memo",node.getNodename()+"["+e.getExceptionName()+"]");
			eLog.setParameter("Message",e.getExceptionMsg());
			eLog.executeRule();
		}
		
		return true;
	}
}
