package com.horizon.wf.action.common;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.action.base.IActionForStartSubFlow;
import com.horizon.wf.action.base.StartSubflow;
import com.horizon.wf.api.common.SerializableUtil;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.expand.signal.Signal;
import com.horizon.wf.expand.signal.SignalListenerUtil;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

/**
 * 处理action中节点激活
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class ActionExtraData {
    // 单例
    private static ActionExtraData ac = null;

    private ActionExtraData() {
    }

    public static ActionExtraData getInstance() {
        if (null == ac) {
            return new ActionExtraData();
        }
        return ac;
    }

    /**
     * 处理下一节点激活方式
     * 
     * @param runningdata 运行期对象
     */
    public void setNextNodesNoActive(RunningData runningdata) {
        List<INextNode> nextNodes = runningdata.getCurTaskNode().getGNextNodes();
        runningdata.putMsgToConsole("[msg]do with next node entry type start.");
        if (CollectionUtil.isListNotEmpty(nextNodes)) {
            for (INextNode node : nextNodes) {
                IFlowNode xmlNode = node.getFlowNode();
                String startModeType = xmlNode.getStartModeType();
                if (!(StringUtilExtend.isNull(startModeType) || "0".equals(startModeType))) {
                    int type = Integer.parseInt(startModeType);
                    if (type > 0 && type < 4) {
                        node.setNoActive();// 设置节点不激活
                    }
                }
            }
        } 
        else {
            runningdata.putMsgToConsole("[msg]do with next node entry type end.startModeType is null.");
        }
        runningdata.putMsgToConsole("[msg]do with next node entry type end.");
    }

    /**
     * 处理下一节点额外数据,如事件节点，自动节点
     */
    public boolean doWithNextNodesExtraData(IActionForStartSubFlow action){//(RunningData runningdata,PubInfo pubInfo, List<Object> taskLists,List<RunningData> subRunningdatas) {
    	RunningData runningdata 			= action.getRunningData();
    	PubInfo pubInfo 					= action.getPubInfo();
    	List<Object> taskLists 				= action.getTaskLists();
    	List<INextNode> nextNodes = runningdata.getCurTaskNode().getGNextNodes();
        runningdata.putMsgToConsole("[msg]do with next node entry type start.");
        boolean result = true;
        if (CollectionUtil.isListNotEmpty(nextNodes)) {
            for (INextNode node : nextNodes) {
                int nodetype = node.getFlowNode().getNodetype();
                if (StaticFunExtend.getActionCommon().isAutoNode(nodetype)) { // 自动节点
                	result = nextNode_Robot(node.getFlowNode(), runningdata, pubInfo, taskLists);
                } else if (StaticFunExtend.getActionCommon().isEventNode(nodetype)) {// 事件节点
                	result = nextNode_Event(node.getFlowNode(), runningdata, pubInfo, taskLists);
                }else if (nodetype == NodeTypeEnum.Node_Sub) { // 内嵌子流程
                    // 子流程节点,启动指定的子流程,并根据设置对子流程节点进行处理
                	result = nextNode_Subflow(node.getFlowNode(),action);
                }else if (nodetype == NodeTypeEnum.Node_Mutual) { // 引擎交互
                    // 更新交互节点的trackid,并获取SQL,因为节点可能在新的分支上
                    result = nextNode_Mutual(node.getFlowNode(), action);
                }
                if(!result){
                	break;
                }
                if (!node.isActive()) {
                	result = nodeNotActiveForAddTask(node.getFlowNode(), runningdata, pubInfo, taskLists);
                }
                if(!result){
                	break;
                }
            }
        } else {
            runningdata.putMsgToConsole("[msg]do with next node entry type end.startModeType is null.");
        }
        runningdata.putMsgToConsole("[msg]do with next node entry type end.");
        return result;
    }
    
    private boolean nextNode_Subflow(IFlowNode nextNode, IActionForStartSubFlow action) {
    	RunningData runningdata 			= action.getRunningData();
    	PubInfo pubInfo 					= action.getPubInfo();
    	List<Object> taskLists 				= action.getTaskLists();
    	List<RunningData> subRunningdatas	= action.getSubRunningdatas();
    	List<DBRelationSubflow> subflowWorks = action.getSubflowWorks();
    	
    	List<INodeSubflow> allSubFlowList = nextNode.getSubFlowList();//可以启动的子流程列表
    	List<String> subworkidLst = new ArrayList<String>();	//记录已经启动成功的子流程实例id,用于失败时删除实例
    	if(allSubFlowList.isEmpty()){
    		runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0050","子流程节点未设置子流程."));
    		return false;
    	}
    	DBTrack track = getTrackIdByNodeId(nextNode.getNodeid(), runningdata);
    	boolean isMuilt = nextNode.getSubFlowMuilt() ; //是否允许多个实例
    	StartSubflow subflow = new StartSubflow(runningdata,pubInfo,nextNode,track.getId());
    	for(int i=0,n=allSubFlowList.size();i<n;i++){
			INodeSubflow subFlowInfo = allSubFlowList.get(i);
    		//如果前台传入办理人
    		//检测前台是否传入了子流程接收人
			String allAuthors = action.getSelectedUsers().get(subFlowInfo.getSubFlowId());
			if(StringUtilExtend.isNotNull(allAuthors)){
				String[] authors = allAuthors.split(StaticVarExtend.UserSplitChar);
				if(isMuilt || authors.length == 1){
					for(String author:authors){
						//重置第一个节点办理人
						subflow.setAuthor(author);
						if(!startSubAction(subflow,subFlowInfo,subworkidLst,action)){
							subRunningdatas.clear();
							subflowWorks.clear();
							return false;
						}
					}
				}
				else{
					runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
					runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0012", "子流程不允许启动多个时,不能选择多个办理人"));
					
					subRunningdatas.clear();
					subflowWorks.clear();
					return false;
				}
				//从选择的办理人中删除,避免正常节点发送待办时,给flowid发送消息
				action.getSelectedUsers().remove(subFlowInfo.getSubFlowId());
			}
			else{
				//重置第一个节点办理人
				subflow.setAuthor("");
				if(!startSubAction(subflow,subFlowInfo,subworkidLst,action)){
					subRunningdatas.clear();
					subflowWorks.clear();
					return false;
				}
			}
    	}
    	//判断下一节点是否符号条件
    	boolean result = checkNextNode(nextNode,runningdata,pubInfo);
    	if(!result){
    		subRunningdatas.clear();
    		subflowWorks.clear();
    		return false;
    	}
    	
		//不需要等待时,增加一个立即执行的定时任务
    	boolean wait = nextNode.getSubFlowWait();
    	if(!wait){
    		if(!nextNode_Robot(nextNode,runningdata,pubInfo,taskLists)){
    			subRunningdatas.clear();
    			subflowWorks.clear();
    			return false;
    		}
    	}
    	return true;
    }
    
    private String getUserFromOrg(INodeAuthUser xmluser) {
		StringBuilder sb = new StringBuilder(2000);
		String tmpUser;
		tmpUser = xmluser.getPerson();
		if (tmpUser.length() != 0) {
			tmpUser = tmpUser.replaceAll("\\|", StaticVarExtend.UserSplitChar);
			String[] users = tmpUser.split(StaticVarExtend.UserSplitChar);
			for(String u : users){
				sb.append(StaticVarExtend.UserFix).append(StaticVarExtend.Mark_Fix).append(u);
				sb.append(StaticVarExtend.UserSplitChar);				
			}
		}
		
		tmpUser = xmluser.getDept();
		if (tmpUser.length() != 0) {
			tmpUser = tmpUser.replaceAll("\\|", StaticVarExtend.UserSplitChar);
			String[] depts = tmpUser.split(StaticVarExtend.UserSplitChar);
			for(String u : depts){
				sb.append(StaticVarExtend.SubjectionFix);
				if(u.indexOf(StaticVarExtend.Mark_Fix) ==-1){
					sb.append(StaticVarExtend.DeptFix).append(StaticVarExtend.Mark_Fix);
				}
				sb.append(u);
				sb.append(StaticVarExtend.UserSplitChar);				
			}
		}
		
		tmpUser = xmluser.getGroup();
		if (tmpUser.length() != 0) {
			tmpUser = tmpUser.replaceAll("\\|", StaticVarExtend.UserSplitChar);
			String[] groups = tmpUser.split(StaticVarExtend.UserSplitChar);
			for(String u : groups){
				sb.append(StaticVarExtend.SubjectionFix);
				sb.append(StaticVarExtend.GroupFix).append(StaticVarExtend.Mark_Fix).append(u);
				sb.append(StaticVarExtend.UserSplitChar);				
			}
		}
		
		tmpUser = xmluser.getRole();
		if (tmpUser.length() != 0) {
			tmpUser = tmpUser.replaceAll("\\|", StaticVarExtend.UserSplitChar);
			String[] roles = tmpUser.split(StaticVarExtend.UserSplitChar);
			for(String u : roles){
				sb.append(StaticVarExtend.SubjectionFix);
				sb.append(StaticVarExtend.RoleFix).append(StaticVarExtend.Mark_Fix).append(u);
				sb.append(StaticVarExtend.UserSplitChar);				
			}
		}
		tmpUser = xmluser.getPosition();
		if (tmpUser.length() != 0) {
			tmpUser = tmpUser.replaceAll("\\|", StaticVarExtend.UserSplitChar);
			String[] positions = tmpUser.split(StaticVarExtend.UserSplitChar);
			for(String u : positions){
				sb.append(StaticVarExtend.SubjectionFix);
				sb.append(StaticVarExtend.PosFix).append(StaticVarExtend.Mark_Fix).append(u);
				sb.append(StaticVarExtend.UserSplitChar);				
			}
		}
		return sb.toString();
	}
    

    private boolean startSubAction(StartSubflow subflow,INodeSubflow subFlowInfo,List<String> subworkidLst,IActionForStartSubFlow action){
    	RunningData runningdata 			= action.getRunningData();
    	PubInfo pubInfo 					= action.getPubInfo();
    	List<RunningData> subRunningdatas	= action.getSubRunningdatas();
    	List<DBRelationSubflow> subflowWorks = action.getSubflowWorks();
    	
    	IWorkResult wr = subflow.startAndSaveFlow(subFlowInfo);
		if(wr == null){
			runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0052","子流程id为空,启动失败."));
			
//			delRdySubInstance(subworkidLst,runningdata.getInitData().getTenantid(),runningdata.getInitData().getFlowIdentifier());
			return false;
		}
		else if(wr.getResult() == StaticVarExtend.Init_Success){
			subworkidLst.add(wr.getWorkid());
			subRunningdatas.add(wr.getRunningdata());
			subflowWorks.add(subflow.getDBRelationSubflow());
		}
		else{
			if(wr.getResult() == StaticVarExtend.F_STATUS_SelectAuthor){
				runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0010","子流程[|flowname|]第一个节点的办理人未知")
							.replace("|flowname|", subFlowInfo.getSubFlowName()));
			}
			else{
				runningdata.setBackMsg("["+subFlowInfo.getSubFlowId()+"]"+wr.getBackMsg());
			}
			
//			delRdySubInstance(subworkidLst,action.getTenantid(),action.getIdentifier());
			return false;
		}
    	return true;
    }
    
    // 自动节点额外数据处理
    private boolean nextNode_Robot(IFlowNode node, RunningData runningdata,PubInfo pubInfo, List<Object> taskLists) {
    	String nodeid = node.getNodeid();
    	DBTrack track = getTrackIdByNodeId(nodeid, runningdata);
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        Map<String,String> para = new HashMap<String,String>();
        para.put("flowname",runningdata.getWork().getFlowname());
        para.put("nodename",node.getNodename());
        para.put("nodeid",nodeid);
        para.put("workid",runningdata.getWork().getId());
        para.put("version",String.valueOf(runningdata.getWork().getVersion()));
        para.put("trackid",track.getId());
        para.put("tenantid",runningdata.getInitData().getTenantid());
        para.put("identifier",runningdata.getInitData().getFlowIdentifier());
        
        Object task = addMainSubmitTaskForSubEnd(saveMap, para);
        if (null == task) {
        	runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0051","定时任务创建失败"));
        	return false;
        }
    	setMapToRunningdata(saveMap, runningdata);
    	taskLists.add(task);
    	return true;
    }
    /**
     * 用于子流程节点上的子流程结束时,添加主流程的自动提交任务
     * @param saveMap
     * @param para
     * @return
     */
    public Object addMainSubmitTaskForSubEnd(Map<String, List<Object>> saveMap,Map<String,String> para){
		String nodeid = para.get("nodeid");
		String workid = para.get("workid");
		String trackid = para.get("trackid");

		DBRobotTask rTask = new DBRobotTask();
		rTask.setId(StaticFunExtend.getUnid());
		rTask.setStatus("0");
		rTask.setClassname("");
		rTask.setNodeid(nodeid);
		rTask.setWorkid(workid);
		rTask.setTrackid(trackid);

		saveMap.putAll(rTask.getSQL());
		
		ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
		
		para.put("jbClassName", "com.horizon.wf.third.hz.task.adapter.NodeAutoSubmitTask");
		Object task = ti.makeTaskBeanForAutoSubmit(saveMap, para);
		
		return task;
    }
    
    // 事件节点额外数据处理
    private boolean nextNode_Event(IFlowNode node, RunningData runningdata,PubInfo pubInfo, List<Object> taskLists) {
        ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
        String nodeid = node.getNodeid();
        int nodetype = node.getNodetype();
        DBTrack track = getTrackIdByNodeId(nodeid, runningdata);
        DBWork work = runningdata.getWork();
        switch(nodetype){
        case NodeTypeEnum.Node_Event_Signal_Throw:
        	Signal signal = new Signal();
            String flowpara = node.getEventSignalPara();//.getEventFlowVar();
            if (StringUtilExtend.isNotNull(flowpara)) {
                Map<String, String> flowVarmap = runningdata.getInitData().getFlowVarMap();
                flowpara = flowVarmap.get(flowpara);
            }
            signal.setSignalPara(flowpara);
            signal.setIdentifier(runningdata.getInitData().getFlowIdentifier());
            SignalListenerUtil.sendSignal(signal);
            //此处不要break,因为需要执行下面的定时任务添加程序
        case NodeTypeEnum.Node_Event_Intermediate:
			Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
			Map<String, String> para = new HashMap<String, String>();
			para.put("flowname", runningdata.getWork().getFlowname());
			para.put("nodename", node.getNodename());
			para.put("nodeid", node.getNodeid());
			para.put("workid", runningdata.getWork().getId());
			para.put("version",	String.valueOf(runningdata.getWork().getVersion()));
			para.put("trackid", track.getId());
			para.put("tenantid", runningdata.getInitData().getTenantid());
			para.put("identifier", runningdata.getInitData().getFlowIdentifier());
			para.put("jbClassName","com.horizon.wf.third.hz.task.adapter.NodeEventSubmitTask");
			Object task = ti.makeTaskBeanForAutoSubmit(saveMap, para);
			if (null == task) {
				runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0051",
						"定时任务创建失败"));
				return false;
			}
			setMapToRunningdata(saveMap, runningdata);
			taskLists.add(task);
			
			break;
        case NodeTypeEnum.Node_Event_Timer:
            Map<String, List<Object>> saveMap0 = new LinkedHashMap<String, List<Object>>();
            Object task0 = ti.makeTaskBean(runningdata, node, saveMap0, track);
            if (null == task0) {
            	runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0051","定时任务创建失败"));
            	return false;
            }
            taskLists.add(task0);

            DBNodeTaskTrigger e = new DBNodeTaskTrigger();
            e.setId(StaticFunExtend.getUnid());
            e.setTriggerType(StaticVarExtend.Signal_Event_Type_Node);// 事件类型
            e.setExecnum(0);
            e.setTrackid(track.getId());
            e.setWorkid(work.getId());
            e.setVersion(work.getVersion());
            e.setNodeid(nodeid);
            e.setInterfaceClass(node.getEventTimeClass());
            e.setStatus("1");
            e.getSQL(saveMap0,runningdata.getResultJson());
            setMapToRunningdata(saveMap0, runningdata);
            
            break;
        case NodeTypeEnum.Node_Event_Message:// 消息捕获
            DBNodeMessageTrigger mtMsg = new DBNodeMessageTrigger();
            mtMsg.setId(StaticFunExtend.getUnid());
            mtMsg.setMessageContent(SerializableUtil.objectToString(runningdata.getInitData().getHashMap()));
            mtMsg.setMessageFrom("");
            mtMsg.setMessageName(node.getStartModeTriggerMessageName());
            mtMsg.setMessageId(node.getStartModeTriggerMessageID());
            String msgpara = node.getStartModeTriggerMessagePara();
            if (StringUtilExtend.isNotNull(msgpara)) {
                Map<String, String> flowVarmap = runningdata.getInitData().getFlowVarMap();
                msgpara = flowVarmap.get(msgpara);
            }
            mtMsg.setMessagePara(msgpara);
            mtMsg.setMessageTo("");
            mtMsg.setMessageType(StaticVarExtend.Signal_Event_Type_Node);
            mtMsg.setNodeid(nodeid);
            mtMsg.setTrackid(track.getId());
            
            mtMsg.setWorkid(work.getId());
            mtMsg.setFlowid(work.getFlowid());
            mtMsg.setVersion(work.getVersion());
            mtMsg.setStatus("1");// 1:可执行
            Map<String, List<Object>> saveMap1 = new LinkedHashMap<String, List<Object>>();
            mtMsg.getSQL(saveMap1,runningdata.getResultJson());
            for (Map.Entry<String, List<Object>> en : saveMap1.entrySet()) {
                runningdata.putSQLToDataMap(en.getKey(), en.getValue());
            }
            break;
        case NodeTypeEnum.Node_Event_Signal_Catch:// 信号捕获
            DBNodeSignalTrigger mtSignal = new DBNodeSignalTrigger();
            mtSignal.setId(StaticFunExtend.getUnid());
            mtSignal.setSignalContent(SerializableUtil.objectToString(runningdata.getInitData().getHashMap()));
            mtSignal.setSignalFrom("");
            mtSignal.setSignalName("");
            mtSignal.setSignalId("");
            mtSignal.setSignalClass(node.getEventClassName());
            String eventpara = node.getEventSignalPara();//.getEventFlowVar();
            if (StringUtilExtend.isNotNull(eventpara)) {
                Map<String, String> flowVarmap = runningdata.getInitData().getFlowVarMap();
                eventpara = flowVarmap.get(eventpara);
            }
            mtSignal.setSignalPara(eventpara);
            mtSignal.setSignalTo("");
            mtSignal.setSignalType(StaticVarExtend.Signal_Event_Type_Node);
            mtSignal.setNodeid(nodeid);
            mtSignal.setTrackid(track.getId());
            mtSignal.setWorkid(work.getId());
            mtSignal.setFlowid(work.getFlowid());
            mtSignal.setVersion(work.getVersion() + 1);
            mtSignal.setStatus("1");
            Map<String, List<Object>> saveMap2 = new LinkedHashMap<String, List<Object>>();
            mtSignal.getSQL(saveMap2,runningdata.getResultJson());
            for (Map.Entry<String, List<Object>> en : saveMap2.entrySet()) {
                runningdata.putSQLToDataMap(en.getKey(), en.getValue());
            }
            break;
         default:
            	
        }
        return true;
    }
    
    private boolean nextNode_Mutual(IFlowNode nextNode, IActionForStartSubFlow action) {
    	RunningData runningdata 			= action.getRunningData();
    	PubInfo pubInfo 					= action.getPubInfo();
    	List<Object> taskLists 				= action.getTaskLists();
    	String interactiveClassName = nextNode.getInteractiveClassName();
    	if(CStrUtil.isNull(interactiveClassName)){
    		//如果服务器地址为空,则增加定时任务往下流转
    		if(!CStrUtil.isNull(nextNode.getClusterUrl())){
    			nextNode_Mutual_Cluster(nextNode,runningdata,action.getMutualLists());
        		return true;
    		}
    		//下一节点的判断需要在服务器地址为空时执行,否则不需要
    		boolean result = checkNextNode(nextNode,runningdata,pubInfo);
        	if(!result){
        		return false;
        	}
    	}
    	else{
    		//有交互处理类时,下一节点的判断需要在执行类之前判断,避免类中的数据无法同步处理
    		boolean result = checkNextNode(nextNode,runningdata,pubInfo);
        	if(!result){
        		return false;
        	}
        	
	    	IBaseRule ruleObj = InterfaceFactory.getNewInterface(interactiveClassName);
	    	if(ruleObj == null){
	    		runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0054","交互处理类初始化失败!|classname|")
	    				.replace("|classname|",interactiveClassName));
	    		return false;
	    	}
	    	ruleObj.setRunningData(runningdata);
	    	//后期根据实际需要增加一些参数,
	    	ruleObj.setParameter("workid", runningdata.getWork().getId());
	    	//为引擎交互处理提供参数
	    	DBTrack track = getTrackIdByNodeId(nextNode.getNodeid(), runningdata);
	    	ruleObj.setParameter("nxtTrackid", track.getId());
	    	ruleObj.setParameter("identifier", runningdata.getInitData().getFlowIdentifier());
	    	
	    	result = ruleObj.executeRule();
	    	if(result){
	    		//20170619 liys 增加判断是否为引擎交互处理,
	    		//如果是则直接返回,不需要进行往下提交处理
	    		//参考:com.horizon.wf.api.mutual.HZInteractiveSample
	    		//如果不是引擎间的交互处理,只是针对其他数据的处理,则需要进行流程的自动提交
	    		String isCluster = (String)ruleObj.getResult("IsCluster");
	    		if("1".equals(isCluster)){
	    			DBMutualTask sTask = (DBMutualTask) ruleObj.getResult("DBMutualTask");
	    			action.getMutualLists().add(sTask);
	    			return true;
	    		}
	    	}
	    	else{
	    		runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0055","交互处理失败!"));
	    		return false;
	    	}
    	}
    	
    	//增加自动往下提交的定时任务
    	if(!nextNode_Robot(nextNode,runningdata,pubInfo,taskLists)){
			return false;
		}
    	return true;
    }
    
    //引擎交互时,创建中间数据
    private void nextNode_Mutual_Cluster(IFlowNode node, RunningData runningdata,List<DBMutualTask> mutualLists) {
        // 插入一条交互中间数据,用于后面定时任务执行时获取
        DBMutualTask sTask = new DBMutualTask();
        sTask.setId(StaticFunExtend.getUnid());
        sTask.setSortnum(1);
        sTask.setServername(node.getClusterUrl());
        sTask.setClassname(node.getClusterClassName());
        sTask.setWorkid(runningdata.getWork().getId());
        sTask.setStatus("0"); // 0=还没有写入到目标服务器
        DBTrack track = getTrackIdByNodeId(node.getNodeid(), runningdata);
        sTask.setTrackid(track.getId());
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        sTask.getSQL(saveMap,runningdata.getResultJson());
        mutualLists.add(sTask);
        setMapToRunningdata(saveMap, runningdata);
    }
    
    
    private boolean checkNextNode(IFlowNode nextNode,RunningData runningdata,PubInfo pubInfo){
    	//判断是否有唯一下一节点,且有办理人
		List<INodeRouter> routers =nextNode.getAllToRouters();
		int size = routers.size();
		if(size == 0){
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0013", "节点[|nodename|]缺少后续节点")
					.replace("|nodename|", nextNode.getNodename()));
			
			return false;
		}
		if(size >1){
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0014", "节点[|nodename|]后续节点不唯一")
					.replace("|nodename|", nextNode.getNodename()));
			
			return false;
		}
    	INodeRouter router = routers.get(0);
    	IFlowNode xmlNode = runningdata.getInstanceDefinition().getFlowinfo().getNodeById(router.getNodeid());
    	int nxtNodeType = xmlNode.getNodetype();

    	if(nxtNodeType >= NodeTypeEnum.Node_Merger && nxtNodeType != NodeTypeEnum.Node_Progressively){
    		//内部循环节点
			return checkNextNode_Special(xmlNode,router,runningdata,pubInfo);
    	}
    	INodeAuthUser xmluser = xmlNode.getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
    	String tmpUser = getUserFromOrg(xmluser);
    	if("".equals(tmpUser)){
    		runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0016", "后续节点[|nodename|]未设置办理人")
					.replace("|nodename|", router.getNodename()));
			
    		return false;
    	}
    	List<AuthUserImpl> listUser = AuthUserImpl.getAuthUserList(tmpUser);
    	if((nxtNodeType == NodeTypeEnum.Node_Single || nxtNodeType == NodeTypeEnum.Node_Progressively)
				&& listUser.size() !=1){
    		runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0017", "后续节点[|nodename|]为单一办理,设置的办理人多于一个.")
					.replace("|nodename|", router.getNodename()));
			
    		return false;
    	}
    	return true;
    }
    //判断下一节点为特殊节点时,是否能作为系统自动处理的后续节点
    private boolean checkNextNode_Special(IFlowNode xmlNode,INodeRouter router,RunningData runningdata,PubInfo pubInfo){
		//自动,事件,子流,网关,结束
		int nxtNodeType = xmlNode.getNodetype();
		if(nxtNodeType== NodeTypeEnum.Node_GateWay_Merge || nxtNodeType == NodeTypeEnum.Node_GateWay_Split){
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			runningdata.setBackMsg(pubInfo.getInfo("SubFlow_Msg0015",
					"后续节点[|nodename|]类型不符合要求.(只能是单人或者多人节点)")
					.replace("|nodename|", router.getNodename()));

			return false;
		}

		return true;
	}

    private void setMapToRunningdata(Map<String, List<Object>> map, RunningData runningdata) {
        if (CollectionUtil.isMapNotEmpty(map)) {
            for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
                runningdata.putSQLToDataMap(entry.getKey(), entry.getValue());
            }
        }
    }

    /**
     * 节点不激活时,添加任务信息
     */
    private boolean nodeNotActiveForAddTask(IFlowNode xmlNode, RunningData runningdata,PubInfo pubInfo, List<Object> taskLists) {
        String startModeType = xmlNode.getStartModeType();
        String nodeid = xmlNode.getNodeid();
        DBTrack track = getTrackIdByNodeId(nodeid, runningdata);
        // 定时任务激活
        if ("1".equals(startModeType)) {
            if (addActivationTask(xmlNode, track, runningdata, taskLists)) {
                addNodeTriggerRecord(xmlNode, track, runningdata);// 生成数据库存储的触发机制记录
            }
            else{
            	runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0051","定时任务创建失败"));
            	return false;
            }
        } else if ("2".equals(startModeType)) {// 消息激活
            DBNodeMessageTrigger mt = new DBNodeMessageTrigger();
            mt.setId(StaticFunExtend.getUnid());
            mt.setMessageContent(SerializableUtil.objectToString(runningdata.getInitData().getHashMap()));
            mt.setMessageFrom("");
            mt.setMessageName(xmlNode.getStartModeTriggerMessageName());
            mt.setMessageId(xmlNode.getStartModeTriggerMessageID());
            String para = xmlNode.getStartModeTriggerMessagePara();
            if (StringUtilExtend.isNotNull(para)) {
                Map<String, String> flowVarmap = runningdata.getInitData().getFlowVarMap();
                para = flowVarmap.get(para);
            }
            mt.setMessagePara(para);
            mt.setMessageTo(xmlNode.getStartModeTriggerMessageTo());
            mt.setMessageType(StaticVarExtend.Activation_Type_Node);
            mt.setNodeid(nodeid);
            DBWork work = runningdata.getWork();
            mt.setTrackid(track.getId());
            mt.setWorkid(work.getId());
            mt.setFlowid(work.getFlowid());
            mt.setVersion(work.getVersion() + 1);
            mt.setStatus("1");// 1:可执行
            Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
            mt.getSQL(saveMap,runningdata.getResultJson());
            for (Map.Entry<String, List<Object>> en : saveMap.entrySet()) {
                runningdata.putSQLToDataMap(en.getKey(), en.getValue());
            }
        } else if ("3".equals(startModeType)) {// 信号激活
            DBNodeSignalTrigger mt = new DBNodeSignalTrigger();
            mt.setId(StaticFunExtend.getUnid());
            mt.setSignalContent(SerializableUtil.objectToString(runningdata.getInitData().getHashMap()));
            mt.setSignalFrom("");
            mt.setSignalName("signalname");
            mt.setSignalId(StaticFunExtend.getUnid());
            String para = xmlNode.getEventSignalPara();//.getEventFlowVar();
            if (StringUtilExtend.isNotNull(para)) {
                Map<String, String> flowVarmap = runningdata.getInitData().getFlowVarMap();
                para = flowVarmap.get(para);
            }
            mt.setSignalPara(para);
            mt.setSignalClass(xmlNode.getEventClassName());
            mt.setSignalTo("");
            mt.setSignalType(StaticVarExtend.Activation_Type_Node);
            mt.setNodeid(nodeid);
            mt.setStatus("1");
            DBWork work = runningdata.getWork();
            mt.setTrackid(track.getId());
            mt.setWorkid(work.getId());
            mt.setFlowid(work.getFlowid());
            mt.setVersion(work.getVersion() + 1);
            Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
            mt.getSQL(saveMap,runningdata.getResultJson());
            for (Map.Entry<String, List<Object>> en : saveMap.entrySet()) {
                runningdata.putSQLToDataMap(en.getKey(), en.getValue());
            }
        }
        return true;
    }

    /**
     * 添加节点触发记录
     */
    private void addNodeTriggerRecord(IFlowNode node, DBTrack track, RunningData runningdata) {
        DBNodeTaskTrigger e = new DBNodeTaskTrigger();
        e.setId(StaticFunExtend.getUnid());
        e.setTriggerType(StaticVarExtend.Activation_Type_Node);// 事件类型
        e.setExecnum(0);
        e.setWorkid(runningdata.getWork().getId());
        e.setTrackid(track.getId());
        e.setNodeid(node.getNodeid());
        e.setInterfaceClass(node.getStartModeClass());
        e.setVersion(runningdata.getWork().getVersion() + 1);
        e.setStatus("1");
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        e.getSQL(saveMap,runningdata.getResultJson());
        for (Map.Entry<String, List<Object>> en : saveMap.entrySet()) {
            runningdata.putSQLToDataMap(en.getKey(), en.getValue());
        }
    }

    /**
     * 添加一个定时任务
     * 
     * @param node
     */
    private boolean addActivationTask(IFlowNode node, DBTrack track, RunningData runningdata, List<Object> taskLists){
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
        Object task = ti.makeTaskBean(runningdata, node, saveMap, track);
        if (null != task) {
            taskLists.add(task);
            if (!saveMap.isEmpty()) {
                for (Map.Entry<String, List<Object>> en : saveMap.entrySet()) {
                    runningdata.putSQLToDataMap(en.getKey(), en.getValue());
                }
            }
            return true;
        }
        return false;
    }

    private DBTrack getTrackIdByNodeId(String nodeid, RunningData runningdata) {
        List<DBTrack> trackInfos = runningdata.getNextTrackList();
        if (CollectionUtil.isListNotEmpty(trackInfos)) {
            for (DBTrack t : trackInfos) {
                if (t.getNodeid().equals(nodeid)) {
                    return t;
                }
            }
        }
        return runningdata.getCurTrack();
    }

    public void putSubMapToMainMap(Map<String,List<Object>> mainMap,Map<String, List<Object>> subMap){
		Iterator<Map.Entry<String,List<Object>>> iter = subMap.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry<String,List<Object>> entry = (Map.Entry<String,List<Object>>)iter.next();
			String key = entry.getKey();
			List<Object> value = entry.getValue();
			List<Object> oldValue = mainMap.get(key);
			if(oldValue == null){
				mainMap.put(key, value);
			}
			else{
				oldValue.addAll(value);
			}
		}
    }
    
}
