package com.horizon.wf.action.common;

import com.alibaba.fastjson.JSONObject;
import com.horizon.common.collect.Lists;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowManager;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.expand.impl.IMessageMould;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.global.*;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.pool.XMLTodoPub;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 操作各action中通用的方法
 * 
 * @author liangjw
 * @version 1.0
 */
public class ActionCommon {
    // 单例
    private static ActionCommon AC = null;

    private ActionCommon() {
    }

    public static ActionCommon getInstance() {
        if (null == AC) {
            return new ActionCommon();
        }
        return AC;
    }

    /**
     * 获取发送消息的的标题
     * 
     * @param trackid
     *            发送消息的trackid
     * @param node
     *            发送到哪个节点
     * @param rd
     *            运行期对象
     * @param msgType
     *            消息类型
     * @param authType  
     *             权限类型
     * @return 处理好后的标题
     */
    public String getTodoTitle(String trackid, IFlowNode node, RunningData rd, String msgType, String authType) {
        IMessageMould mm = PluginsUtil.getSingleInstance().getMessageMould();
        if (mm == null) {
            rd.putMsgToConsole("[Msg]IMessageMould is null.");
        }
        return mm.getTodoTitle(trackid, node, rd, msgType, authType);
    }

    /**
     * 根据msgType获取消息格式,并把title按照格式进行格式化返回
     * @param title
     * @param rd
     * @param msgType
     * @return
     */
    public String getTodoTitle(String title,RunningData rd,String msgType){
        IMessageMould mm = PluginsUtil.getSingleInstance().getMessageMould();
        if (mm == null) {
            rd.putMsgToConsole("[Msg]IMessageMould is null.");
        }
        return mm.getTodoTitle(title,rd,msgType);
    }

    /**
     * 异常处理(操作过程中的异常)
     * 
     * @param e
     *            异常xml信息
     * @param rd
     *            运行期对象
     * @param node
     *            要处理异常的节点
     * @return 处理异常是否成功
     */
    public boolean handleException(INodeException e, RunningData rd, IFlowNode node) {
        if (null == e) {
            return true;
        }
        Object obj = rd.getWorkResultBean();
        WorkParaBean wpb = new WorkParaBean();
        if (null != obj) {
            wpb = (WorkParaBean) rd.getWorkParaBean();
            wpb.setTitle(rd.getTitle());
        } 
        else {
            wpb.setWorkId(rd.getWork().getId());
            wpb.setTrackId(rd.getCurTrack().getId());
            wpb.setUserId(rd.getCurUser().getUserid());
            wpb.setFlowIdentifier(rd.getInitData().getFlowIdentifier());
            wpb.setDataIdentifier(rd.getInitData().getDataIdentifier());
            wpb.setTitle(rd.getTitle());
            wpb.setUrlApp(StaticVarExtend.Todo_Default_URL.replace("|workid|", rd.getWork().getId()));
        }
        return handleException(e, node,  wpb, rd);
    }

    /**
     * 延迟执行的异常
     * 
     * @param e     异常定义信息
     * @param rd    运行期对象
     * @param node  节点定义信息
     * @return  true
     */
    public boolean handleExceptionDelay(INodeException e, RunningData rd, IFlowNode node) {
        // 把参数存入到runningdata中
        Map<String, Object> handleDelayPara = rd.getHandleDelayPara();
        handleDelayPara.clear();

        handleDelayPara.put("IXmlException", e);
        handleDelayPara.put("IXmlNode", node);
        return true;
    }

    /**
     * 异常处理(操作结束的异常)
     * 
     * @param e
     *            :xml中配置的异常信息
     * @param   node
     *            节点定义信息
     * @param wpb
     *            前台参数
     * @return 处理异常是否成功
     */
    public boolean handleException(INodeException e, IFlowNode node,  WorkParaBean wpb,RunningData rd) {
        if (null == e) {
            return true;
        }

        IRunUser curUser = rd.getCurUser();
    	DBWork work = rd.getWork();
    	DBTrack curTrack = rd.getCurTrack();
    	IFlowInfo flowInfo = rd.getInstanceDefinition().getFlowinfo();
    	String tenantid = rd.getInitData().getTenantid();
    	String identifier = rd.getInitData().getFlowIdentifier();
    	JSONObject json = rd.getResultJson();

        String sendMsgType = e.getExceptionMsg();
        if (StringUtilExtend.isNotNull(sendMsgType)) {
            StaticFunExtend.println("[msg]exception senMsgType:" + sendMsgType);
            if (null == curUser || null == work || null == node || null == curTrack) {
                StaticFunExtend.println("[msg]get Object from Runningdata is null.");
                StaticFunExtend.println("[msg]RunUser:" + curUser + ";DBWork:" + work + ";IXmlNode:" + node
                        + ";DBTrack:" + curTrack);
                return true;
            }
            String todoUserid = "";
            String sendUser = e.getExceptionSendUser();
            if (StringUtilExtend.isNull(sendUser)) {
                StaticFunExtend.println("[msg]exception sendUser is null.");
                return true;
            }
            StaticFunExtend.println("[msg]exception sendUser:" + sendUser);
            if ("1".equals(sendUser)) {// 流程启动者
                todoUserid = rd.getCreatorFullName();//getFlowCreator(work);
            } 
            else if ("2".equals(sendUser)) {// 管理员
                String flowid = flowInfo.getFlowid();
                // String tenantid = wpb.getTenantCode();
                todoUserid = PluginsUtil.getMultiInstance().getAuthority(tenantid).getManager(flowid);
                // getFlowManager(flowInfo,identifier);
            } 
            else {// 自定义
                IBaseRule br = InterfaceFactory.getNewInterface(sendUser);
                br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);// 设置前后台对象到接口
                br.setParameter(StaticVarExtend.Parameter_DBWork, work);
                br.setParameter(StaticVarExtend.Parameter_RunUser, curUser);
                br.setParameter(StaticVarExtend.Parameter_DBTrack, curTrack);
                br.setParameter(StaticVarExtend.Parameter_Exception_INodeException, e);
                if (br.executeRule()) {
                    todoUserid = (String) br.getResult();
                }
            }

            if ("".equals(todoUserid)) {
                return true;
            }
            DBTodo todo = new DBTodo();
            todo.setSenduserid(curUser.getUserid());
            todo.setSendusername(curUser.getUsername());
            todo.setSendsubjectionid(curUser.getSubjectionid());
            todo.setSendsubjectiontype(curUser.getSubjectiontype());
            todo.setSendtime(DateUtil.getNow());

            todo.setFlowid(work.getFlowid());
            todo.setFlowname(work.getFlowname());

            todo._setUrl("");
            todo._setIdentifier(identifier);
            todo._setLimit_time("0");
            todo._setLimit_type(StaticVarExtend.Day_Normal);
            todo._setIdentifier(identifier);
            todo._setOtherstatus("");

            int[] nodelimit = node.getNodeLimit();
            todo._setLimit_time(String.valueOf(nodelimit[1]));
            todo._setLimit_type(String.valueOf(nodelimit[0]));

            PubInfo pubInfo = PubInfo.getPubInfo(tenantid);

            todo.setTitle(work.getTitle()
                    + ":"
                    + pubInfo.getInfo("Exception_Msg0001", "异常[|codename|(代码|code|)]")
                            .replace("|codename|", e.getExceptionName())
                            .replace("|code|", e.getExceptionCode()));
            todo.setWorkid(work.getId());
            todo.setAuthId(todoUserid);
            todo.setTrackactive(String.valueOf(curTrack.getActive()));
            todo.setTrackid(curTrack.getId());
            todo.setTrackstatus(String.valueOf(curTrack.getFlowstatus()));
            todo.setWorkver((work.getVersion()));
            todo.setNodeid(curTrack.getNodeid());
            todo.setNodename(curTrack.getNodename());
            todo.setIsactive("1");

            //20190115 liys UPDATETASK 先从workparabean中获取是否有task更新的saveMap
            Map<String, List<Object>> saveMap = (Map<String,List<Object>>)wpb.getOtherPara().get("UPDATETASK");
            if(saveMap == null){
                saveMap = new LinkedHashMap<String, List<Object>>();
            }

            String[] msgSendTypes = sendMsgType.split(StaticVarExtend.StrSplitChar);
            List<String> tmpIdList = new ArrayList<String>();
            for (String str : msgSendTypes) {
                if (str.equalsIgnoreCase(StaticVarExtend.Send_Read)) {
                    DBTodo tTodo = todo.copy();
                    tTodo.setStatus(StaticVarExtend.AUTH_READER);
                    // 20150921 liys 删除当前信息相同的已阅和待阅,保证一条最新的待阅信息
                    DBChgTodo rTodo = new DBChgTodo();
                 // 处理接收人,确保写入auth_id字段的值相同
                    AuthUserImpl tmp = AuthUserImpl.getAuthUserByStr(todo.getAuthId());
                    
                    List<String> para = new ArrayList<String>(2);
                    para.add(StaticVarExtend.AUTH_READER);
                    para.add(StaticVarExtend.AUTH_READED);
                    rTodo._setWhere_and_status_or(para);

                    rTodo._setWhere_and_senduserid_equals(curUser.getUserid());
                    rTodo._setWhere_and_authId_equals(tmp.getAuthId());
                    rTodo._setWhere_and_trackid_equals(todo.getTrackid());

                    rTodo.getSQL(saveMap,json);
                    tTodo.getSQL(saveMap,json);
                    // 20150911 liys 如果是开始节点启动时,出现创建实例异常和开始节点离开异常需要特别处理
                    if ("Start".equals(tTodo.getNodeid())) {
                        tTodo.setTitle(pubInfo
                                .getInfo("Exception_Msg0002", "实例不存在.此消息由流程[|flowname|]创建实例时的异常（异常代码|code|)发送.")
                                .replace("|flowname|", todo.getFlowname()).replace("|code|", e.getExceptionName()));
                    } 
                    else {
                        // 删除已经存在的Reader权限,避免出现很多的Reader权限
                        DBWorkAuth delAuth = new DBWorkAuth();
                        delAuth.setAuthId(tmp.getAuthId());
                        delAuth.setTrackid(tTodo.getTrackid());
                        delAuth.setNodeid(tTodo.getNodeid());
                        delAuth.setStatus(StaticVarExtend.AUTH_READER);// 同时对oldStatus赋值,所以需要放在上面
                        delAuth.setOldStatus(StaticVarExtend.AUTH_READED);
                        delAuth.getDelSQLForException(saveMap,json);

                        // 增加一个Reader权限,否则无法完成自动已阅
                        DBWorkAuth auth = new DBWorkAuth();
                        auth.setAuthId(tTodo.getAuthId());
                        auth.setWorkid(tTodo.getWorkid());
                        auth.setTrackid(tTodo.getTrackid());
                        auth.setNodeid(tTodo.getNodeid());
                        auth.setStatus(StaticVarExtend.AUTH_READER);
                        auth.setVersion(work.getVersion());

                        auth.getSQL(saveMap,json);
                       /* List<DBWorkAuth> auths= Lists.newArrayList();
                        auths.add(auth);
                        rd.setCurAuthToMap(auths);*/

                        //20180914 增加参数json的目的,是为了更新内存中的数据
                        delAuth.setWorkid(tTodo.getWorkid());
                        delAuth.setVersion(work.getVersion());
                        delAuth.updateJson(saveMap,json,tenantid);
                    }
                } 
                else {
                    DBTodo oTodo = todo.copy();
                    oTodo.setStatus("");
                    oTodo._setOtherstatus(str);
                    oTodo.getSQL(saveMap,json);
                    tmpIdList.addAll(oTodo._getMsgTmpIdList());
                }
            }

            if (AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier)) {
                XMLTodoPub.startThread(work.getId(), tmpIdList, identifier);
            }
        } 
        else {
            StaticFunExtend.println("[msg]exception senMsgType is null.");
        }

        boolean result = true;
        // 不是第一次操作
        result = dealException(wpb, e, work, curTrack, tenantid, identifier);
        if (!isFirstStart(curTrack.getId(), identifier)) {

        }
        return result;
    }

    /**
     * 处理异常
     * 
     * @param wpb
     *            前台参数
     * @param e
     *            异常xml
     * @param work
     *            实例对象
     * @param track
     *            路径对象
     * @param  tenantid
     *              租户id           
     * @param identifier
     *            数据库标示符
     * @return 处理异常是否成功
     */
    private boolean dealException(WorkParaBean wpb, INodeException e, DBWork work, DBTrack track, String tenantid,
            String identifier) {
        String exceptionDealType = e.getExceptionDealType();// 获取异常处理方式
        if (StringUtilExtend.isNull(exceptionDealType)) {
            StaticFunExtend.println("[msg]exception deal type is null.");
            return false;
        }
        boolean result = false;
        if ("0".equals(exceptionDealType)) {// 自定义
            if (null == wpb) {
                return false;
            }
            IBaseRule br = InterfaceFactory.getNewInterface(e.getExceptionDeal());
            br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);// 设置前后台对象到接口
            br.setParameter(StaticVarExtend.Parameter_DBWork, work);
            br.setParameter(StaticVarExtend.Parameter_DBTrack, track);
            br.setParameter(StaticVarExtend.Parameter_Exception_INodeException, e);
            result = br.executeRule();// 执行自定义处理类
            if(result){
                return true;
            }
            //从结果中获取异常处理默认方式
            exceptionDealType = (String)br.getResult();
        }

        if ("1".equals(exceptionDealType)) {// 无
            result = true;
        } 
        else if ("2".equals(exceptionDealType)) {// 跳转
            if (null == e || null == wpb) {
                return false;
            }
            result = gotoAction(wpb, e.getExceptionDeal());
        } 
        else if ("3".equals(exceptionDealType)) {// 挂起
            result = stopOrPauseWorkForException(work.getId(), track.getId(), tenantid,
                    "com.horizon.wf.action.ActionPause", identifier);
        } 
        else if ("4".equals(exceptionDealType)) {// 终止
            result = stopOrPauseWorkForException(work.getId(), track.getId(), tenantid,
                    "com.horizon.wf.action.ActionStop", identifier);
        }
        StaticFunExtend.println("exception deal result:" + result);
        return result;
    }
    /**
     * 异常时终止和暂停实例
     * @param workid    实例id
     * @param trackid   路径id
     * @param tenantid  租户id
     * @param className 终止还是暂停操作类路径
     * @param identifier    数据源标识符
     * @return  成功true
     */
    private boolean stopOrPauseWorkForException(String workid, String trackid, String tenantid, String className,
            String identifier) {
        // 1.打开实例
        WorkParaBean paraBean = new WorkParaBean();
        paraBean.setFlowIdentifier(identifier);
        paraBean.setUserId(StaticVarExtend.System_Id);
        paraBean.setTrackId(trackid);
        paraBean.setWorkId(workid);
        paraBean.setTenantCode(tenantid);

        IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator();
        IWorkResult resultBean = operator.openNotExeOpenEvent(paraBean);
        if (resultBean.getResult() == StaticVarExtend.Init_Success) {
            // 2.执行操作
            paraBean.setActionClass(className);
            paraBean.setSubmitflag("0");
            if ("com.horizon.wf.action.ActionStop".equals(className)) {
            } 
            else {
                // 20150921 liys 异常处理会重复执行,如果是暂停状态,则不能执行恢复,此处需要判断并忽略
                if (StaticVarExtend.FlowStatus_Pause == resultBean.getCurTrackInfo().getFlowstatus()) {
                    // 已经是暂停状态时,忽略处理
                	operator.close(workid, trackid, StaticVarExtend.System_Id);
                    return true;
                }
            }
            resultBean = operator.operator(paraBean);
            if (resultBean.getResult() == StaticVarExtend.F_STATUS_Success) {
                return true;
            }
        }
        operator.close(workid, trackid, StaticVarExtend.System_Id);
        return false;
    }

    /**
     * 异常处理跳转
     * 
     * @param wpb
     *            前台参数
     * @param nextNodeId
     *            跳转的节点
     * @return 跳转是否成功
     */
    private boolean gotoAction(WorkParaBean wpb, String nextNodeId) {
        IWorkflowOperator wo = WorkflowFactory.getWorkflowOperator();
        String workid = wpb.getWorkId();
        String trackid = wpb.getTrackId();
        wo.close(workid, trackid, wpb.getUserId());

        WorkParaBean workPara = new WorkParaBean();
        workPara.setUserId(StaticVarExtend.System_Id);

        workPara.setWorkId(workid);
        workPara.setNodeId(wpb.getNodeId());
        workPara.setTrackId(trackid);
        workPara.setFlowIdentifier(wpb.getFlowIdentifier());
        workPara.setDataIdentifier(wpb.getDataIdentifier());
        workPara.setBussinessClass(wpb.getBussinessClass());
        workPara.setComment(wpb.getComment());
        workPara.setUrlApp(wpb.getUrlApp());
        workPara.setTitle(wpb.getTitle());
        workPara.setSxComment(wpb.getSxComment());
        workPara.setOtherPara(wpb.getOtherPara());
        workPara.setFlowVarMap(wpb.getFlowVarMap());

        IWorkResult wr = wo.openNotExeOpenEvent(workPara);
        if (StaticVarExtend.Init_Success == wr.getResult()) {
            workPara.setFunname(StaticVarExtend.OPERATOR_FUNNAME_GOTO);
            workPara.setNextNodeId(nextNodeId);
            workPara.setActionClass("com.horizon.wf.action.ActionGoto");
            wr = wo.operator(workPara);
            if (StaticVarExtend.F_STATUS_Success == wr.getResult()) {
                StaticFunExtend.println("[msg]exception deal goto success.");
                return true;
            }
        }
        wo.close(workid, trackid, StaticVarExtend.System_Id);
        StaticFunExtend.println("[msg]exception deal goto error.result:" + wr.getResult() + ";backmsg:"
                + wr.getBackMsg());
        return false;
    }

    /**
     * 根据给定的code在列表exceptions中查找IXmlException对象
     * 
     * @param code
     *            异常定义代码
     * @param exceptions
     *            节点设置的异常信息xml
     * @return 匹配后的异常信息
     */
    public INodeException getExceptionByCode(String code, List<INodeException> exceptions) {
        if (CollectionUtil.isListNotEmpty(exceptions)) {
            for (INodeException e : exceptions) {
                if (code.equals(e.getExceptionCode())) {
                    return e;
                }
            }
        }
        return null;
    }

    /**
     * 获取流程创建者
     * 
     * @param work
     *            实例对象
     * @return 创建者
     */
    private String getFlowCreator(DBWork work) {
        String creator = work.getCreator();
        return creator;
    }

    /**
     * 激活不活动的节点
     * 
     * @param workid
     *            实例id
     * @param trackid
     *            路径id
     * @param   actionname
     *          操作名称           
     * @param interfaceClass
     *            接口类
     * @param identifier
     *            数据库标示符
     * @return 激活是否成功
     */
    public boolean activeTrigger(String workid, String trackid, String actionname, String interfaceClass,
            String identifier) {
        String tenantid = ThirdAdapterFactory.getTenantidByIdentifier(identifier);
        try {
            IWorkflowManager iwm = WorkflowFactory.getWorkflowManager();
            if (iwm.activeTrack(workid, trackid, actionname, interfaceClass, tenantid, identifier)) {
                XMLTodoPub.startThreadForNoActiveMsg(workid, trackid, identifier);// 激活时发送待办
                return true;
            } 
            else {
                handleException(workid, trackid, tenantid, identifier,
                        StaticVarExtend.Exception_Code_NodeAutoActivation);
                return false;
            }
        } 
        catch (Exception e) {
            handleException(workid, trackid, tenantid, identifier, StaticVarExtend.Exception_Code_NodeAutoActivation);
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 根据给定的参数处理异常 用系统用户打开流程，查找异常信息,处理异常 未打开流程时刻调用该方法处理
     * 
     * @param workid
     *            实例id
     * @param trackid
     *            路径id
     * @param   tenantid
     *          租户id           
     * @param identifier
     *            数据源标识
     * @param exceptionCode
     *            异常代码
     */
    public void handleException(String workid, String trackid, String tenantid, String identifier, String exceptionCode) {
        IWorkflowOperator ica = WorkflowFactory.getWorkflowOperator(); // 流程操作对象
        try {
            WorkParaBean xfb = new WorkParaBean(); // 操作参数对象
            xfb.setUserId(StaticVarExtend.System_Id); // 当前操作人id
            xfb.setFlowIdentifier(identifier); // 流程数据的数据源
            xfb.setWorkId(workid);
            xfb.setTrackId(trackid);
            IWorkResult wb = ica.open(xfb); // 打开实例
            IFlowNode node = wb.getCurFlowNode();
            INodeException exception = getExceptionByCode(exceptionCode, node.getExceptions());
            handleException(exception, node,xfb, wb.getRunningdata());
        } 
        catch (Exception e) {
            e.printStackTrace();
        } 
        finally {
            ica.close(workid, trackid, StaticVarExtend.System_Id);
        }
    }

    /**
     * 当前流程是否第一次启动
     * 
     * @param trackId   路径id
     * @param identifier 数据源标识
     * @return true:第一次启动
     */
    private boolean isFirstStart(String trackId, String identifier) {
        String sql = "select * from " + StaticVarExtend.Table_Track + " where id=?";
        List<String> conditionList = new ArrayList<String>();
        conditionList.add(trackId);
        int counts = AccessUtil.getInstance().getRsCount(sql, conditionList, identifier);
        return counts == 0;
    }

    /**
     * 生成管理操作日志
     * 
     * @param para
     *            workid 实例id trackid 路径id identifier 数据库标示符 actionname 操作名称
     *            actionUserid 操作人id actionUsername 操作人名称 comments 意见记录内容
     * @return 日志类
     */
    private DBLog makeDbLog(Map<String, String> para) {
        String workid = para.get("workid");
        String trackid = para.get("trackid");
        String actionname = para.get("actionname");
        String memo = para.get("memo");
        String actionUserid = para.get("actionUserid");
        String actionUsername = para.get("actionUsername");
        String identifier = para.get("identifier");

        DBLog trackLog = new DBLog();
        if (StringUtilExtend.isNotNull(workid)) {
            DBWork work = DBWork.getWorkById(null, workid, identifier);
            if (null != work) {
                trackLog.setFlowid(work.getFlowid()); // 流程id
                trackLog.setFlowname(work.getFlowname()); // 流程name
                trackLog.setTitle(work.getTitle());
            }
        }
        if (StringUtilExtend.isNotNull(trackid)) {
            String trackSql = "select * from " + StaticVarExtend.Table_Track + " where id=?";
            List<String> conditionList = new ArrayList<String>();
            conditionList.add(trackid);
            DBTrack track = AccessUtil.getInstance().getSingleObject(trackSql, conditionList, DBTrack.class, identifier);
            trackLog.setAction(track.getFunname()); // 操作名称
            trackLog.setNodeid(track.getNodeid());
            trackLog.setNodename(track.getNodename());
        }
        trackLog.setActionname(actionname);
        trackLog.setActiontime(DateUtil.getNow()); // 操作时间
        trackLog.setId(StaticFunExtend.getUnid());
        trackLog.setWorkid(workid);
        trackLog.setTrackid(trackid);
        trackLog.setUserid(actionUserid);
        trackLog.setUsername(actionUsername);
        trackLog.setSxcomments("");// 手写意见id
        trackLog.setLimittime("0");
        trackLog.setMemo(memo);// 
        trackLog.setIsover("0");
        trackLog.setDotime(DateUtilExtend.getSubtractDHM(DateUtilExtend.getNow(), DateUtilExtend.getNow()));
        trackLog.setDotimemin("0");
        return trackLog;
    }

    /**
     * 生成管理操作日志,由管理员操作时使用
     * @param   para
     *      生成日志需要的信息
     * @return 日志类
     */
    public DBLog makeDbLogForMgr(Map<String, String> para) {
        return makeDbLog(para);
    }

    /**
     * 生成后台操作日志,用于异常/定时任务执行时使用
     * 
     * @param   para
     *      生成日志需要的信息
     * @return 日志类
     */
    public DBLog makeDbLogForSys(Map<String, String> para) {
        return makeDbLog(para);
    }
    /**
     * 判断给定的类型是否为普通节点
     * 允许退回的节点,可以选择协办的节点
     * @param nodetype
     * @return
     */
    public boolean isNormalNode(int nodetype){
    	if(nodetype == NodeTypeEnum.Node_Progressively ||
    		(nodetype >= NodeTypeEnum.Node_Single && nodetype < NodeTypeEnum.Node_Auto)
		   ) {
			return true;
		}
		return false;
    }
    /**
     * 是否为自动节点/事件节点/子流程节点/网关节点
     * >40 <100 !=50
     * @param nodetype
     * @return
     */
    public boolean isSpecialNode(int nodetype){
    	if(nodetype == NodeTypeEnum.Node_Progressively 
    			|| nodetype < NodeTypeEnum.Node_Auto 			
    			|| nodetype >= NodeTypeEnum.Node_End  ){
    		return false;
    	}
    	return true;
    }
    
    /**
     * 是否为子流程节点
     * @param nodetype
     * @return
     */
    public boolean isSubFlowNode(int nodetype){
    	if(NodeTypeEnum.Node_Sub == nodetype){
    		return true;
    	}
    	return false;
    }
    
    /**
     * 判断给定的类型是否为自动节点
     * 
     * @param nodetype
     *            节点类型
     * @return  true是
     */
    public boolean isAutoNode(int nodetype) {
        if (NodeTypeEnum.Node_Auto == nodetype || NodeTypeEnum.Node_Auto_Program == nodetype
                || NodeTypeEnum.Node_Auto_Rule == nodetype || NodeTypeEnum.Node_Auto_Service == nodetype) {
            return true;
        }
        return false;
    }

    /**
     * 判断给定的类型是否为事件节点
     * 
     * @param nodetype  节点类型
     * @return true是
     */
    public boolean isEventNode(int nodetype) {
        if (NodeTypeEnum.Node_Event_Timer == nodetype || NodeTypeEnum.Node_Event_Message == nodetype
                || NodeTypeEnum.Node_Event_Signal_Catch == nodetype || NodeTypeEnum.Node_Event_Signal_Throw == nodetype
                || NodeTypeEnum.Node_Event_Intermediate == nodetype) {
            return true;
        }
        return false;
    }

    /**
     * 判断给定的类型是否为网关节点
     * 
     * @param nodetype
     *            节点类型
     * @return  true是
     */
    public boolean isGateWayNode(int nodetype) {
        if (NodeTypeEnum.Node_GateWay_Merge == nodetype || NodeTypeEnum.Node_GateWay_Split == nodetype) {
            return true;
        }
        return false;
    }

    /**
     * 判断给定的类型是否为自动开始节点
     * 
     * @param nodetype
     *            节点类型
     * @return  true是
     */
    public boolean isAutoStartNode(int nodetype) {
        if (NodeTypeEnum.Node_Timer_Start == nodetype || NodeTypeEnum.Node_Msg_Start == nodetype
                || NodeTypeEnum.Node_Signal_Start == nodetype) {
            return true;
        }
        return false;
    }

    /**
     * 是否是开始节点
     * 
     * @param nodetype
     *            节点类型
     * @return  true 是
     */
    public boolean isStartNode(int nodetype) {
        if (isAutoStartNode(nodetype) || NodeTypeEnum.Node_Start == nodetype) {
            return true;
        }
        return false;
    }

    /**
     * 判断给定的类型是否为结束节点
     * 
     * @param nodetype
     *            节点类型
     * @return  true是
     */
    public boolean isEndNode(int nodetype) {
        if (NodeTypeEnum.Node_End == nodetype || NodeTypeEnum.Node_End_Instance == nodetype) {
            return true;
        }
        return false;
    }
    /**
     * 判断给定的类型是否为实例结束节点
     * 
     * @param nodetype
     *            节点类型
     * @return  true是
     */
    public boolean isEndInstanceNode(int nodetype) {
        if (NodeTypeEnum.Node_End_Instance == nodetype) {
            return true;
        }
        return false;
    }

    /**
     * 撤办时标记定时任务
     * @param status    状态
     * @param nodetype  节点类型
     * @param rd        运行期对象
     * @param identifier    数据源标识
     */
    public void dowithTimer(String status, int nodetype, RunningData rd, String identifier) {
        String curNodeid = rd.getCurFlowNode().getNodeid();
        String trackid = rd.getCurTrack().getId();

        dowithTimer(status, nodetype, curNodeid, trackid, rd, identifier);
    }
    /**
     * 标记定时任务
     * @param status        暂停还是恢复
     * @param nodetype      节点类型
     * @param nodeid        节点id
     * @param trackid       路径id
     * @param rd            运行期对象
     * @param identifier    数据源标识
     */
    public void dowithTimer(String status, int nodetype, String nodeid, String trackid, RunningData rd,
            String identifier) {
        // 自动节点，事件节点，网关节点，自动程序
        if (isAutoNode(nodetype) || isEventNode(nodetype)) {
            ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
            Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
            String workid = rd.getWork().getId();
            if ("restore".equals(status)) {// 恢复实例
                changeTriggerStatus("0", "1", StaticVarExtend.Table_Node_Message_Trigger, saveMap, workid, trackid,
                        nodeid);
                changeTriggerStatus("0", "1", StaticVarExtend.Table_Node_Task_Trigger, saveMap, workid, trackid, nodeid);
                changeTriggerStatus("0", "1", StaticVarExtend.Table_Node_Signal_Trigger, saveMap, workid, trackid,
                        nodeid);
                ti.restore(workid, nodeid, saveMap, identifier);
            } 
            else {// 暂停实例
                changeTriggerStatus("1", "0", StaticVarExtend.Table_Node_Message_Trigger, saveMap, workid, trackid,
                        nodeid);
                changeTriggerStatus("1", "0", StaticVarExtend.Table_Node_Task_Trigger, saveMap, workid, trackid, nodeid);
                changeTriggerStatus("1", "0", StaticVarExtend.Table_Node_Signal_Trigger, saveMap, workid, trackid,
                        nodeid);
                ti.pause(workid, nodeid, saveMap, identifier);
            }
            if (!saveMap.isEmpty()) {
                for (Map.Entry<String, List<Object>> e : saveMap.entrySet()) {
                    rd.putSQLToDataMap(e.getKey(), e.getValue());
                }
            }
        }
    }

    /**
     * 恢复消息记录   
     * @param oldstatus 旧状态
     * @param newstatus 新状态
     * @param tablename 表名
     * @param saveMap   需要保存数据的sql和对应的参数
     * @param workid    实例id
     * @param trackid   路径id
     * @param curNodeid 当前节点id
     */
    private void changeTriggerStatus(String oldstatus, String newstatus, String tablename,
            Map<String, List<Object>> saveMap, String workid, String trackid, String curNodeid) {
        String updateMsg = "update " + tablename
                + "  set status=? where workid=? and trackid=? and nodeid=? and status=?";
        List<Object> msgCondition = new ArrayList<Object>();
        msgCondition.add(newstatus);
        msgCondition.add(workid);
        msgCondition.add(trackid);
        msgCondition.add(curNodeid);
        msgCondition.add(oldstatus);
        saveMap.put(updateMsg, msgCondition);
    }

    /**
     * 从当前节点定义中获取表单id
     * 
     * @param curNode   节点定义
     * @param curUser   当前人信息
     * @return  表单id数组
     */
    public String[] setFormIdsByRunningdata(IFlowNode curNode, IRunUser curUser) {
        String[] formids = null;
        // 获取当前人有权限的表单
        String controlNodeName = curUser.getControlNodeName();
        INodeControl control = curNode.getParticipantsControl(controlNodeName);
        // String s = control.asXML();
        if (null != control) {
            List<INodeForm> nodeForms = control.getAllNodeForms();
            if (CollectionUtil.isListNotEmpty(nodeForms)) {
                formids = new String[nodeForms.size()];
                for (int i = 0; i < nodeForms.size(); i++) {
                    String formid = nodeForms.get(i).getFormid();
                    formids[i] = formid;
                }
            }
        }
        return formids;
    }

    /**
     * 根据相对关系获取相对人员
     *  
     * @param runningdata   运行期对象
     * @param sb            返回数据存放buffer
     * @param baseNode      基准节点
     * @param baseTemp      基准
     * @param relation      关系
     * @param authname      权限类型
     * @return 返回空表示不需要进行组织相对运算,结果已放入sb中,不为空则为相对人员     
     */
    public String getSingleRelation(RunningData runningdata, StringBuilder sb, String baseNode, int baseTemp,
            String relation, String authname) {
        String creator = runningdata.getCreatorFullName();
        if ("0".equals(baseNode)) {
            // 基准只有无0和流程启动者2
            if (baseTemp == 0) {
                if ("10".equals(relation) || "Creator".equals(relation)) {
                    // 流程启动者
                    sb.append(StaticVar.UserSplitChar);
                    sb.append(creator);
                } 
                else if ("0".equals(relation) || "PreDone".equals(relation)) {
                    // 当前节点历史办理人()
                    sb.append(StaticVar.UserSplitChar);
                    // HZWF-637 liys 20151012
                    // sb.append(runningdata.getCurUser().getUserid());
                    sb.append(runningdata.getPreNodeAuthor(authname));
                } 
                else if ("CurUser".equals(relation)) {
                    sb.append(StaticVar.UserSplitChar);
                    //WFMS-971
                    sb.append(runningdata.getCurUser().getFullName());
                }
                return "";
            } 
            else if (baseTemp == 2 || baseTemp == 3) {
                String author ;
                if (baseTemp == 2) {
                    author = creator;
                } else  {
                    author = runningdata.getCurUser().getFullName();
                }
                // 基准流程启动者2
                if ("99".equals(relation)) {
                    sb.append(StaticVar.UserSplitChar);
                    sb.append(author);
                    return "";
                } else {
                    return author;
                }
            }
            else {
                return "";
            }
        } 
        else {
            String author ;
            if ("1".equals(baseNode)) {// 上一节点
                author  = runningdata.getPreNodeAuthor(authname);// 获取上一节点办理人

            } else {
                author = runningdata.getNodeAuthor(baseNode, authname);
            }

            if ("99".equals(relation)) {
                sb.append(StaticVar.UserSplitChar);
                sb.append(author);
                return "";
            } else {
                return author;
            }
        }
    }
}
