package com.horizon.wf.action.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.action.common.ActionExtraData;
import com.horizon.wf.api.common.SerializableUtil;
import com.horizon.wf.config.AuthEnum;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.DateUtil;
import com.horizon.wf.tools.CStrUtil;

/**
 * 子流程结束时的处理
 * 20161122
 * @author liys
 */
public class SubflowEnd {
	private BaseAction  action;
	private RunningData runningdata;
	private PubInfo pubInfo;
	private String workid,identifier;
	
	private boolean mainInstanceIsContinue = false;
	private DBRelationSubflow dRelation = null;
	/**
     * 数据库读写对象
     */
//	private IDBAccess db;
	public SubflowEnd(BaseAction action){
		this.action = action;
		this.runningdata = action.getRunningData();
	}
	
	/**
	 * 子流程结束时的额外处理
	 * 对于内嵌的子流程,需要额外判断处理
	 */
	public boolean doWithSubFlowEnd(){
		String parentworkid = runningdata.getWork().getParentworkid();
		runningdata.putMsgToConsole("[msg]parentworkid:"+parentworkid);	
		if(StringUtilExtend.isNull(parentworkid)){
			//没有父流程时的结束,直接返回true
			return true;
		}
		 // 获取语言包对象
        pubInfo = action.pubInfo;
        workid = action.getWorkid();
        identifier = action.getIdentifier();

		dRelation = DBRelationSubflow.getRelationBySubworkid(workid,identifier);
		if(dRelation ==null){
			runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg0003","未能获取到跟主流程的关联数据."));
			return false;
		}
		//获取对应的主流程Trackid
		if(!( parentworkid.equals(dRelation.getWorkid()))){
			runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg0004",
					"跟主流程的关联数据异常.(subworkid=|subworkid|,workid=|workid|,parentworkid=|parentworkid|)")
					.replace("|subworkid|", dRelation.getSubworkid())
					.replace("|workid|", dRelation.getWorkid())
					.replace("|parentworkid|",parentworkid));
			return false;
		}

		//更新关联数据
		updateRelation(dRelation);
		updateRecord();

		int r = Integer.parseInt(dRelation.getWaitreturn());
		//主流程是否等待子流程返回  0:不等待  1：等待	 2: 子流程节点的等待
		 if(r > 0 && dRelation.checkSubFlowIsAllEnd(identifier)){
			if(r == 1){
				//通知主流程办理人
				makeReadToParent();
			}
		 	else if(r == 2){
				//标记是否需要驱动主流程往下流转
				mainInstanceIsContinue = true;
			}
		}

		return true;
	}

	/**
	 * 子流程结束时,更新关联表的subflowend=1
	 */
	private void updateRelation(DBRelationSubflow dRelation){
		String relationSQL = "UPDATE "+StaticVarExtend.Table_Relation_Subflow +" SET SUBFLOWEND='1' WHERE ID=?";
		List<Object> para = new ArrayList<Object>();
		para.add(dRelation.getId());
		runningdata.putSQLToDataMap(relationSQL, para);
		runningdata.putMsgToConsole("[msg]update DBRelationSubflow end.");
	}

	/**
	 * 子流程结束时,更新记录表的subflowvardata
	 */
	private void updateRecord(){
		Map<String, String>	flowVarMap = runningdata.getInitData().getFlowVarMap();
		StringBuilder recordSql = new StringBuilder();
		recordSql.append("UPDATE ").append(StaticVarExtend.Table_Subflow_Record)
				.append(" SET SAVETIME=?,SUBFLOWEND='1'");
		List<Object> para = new ArrayList<Object>();
		para.add(DateUtilExtend.getNow());

		if(CollectionUtil.isMapNotEmpty(flowVarMap)){
			recordSql.append(",SUBFLOWVARDATA=?");
			//更新子流程记录表,主要用于变量的传递
			para.add(CStrUtil.encode(SerializableUtil.objectToString(flowVarMap)));
		}

		recordSql.append("WHERE SUBWORKID=?");
		para.add(workid);

		//将子流程中的全部流程变量序列化后存入
		runningdata.putSQLToDataMap(recordSql.toString(), para);
		runningdata.putMsgToConsole("[msg]update flowvar map.");
	}

	private void makeReadToParent(){
		//查找主流程的待办
		String sql = DBTodo.SelectFromTodo +" WHERE TRACKID=? AND STATUS_NO = ?";
		List<Object> para = new ArrayList<Object>();
		para.add(dRelation.getTrackid());
		para.add(AuthEnum.getStatusNo("Author"));
		List<DBTodo> todoLst = DBTodo.getTodoListBySQL(sql,para,identifier);
		for(DBTodo todo:todoLst){
			//标识此对象为子流程结束时,发送通知给主流程办理人
			todo.noticeParentWhenSubEnd();
			todo.setStatus(StaticVarExtend.AUTH_READER);
			todo.setTitle(action.ac.getTodoTitle(todo.getTitle(),runningdata,"Sub"));
			todo.setSendtime(DateUtil.getNow());
			todo.setIsactive("1");
			action.todoLst.add(todo);
		}
	}

	/**
	 * 主流程实例调度往下流转
	 * @return
	 */
	public boolean mainInstanceContinue(Map<String, List<Object>> saveMap,List<Object> taskLists){
		if(mainInstanceIsContinue){
			//为主流程实例
			String workid 	= dRelation.getWorkid();
			String trackid 	= dRelation.getTrackid();
			String nodeid	= dRelation.getNodeid();

			Map<String,String> para = new HashMap<String,String>();
			para.put("flowname","");
			para.put("nodename","");
			para.put("nodeid",nodeid);
			para.put("workid",workid);
			para.put("version","0");
			para.put("trackid",trackid);
			para.put("tenantid",runningdata.getInitData().getTenantid());
			para.put("identifier",runningdata.getInitData().getFlowIdentifier());

			Object task = ActionExtraData.getInstance().addMainSubmitTaskForSubEnd(saveMap,para);
			if (null == task) {
				runningdata.setBackMsg(pubInfo.getInfo("Action_Msg0051","定时任务创建失败"));
				return false;
			}

			taskLists.add(task);
		}
		return true;
	}
}
