package com.horizon.wf.action.base;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.api.common.SerializableUtil;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.entity.db.DBSubflowRecord;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.*;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

/**
 * 启动子流程的处理
 * 20161123
 * @author liys
 *
 */
public class StartSubflow {
	private RunningData runningdata;
	private IFlowNode xmlNode;
	private String nodeid,trackid;	//子流程所在的节点和路径
	
	private String author = "";
	private DBRelationSubflow relationSubflow;
	private List<List<String>> paraVarList = new ArrayList<List<String>>();//存放子流程传入主流程的变量
	
	public StartSubflow(RunningData runningdata,PubInfo pubInfo,IFlowNode xmlNode,String trackid){
		this.runningdata = runningdata;
		this.xmlNode = xmlNode;
		this.nodeid = xmlNode.getNodeid();
		this.trackid = trackid;
	}
	public void setAuthor(String author){
		this.author = author;
	}
	public DBRelationSubflow getDBRelationSubflow(){
		return relationSubflow;
	}
	/**
	 * 启动流程并提交到第一个节点,如果不能提交到第一个节点则返回启动失败
	 * @param subFlowInfo 
	 * @return
	 */
	public IWorkResult startAndSaveFlow(INodeSubflow subFlowInfo){
		String flowid = subFlowInfo.getSubFlowId();
		if(StringUtilExtend.isNull(flowid)){
			return null;
		}
		IRunUser curUser = runningdata.getCurUser();
		WorkParaBean para = new WorkParaBean();//getHumanComputer().getWorkParaBean();
		para.setUserId(curUser.getFullName());
		para.setUserName(curUser.getUsername());
		para.setSubjection("");
		para.setFlowId(flowid);
		para.setWorkId("");
		para.setTrackId("");
		para.setNodeId("");
		para.setActionClass("");
		para.setSubmitflag("0");
		para.setTenantCode(runningdata.getInitData().getTenantid());
		para.setFlowIdentifier(runningdata.getInitData().getFlowIdentifier());
		para.setDataIdentifier(runningdata.getInitData().getDataIdentifier());
		para.setParentWorkid(runningdata.getWork().getId());
		//确定是否由前台指定了接收人
		if(StringUtilExtend.isNotNull(author)){
			Map<String,String> selectAuthorMap = new HashMap<String,String>();
			selectAuthorMap.put(StaticVarExtend.AUTH_AUTHOR, author);
			para.setSelectAuthorMap(selectAuthorMap);
		}
		//把主流程的变量传入子流程中
		paraVarList = new ArrayList<List<String>>();//存放子流程传入主流程的变量
		doWithParentWorkData(para,subFlowInfo);
		
		String oldThreadName = Thread.currentThread().getName();
		runningdata.putMsgToConsole("[Msg]Create Sub Instance.......Start");
		IWorkflowOperator iwo = WorkflowFactory.getWorkflowOperator();
		
		//**********不立即保存数据*************
		para.setMultiInstanceTransaction(true);
		
		IWorkResult wr = iwo.create(para);
		Thread.currentThread().setName(oldThreadName);
		runningdata.putMsgToConsole("[Msg]Create Sub Instance.......End");
//		不能自动提交到第一个节点时,如果算启动失败,则需要下面的代码
		IFlowNode curNode = wr.getCurFlowNode();
		if(curNode == null){
			return wr;
		}

		if(wr.getResult() == StaticVarExtend.Init_Success){
			makeSubFlowRecord(wr);
			makeRelationSubflow(flowid,wr);
		}
		return wr;
	}	
	
	/**
	 * 处理主子流程之间的数据
	 */
	private void doWithParentWorkData(WorkParaBean subParaBean, INodeSubflow parentSubFlowInfo) {
		List<List<String>> parasList = parentSubFlowInfo.getSubFlowParaList();
		if(CollectionUtil.isListNotEmpty(parasList)){
			for(int i=0,n=parasList.size();i<n;i++){
				List<String> para = parasList.get(i);
				//in表示传入,由主流程传入子流程
				if(StaticVarExtend.SUBFLOW_IN.equalsIgnoreCase(para.get(2))){
					String mainFlowPara = para.get(0);
					String value = runningdata.getFlowVar().getValue(mainFlowPara);
					//para.get(1)子流程变量id  para.get(0)主流程变量id
					subParaBean.putFlowVar(para.get(1),value);
				}else if(StaticVarExtend.SUBFLOW_OUT.equalsIgnoreCase(para.get(2))){
					paraVarList.add(para);
				}else if(StaticVarExtend.SUBFLOW_INOUT.equalsIgnoreCase(para.get(2))){
					String mainFlowPara = para.get(0);
					String value = runningdata.getFlowVar().getValue(mainFlowPara);
					//para.get(1)子流程变量id  para.get(0)主流程变量id
					subParaBean.putFlowVar(para.get(1),value);
					paraVarList.add(para);
				}
			}
		}
	}
	
	/**
	 * 添加子流程数据记录
	 * @param wr
	 */
	private void makeSubFlowRecord(IWorkResult wr) {
		DBSubflowRecord subflowRecord = new DBSubflowRecord(); 
		subflowRecord.setId(StaticFunExtend.getUnid());
		subflowRecord.setParentnodeid(nodeid);
		subflowRecord.setParenttrackid(trackid);
		subflowRecord.setParentworkid(runningdata.getWork().getId());
		String subtoparentdata = "";
		//要传入主流程的变量
		if(CollectionUtil.isListNotEmpty(paraVarList)){
			subtoparentdata = CStrUtil.encode(SerializableUtil.objectToString(paraVarList));
		}
		subflowRecord.setSubtoparentdata(subtoparentdata);
		subflowRecord.setSubflowvardata("");
		subflowRecord.setSubworkid(wr.getWorkid());
		subflowRecord.setSubflowend("0");

		int version = runningdata.getWork().getVersion();
		if(xmlNode.getNodeid().equals(runningdata.getCurFlowNode().getNodeid())){
			//启动子流程操作时,是在saveWork之前执行,所以需要+1
			version += 1;
		}
		subflowRecord.setVersion(version);
		subflowRecord.setSavetime(DateUtilExtend.getNow());
		Map<String, List<Object>> dataMap = new LinkedHashMap<String, List<Object>>();
		subflowRecord.getSQL(dataMap,runningdata.getResultJson());
		
		for(Map.Entry<String, List<Object>> e : dataMap.entrySet()){
			runningdata.putSQLToDataMap(e.getKey(), e.getValue());
		}
	}
	/**
	 * 生成主子流程关联数据
	 * @param subflowid
	 * @param wr
	 */
	private void makeRelationSubflow(String subflowid, IWorkResult wr) {
		relationSubflow = new DBRelationSubflow();
		relationSubflow.setId(StaticFunExtend.getUnid()); 
		relationSubflow.setFlowid(runningdata.getWork().getFlowid());
		relationSubflow.setFlowname(runningdata.getWork().getFlowname());
		relationSubflow.setNodeid(nodeid);
		relationSubflow.setNodename(xmlNode.getNodename());
		relationSubflow.setSubflowend("0");
		relationSubflow.setSubflowid(subflowid);
		relationSubflow.setSubflowname(wr.getWork().getFlowname());
		relationSubflow.setSubworkid(wr.getWorkid());
		relationSubflow.setTitle(wr.getWork().getTitle());
		relationSubflow.setTrackid(trackid);
		relationSubflow.setVersion(runningdata.getWork().getVersion()+1);
		//不等待为0,正常节点上的子流程等待状态=1,子流程节点上的等待=2,
		String  waitReturn = "0";
		if(xmlNode.getSubFlowWait()){
			if(xmlNode.getNodeid().equals(runningdata.getCurFlowNode().getNodeid())){
				waitReturn = "1";
			}
			else{
				waitReturn = "2";
			}
		}
		relationSubflow.setWaitreturn(waitReturn);
		relationSubflow.setWorkid(runningdata.getWork().getId());
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		relationSubflow.getSQL(saveMap,runningdata.getResultJson());
		for(Map.Entry<String, List<Object>> e : saveMap.entrySet()){
			runningdata.putSQLToDataMap(e.getKey(), e.getValue());
		}
	}
}
