package com.horizon.wf.action.base;

import java.util.List;
import java.util.Map;

import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBMutualTask;
import com.horizon.wf.entity.db.DBRelationSubflow;

public interface IActionForStartSubFlow {

	/**
     * 获取运行环境对象
     * @return  运行环境对象
     */
    public RunningData getRunningData();
    /**
     * 获取语言文件对象
     * @return
     */
    public PubInfo getPubInfo();
    /**
     * 存放操作中需要的办理人
     */
    public Map<String, String> getSelectedUsers();
    /**
     * 存放操作中需要的办理人中文显示名称
     */
    public Map<String, String> getSelectedUserNames();
    
    /**
	 * 获取任务列表对象
	 * @return
	 */
	public List<Object> getTaskLists();
	/**
	 * 获取引擎交互临时数据id
	 */
	public List<DBMutualTask> getMutualLists();
	/**
	 * 获取子流程启动实例的运行期对象
	 * @return
	 */
	public List<RunningData> getSubRunningdatas();
	/**
	 * 所有已经启动的子流程实例
	 * @return
	 */
	public List<DBRelationSubflow> getSubflowWorks();
	 /**
     * 获取租户id
     * @return
     */
    public String getTenantid();
    /**
     * 获取数据源标识
     * 
     * @return 引擎数据源标识
     */
    public String getIdentifier();
	
}
