package com.horizon.wf.action.base;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.xml.IXMLSubFlowInfo;
import com.horizon.wf.definition.xml.IXmlFlowInfo;
import com.horizon.wf.definition.xml.IXmlNode;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

/**
 * 操作返回结果对象
 * 
 * @author liys
 * @version 7.2.2
 */
public class HmiResultBean {
    /**
     * 传入参数对象
     */
    private WorkParaBean workParaBean = new WorkParaBean();
    // ===========返回值参数列表=======================================================
    /**
     * 操作执行结果编号
     */
    private int result;
    /**
     * 操作执行结果提示信息
     */
    private String backMsg;
    /**
     * 当前执行人的信息对象
     */
    private IRunUser curUser;
    /**
     * 运行期对象
     */
    protected RunningData runningdata = null;
    // 打开或者创建实例时,获取实例当前信息的参数
    /**
     * 当前节点定义信息
     */
    private IFlowNode curNode;
    /**
     * 当前实例信息
     */
    private DBWork work;
    /**
     * 当前路径信息
     */
    private DBTrack curTrackInfo = null;
    /**
     * 流程定义信息
     */
    private IFlowInfo flowInfo;
    /**
     * 存放流程变量map
     */
    private Map<String, String> flowVarMap = new HashMap<String, String>();
    /**
     * 操作传入的其他参数
     */
    private Map<String, Object> hashMap = new LinkedHashMap<String, Object>();
    // 操作执行时,涉及到节点变更时需要获取的参数
    // 当前路径
    /**
     * 下一节点列表,提交时带有Line信息,其他操作只有节点Nodeid信息
     */
    private List<INextNode> nextNodes;
    /**
     * 所有需要传入后台的下一节点字符串
     */
    private String nextNodeids;
    /**
     * 前台选择人员设置格式: key=节点id_参与者类型(Author,reader) value=userid(多个使用分号";"分割) 例如：
     * LinkedHashMap<String,String> selectedUsers = new
     * LinkedHashMap<String,String>();
     * selectedUsers.put("Node1_Author","xxxx;yyyyy");
     * selectUsers.put("Node1_Reader","xxxx;yyyyy");
     */
    private Map<String, String> selectAuthorMap = new LinkedHashMap<String, String>(); // 指定的下一节点的办理人
    /**
     * 临时存放的人员信息,此属性暂时无用
     */
    private Map<String, String> tmpAuthorMap = new LinkedHashMap<String, String>(); // 后台取到的xml中的办理人
    /**
     * 定义信息中获取到的人员信息,一般用于前台选择人员时
     */
    private Map<String, String> initAuthorMap = new LinkedHashMap<String, String>(); // 后台取到的xml中的办理人

    /**
     * 已经启动的子流程关联列表
     */
    private List<DBRelationSubflow> subflowWorks = null; // 正在运行的子流程
    /**
     * xml定义中的子流程信息
     */
    private List<INodeSubflow> subflows = null; // 可以启动的子流程
    /**
     * 启动子流程结果对象
     */
    private IWorkResult subflowWorkResult;// 子流程启动成功后返回的对象
    /**
     * 下一节点路径信息对象,用于前台信息显示
     */
    private List<DBTrack> nextTrackInfos;

    /**
     * webservice 返回时,转换成xml格式的字符串
     * 
     */
    protected void forServiceString(StringBuilder sb) {
        CStrUtil.appendTo(sb, "result", String.valueOf(result));
        CStrUtil.appendTo(sb, "backMsg", backMsg);

        CStrUtil.appendTo(sb, "curUser", curUser == null ? "" : curUser.forServiceString());

        CStrUtil.appendTo(sb, "allFormsXml", flowInfo == null ? "" : getXmlStr(flowInfo.getFormsXML()));
        CStrUtil.appendTo(sb, "curNodeXml", curNode == null ? "" : getXmlStr(curNode.getDataString()));
        CStrUtil.appendTo(sb, "work", work == null ? "" : work.forServiceString());

        CStrUtil.appendTo(sb, "curTrackInfo", curTrackInfo == null ? "" :
                curTrackInfo.forServiceString());
        CStrUtil.appendTo(sb, "flowVarMap", flowVarMap);
        CStrUtil.appendTo(sb, "nextNodeids", nextNodeids);
        CStrUtil.appendTo(sb, "selectAuthorMap", selectAuthorMap);
        CStrUtil.appendTo(sb, "initAuthorMap", initAuthorMap);

        if (!(nextTrackInfos == null || nextTrackInfos.isEmpty())) {
            sb.append("<nextTrackInfoList>");
            for (DBTrack t : nextTrackInfos) {
                sb.append(t.forServiceString());
            }
            sb.append("</nextTrackInfoList>");
        }
        if (!(nextNodes == null || nextNodes.isEmpty())) {
            sb.append("<nextNodesList>");
            for (INextNode n : nextNodes) {
                sb.append(n.forServiceString());
            }
            sb.append("</nextNodesList>");
        }

        if (!(subflowWorks == null || subflowWorks.isEmpty())) {
            sb.append("<subflowWorkList>");
            for (DBRelationSubflow sub : subflowWorks) {
                sb.append(sub.forServiceString());
            }
            sb.append("</subflowWorkList>");
        }
        if (!(subflows == null || subflows.isEmpty())) {
            sb.append("<subflowsXmlList>");
            for (INodeSubflow subflow : subflows) {
                sb.append("<xml>");
                sb.append(subflow.getDataString());
                sb.append("</xml>");
            }
            sb.append("</subflowsXmlList>");
        }
        if (subflowWorkResult != null) {
            CStrUtil.appendTo(sb, "subflowWorkResult", subflowWorkResult.forServiceString());
        }
    }
    /**
     * 添加xml头文件
     * @param xml
     * @return xml
     */
    private String getXmlStr(String xml) {
        StringBuilder sb = new StringBuilder(50000);
        sb.append("<xml>").append(xml).append("</xml>");
        return sb.toString();
    }

    /**
     * 传入参数对象
     * 
     * @return  传入参数对象
     */
    public WorkParaBean getWorkParaBean() {
        return workParaBean;
    }

    /**
     * 设置传入参数对象
     * 
     * @param workParaBean
     */
    public void setWorkParaBean(WorkParaBean workParaBean) {
        this.workParaBean = workParaBean;
    }

    /**
     * 获取操作结果编号,编号查阅StaticVarExtends类
     * 
     */
    public int getResult() {
        return result;
    }

    /**
     * 设置操作结果编号
     * 
     * @param result
     */
    public void setResult(int result) {
        this.result = result;
    }

    /**
     * 获取操作执行结果信息
     * 
     * @return
     */
    public String getBackMsg() {
        return backMsg;
    }

    /**
     * 设置操作结果信息
     * 
     * @param backMsg
     */
    public void setBackMsg(String backMsg) {
        this.backMsg = backMsg;
    }

    /**
     * 获取当前执行人的用户信息对象
     */
    public IRunUser getCurUser() {
        return curUser;
    }

    /**
     * 设置当前执行人的用户信息对象
     * 
     * @param curUser
     */
    public void setCurUser(IRunUser curUser) {
        this.curUser = curUser;
    }

    /**
     * 获取运行期的环境对象
     * 
     * @return
     */
    public RunningData getRunningdata() {
        return runningdata;
    }

    /**
     * 设置运行期的环境对象
     * 
     * @param runningdata
     */
    public void setRunningdata(RunningData runningdata) {
        this.runningdata = runningdata;
    }

    /**
     * 获取当前节点定义信息的xml对象
     * 保留此方法仅为了兼容之前的版本
     * 请使用getCurFlowNode方法返回IFlowNode接口
     * @deprecated
     * @return
     */
    public IXmlNode getCurNode() {
        return curNode;
    }
    /**
     * 获取当前节点定义信息的xml对象
     */
    public IFlowNode getCurFlowNode() {
        return curNode;
    }
    /**
     * 设置当前节点定义信息的xml对象
     * 
     * @param curNode
     */
    public void setCurNode(IFlowNode curNode) {
        this.curNode = curNode;
    }

    /**
     * 获取当前实例对象
     * 
     * @return
     */
    public DBWork getWork() {
        return work;
    }

    /**
     * 设置当前实例对象
     * 
     * @param work
     */
    public void setWork(DBWork work) {
        this.work = work;
    }

    /**
     * 获取当前路径信息对象
     * 
     * @return
     */
    public DBTrack getCurTrackInfo() {
        return curTrackInfo;
    }

    /**
     * 设置当前路径信息对象
     * 
     * @param curTrackInfo
     */
    public void setCurTrackInfo(DBTrack curTrackInfo) {
        this.curTrackInfo = curTrackInfo;
    }

    /**
     * 获取当前实例定义的xml对象
     * 
     * @return
     */
    public IFlowInfo getFlowinfo() {
        return flowInfo;
    }
    public IXmlFlowInfo getFlowInfo(){
        return flowInfo;
    }

    /**
     * 设置当前实例定义的xml对象
     * 
     * @param flowInfo
     */
    public void setFlowInfo(IFlowInfo flowInfo) {
        this.flowInfo = flowInfo;
    }

    /**
     * 获取流程定义的流程变量
     * 
     * @return
     */
    public Map<String, String> getFlowVarMap() {
        return flowVarMap;
    }

    /**
     * 设置流程变量
     * 
     * @param flowVarMap
     */
    public void setFlowVarMap(Map<String, String> flowVarMap) {
        this.flowVarMap = flowVarMap;
    }

    /**
     * 获取传入的数据map
     * 
     * @return
     */
    public Map<String, Object> getHashMap() {
        return hashMap;
    }

    /**
     * 设置传入的数据map
     * 
     * @param hashMap
     */
    public void setHashMap(Map<String, Object> hashMap) {
        this.hashMap = hashMap;
    }

    /**
     * 获取下一节点对象列表
     * 
     * @return
     */
    public List<INextNode> getNextNodes() {
        return nextNodes;
    }

    /**
     * 设置下一节点对象列表
     * 
     * @param nextNodes
     */
    public void setNextNodes(List<INextNode> nextNodes) {
        this.nextNodes = nextNodes;
    }

    /**
     * 获取下一节点id
     * 
     * @return
     */
    public String getNextNodeids() {
        return nextNodeids;
    }

    /**
     * 设置下一节点id
     * 
     * @param nextNodeids
     */
    public void setNextNodeids(String nextNodeids) {
        this.nextNodeids = nextNodeids;
    }

    /**
     * 获取办理人信息map
     * 
     * @return
     */
    public Map<String, String> getSelectAuthorMap() {
        return selectAuthorMap;
    }

    /**
     * 设置办理人信息map
     * 
     * @param selectAuthorMap
     */
    public void setSelectAuthorMap(Map<String, String> selectAuthorMap) {
        this.selectAuthorMap = selectAuthorMap;
    }

    /**
     * 获取办理人临时信息map
     * 
     * @return
     */
    public Map<String, String> getTmpAuthorMap() {
        return tmpAuthorMap;
    }

    /**
     * 设置办理人临时信息map
     * 
     * @param tmpAuthorMap
     */
    public void setTmpAuthorMap(Map<String, String> tmpAuthorMap) {
        this.tmpAuthorMap = tmpAuthorMap;
    }

    /**
     * 获取xml定义中的办理人信息map
     * 
     * @return
     */
    public Map<String, String> getInitAuthorMap() {
        return initAuthorMap;
    }

    /**
     * 设置xml定义中的办理人信息map
     * 
     * @param initAuthorMap
     */
    public void setInitAuthorMap(Map<String, String> initAuthorMap) {
        this.initAuthorMap = initAuthorMap;
    }

    /**
     * 获取子流程实例关联列表
     * 
     * @return
     */
    public List<DBRelationSubflow> getSubflowWorks() {
        return subflowWorks;
    }

    /**
     * 设置子流程实例关联列表
     * 
     * @param subflowWorks
     */
    public void setSubflowWorks(List<DBRelationSubflow> subflowWorks) {
        this.subflowWorks = subflowWorks;
    }

    /**
     * 获取xml中定义的子流程定义信息列表
     * 
     * @return
     */
    public List<IXMLSubFlowInfo> getSubflows() {
        List<IXMLSubFlowInfo> subs = new ArrayList<IXMLSubFlowInfo>();
        for(INodeSubflow sub:subflows){
            subs.add(sub);
        }
        return subs;
    }
    public List<INodeSubflow> getNodeSubflows(){
        return subflows;
    }
    /**
     * 设置xml中定义的子流程定义信息列表
     * 
     * @param subflows
     */
    public void setSubflows(List<INodeSubflow> subflows) {
        this.subflows = subflows;
    }

    /**
     * 启动子流程时,执行结果对象
     * 
     * @return
     */
    public IWorkResult getSubflowWorkResult() {
        return subflowWorkResult;
    }

    /**
     * 设置子流程启动结果对象
     * 
     * @param subflowWorkResult
     */
    public void setSubflowWorkResult(IWorkResult subflowWorkResult) {
        this.subflowWorkResult = subflowWorkResult;
    }

    /**
     * 获取下一节点路径信息对象列表
     * 
     * @return
     */
    public List<DBTrack> getNextTrackInfos() {
        return nextTrackInfos;
    }

    /**
     * 设置下一节点路径信息对象
     * 
     * @param nextTrackInfos
     */
    public void setNextTrackInfos(List<DBTrack> nextTrackInfos) {
        this.nextTrackInfos = nextTrackInfos;
    }

}
