package com.horizon.wf.action.base;

import com.horizon.wf.api.mutual.HZInstance;
import com.horizon.wf.entity.db.DBMutualTask;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.plugins.PluginsUtil;

import java.util.ArrayList;
import java.util.List;

public class BaseForTask extends BaseForSubFlow {
	private List<Object> taskLists = new ArrayList<Object>();			//定时任务基类
	private List<DBMutualTask> mutualLists = new ArrayList<DBMutualTask>();			//引擎交互临时数据id
	
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	protected void actionAfterSaveToDB() {
		// 发送定时任务
		if (CollectionUtil.isListNotEmpty(taskLists)) {
			try {
				if (!taskLists.isEmpty()) {
					PluginsUtil.getSingleInstance().getTaskInterface().addTask(taskLists);
				}
			} catch (Exception e) {
				e.printStackTrace();
				runningdata.putMsgToConsole("[msg]add task error!");
			}
		}
		//处理引擎交互临时数据
		if(CollectionUtil.isListNotEmpty(mutualLists)){
			HZInstance.getInstance().sendDataAfterAction(mutualLists,identifier);
		}
	}
	/**
	 * 获取任务列表对象
	 * @return
	 */
	public List<Object> getTaskLists(){
		return taskLists;
	}
	/**
	 * 获取引擎交互临时数据
	 * @return
	 */
	public List<DBMutualTask> getMutualLists(){
		return mutualLists;
	}
}
