package com.horizon.wf.action.base;

import com.horizon.wf.action.common.ActionExtraData;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.DateUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public  class BaseForSubFlow extends BaseAction {
	private List<RunningData> subRunningdatas = new ArrayList<RunningData>();	//所有启动成功后的子流程运行期对象
	private List<DBRelationSubflow> subflowWorks = new ArrayList<DBRelationSubflow>(); //所有已经启动的子流程实例
	
	public boolean execute(ITaskNode curTaskNode) {
		return false;
	}

	protected void actionBeforeForSubFlow(Map<String, List<Object>> saveMap){
		//把子流程启动的SQLMap放入saveMap中
		if(!subRunningdatas.isEmpty()){
			for(int i=0,n=subRunningdatas.size();i<n;i++){
				RunningData subRD=subRunningdatas.get(i);
				
				ActionExtraData.getInstance().putSubMapToMainMap(saveMap, subRD.getFlowMap());
			}
		}
		//根据子流程关联表记录日志
		if(!subflowWorks.isEmpty()){
			for(int i=0,n=subflowWorks.size();i<n;i++){
				DBRelationSubflow subRelation = subflowWorks.get(i);
				DBLog log = new DBLog();
				log.setAction(StaticVarExtend.OPERATOR_FUNNAME_SUBFLOW);
				log.setActionname(pubInfo.getInfo("SubFlow_Msg0001","启动子流程"));
				log.setActiontime(DateUtil.getNow());
				log.setComments("");
				log.setDotime("");
				log.setDotimemin("0");
				log.setFlowid(subRelation.getFlowid());
				log.setFlowname(subRelation.getFlowname());
				log.setIsover("0");
				log.setId(StaticFunExtend.getUnid());
				log.setLimittime("");
				log.setNextnodeids(subRelation.getNodeid());
				log.setNodeid(subRelation.getNodeid());
				log.setNodename(subRelation.getNodename());
				log.setSxcomments("");
				log.setTitle(runningdata.getTitle());
				log.setTrackid(subRelation.getTrackid());
				log.setWorkid(subRelation.getWorkid());
				log.setUserid(StaticVarExtend.System_Id);
				log.setUsername(pubInfo.getInfo("System_Name", "工作流系统"));
				
				String memoStr = pubInfo.getInfo("SubFlow_Msg0009","启动子流程[|flowname|]实例ID[|workid|]")
				.replace("|workid|", subRelation.getSubworkid())
				.replace("|flowname|", subRelation.getSubflowname());
				
				log.setMemo(memoStr);
				
				log.getSQL(saveMap);
			}
		}
	}
	
	protected void actionAfterForSubFlow(){
		//执行子流程启动时的actionAfterSaveToDB方法
		if(!subRunningdatas.isEmpty()){
			for(int i=0,n=subRunningdatas.size();i<n;i++){
				RunningData subRD=subRunningdatas.get(i);
				subRD.excuteAfterSaveToDB_MultiInstanceTransaction();
			}
		}
	}
	
	/**
	 * 获取子流程启动实例的运行期对象
	 * @return
	 */
	public List<RunningData> getSubRunningdatas(){
		return subRunningdatas;
	}
	/**
	 * 所有已经启动的子流程实例
	 * @return
	 */
	public List<DBRelationSubflow> getSubflowWorks(){
		return subflowWorks;
	}
}
