package com.horizon.wf.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 提交操作实现类(不离开节点，可用于协办提交)
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionSubmitNotLeave extends BaseAction implements ICustomAction{

	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_SENCOND_SUBMIT);
		setActionname("Submit_Msg6001","协办提交");
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		String authname = StaticVarExtend.AUTH_SECOND_AUTHOR;//getCurAuthName();
		List<DBWorkAuth> auths = getXAuthList(authname);
		if(CollectionUtil.isListNotEmpty(auths)){
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth a = auths.get(i);
				if(a.equalsRunUser(getCurUser())){
					a.setStatus(StaticVarExtend.AUTH_DONE_SecondSubmit);
					newAuths.add(a);
				}
			}
		}
		runningdata.setCurAuthToMap(newAuths);
		result = StaticVarExtend.F_STATUS_Success;
		msg = pubInfo.getInfo("Submit_Msg6002","协办提交成功（不离开节点）");
		//执行操作完成事件
		executeEventSave();	
		memoBuffer.append(msg);
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		return;
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB(){
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}

}
