package com.horizon.wf.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;

/**
 * 会签提交操作实现类
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.1
 */
public class ActionSubmitHuiqian extends BaseAction implements ICustomAction{
	private List<DBWorkAuth> auths = new ArrayList<DBWorkAuth>();
	/**
	 * 本操作需要执行的内容
	 */
	public boolean execute(ITaskNode curTaskNode){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_HUIQIAN_SUBMIT);
		setActionname("Submit_Msg5001","会签提交");
		//会签提交
		runningdata.putMsgToConsole("[msg]funname:huiqian submit.");
		huiqianSubmit();
		
		runningdata.setCurAuthToMap(auths);
		//执行操作完成事件
		if(StaticVarExtend.F_STATUS_Success == result &&executeEventSave()){
			// 获取当前人有权限的表单
			runningdata.getInitData().setFormids(ac.setFormIdsByRunningdata(getCurFlowNode(), getCurUser()));
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 会签提交
	 */
	private void huiqianSubmit(){
		//会签人列表
		List<DBWorkAuth> hqAuth = new ArrayList<DBWorkAuth>();
		//会签提出人列表
		List<DBWorkAuth> creatorAuth = new ArrayList<DBWorkAuth>();
		//当前正在会签的人员
		hqAuth = getXAuthList(StaticVarExtend.AUTH_HUIQIAN_AUTHOR);
		//所有会签提出人,包含会签再会签人
		creatorAuth = getXAuthList(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR);
		IRunUser curUser = getCurUser();
		//获取当前会签人的权限对象
		DBWorkAuth curAuth = getCurDBWorkAuth(hqAuth,curUser);
		//处理会签
		Map<String,Object> backMap = runningdata.checkAndDoHuiQain(creatorAuth, curAuth);
		//获取当前会签的发起人权限
		DBWorkAuth startAuth = (DBWorkAuth)backMap.get("StartAuth");
		//当前同一次会签是否全部结束
		boolean curUserAllDone = "1".equals(backMap.get("CurUserAllDone"));
		if(curUserAllDone){
			//如果没有其他会签人员,则对会签提出人进行处理
			startAuth.setStatus((String)backMap.get("AuthName"));
			auths.add(startAuth);
			//当前节点的会签是否全部结束
			boolean curNodeAllDone = "1".equals(backMap.get("CurNodeAllDone"));
			if(curNodeAllDone){
				runningdata.getCurTrack().setFlowstatus(StaticVarExtend.FlowStatus_Normal);
				memoBuffer.append(pubInfo.getInfo("Submit_Msg5004","会签提交,会签结束"));
			}
			else{
				memoBuffer.append(pubInfo.getInfo("Submit_Msg5003","会签提交到会签发起人"));
			}
		}
		else{
			memoBuffer.append(pubInfo.getInfo("Submit_Msg5005","会签提交,等待其他会签人"));
		}
		
		//删除当前会签记录
//		deleteHuiqianRecordByToId(curRecord.getId());
		//增加历史记录
//		makeHuiqianRecordVer(curRecord);
		
		msg = pubInfo.getInfo("Submit_Msg5002","会签提交成功");
	}
	/**
	 * 查找当前人的权限对象,并更新状态为已办AUTH_DONE_HUIQIAN
	 * @param list
	 * @param curUser
	 * @return
	 */
	private DBWorkAuth getCurDBWorkAuth(List<DBWorkAuth> list,IRunUser curUser){
		for(int i=0,n=list.size();i<n;i++){
			DBWorkAuth hq = list.get(i);
			if(hq.equalsRunUser(curUser)){
				auths.add(hq);
				hq.setStatus(StaticVarExtend.AUTH_DONE_HUIQIAN);
				return hq;
			}
		}
		return null;
	}
	
	//===========================分割线==============================================	
	/**
	 * 给task表添加数据
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}


	/**
	 * 取消分支时调用
	 */
	public void cancelTrackAction(String arg0, List<DBWorkAuth> arg1) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}

	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		return;
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionBefore(saveMap);
		return saveMap ;
	}
	
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
}
