package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 使用跳转操作实现一个退回后再次提交到退回节点的类
 * 跳转后如果操作人为主办则变为已办、如果操作人为管理员，则发送待阅,如果有其他办理人变为读者
 * @author liys
 * @version 1.0
 * @since v7.0
 * 
 */
public class ActionSubmitForReject extends BaseAction implements ICustomAction {
	//退回时获取原来节点的办理人类型,默认获取退回节点的已办人
	//如果想获取退回节点的办理人,则修改为StaticVarExtend.AUTH_AUTHOR
	private String authType = StaticVarExtend.AUTH_DONE;
	
	public boolean execute(ITaskNode curTaskNode){
		initNextNodePara();//初始化下一节点信息
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_REJECT_SUBMIT);
		setActionname("Submit_Msg4001","退回提交");
		DBTrack curTrack = getCurTrack();
		if(curTrack.getFlowstatus() != StaticVarExtend.FlowStatus_Reject){
			runningdata.putMsgToConsole("[msg]flowstatus!= reject .operator is not surport!");
			msg = pubInfo.getInfo("Submit_Msg4002","当前状态不是退回状态,不能执行退回提交操作.");
			result = StaticVarExtend.F_STATUS_OtherError;
			runningdata.setBackMsg(msg);
			runningdata.setResultCode(result);
			return false;
		}
		//20150629 liys 修改[退回提交]不接收前台传入的节点信息
		nextNodeList = new ArrayList<String>();
		nextNodeId = "";
		//未传入节点时,系统自动获取退回节点
		//获取退回节点信息
		ITrackJson tTrack = curTrack._getTrackJson();
		String doneNodeID = tTrack.getTrueRecord();
		String[] nodes = doneNodeID.split(StaticVar.StrSplitChar);
		
		if(nodes.length>1){
			nextNodeId = nodes[nodes.length-2];
			nextNodeList.add(nextNodeId);
			//获取上一节点已办理人
			doRejectNodeAuthor(curTrack.getId(), nodes.length-2, nextNodeId);
		}
		else{
			//说明之前是分支的情况
			doMuiltRejectNode();
		}
		
		if(null == nextNodeList || nextNodeList.isEmpty()){
			runningdata.putMsgToConsole("[msg]get reject node error");
			msg = pubInfo.getInfo("Submit_Msg4003","获取退回节点失败");
			result = StaticVarExtend.F_STATUS_OtherError;
			runningdata.setBackMsg(msg);
			runningdata.setResultCode(result);
			return false;
		}
		
		
		getCurTrack().setEnd(true);//结束当前节点
		curTaskNode.jumpToOtherNode(nextNodeList, selectedUsers);
		INextNode curNode = curTaskNode.getCurNode();
		result = curNode.getInitResult();
		msg = curNode.getBackMsg();
		List<INextNode> nextNodes = curTaskNode.getGNextNodes();
		if (result == StaticVarExtend.F_STATUS_Success) {
			doWithNextNodeResult(true);
			if(result == StaticVarExtend.F_STATUS_Success){
				msg = pubInfo.getInfo("Submit_Msg4004","退回提交成功");
				dowithCurAuth();//跳转成功后处理当前节点人员
				ac.dowithTimer("cancel", getCurNodeType(), runningdata, getIdentifier());//如果当前节点包含定时任务则撤销定时任务
				//执行操作完成事件
				if(executeEventSave()){
//					selectedUsers = ac.makeAgentUser(selectedUsers, runningdata);
					runningdata.setUpdateTask(true);
				}
				runningdata.putMsgToConsole("[msg]goto operator is success!");
				
				memoBuffer.append(pubInfo.getInfo("Submit_Msg4005","退回提交到节点"));
				for(int i=0,n=nextNodes.size();i<n;i++){
					doMemoFromSelected(nextNodes.get(i));
				}
			}
			
			resultBean.setNextNodes(nextNodes);
		}else{
			runningdata.putMsgToConsole("[msg]goto operator result:"+result+";backmsg:"+msg);
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	/**
	 * 多个节点退回到当前节点时,再次提交的处理
	 */
	private void doMuiltRejectNode(){
		Map<String,String> trackids = runningdata.getPrevNodeid();
		for(String nodeid:trackids.keySet()){
			nextNodeList.add(nodeid);
			String trackid = trackids.get(nodeid);
			int num = getNodeInTrackNum(trackid,nodeid);
			if(num >= 0){
				doRejectNodeAuthor(trackid,num,nodeid);
			}
		}
	}
	/**
	 * 获取节点在路径下最后出现的编号
	 * @return
	 */
	private int getNodeInTrackNum(String trackid,String nodeid){
		String nodes = runningdata.getNodesOfTrackid(trackid);
		if(StringUtilExtend.isNotNull(nodes)){
			String[] nodesArr = nodes.split(StaticVarExtend.UserSplitChar);
			//从后往前查找指定节点
			for(int i = nodesArr.length-1 ; i >= 0 ; i --){
				if(nodeid.equalsIgnoreCase(nodesArr[i])){
					return i;
				}
			}
		}
		return -1;
	}
	
	/**
	 * 退回节点办理人处理
	 */
	private void doRejectNodeAuthor(String trackid,int num,String nodeid){
		//获取上一节点已办理人
        String doneUsers = getUserFromTrackNode(trackid,num,nodeid,authType);
		//增加内部循环节点时,判断已办人是否多于一个,如果多于一个则默认只获取最后一个
		IFlowNode xmlNode = getRunningData().getInstanceDefinition().getFlowinfo().getNodeById(nodeid);

		int nodetype = xmlNode.getNodetype();
		if( nodetype == NodeTypeEnum.Node_Progressively){
			String[] userArr = doneUsers.split(StaticVarExtend.UserSplitChar);
            doneUsers = userArr[userArr.length-1];
		}

        else if(nodetype == NodeTypeEnum.Node_Multi){
            //20191111 LIYS 增加多人并行时,退给退回前所有办理人()
           doneUsers = getUserFromTrackNode(trackid,num,nodeid,StaticVarExtend.AUTH_AUTHOR);
        }

		selectedUsers.put(nodeid+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR, doneUsers);
	}
	private String getUserFromTrackNode(String trackid,int num,String nodeid,String type){
        List<ITrackUserJson> tempTU = runningdata.getParticipants(trackid, num, nodeid, type);
		//20220319新增退回提交后拿回情况
		if(null==tempTU || tempTU.isEmpty()){
			tempTU = runningdata.getParticipants(trackid, num, nodeid, StaticVarExtend.AUTH_AUTHOR);
		}
        StringBuilder sb = new StringBuilder(1000);
        for(int i=0,n=tempTU.size();i<n;i++){
            ITrackUserJson tUser = tempTU.get(i);
            if(tUser.getFromType().equals(StaticVarExtend.AUTH_AUTHOR)){
                String done = tUser.getPlanId();
                if(done.length()>0) {
                    sb.append(done).append(StaticVarExtend.UserSplitChar);
                }
            }
        }
        return sb.toString();
    }
	/**
	 * 提交成功后处理当前人员权限
	 * 将主办改为流程读者权限(StaticVarExtend.AUTH_CREADER)
	 */
	private void dowithCurAuth() {
		List<DBWorkAuth> workAuthList =runningdata
				.getListAuthLikeAuthorByTrackid(getCurTrack().getId());
		if(!(null == workAuthList || workAuthList.isEmpty())){
			for(int i=0,n=workAuthList.size();i<n;i++){
				DBWorkAuth wa = workAuthList.get(i);
				if(wa.equalsRunUser(getCurUser())){//当前人员状态改为已办,其余改为读者
					wa.setStatus(StaticVarExtend.AUTH_DONE);
				}else{
					//改变其余办理人权限
					wa.setStatus(StaticVarExtend.AUTH_CREADER);
				}
			}
		}
		runningdata.setCurAuthToMap(workAuthList);
	}
	/**
	 * 给task表添加数据
	 */
	public Map<String,List<Object>>  actionForTask() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionForTask(saveMap);
		//下一节点任务创建
		for(int i=0,n=runningdata.getNextTrackList().size();i<n;i++){
			DBTrack tTrack = runningdata.getNextTrackList().get(i);
			createTaskObj(null,tTrack,saveMap);
		}
		return saveMap;
	}
/*
	private void createTaskObj(DBTask xTask,DBTrack xTrack,Map<String, List<Object>> saveMap){
		DBWork xWork = runningdata.getWork();
		if(xTask == null){
			xTask = new DBTask();
			xTask.setId(StaticFunExtend.getUnid());
			xTask.setFlowid(xWork.getFlowid());
			xTask.setFlowname(xWork.getFlowname());
			xTask.setWorkid(xWork.getId());		
			IXmlFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowInfo();
			int[] ls = flowInfo.getLimitSet();
			
			xTask.setFlowlimitdate(ls[1]);
			xTask.setFlowlimittype(String.valueOf(ls[0]));
			
			xTask.setStarttime(xWork.getStarttime());	
			//计算流程超期时间点，如果没有设置，默认为一年
			int tp  =xTask.getFlowlimitdate();
			
			Date date = addDateForTask(xTask.getStarttime(),ls[0], tp);   
//			        DateUtil.addDateDay(DateUtil.getDateTime(xTask.getStarttime()), tp==0?365:tp);  
			xTask.setFlowlimittime(DateUtil.formatDateTime(date,"yyyy-MM-dd HH:mm:ss"));
		
			String nowtime = DateUtil.getNow();
			xTask.setReceivetime(nowtime);//节点到达时间，计入xml中
//			curNode.setNodeRecevieTime(nowtime);
			//int[] ns = runningdata.getCurXMLNode().getNodeLimit(); 
			int[] ns = flowInfo.getNodeById(xTrack.getNodeid()).getNodeLimit();
			
			String outerCofig = paraBean.getOuterConfig();
			if(StringUtilExtend.isNull(outerCofig)){
				outerCofig = runningdata.getOuterSetType();
			}
			
			if(StringUtilExtend.isNotNull(outerCofig)){
				String limittime = RuleUtil.getOuterLimittime(flowInfo.getFlowid(), xTrack.getNodeid(), outerCofig, getIdentifier());
				if(StringUtilExtend.isNull(limittime)){
					limittime = "0";
				}
				xTask.setNodelimitdate(Integer.parseInt(limittime));				
			}else{
				xTask.setNodelimitdate(ns[1]);				
			}
			xTask.setNodelimittype(String.valueOf(ns[0]));
						
			xTask.setWaringdate(ns[2]);
			xTask.setWaringtype(String.valueOf(ns[0]));
			xTask.setDooverpass(ns[4]);
			xTask.setRemsgnum(ns[3]);
			xTask.setRedonenum(0);
			tp  =xTask.getNodelimitdate();
			
			date = addDateForTask(xTask.getReceivetime(),ns[0], tp);  
			//DateUtil.addDateDay(DateUtil.getDateTime(xTask.getReceivetime()), tp==0?365:tp);  
            xTask.setNodelimittime(DateUtil.formatDateTime(date,"yyyy-MM-dd HH:mm:ss"));
            xTask.setTrackid(xTrack.getId());
		}
		
		xTask.setFlowstatus(xTrack.getFlowstatus());		//流程状态更新
		xTask.setNodetype(runningdata.getCurXMLNode().getNodetype());
		
		xTask.setTitle(xWork.getTitle());
		xTask.setStatus(StaticVarExtend.Task_Normal);
		xTask.setNodeid(xTrack.getNodeid());					
		xTask.setNodename(xTrack.getNodename());	
		xTask.getSQL(saveMap);
	}
	//*/
	/**
	 * 取消分支时调用
	 */
	public void cancelTrackAction(String arg0, List<DBWorkAuth> auths) {
		if(isNotSaveToDB){
			return;
		}
		makeSendInfoByCurAuthList(auths);	
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 发送待办
	 */
	protected void sendTodo(){
		sendTodoForSelectedUsers();
	}
}
