package com.horizon.wf.action;

import com.horizon.wf.config.PubInfo;
import com.horizon.wf.definition.FlowDefinitionUtil;
import com.horizon.wf.definition.InstanceDefinitionUtil;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.CStrUtil;

import java.util.List;
import java.util.Map;

/**
 * 自由提交操作实现类
 * 
 * @author liys
 * @version 1.0
 * @since v7.0
 */
public class ActionSubmitForFree extends ActionSubmit{
	protected void setFunnameToRunningdata(){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_FREE_SUBMIT);
		setActionname("Submit_Msg0001","自由提交");
	}
	/**
	 * 自由提交时,用于检查节点是否需要增加节点的处理
	 * 返回true表示终止程序
	 * @return
	 */
	protected boolean checkForFree(){
		//20170731 liys 动态增加节点实现自由流程
		//如果有指定的下一节点,则走正常提交处理
//		if(nextNodeList.size() > 0){
//			return false;
//		}
		//动态增加定义信息
//		boolean isReturn = addNode();
//		return isReturn;
		
		return nextNodeList.size() > 0?false:addNode(true);
	}
	/**
     * 当前操作是否动态创建节点
     * @return
     */
    public boolean isDynamicCreateNode(){
    	return true;
    }
	//增加节点,并根据需要设置操作
	private boolean addNode(boolean isCheck){
		//获取当前节点对象
		IFlowNode curNode = runningdata.getCurFlowNode();
		//从当前节点获取指向下一节点的路由,动态创建的
		INodeRouter nxtRouter = getRdyNewRouter();
		//传入的节点不存在,增加节点信息
		if(nxtRouter == null){
			if(CStrUtil.isNull(paraBean.getNextNodeName())){
				msg = pubInfo.getInfo("Free_Msg001","节点名称必须指定");
				result = StaticVarExtend.F_STATUS_OtherError;
				return true;
			}
		}
		else{
			if(CStrUtil.isNull(paraBean.getNextNodeName())){
				paraBean.setNextNodeName(nxtRouter.getNodename());
			}
			//删除已经创建的节点
			IFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowinfo();
			flowInfo.deleteNodeById(nxtRouter.getNodeid());
			//删除指向路由
			curNode.deleteToRouter(nxtRouter.getRouterid());
		}
		Map<String, String> selectedUsers = paraBean.getSelectAuthorMap();
		
		//获取当前节点位置信息
		int[] pos = curNode.getNodePosition();
		//如果未传入位置信息时,根据当前节点推算一个位置(x往右移动150,y保持不变)
		if(paraBean.getNextNodeX() <= 0){
			if(paraBean.getNextNodePosX() == 0 && paraBean.getNextNodePosY() == 0){
				paraBean.setNextNodeX(pos[0] + 150);
			}
			else{
				paraBean.setNextNodeX(pos[0] + paraBean.getNextNodePosX());
			}
		}
		if(paraBean.getNextNodeY() <= 0){
			paraBean.setNextNodeY(pos[1] + paraBean.getNextNodePosY());
		}
		IFlowNode moduleNode = curNode;//作为模版拷贝的源节点对象
		//20171009 liys 增加从节点模版库中获取节点信息
		String moduleName = paraBean.getNextNodeModuleName();
		if(CStrUtil.isNotNull(moduleName)){
			String dataStr = XmlDBUtil.getNodeModuleByName(moduleName, runningdata.getInitData().getFlowIdentifier());

			moduleNode = FlowDefinitionUtil.getNodeByStr(dataStr);
			moduleNode.setFlowMap(curNode.getFlowMap());

			if(moduleNode.getNodetype() < NodeTypeEnum.Max_Start ){
				msg = pubInfo.getInfo("Free_Msg002","节点模版指定非法,不能是开始节点类型");
				result = StaticVarExtend.F_STATUS_OtherError;
				return true;
			}
		}
		
		nxtRouter = createNewNode(moduleNode,curNode);
		
		//选择的节点信息重置
		nextNodeId = nxtRouter.getRouterid() + "~" + nxtRouter.getNodeid();
		initNextNodePara();
		//下一节点办理人的重置
		String newKeyid = nxtRouter.getRouterid();
		chgSelectedUsers(selectedUsers,StaticVarExtend.AUTH_AUTHOR,newKeyid);
		chgSelectedUsers(selectedUsers,StaticVarExtend.AUTH_SECOND_AUTHOR,newKeyid);
		chgSelectedUsers(selectedUsers,StaticVarExtend.AUTH_READER,newKeyid);
		
		//20180301 liys 在BaseAction中是按照下一节点id获取的,所以需要转换一下
		int[] tmpNs = paraBean.getNodeLimitByActionSet("Node");
		if(tmpNs != null){
			paraBean.putNodeLimitSetMap(nxtRouter.getNodeid(), tmpNs);
		}
		
		return false;
	}
	private INodeRouter getRdyNewRouter(){
		//判断是否有后续路由,如果有就不增加
		List<INodeRouter> routers = getCurFlowNode().getAllToRouters();
		int size = routers.size();
		if(size>0){
			for(int i=0,n=size;i<n;i++){
				INodeRouter router = routers.get(i);
				if(router.isDynamic()){
					return router;
				}
			}
		}
		return null;
	}
	private INodeRouter createNewNode(IFlowNode mNode, IFlowNode curNode){
		InstanceDefinitionUtil  define = runningdata.getInstanceDefinition();
		IFlowInfo flowInfo = define.getFlowinfo();
//		此处应该重新从flowInfo对象中获取当前节点对象,
		IFlowNode nextNode = flowInfo.getCopyNode(mNode,paraBean.getNextNodeName());
		
		//设置新节点的位置信息,此方法会在mapxml中增加node信息
		nextNode.setNodePosition(paraBean.getNextNodeX(), paraBean.getNextNodeY());
		//在流程图上标记为临时创建节点
		nextNode.setDynamic(true);
		//设置新节点mapxml中的sub属性信息,数据来源当前节点在mapxml中的sub值
		nextNode.setMapNodeSubFromCopyNode(curNode);
		
		//更改节点类型,特别注意,此类型修改范围:只能是节点属性框中节点类型下拉框里显示的类型
		//nextNode.setNodetype(NodeTypeEnum.Node_Multi);
		
		//设置必要的操作和表单信息,
		//从当前节点拷贝所有信息时表单和操作跟当前节点一致,也可以根据需要调整
		//setButtonForAuthor(nextNode);
		//setButtonForDone(nextNode);
		
		//生成路由,
		
		INodeRouter router = curNode.addToRouter(null);
		router.setNodeid(nextNode.getNodeid());
		router.setNodename(nextNode.getNodename());
		router.setNodetype(nextNode.getNodetype());
		
		//设置路由起止坐标,此方法为会在mapxml中修改或者增加line节点	
		int[] pos = curNode.getNodePosition();
		router.setRouterPosition(pos[0]+25, pos[1]+25, paraBean.getNextNodeX()+25, paraBean.getNextNodeY()+25);
		//标记为动态增加的临时节点,此方法必须在setRouterPosition方法后执行
		router.setDynamic(true);
		//更新修改
		define.setChange(true);
		
		return router;
	}
	
	private void chgSelectedUsers(Map<String, String> selectedUsers,String status,String newKeyid){
		String tmpKeyid = "Node-"+status;//前台传入的key固定写死
		String users = selectedUsers.get(tmpKeyid);
		if(StringUtilExtend.isNotNull(users)){
			selectedUsers.put(newKeyid+StaticVarExtend.MARK_NODE_USER+status, users);
			//20180228 liys 必须删除tmpKeyid对应的值,不然在创建todo的时候,会出现当前也有待办的现象
			selectedUsers.remove(tmpKeyid);
		}
	}
	
	/* 自行增加操作时参考
	private void setButtonForAuthor(XMLNode nextNode){
		XMLControl control = (XMLControl)nextNode.getParticipantsControl(StaticVarExtend.AUTH_AUTHOR+"_DO");
		//按钮默认为提交,可以通过修改属性变成其他操作
		XMLButton button =control.getNewButton();
		button.setButtonId("freesubmit");
		button.setButtonName("自由提交");
		button.setButtonReName("自由提交");
		button.setImplClass("com.horizon.wf.action.ActionSubmitForFree");
		//正常提交按钮
		button =control.getNewButton();
		
		button =control.getNewButton();
		button.setButtonId("rejectSubmit");
		button.setButtonName("退回提交");
		button.setButtonReName("退回提交");
		button.setImplClass("com.horizon.wf.action.ActionSubmitForReject");
		
		button =control.getNewButton();
		button.setButtonId("reject");
		button.setButtonName("退回");
		button.setButtonReName("退回");
		button.setImplClass("com.horizon.wf.action.ActionReject");
		
		button =control.getNewButton();
		button.setButtonId("save");
		button.setButtonName("暂存");
		button.setButtonReName("暂存");
		button.setImplClass("com.horizon.wf.action.ActionSave");
		//表单信息设置
		
		
	}
	
	private void setButtonForDone(XMLNode nextNode){
		XMLControl control = (XMLControl)nextNode.getParticipantsControl(StaticVarExtend.AUTH_DONE+"_DO");
		XMLButton button =control.getNewButton();
		button.setButtonId("getback");
		button.setButtonName("拿回");
		button.setButtonReName("拿回");
		button.setImplClass("com.horizon.wf.action.ActionGetBack");
	}
	//*/
}
