package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseForTask;
import com.horizon.wf.action.base.IActionForStartSubFlow;
import com.horizon.wf.action.base.SubflowEnd;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.jsr94.IRuleEngine;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 自动提交实现类
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionSubmitAuto extends BaseForTask implements ICustomAction,IActionForStartSubFlow{
	private SubflowEnd  subflowEnd =null;//子流程实例结束时,主流程是否可以往下流转处理类
	
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_AUTO_SUBMIT);
		paraBean.setActionname(pubInfo.getInfo("Submit_Msg1001", "自动提交"));
		int nodetype = getCurNodeType();
		String className = curTaskNode.getCurNode().getFlowNode().getRobotClassName();
		if(StringUtilExtend.isNotNull(className)){
			//程序执行
			if(NodeTypeEnum.Node_Auto_Program == nodetype){
				try{
					Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
					IBaseRule br = InterfaceFactory.getNewInterface(className);
					br.setParameter(StaticVarExtend.Parameter_WorkParaBean, paraBean);//设置前后台对象到接口
					br.setParameter(StaticVarExtend.Parameter_DBWork, getWork());
					br.setParameter(StaticVarExtend.Parameter_RunUser, getCurUser());
					br.setParameter(StaticVarExtend.Parameter_DBTrack, getCurTrack());
					br.setParameter(StaticVarExtend.Parameter_SaveMap,saveMap);
					br.setRunningData(runningdata);
					//接口判断是否可以继续
					if(!br.executeRule()){
						runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg1002", "自动节点规则不允许继续."));
						runningdata.setResultCode(StaticVarExtend.F_STATUS_AutoSubmit_Not_Continue);
						return false;
					}
					if(!saveMap.isEmpty()){
						for(Map.Entry<String, List<Object>> entry : saveMap.entrySet()){
							runningdata.putSQLToDataMap(entry.getKey(), entry.getValue());
						}
					}
				}catch(Exception e){
					INodeException exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_NodeAutoProgramError, getCurFlowNode().getExceptions());
					boolean res = ac.handleExceptionDelay(exception, runningdata, getCurFlowNode());
					runningdata.putMsgToConsole("[msg]handle exception result:"+res);
					runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg1003", "自动节点程序执行异常."));
					runningdata.setResultCode(StaticVarExtend.F_STATUS_AutoSubmit_Not_Continue);
					return false;

				}
			}else if(NodeTypeEnum.Node_Auto_Rule == nodetype){//业务规则执行
				try{
					IRuleEngine du = PluginsUtil.getMultiInstance().getRuleEngine();
					du.setPara("RunningData", runningdata);
					
					Object rs = du.exctu(className);
					boolean execResult = (Boolean)rs;
					if(!execResult){
						runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg1002", "自动节点规则不允许继续."));
						runningdata.setResultCode(StaticVarExtend.F_STATUS_AutoSubmit_Not_Continue);
						return false;
					}
				}catch(Exception e){
					INodeException exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_NodeAutoRuleError, getCurFlowNode().getExceptions());
					boolean res = ac.handleExceptionDelay(exception, runningdata, getCurFlowNode());
					runningdata.putMsgToConsole("[msg]handle exception result:"+res);
					runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg1003", "自动节点程序执行异常."));
					runningdata.setResultCode(StaticVarExtend.F_STATUS_AutoSubmit_Not_Continue);
					return false;
				}

			}else if(NodeTypeEnum.Node_Auto_Service == nodetype){//webservice执行
				try{
					boolean execResult = true;
					if(!execResult){
						runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg1002","自动节点规则不允许继续."));
						runningdata.setResultCode(StaticVarExtend.F_STATUS_AutoSubmit_Not_Continue);
						return false;
					}
				}catch(Exception e){
					INodeException exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_NodeAutoServiceError, getCurFlowNode().getExceptions());
					boolean res = ac.handleExceptionDelay(exception, runningdata, getCurFlowNode());
					runningdata.putMsgToConsole("[msg]handle exception result:"+res);
					runningdata.setBackMsg(pubInfo.getInfo("Submit_Msg1003","自动节点程序执行异常."));
					runningdata.setResultCode(StaticVarExtend.F_STATUS_AutoSubmit_Not_Continue);
					return false;
				}
			}
		}
		//是否允许离开当前节点
		if(curTaskNode.doCurNode()){
			initNextNodePara();
			INextNode curNode = curTaskNode.getCurNode();
			// 获取前台是否传入选择的节点,key=自行定义,默认为nextNodeid
			// 格式：rId1~nId1|rId2~nId2&rId3~nId3//runningdata.getValueFromHashMap("nextNodeid");
			
			runningdata.getCurTaskNode().leaveByRouter(nextNodeList, selectedUsers);
			int initResult = runningdata.getResultCode();
			if(initResult != StaticVarExtend.F_STATUS_Success){
				initResult = runningdata.getResultCode();
				msg = runningdata.getBackMsg();
				return false;
			}
			result = curNode.getInitResult();
			msg = curNode.getBackMsg();
			List<INextNode> nextNodes = runningdata.getCurTaskNode().getGNextNodes();// 获取符合条件的节点列表
			if (result == StaticVarExtend.F_STATUS_Success) {
//				if (HandleSelectUserUtil.isSelectAuthor(nextNodes, selectedUsers,tmpUsers, runningdata) == 1) {// 判断节点是否准备就绪,就绪之后可以更新任务表以及设置formid
//					msg = "提交成功";
//					if(executeEventSave()){
//						selectedUsers = ac.makeAgentUser(selectedUsers, runningdata);
//						runningdata.setUpdateTask(true);
//						runningdata.getInitData().setFormids(ac.setFormIdsByRunningdata(getCurFlowNode(), getCurUser()));
//					}
//				} else {
//					msg = "请选择办理人";
//					result = StaticVarExtend.F_STATUS_AutoSubmit_SelectAuthor;
//				}
				doWithNextNodeResult(true);
				if(result == StaticVarExtend.F_STATUS_Success){
					msg = pubInfo.getInfo("Submit_Msg1004","自动提交成功");
					if(executeEventSave()){
//						selectedUsers = ac.makeAgentUser(selectedUsers, runningdata);
						runningdata.setUpdateTask(true);
						runningdata.getInitData().setFormids(ac.setFormIdsByRunningdata(getCurFlowNode(), getCurUser()));
						memoBuffer.append(pubInfo.getInfo("Submit_Msg1005","自动提交到节点"));
						for(int i=0,n=nextNodes.size();i<n;i++){
							doMemoAutoGet(nextNodes.get(i));
						}
					}
				}
				else if(result == StaticVarExtend.F_STATUS_SelectAuthor){
					result = StaticVarExtend.F_STATUS_AutoSubmit_SelectAuthor;
				}
				
			}else if(result == StaticVarExtend.F_STATUS_SelectNode){
				// 获取可选的路由，返回前台供选择
				result = StaticVarExtend.F_STATUS_AutoSubmit_Not_Node;
			}
			if(CollectionUtil.isListNotEmpty(nextNodes)){
				resultBean.setNextNodes(nextNodes);
			}
		}
		List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
		for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
			auth.setStatus(StaticVarExtend.AUTH_DONE);
		}
		runningdata.setCurAuthToMap(auths);
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 给task表添加数据
	 */
	public Map<String,List<Object>>  actionForTask() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(isNotSaveToDB || paraBean.getFunname().equals(StaticVarExtend.OPERATOR_FUNNAME_URGE)){
			return saveMap;
		}
		//流程结束,无论是否配置删除版本,task都需要清理
		if(runningdata.isFlowEnd()){
			//20161122 liys 子流程结束时,对主流程的处理,由actionSuccess方法中移动到此处
			//可以避免子流程只是分支结束时,也对主流程的处理
			subflowEnd = new SubflowEnd(this);
			if( !subflowEnd.doWithSubFlowEnd()){
				//结束节点时的额外处理
				runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
				return null;
			}
			
//			List<Object> para = new ArrayList<Object>(1);
//			para.add(runningdata.getInitData().getWorkid());
//			List<Object> lst = new ArrayList<Object>();
//			lst.add(para);
//			saveMap.put(("DELETE FROM "+StaticVarExtend.Table_Task+" WHERE WORKID=? "),lst);

			DBTask.delSQLByWorkid(saveMap, runningdata.getResultJson(), runningdata.getWork().getId());
			return saveMap;
		}
		actionForTask(saveMap);
		//下一节点任务创建
		for(int i=0,n=runningdata.getNextTrackList().size();i<n;i++){
			DBTrack tTrack = runningdata.getNextTrackList().get(i);
			createTaskObj(null,tTrack,saveMap);
		}
		return saveMap;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		Map<String,String> map = new HashMap<String,String>();
		//取消其他分支时,哪些权限需要变更,在map中设置即可
		map.put(StaticVarExtend.AUTH_AUTHOR, StaticVarExtend.AUTH_CREADER);
		map.put(StaticVarExtend.AUTH_SECOND_AUTHOR,  StaticVarExtend.AUTH_CREADER);
		map.put(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR,  StaticVarExtend.AUTH_CREADER);
		map.put(StaticVarExtend.AUTH_HUIQIAN_AUTHOR,  StaticVarExtend.AUTH_CREADER);
		return map;
	}
	
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(!StaticFunExtend.getActionExtraData().doWithNextNodesExtraData(this)){
			return null;
		}
		if(subflowEnd != null){
			if(!subflowEnd.mainInstanceContinue(saveMap,getTaskLists())){
				return null;
			}
		}
		sendTodo();
		actionBefore(saveMap);
		//把子流程启动的SQLMap放入saveMap中
		actionBeforeForSubFlow(saveMap);
		return saveMap ;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
		//执行子流程启动时的actionAfterSaveToDB方法
		actionAfterForSubFlow();
		
		//发送定时任务
		super.actionAfterSaveToDB();
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 发送待办
	 */
	protected void sendTodo(){
		sendTodoForSelectedUsers();
	}
}
