package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.action.base.SubflowEnd;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.DateUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 异常终止流程 ,终止后不可恢复,待办变更为Reader
 * 1)办理人执行时,终止当前track
 * 2)管理员执行时,终止所有track
 * 
 * @author liys
 */
public class ActionStop extends BaseAction implements ICustomAction{
	private List<DBTrack> tracklst;
	private List<Object> taskLists = new ArrayList<Object>();			//定时任务基类
	private SubflowEnd  subflowEnd =null;//子流程实例结束时,主流程是否可以往下流转处理类
	public boolean execute(ITaskNode curTaskNode) {
		IRunUser curUser = getCurUser();
		boolean isManager = curUser.isManager();
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_STOP);
		setActionname("Stop_Msg0001", "终止");
		msg = pubInfo.getInfo("Stop_Msg0002","终止流程成功");
		if(isnewdoc<2){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Stop_Msg0003","当前流程处于起草状态，无法终止.");
		}
		else if(isManager){
			managerAction();
		}
		else{
			authorAction();
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 办理人执行时
	 */
	private void authorAction(){
		DBTrack curTrack = getCurTrack();
		if(StaticVarExtend.FlowStatus_End == curTrack.getFlowstatus()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Stop_Msg0004","结束节点，无法终止.");
		}
		else if(StaticVarExtend.FlowStatus_ErrorEnd == curTrack.getFlowstatus()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Stop_Msg0005","流程已经终止.");
		}
		else if(StaticVarExtend.FlowStatus_Cancel == curTrack.getFlowstatus()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Stop_Msg0006","撤销状态下不能终止.");
		}
		else{
			tracklst = runningdata.getAllTrackBeforeEndByWorkid(getWorkid());
			if(tracklst.size()==1){
				//20160525标记流程已经结束
				runningdata.setUpdateTask(true);
				memoBuffer.append(pubInfo.getInfo("Stop_Msg0008","终止流程,流程终止"));
			}
			else{
				memoBuffer.append(pubInfo.getInfo("Stop_Msg0009","终止流程,分支终止"));
			}
			curTrack.setFlowstatus(StaticVarExtend.FlowStatus_ErrorEnd);
			ac.dowithTimer("cancel", getCurNodeType(), runningdata, getIdentifier());//如果当前节点包含定时任务则撤销定时任务
			IRunUser curUser = getCurUser();
			//获取当前路径下的所有办理人
			List<DBWorkAuth> auths = getListAuthByTrackid(curTrack.getId());
			boolean isFind = true;
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				auth.setId("LIYS");//id不为空时不进行拆分,会重新赋值
				//查找自己
				if(isFind && auth.equalsRunUser(curUser)){
					isFind = false;
					auth.setStatus(StaticVarExtend.AUTH_DONE);
				}
				else{
					auth.setStatus(StaticVarExtend.AUTH_READER);
				}
				auth.setOldStatus("");
			}
			runningdata.setCurAuthToMap(auths);
			
			//当前路径下的待办处理,修改为Reader
			List<DBTodo> list = getListTodoByTrackid(curTrack.getId());
			isFind = true;
			if(!(list == null || list.isEmpty())){
				for(int i=0,n=list.size();i<n;i++){
					DBTodo a = list.get(i);
					DBChgTodo todo = new DBChgTodo();
					todo.setTrackid(a.getTrackid());
					todo.setNodeid(a.getNodeid());
					todo.setStatus(a.getStatus());
					todo.setAuthId(a.getAuthId());
					todo.setSubjectionId(a.getSubjectionId());
					if(isFind && (a.getAuthId().equals(curUser.getUserid())
							|| a.getAgentId().equals(curUser.getUserid()))){
						isFind = false;
						todo._setStatus(StaticVarExtend.AUTH_DONE);
					}
					else {
						todo._setStatus(StaticVarExtend.AUTH_READER);
					}
					todo._setDotime(DateUtil.getNow());
					todo._setTrackstatus(String.valueOf(StaticVarExtend.FlowStatus_ErrorEnd));
					todo._setTitle(pubInfo.getInfo("Stop_Msg0007","[终止通知]")+a.getTitle());
					todoLst.add(todo);
				}
			}
		}
	}
	/**
	 * 管理员执行时
	 */
	private void managerAction(){
		tracklst = runningdata.getAllTrackBeforeEndByWorkid(getWorkid());
		if(checkTrackIsCancel()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Stop_Msg0006","撤销状态下不能终止.");
		}
		else{
			//20160525标记流程已经结束
			runningdata.setUpdateTask(true);
			memoBuffer.append(pubInfo.getInfo("Stop_Msg0008","终止流程,流程终止"));
			//修改track状态
			IFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowinfo();
			for(int i=0,n=tracklst.size();i<n;i++){
				DBTrack track = tracklst.get(i);
				runningdata.setOldStatus(track.getId(),StaticVarExtend.FlowStatus_ErrorEnd, track.getFlowstatus());
				track.setFlowstatus(StaticVarExtend.FlowStatus_ErrorEnd);
				if(getCurTrack().getId().equals(track.getId())){
					getCurTrack().setFlowstatus(track.getFlowstatus());
				}
				else{
					track.setFunname(StaticVarExtend.OPERATOR_FUNNAME_STOP);
				}
				String nodeid = track.getNodeid();
				IFlowNode xmlNode = flowInfo.getNodeById(nodeid);
				ac.dowithTimer("cancel", xmlNode.getNodetype(),nodeid,track.getId(), runningdata, getIdentifier());
			}
			//获取当前实例下的所有办理人
			List<DBWorkAuth> auths = runningdata.getListAuthLikeAuthorByWorkid(getWorkid());
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				auth.setId("LIYS");//id不为空时不进行拆分,会重新赋值
				auth.setStatus(StaticVarExtend.AUTH_READER);
				auth.setOldStatus("");
			}
			runningdata.setCurAuthToMap(auths);
			//待办处理
			//当前所有路径下的待办处理,修改为Reader
			List<DBTodo> list = getListTodoByWorkid(getWorkid());
			if(!(list == null || list.isEmpty())){
				for(int i=0,n=list.size();i<n;i++){
					DBTodo a = list.get(i);
					DBChgTodo todo = new DBChgTodo();
					todo.setTrackid(a.getTrackid());
					todo.setNodeid(a.getNodeid());
					todo.setStatus(a.getStatus());
					todo.setAuthId(a.getAuthId());
					todo.setSubjectionId(a.getSubjectionId());
					
					todo._setStatus(StaticVarExtend.AUTH_READER);
					todo._setDotime(DateUtil.getNow());
					todo._setTrackstatus(String.valueOf(StaticVarExtend.FlowStatus_ErrorEnd));
					todo._setTitle(pubInfo.getInfo("Stop_Msg0007","[终止通知]")+a.getTitle());
					todoLst.add(todo);
				}
			}
		}
	}
	
	/**
	 * 判断路径是否为撤销状态,只有有一个是,则返回true,否则返回false
	 * @return
	 */
	private boolean checkTrackIsCancel(){
		for(int i=0,n=tracklst.size();i<n;i++){
			DBTrack track = tracklst.get(i);
			if(track.getFlowstatus() == StaticVarExtend.FlowStatus_Cancel){
				return true;
			}
		}
		return false;
	}
	/**
	 * 获取指定路径下所有办理人的工作列表
	 * @return
	 */
	private List<DBTodo> getListTodoByTrackid(String trackid){
			List<DBTodo> list = DBTodo
					.getTodoListByTrackid(runningdata.getResultJson(),trackid, getIdentifier());
		return list;
	}
	
	/**
	 * 获取实例下所有办理人的工作列表
	 * @param workid
	 * @return
	 */
	private List<DBTodo> getListTodoByWorkid(String workid){
		List<DBTodo> list = DBTodo
				.getTodoListByWorkid(runningdata.getResultJson(),workid, getIdentifier());
		return list;
	}
	
	public List<DBWorkAuth> getListAuthByTrackid(String trackid){
		
		List<DBWorkAuth> list = runningdata.getListAuthLikeAuthorByTrackid(trackid);
		
//		String sql = "SELECT * FROM "+StaticVar.Table_Work_Auth + " WHERE TRACKID=? AND STATUS_NO < ?" ;
//		List<String> para = new ArrayList<String>();
//		para.add(trackid);
//		para.add(AuthEnum.getStatusNo("TodoMax"));
//		
//		List<DBWorkAuth> list = AccessUtil.getInstance().getMultiObject(sql, para, DBWorkAuth.class, getIdentifier());
		return list;
	}
	
	/**
	 * 用于操作完成时,更新所有路径信息时获取所有需要更新的路径对象
	 * 默认为null,由后台自动去库表中获取,
	 * 但在撤办/结束/暂停操作中由于需要对所有路径进行处理,所以此处需要返回处理后的路径列表信息
	 * @return
	 */
	public List<DBTrack> getAllOldTrack(){
		return tracklst;
	}
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		//设置流程结束为了删除历史版本
		runningdata.setFlowEnd(true);
		//20161122 liys 增加主子流程的处理,如果子流程异常,
		//主流程必须异常结束的话,则需要屏蔽SubflowEnd部分代码
		//主流程还需要正常流转,则需要对下面的代码处理
		//20161122 liys 增加子流程结束时,跟主流程交互的处理
		subflowEnd = new SubflowEnd(this);
		if( !subflowEnd.doWithSubFlowEnd()){
			//必须设置ResultCode此处设置用于引擎判断
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			return null;
		}
		//在配置允许删除历史版本时,才删除中间节点的任务信息.
		if(HZResourceBundle.getInstance().IsClearVersion()){
			Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
			
//			List<Object> para = new ArrayList<Object>(1);
//			para.add(runningdata.getInitData().getWorkid());
//			List<Object> lst = new ArrayList<Object>();
//			lst.add(para);
//			saveMap.put(("DELETE FROM "+StaticVarExtend.Table_Task+" WHERE WORKID=? ").toUpperCase(),lst);
			DBTask.delSQLByWorkid(saveMap, runningdata.getResultJson(), runningdata.getWork().getId());
			
			return saveMap;
		}
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
		//发送定时任务
		if(CollectionUtil.isListNotEmpty(taskLists)){
			try{
				if(!taskLists.isEmpty()){
					PluginsUtil.getSingleInstance().getTaskInterface().addTask(taskLists);
				}
			}catch(Exception e){
				e.printStackTrace();
				runningdata.putMsgToConsole("[msg]add task error!");
			}
		}
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(subflowEnd != null){
			if(!subflowEnd.mainInstanceContinue(saveMap,taskLists)){
				return null;
			}
		}
		
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
}
