package com.horizon.wf.action;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.action.base.StartSubflow;
import com.horizon.wf.action.common.ActionExtraData;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 一次启动多个子流程实现类
 * @author liys
 * @version 1.0
 * @since v7.2.3
 */
public class ActionStartMultiSubFlow extends BaseAction implements ICustomAction{
//	private List<List<String>> paraVarList = new ArrayList<List<String>>();//存放子流程传入主流程的变量
	private List<DBRelationSubflow> subflowWorks; //所有已经启动的子流程实例
	private List<RunningData> subRunningdatas = new ArrayList<RunningData>();		//所有启动成功后的子流程运行期对象
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_SUBFLOW);
		setActionname("SubFlow_Msg0001","启动子流程");
		isNotSaveToDB = false;
		runningdata.setContinueSave(true);

		IFlowNode curNode = getCurFlowNode();
		String subflowid = paraBean.getSelectSubFlowid();//前台传入的要启动的子流程id,可能为多个
		
		List<INodeSubflow> allSubFlowList = curNode.getSubFlowList();//可以启动的子流程列表
		subflowWorks = getSubFlowWorks(getWorkid(),getCurTrackid(),curNode.getNodeid(),getIdentifier());//已经启动过的子流程
		//判断是否允许启动子流程
		int rdyworksize = subflowWorks ==null?0:subflowWorks.size();
		boolean isMuilt = curNode.getSubFlowMuilt() ; //是否允许多个实例
		int isStart = checkSubIsStart(isMuilt,subflowid,rdyworksize);
		if(isStart == 0){//已传入子流程id
			StringBuilder sb = new StringBuilder(1000);
			String[] subflowids = subflowid.split(StaticVarExtend.StrSplitChar);
			for(String subflowId:subflowids){
				//要启动的子流程是否存在于可启动子流程列表中
				if(!subflowidExitSubFlowList(subflowId, allSubFlowList)){
					sb.append(StaticVarExtend.StrSplitChar).append(subflowId);
				}
			}
			if(sb.length() >0 ){
				sb.deleteCharAt(0);
				result = StaticVarExtend.F_STATUS_OtherError;
				msg = pubInfo.getInfo("SubFlow_Msg0002", "要启动的子流程[|flowid|]不存在于可启动子流程列表中")
					.replace("|flowid|", sb.toString());
			}
			else{
				if(isMuilt || subflowids.length ==1){
					startSub(allSubFlowList,subflowids,isMuilt);
				}
				else{
					result = StaticVarExtend.F_STATUS_OtherError;
					msg = pubInfo.getInfo("SubFlow_Msg0011", "子流程不允许启动多个时,不能选择多个子流程");
				}
			}
		}
		else if(isStart ==1){//未传入子流程id
			if(CollectionUtil.isListEmpty(allSubFlowList)){//没有子流程
				result = StaticVarExtend.F_STATUS_OtherError;
				msg =  pubInfo.getInfo("SubFlow_Msg0003","没有可以启动的子流程");	
			}
		}
		
		resultBean.setSubflows(allSubFlowList);//可以启动的子流程列表
		resultBean.setSubflowWorks(subflowWorks);	//已经启动过的子流程实例列表
		
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	private void startSub(List<INodeSubflow> allSubFlowList,String[] subflowids,boolean isMuilt){
		IFlowNode curNode = getCurFlowNode();
		List<String> subworkidLst = new ArrayList<String>();	//记录已经启动成功的子流程实例id,用于失败时删除实例
		StartSubflow subflow = new StartSubflow(runningdata,pubInfo,curNode,getCurTrackid());
		for(String subflowId:subflowids){
			//启动子流程
			//获取选中的子流程对象
			INodeSubflow subFlowInfo = getSubFlowInfo(subflowId,allSubFlowList);
			//检测前台是否传入了子流程接收人
			String allAuthors = selectedUsers.get(subFlowInfo.getSubFlowId());
			if(StringUtilExtend.isNotNull(allAuthors)){
				String[] authors = allAuthors.split(StaticVarExtend.UserSplitChar);
				if(isMuilt || authors.length == 1){
					for(String author:authors){
						//重置第一个节点办理人
						subflow.setAuthor(author);
						if(!startSubAction(subflow,subFlowInfo,subworkidLst)){
							delRdySubInstance(subworkidLst);
							return;
						}
					}
				}
				else{
					result = StaticVarExtend.F_STATUS_OtherError;
					msg = pubInfo.getInfo("SubFlow_Msg0012", "子流程不允许启动多个时,不能选择多个办理人");
					delRdySubInstance(subworkidLst);
					return;
				}
			}
			else {
				//重置第一个节点办理人
				subflow.setAuthor("");
				if(!startSubAction(subflow,subFlowInfo,subworkidLst)){
					delRdySubInstance(subworkidLst);
					return;
				}
			}
			
		}
		//全部子流程启动完毕后执行
		//改变当前流程状态
		changeflowstatus( curNode);
		//标记存储主数据
		paraBean.setSubmitflag("0");
		//操作完成前事件
		
		if(executeEventSave()){
			// 获取当前人有权限的表单
			runningdata.getInitData().setFormids(ac.setFormIdsByRunningdata(curNode, getCurUser()));	
		}
	}
	
	private boolean startSubAction(StartSubflow subflow,INodeSubflow subFlowInfo,List<String> subworkidLst){
		IWorkResult wr = subflow.startAndSaveFlow(subFlowInfo);
		if(null == wr){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg =  pubInfo.getInfo("SubFlow_Msg0006","启动子流程[|flowname|]失败")
					.replace("|flowname|", subFlowInfo.getSubFlowName());
			
			
			return false;
		}
		else if(wr.getResult() == StaticVarExtend.F_STATUS_SelectAuthor){
		    result = StaticVarExtend.F_STATUS_OtherError;
            msg =  pubInfo.getInfo("SubFlow_Msg0010","子流程[|flowname|]第一个节点的办理人未知或者人数和节点类型不匹配")
            		.replace("|flowname|", subFlowInfo.getSubFlowName());
            
            return false;
            
		}
		else if(wr.getResult() == StaticVarExtend.Init_Success){
			result = StaticVarExtend.F_STATUS_Success;
			msg = pubInfo.getInfo("SubFlow_Msg0007", "启动子流程成功");
//			多个一块启动的时候,不需要设置
//			resultBean.setSubflowWorkResult(wr);
			subworkidLst.add(wr.getWorkid());
			DBRelationSubflow s = subflow.getDBRelationSubflow();
			if(subflowWorks ==null){
			    subflowWorks = new ArrayList<DBRelationSubflow>();
			}
			subflowWorks.add(0, s);
			
			memoBuffer.append(pubInfo.getInfo("SubFlow_Msg0009","启动子流程[|flowname|]实例ID[|workid|].")
					.replace("|workid|", wr.getWorkid()).replace("|flowname|", wr.getWork().getFlowname()));
			//记录SQLMap
			subRunningdatas.add(wr.getRunningdata());
		}
		else{
		    result = wr.getResult();
            msg = wr.getBackMsg();
            
            return false;
		}
		
		return true;
	}
	
	 //删除已经启动的子流程实例,
    private void delRdySubInstance(List<String> subworkidLst){
		//不需要执行了,因为SQL放到跟主流程一起执行了,也就是失败时,SQL不会写入
//    	ActionExtraData.getInstance().delRdySubInstance(subworkidLst,runningdata.getInitData().getTenantid(), runningdata.getInitData().getFlowIdentifier());
    }
	/**
	 * 获取已经启动过的子流程
	 * @param workid 实例id
	 * @param identifier 数据库标示符
	 * @return 子流程
	 */
	private List<DBRelationSubflow> getSubFlowWorks(String workid,String trackid,String nodeid,String identifier){
		return DBRelationSubflow.getListByTrackidAndNodeid(runningdata.getResultJson(),trackid, nodeid, identifier);
	}
	/**
	 * 
	 * @param isMuilt			是否允许启动多个子流程
	 * @param rdyworksize		已经启动的子流程实例
	 * @return
	 */
	private int  checkSubIsStart(boolean isMuilt,String subflowid,int rdyworksize){
		boolean isNullSubflowid = null == subflowid || "".equals(subflowid);//前台是否指定过要启动的子流程
		//未指定子流程ID时,需要判断是否可以启动子流程,然后获取列表供前台选择
		if(rdyworksize > 0){//已经启动过子流程
			if(isMuilt){//允许多个子流程
				if(isNullSubflowid){
					result = StaticVarExtend.F_STATUS_NeedSelSubFlow;
					msg =  pubInfo.getInfo("SubFlow_Msg0004","需要选择子流程");
					return 1;
				}
			}
			else{
				//不允许启动多个子流程
				result = StaticVarExtend.F_STATUS_IsHaveSubFlow;
				msg =  pubInfo.getInfo("SubFlow_Msg0005","已经启动过子流程,不允许启动多个");
				return 2;
			}
		}
		else{
			if(isNullSubflowid){
				result = StaticVarExtend.F_STATUS_NeedSelSubFlow;
				msg =  pubInfo.getInfo("SubFlow_Msg0004","需要选择子流程");
				return 1;
			}
		}
		return  0;
	}
	
	/**
	 * 找出allSubFlowList中含有subflowid的一项
	 * @param subflowid
	 * @param allSubFlowList
	 * @return
	 */
	private INodeSubflow getSubFlowInfo(String subflowid,
			List<INodeSubflow> allSubFlowList) {
		if(CollectionUtil.isListNotEmpty(allSubFlowList)){
			for(int i=0,n= allSubFlowList.size();i<n;i++){
				INodeSubflow sf = allSubFlowList.get(i);
				if(sf.getSubFlowId().equals(subflowid)){
					return sf;
				}
			}
		}
		return null;
	}
	/**
	 * 改变当前流程状态
	 * 主流程需要等待子流程返回时 将主流程状态改为AUTH_AUTHOR_SUBFLOW
	 */
	private void changeflowstatus(IFlowNode curNode) {
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		if(curNode.getSubFlowWait()){//需要等待子流程返回
			int flowstatus = getCurTrack().getFlowstatus();
			if(flowstatus != StaticVarExtend.FlowStatus_SubFlow){
				getCurTrack().setFlowstatus(StaticVarExtend.FlowStatus_SubFlow);
			}
		}
		runningdata.setCurAuthToMap(newAuths);
	}

	/**
	 * 给定的子流程id是否存在与可启动的子流程列表中
	 * @param subflowid
	 * @param allSubFlowList
	 * @return
	 */
	private boolean subflowidExitSubFlowList(String subflowid,List<INodeSubflow> allSubFlowList){
		if(CollectionUtil.isListNotEmpty(allSubFlowList)){
			for(int i=0,n= allSubFlowList.size();i<n;i++){
				INodeSubflow sf = allSubFlowList.get(i);
				if(subflowid.equals(sf.getSubFlowId())){
					return true;
				}
			}			
		}
		return false;
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		//执行子流程启动时的actionAfterSaveToDB方法
		if(!subRunningdatas.isEmpty()){
			for(int i=0,n=subRunningdatas.size();i<n;i++){
				RunningData subRD=subRunningdatas.get(i);
				subRD.excuteAfterSaveToDB_MultiInstanceTransaction();
			}
		}
		return;
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		
		actionBefore(saveMap);
		//把子流程启动的SQLMap放入saveMap中
		if(!subRunningdatas.isEmpty()){
			for(int i=0,n=subRunningdatas.size();i<n;i++){
				RunningData subRD=subRunningdatas.get(i);
				ActionExtraData.getInstance().putSubMapToMainMap(saveMap, subRD.getFlowMap());
			}
		}
		return saveMap ;
	}

	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
//		if(CollectionUtil.isListNotEmpty(auths)){
//			makeSendInfoByCurAuthList(auths);			
//		}
		return true;
	}

}

