package com.horizon.wf.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 暂存（清空内存）
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionSaveAndClose extends BaseAction implements ICustomAction {
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_SAVE);
		setActionname("Save_Msg0001","暂存");
		//仅在新实例未进行任何操作时执行权限处理,其他情况,不做任何处理
		if(isnewdoc == 0){
//			NodeStart startNode = (NodeStart)curTaskNode;
			//开始节点的特殊处理(针对第一次保存的一些特殊处理)
//			startNode.doFirstAction();	
			
			String doneId = getCurUser().getFullName();
			//增加创建者权限
			List<DBWorkAuth> auths = new ArrayList<DBWorkAuth>();
			DBWorkAuth creator = makeAuthByAuthId(doneId,StaticVarExtend.AUTH_CREATOR,"");
			creator.setAuthType(StaticVarExtend.UserFix);
			auths.add(creator);
			runningdata.setCurAuthToMap(auths);
			isNewDoc("1"); //标记已保存
		}
		String msg = pubInfo.getInfo("Save_Msg0002","保存成功!");
		int initResult = StaticVarExtend.F_STATUS_Success;
//		if(executeEventSave()){
//			runningdata.setUpdateTask(false);
//			// 获取当前人有权限的表单
//			runningdata.getInitData().setFormids(ac.setFormIdsByRunningdata(getCurXmlNode(), getCurUser()));					
//		}			
		runningdata.setAddVersion(false);
		memoBuffer.append(msg);
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(initResult);
		return true;
	}
	
	/**
	 * 根据authId生成auth对象
	 * @param authId
	 * @return
	 */
	private DBWorkAuth makeAuthByAuthId(String authId,String status,String oldStatus){
		DBWorkAuth a = new DBWorkAuth();
		a.setAuthId(authId);
		a.setAuthNo(0);
		a.setNodeid(getCurNodeid());
		a.setNodenum(0);
		a.setStatus(status);
		a.setOldStatus(oldStatus);
		
		a.setTrackid(getCurTrackid());
		a.setVersion(0);
		a.setWorkid(getWorkid());
		return a;
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		makeSendInfoByCurAuthList(auths);
		return true;
	}
	/**
	 * 发送待办
	 */
	protected void sendTodo(){
		if(isnewdoc == 0){
			runningdata.putMsgToConsole("[msg]todo send start.");
			DBTodo todo = makeDefaultDBTodo();//生成通用的待办信息
			makeSendInfoForNewAuth(todo,getCurUser().getFullName(),StaticVarExtend.AUTH_CREATOR,StaticVarExtend.Send_Todo,
					null,getCurTrack(),getCurFlowNode());
		}
	}
}
