package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 替换处理人操作
 * 1)给新办理人发送指定的消息,其他旧办理人变成读者
 * 2)用指定的办理人替换所有当前所有处理人
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class ActionReplaceAuthor extends BaseAction implements ICustomAction {
	private String sendTodoUserid ="";	//记录需要发送的待办人员id
	private String selectedKey = "";	//获取前台传入办理人的key
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_REPLACE_AUTHOR);
		setActionname("Replace_Msg0001","替换办理人");
		if(null == selectedUsers || selectedUsers.isEmpty()){
			result = StaticVarExtend.F_STATUS_SelectAuthor;
			msg = pubInfo.getInfo("Replace_Msg0002","请指定替换后的办理人");
		}else if(isReplaceAuthor()){
			List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
			//获取当前节点的所有办理人
			List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
			if(auths == null || auths.isEmpty()){
				result = StaticVarExtend.F_STATUS_OtherError;
				msg = pubInfo.getInfo("Replace_Msg0006","未能获取到要替换的办理人(可能是办理人的状态变更为其他状态,比如会签时)");;
				
				runningdata.setBackMsg(msg);
				runningdata.setResultCode(result);
				return true;
			}
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				newAuths.add(auth);
				auth.setStatus(StaticVarExtend.AUTH_CREADER);
			}
			//根据当前办理人相关属性生成新的办理人
			List<DBWorkAuth> lst = addNewAuth(auths.get(0));
			if(lst == null){
				result = StaticVarExtend.F_STATUS_SelectAuthor;
				msg = pubInfo.getInfo("Replace_Msg0002","请指定替换后的办理人");
			}
			else{
				newAuths.addAll(lst);
				runningdata.setCurAuthToMap(newAuths);
				msg = pubInfo.getInfo("Replace_Msg0003","替换处理人成功");
				result = StaticVarExtend.F_STATUS_Success;	
				if(executeEventSave()){
					runningdata.setUpdateTask(true);
					runningdata.setTitle(paraBean.getTitle());//设置待办发送的标题
					
					String username = getUsernameFormSelectedOrFromDB(selectedKey,sendTodoUserid);
					memoBuffer.append(pubInfo.getInfo("Replace_Msg0005","替换办理人为:|username|")
							.replace("|username|", username));
				}	
			}
		}else{
			result = StaticVarExtend.F_STATUS_OtherError;
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		runningdata.setClearAllTempUser(true);
		return true;
	}
	
	/**
	 * 判断是否有替换处理人的权限
	 * @return true:允许替换处理人
	 * 		   false:不允许替换处理人
	 */
	private boolean isReplaceAuthor() {
		if(getCurUser().isManager()){
			return true;
		}
		msg = pubInfo.getInfo("Replace_Msg0004","当前人不是管理员，不能执行当前操作.");
		result = StaticVarExtend.F_STATUS_OtherError;
		return false;
	}

	/**
	 * 构造一个新的转办对象
	 * @param auth
	 * @return
	 */
	private List<DBWorkAuth> addNewAuth(DBWorkAuth auth) {
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		String status = StaticVarExtend.AUTH_AUTHOR;	//权限名称
		selectedKey = status;
		String selectedUser = selectedUsers.get(status);		//权限对应的办理人
		if(StringUtilExtend.isNull(selectedUser)){
			selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+status;
			selectedUser = selectedUsers.get(selectedKey);
		}
		//前台传入标识可能为StaticVarExtend.AUTH_MANAGER
		if(StringUtilExtend.isNull(selectedUser)){
			status = StaticVarExtend.AUTH_MANAGER;
			selectedKey = status;
			selectedUser = selectedUsers.get(status);
		}
		if(StringUtilExtend.isNull(selectedUser)){
			selectedKey = getCurNodeid()+StaticVarExtend.Mark_Fix+status;
			selectedUser = selectedUsers.get(selectedKey);
		}
		
		//前台传入标识可能为StaticVarExtend.AUTH_DONE
		if(StringUtilExtend.isNull(selectedUser)){
			status = StaticVarExtend.AUTH_DONE;
			selectedKey = status;
			selectedUser = selectedUsers.get(status);
		}
		if(StringUtilExtend.isNull(selectedUser)){
			selectedKey = getCurNodeid()+StaticVarExtend.Mark_Fix+status;
			selectedUser = selectedUsers.get(selectedKey);
		}
		if(StringUtilExtend.isNull(selectedUser)){
			return null;
		}
		
		INodeAuthUser xmluser = getCurFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
			//调用代理
			selectedUser = AgentUtil.getInstance().getAgentUser(selectedUser, getWorkid(), getWork().getFlowid(), getIdentifier());				
		}
		
		String[] selectedUsers = selectedUser.split(StaticVarExtend.UserSplitChar);//多个办理人
		sendTodoUserid = selectedUser;	//节点当前办理人(多人顺签时该值为单个人员)
		ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
		int nodetype = getCurNodeType();
		boolean isUpdateTrackOther = false;
		for(String user : selectedUsers){
			DBWorkAuth newAuth = new DBWorkAuth();
			newAuth.setAuthId(user);
			newAuth.setAuthNo(auth.getAuthNo());
			
			newAuth.setNodeid(auth.getNodeid());
			newAuth.setStatus(StaticVarExtend.AUTH_AUTHOR);
			newAuth.setOldStatus("");
			
			newAuth.setTrackid(auth.getTrackid());
			newAuth.setVersion(auth.getVersion()+1);
			newAuth.setWorkid(auth.getWorkid());
			newAuth.setNodenum(auth.getNodenum());		
			
			newAuths.add(newAuth);
			if(NodeTypeEnum.Node_Single == nodetype || NodeTypeEnum.Node_Merger == nodetype){
				sendTodoUserid = user;
				//如果是单人签核或者人工合并，则只取第一个
				ITrackUserJson aPlanUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
				runningdata.setPlanId_ForTrackUser(aPlanUser, sendTodoUserid); 
				break;
			}else if(NodeTypeEnum.Node_Order == nodetype){//如果是顺签则只生成第一个人员的DBWorkAuth记录
				//清空已办记录中的nowid
				ITrackUserJson  trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
				runningdata.setNowId_ForTrackUser(trackRdyUser, "");	
				
				//顺签必须要更新PlanId
				ITrackUserJson trackAuthorUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
				runningdata.setPlanId_ForTrackUser(trackAuthorUser, selectedUser);
				sendTodoUserid = user;
				break;
			}
			else{
				isUpdateTrackOther = true;
			}
		}
		if(isUpdateTrackOther){
			ITrackUserJson aPlanUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
			runningdata.setPlanId_ForTrackUser(aPlanUser, sendTodoUserid); 
		}
		
		this.selectedUsers.clear();
		this.selectedUsers.put(status,sendTodoUserid);
		return newAuths;
	}

	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 继承父类发送待办的方法
	 */
	protected void sendTodo(){
		if(StringUtilExtend.isNull(sendTodoUserid))return;
		String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR, paraBean);//获取发送消息的方式
		DBTodo todo = makeDefaultDBTodo();
		makeSendInfoForNewAuth(todo,sendTodoUserid,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
				msgSendType,getCurTrack(),getCurFlowNode());
	}
}
