package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;

/**
 * 三、多人顺序节点内部退回操作实现类
 *
 * @author liys
 * @version 1.0
 * @since v7.0
 */
public class ActionRejectForInner extends BaseAction implements ICustomAction {
	private int nodeType ;
	private String prevUser="";
	private ITrackNodeJson trackNode;
	private String curAuth="";
	public boolean execute(ITaskNode curTaskNode){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_INNER_REJECT);
		setActionname("Reject_Msg2001","内部退回");
		nodeType = getCurFlowNode().getNodetype();
		if(nodeType == NodeTypeEnum.Node_Order || nodeType == NodeTypeEnum.Node_Progressively){
			if(checkInnerReject()){
				 prevUser = doWithCurNodeAuth(prevUser);
				 String key = trackNode.getNodeid()+StaticVarExtend.MARK_NODE_USER+curAuth;
				 selectedUsers.put(key, prevUser);

				 result = StaticVarExtend.F_STATUS_Success;
				 msg = pubInfo.getInfo("Reject_Msg2004","内部退回成功");


				 String username = getUsernameFormSelectedOrFromDB(key,prevUser);
				 memoBuffer.append(pubInfo.getInfo("Reject_Msg2005","内部退回给:|username|")
						 .replace("|username|", username));
			}
			else{
				runningdata.putMsgToConsole("[msg]The first one who does not support the return handle.");
				result = StaticVarExtend.F_STATUS_OtherError;
				msg = pubInfo.getInfo("Reject_Msg2003","第一个办理人,不支持内部退回.");
			}
		}
		else{
			runningdata.putMsgToConsole("[msg]nodetype!=NodeTypeEnum.Node_Order && != NodeTypeEnum.Node_Progressively");
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Reject_Msg2002","节点类型不是多人顺序或者内部循环类型,不支持内部退回操作");
		}
		
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}

	protected boolean checkInnerReject(){
		DBTrack track = getCurTrack();
		trackNode = track._getTrackNode();
		IRunUser curUser = runningdata.getCurUser();
		curAuth = curUser.getAuthName();
		ITrackUserJson trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,curAuth);
		//第一个办理人也不支持退回
		String doneid = trackRdyUser.getNowId();

		if(doneid == null || "".equals(doneid)){
			return false;
		}
		else{
			/** 假设办理人A,B,C,D,当前办理人为B
			 * 当前记录为:Author-Plan:A;B;C;D
			 * 			 Author-Now:B
			 * 			 Done-Plan:A
			 * 			 Done-Now:A
			 * 退回后应该为:
			 * 			 Author-Plan:A;B;C;D
			 * 			 Author-Now:A
			 * 			 Done-Plan:A;B
			 * 			 Done-Now:
			 * 权限变更:  Status    oldStatus
			 * B	      Done		 Author
			 * A		  Author
			 * A					 Done
			 * B					 Done
			 */
			//获取上一个办理人
			prevUser = getPreUser(trackNode,curUser);
			if("".equals(prevUser)){
				return false;
			}
			else{
				return true;
			}
		}
	}

	/**
	 * 获取顺签中的上一办理人
	 */
	private String getPreUser(ITrackNodeJson trackNode,IRunUser curUser){
		//获取已经办理人
		ITrackUserJson  trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,curUser.getAuthName());
		String rdy = trackRdyUser.getNowId();//+StaticVar.UserSplitChar+curUser.curSetDoUser();
		List<AuthUserImpl> rdyusers = AuthUserImpl.getAuthUserList(rdy);
		if(rdyusers.isEmpty()){
			return ""; //已办为空表名为第一个办理人,此时不允许退回
		}
		//直接获取最后一个已办
		String preUser = rdyusers.get(rdyusers.size()-1)._getFullNameWithAgent();
		return preUser;
	}
	
	/**
	 * 当前顺签节点人员变更处理
	 * @return
	 */
	private String doWithCurNodeAuth(String oldUser) {
		runningdata.putMsgToConsole("[msg]huiqian operator get auth start.");
		String curAuthname = getCurAuthName();
		List<DBWorkAuth> allAuths =  getXAuthList(curAuthname);
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		
		INodeAuthUser xmluser = getCurFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		String preUser = oldUser;
		if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
			//调用代理
			preUser = AgentUtil.getInstance().getAgentUser(oldUser, getWorkid(), getWork().getFlowid(), getIdentifier());				
		}
		
		if(StringUtilExtend.isNull(preUser)){
			runningdata.putMsgToConsole("[msg]huiqian operator get author is null from selectedMap.");
		}else{
			//把当前办理人的权限变更为删除
			IRunUser user = getCurUser();
			int nodenum = 0, authno = 0;
			if(CollectionUtil.isListNotEmpty(allAuths)){
				for(int i=0,n=allAuths.size();i<n;i++){
					DBWorkAuth a = allAuths.get(i);
					if(a.equalsRunUser(getCurUser())){
						a.setStatus(StaticVarExtend.AUTH_DONE);//删除当前人的权限
						newAuths.add(a);
						nodenum = allAuths.get(0).getNodenum();
						authno = allAuths.get(allAuths.size()-1).getAuthNo();
						break;
					}
				}
			}
			//退回需要删除的权限
			//删除当前人的已办权限
			DBWorkAuth dAuth = addNewAuth(user.getFullName(),nodenum,authno,curAuthname);
			dAuth.setOldStatus(StaticVarExtend.AUTH_DONE);
			dAuth.setAuthType(StaticVarExtend.UserFix);
			dAuth._setClearJson(false);//使用JSON时,不要删除当前人的已办信息,否则会无权限查看
			dAuth.setAddNew(false);
			//增加新的权限(上一办理人)
			newAuths.add(addNewAuth(preUser,nodenum,authno,curAuthname));//StaticVarExtend.AUTH_AUTHOR);	
			
			//删除上一办理人的已办权限
			DBWorkAuth pAuth = addNewAuth(oldUser,nodenum,authno,curAuthname);
			pAuth.setOldStatus(StaticVarExtend.AUTH_DONE);
			pAuth.setAddNew(false);

			boolean isDelDB = false;
			if(isDelDB){
				//库表不删除,仅对XML进行中Done节点的NowId进行删除
				ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
				ITrackUserJson xUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
				String rdy = xUser.getNowId();
				
				AuthUserImpl tmpdAuth = AuthUserImpl.getAuthUserByStr(dAuth.getAuthId());
				tmpdAuth.copyToWorkAuth(dAuth);
				rdy  = CStrUtil.replaceSpecialAuth(rdy,dAuth);
				
				AuthUserImpl tmppAuth = AuthUserImpl.getAuthUserByStr(pAuth.getAuthId());
				tmppAuth.copyToWorkAuth(pAuth);
				rdy = CStrUtil.replaceSpecialAuth(rdy, pAuth);
				runningdata.setNowId_ForTrackUser(xUser,rdy);
			}
			else{
				//如果需要从库表中删除已办,则需要添加到当前权限列表中
				//删除dAuth当前人的已办,但其实在SQL中是无效删除因为删除语句在插入之前,但是此删除还必须要有,用于清理track信息
				newAuths.add(dAuth);
				newAuths.add(pAuth);
			}
			//20170525 liys 针对顺序节点的人员在内部退回操作时出现的人员混乱处理
			//主要造成的原因是:上一办理人员在提交时,没有代办人,但在退回时有代办人了,人员无法准确匹配造成
			//解决办法:在删除旧权限时,使用无代办人的id,创建新权限时,使用带有代办人的id,同时判断是否有代办人
			//			如果有则需要对PlanId进行变更
			checkAgentAndChgPlanId(oldUser,preUser);
			
			runningdata.setCurAuthToMap(newAuths);
			
			return preUser;
		}
		
		return oldUser;
	}
	/**
	 * 检查获取代理人后,是否跟原来的办理人一样,如果不一致则修改planid
	 */
	private void checkAgentAndChgPlanId(String oldUser,String newUser){
		//如果没有没有代理人
		if(oldUser.equals(newUser)){
			return;
		}
		
		ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
		String curAuthname = getCurAuthName();
        //获取所有办理人
		ITrackUserJson  trackUser = trackNode.getTrackUserImpl(curAuthname);
        String allplan = trackUser.getPlanId();
        List<AuthUserImpl> allPlanList = AuthUserImpl.getAuthUserList(allplan);

		ITrackUserJson  trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,curAuthname);
        String rdy = trackRdyUser.getNowId();
        //获取已经办理人
        List<AuthUserImpl> rdyDoneList = AuthUserImpl.getAuthUserList(rdy);
        int m = rdyDoneList.size() -1;//查找当前办理人位置,并标记上一办理人在planId的坐标
		
        AuthUserImpl newAuth = AuthUserImpl.getAuthUserByStr(newUser);
		allPlanList.remove(m);
		allPlanList.add(m, newAuth);
        	
    	//重新获取所有PlanId字符串
    	StringBuilder sb = new StringBuilder(200);
    	for(int i=0,n= allPlanList.size();i<n;i++){
    		sb.append(allPlanList.get(i)._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
    	}
    	//写回到xml中
    	getRunningData().setPlanId_ForTrackUser(trackUser, sb.toString());
        
	}
	/**
	 * 构造一个新的办理人
	 * @return
	 */
	private DBWorkAuth addNewAuth(String author,int nodenum,  int authno,String authname) {
		DBWorkAuth newAuth = new DBWorkAuth();
		newAuth.setAuthId(author);
		
		newAuth.setAuthNo(authno);
		newAuth.setNodeid(getCurNodeid());
		newAuth.setStatus(authname);
		
		
		newAuth.setTrackid(getCurTrackid());
		newAuth.setWorkid(getWorkid());
		newAuth.setNodenum(nodenum);
		return newAuth;
	}
	
	
	public Map<String,List<Object>>  actionForTask() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionForTask(saveMap);
		//下一节点任务创建
		for(int i=0,n=runningdata.getNextTrackList().size();i<n;i++){
			DBTrack tTrack = runningdata.getNextTrackList().get(i);
			createTaskObj(null,tTrack,saveMap);
		}
		return saveMap;
	}
	/*
	private void createTaskObj(DBTask xTask,DBTrack xTrack,Map<String, List<Object>> saveMap){
		DBWork xWork = runningdata.getWork();
		if(xTask == null){
			xTask = new DBTask();
			xTask.setId(StaticFunExtend.getUnid());
			xTask.setFlowid(xWork.getFlowid());
			xTask.setFlowname(xWork.getFlowname());
			xTask.setWorkid(xWork.getId());		
			IXmlFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowInfo();
			int[] ls = flowInfo.getLimitSet();
			
			xTask.setFlowlimitdate(ls[1]);
			xTask.setFlowlimittype(String.valueOf(ls[0]));
			
			xTask.setStarttime(xWork.getStarttime());	
			//计算流程超期时间点，如果没有设置，默认为一年
			int tp  =xTask.getFlowlimitdate();
			
			Date date = addDateForTask(xTask.getStarttime(),ls[0], tp);  
			//DateUtil.addDateDay(DateUtil.getDateTime(xTask.getStarttime()), tp==0?365:tp);  
			xTask.setFlowlimittime(DateUtil.formatDateTime(date,"yyyy-MM-dd HH:mm:ss"));
		
			String nowtime = DateUtil.getNow();
			xTask.setReceivetime(nowtime);//节点到达时间，计入xml中
//			curNode.setNodeRecevieTime(nowtime);
			//int[] ns = runningdata.getCurXMLNode().getNodeLimit(); 
			int[] ns = flowInfo.getNodeById(xTrack.getNodeid()).getNodeLimit();
			
			String outerCofig = paraBean.getOuterConfig();
			if(StringUtilExtend.isNull(outerCofig)){
				outerCofig = runningdata.getOuterSetType();
			}
			
			if(StringUtilExtend.isNotNull(outerCofig)){
				String limittime = RuleUtil.getOuterLimittime(flowInfo.getFlowid(), xTrack.getNodeid(), outerCofig, getIdentifier());
				if(StringUtilExtend.isNull(limittime)){
					limittime = "0";
				}
				xTask.setNodelimitdate(Integer.parseInt(limittime));				
			}else{
				xTask.setNodelimitdate(ns[1]);				
			}
			xTask.setNodelimittype(String.valueOf(ns[0]));
						
			xTask.setWaringdate(ns[2]);
			xTask.setWaringtype(String.valueOf(ns[0]));
			xTask.setDooverpass(ns[4]);
			xTask.setRemsgnum(ns[3]);
			xTask.setRedonenum(0);
			tp  =xTask.getNodelimitdate();
			
			date = addDateForTask(xTask.getReceivetime(),ns[0], tp);  
			//DateUtil.addDateDay(DateUtil.getDateTime(xTask.getReceivetime()), tp==0?365:tp);  
            xTask.setNodelimittime(DateUtil.formatDateTime(date,"yyyy-MM-dd HH:mm:ss"));
            xTask.setTrackid(xTrack.getId());
		}
		
		xTask.setFlowstatus(xTrack.getFlowstatus());		//流程状态更新
		xTask.setNodetype(runningdata.getCurXMLNode().getNodetype());
		
		xTask.setTitle(xWork.getTitle());
		xTask.setStatus(StaticVarExtend.Task_Normal);
		xTask.setNodeid(xTrack.getNodeid());					
		xTask.setNodename(xTrack.getNodename());		
				
		xTask.getSQL(saveMap);
	}
	//*/
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return ;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		Map<String,String> map = new HashMap<String,String>();
		if(!isNotSaveToDB){
			map.put(StaticVarExtend.AUTH_AUTHOR, StaticVarExtend.AUTH_CREADER);
		}
		return map;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 发送待办
	 */
	protected void sendTodo(){
		sendTodoForSelectedUsers();
	}
}
